/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.value;

import com.linkedin.feathr.common.types.FeatureType;
import com.linkedin.feathr.common.types.NumericFeatureType;
import com.linkedin.feathr.common.value.FeatureValue;
import java.util.Objects;

public class NumericFeatureValue
implements FeatureValue {
    private static final FeatureType TYPE = NumericFeatureType.INSTANCE;
    private final float _floatValue;

    private NumericFeatureValue(float floatValue) {
        this._floatValue = floatValue;
    }

    public static NumericFeatureValue fromFloat(float floatValue) {
        return new NumericFeatureValue(floatValue);
    }

    public float getFloatValue() {
        return this._floatValue;
    }

    @Override
    public FeatureType getFeatureType() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericFeatureValue that = (NumericFeatureValue)o;
        return Float.compare(that._floatValue, this._floatValue) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this._floatValue));
    }

    public String toString() {
        return "NumericFeatureValue{_floatValue=" + this._floatValue + '}';
    }
}

