/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.value;

import com.linkedin.feathr.common.TensorUtils;
import com.linkedin.feathr.common.tensor.DenseTensor;
import com.linkedin.feathr.common.tensor.DimensionType;
import com.linkedin.feathr.common.tensor.LOLTensorData;
import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.PrimitiveDimensionType;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorIterator;
import com.linkedin.feathr.common.tensor.TensorType;
import com.linkedin.feathr.common.tensor.scalar.ScalarBooleanTensor;
import com.linkedin.feathr.common.tensor.scalar.ScalarFloatTensor;
import com.linkedin.feathr.common.tensorbuilder.DenseTensorBuilder;
import com.linkedin.feathr.common.tensorbuilder.UniversalTensorBuilder;
import com.linkedin.feathr.common.types.BooleanFeatureType;
import com.linkedin.feathr.common.types.CategoricalFeatureType;
import com.linkedin.feathr.common.types.CategoricalSetFeatureType;
import com.linkedin.feathr.common.types.DenseVectorFeatureType;
import com.linkedin.feathr.common.types.NumericFeatureType;
import com.linkedin.feathr.common.types.PrimitiveType;
import com.linkedin.feathr.common.types.TensorFeatureType;
import com.linkedin.feathr.common.types.TermVectorFeatureType;
import com.linkedin.feathr.common.value.AbstractFeatureFormatMapper;
import com.linkedin.feathr.common.value.BooleanFeatureValue;
import com.linkedin.feathr.common.value.CategoricalFeatureValue;
import com.linkedin.feathr.common.value.CategoricalSetFeatureValue;
import com.linkedin.feathr.common.value.DenseVectorFeatureValue;
import com.linkedin.feathr.common.value.NumericFeatureValue;
import com.linkedin.feathr.common.value.QuinceFeatureTypeMapper;
import com.linkedin.feathr.common.value.TensorFeatureValue;
import com.linkedin.feathr.common.value.TermVectorFeatureValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class QuinceFeatureFormatMapper
extends AbstractFeatureFormatMapper<TensorData> {
    private static final float UNIT = 1.0f;
    public static final QuinceFeatureFormatMapper INSTANCE = new QuinceFeatureFormatMapper();
    private static final Representable[] CATEGORICAL_QUINCE_COLUMN_TYPES = QuinceFeatureTypeMapper.INSTANCE.fromFeatureType(CategoricalFeatureType.INSTANCE).getColumnTypes();
    private static final Representable[] CATEGORICAL_SET_QUINCE_COLUMN_TYPES = QuinceFeatureTypeMapper.INSTANCE.fromFeatureType(CategoricalSetFeatureType.INSTANCE).getColumnTypes();
    private static final TensorData EMPTY_CATEGORICAL_SET_TENSOR = new LOLTensorData(CATEGORICAL_SET_QUINCE_COLUMN_TYPES, Collections.singletonList(new ArrayList()), new ArrayList());
    private static final Representable[] TERM_VECTOR_QUINCE_COLUMN_TYPES = QuinceFeatureTypeMapper.INSTANCE.fromFeatureType(TermVectorFeatureType.INSTANCE).getColumnTypes();
    private static final TensorData EMPTY_UNIVERSAL_TENSOR = new UniversalTensorBuilder(TERM_VECTOR_QUINCE_COLUMN_TYPES).build();
    private static final Representable[] TENSOR_INT_FLOAT_TYPE = new Representable[]{Primitive.INT, Primitive.FLOAT};
    private static final TensorData EMPTY_DENSE_VECTOR_TENSOR = new DenseTensorBuilder(TENSOR_INT_FLOAT_TYPE, new long[]{-1L}).build(new float[0]);

    private QuinceFeatureFormatMapper() {
    }

    @Override
    protected TensorData fromNumericFeatureValue(NumericFeatureValue featureValue) {
        return new ScalarFloatTensor(featureValue.getFloatValue());
    }

    @Override
    protected TensorData fromBooleanFeatureValue(BooleanFeatureValue featureValue) {
        return new ScalarBooleanTensor(featureValue.getBooleanValue());
    }

    @Override
    protected TensorData fromCategoricalFeatureValue(CategoricalFeatureValue featureValue) {
        return new LOLTensorData(CATEGORICAL_QUINCE_COLUMN_TYPES, Collections.singletonList(Collections.singletonList(featureValue.getStringValue())), Collections.singletonList(Float.valueOf(1.0f)));
    }

    @Override
    protected TensorData fromCategoricalSetFeatureValue(CategoricalSetFeatureValue featureValue) {
        ArrayList<String> indices = new ArrayList<String>(featureValue.getStringSet());
        if (indices.isEmpty()) {
            return EMPTY_CATEGORICAL_SET_TENSOR;
        }
        ArrayList<Float> values = new ArrayList<Float>(Collections.nCopies(indices.size(), Float.valueOf(1.0f)));
        return new LOLTensorData(CATEGORICAL_SET_QUINCE_COLUMN_TYPES, Collections.singletonList(indices), values);
    }

    @Override
    protected TensorData fromTermVectorFeatureValue(TermVectorFeatureValue featureValue) {
        Map<String, Float> termVector = featureValue.getTermVector();
        if (termVector.isEmpty()) {
            return EMPTY_UNIVERSAL_TENSOR;
        }
        UniversalTensorBuilder builder = new UniversalTensorBuilder(TERM_VECTOR_QUINCE_COLUMN_TYPES);
        builder.start(termVector.size());
        termVector.forEach((term, value) -> {
            builder.setString(0, (String)term);
            builder.setFloat(1, value.floatValue());
            builder.append();
        });
        return builder.build();
    }

    @Override
    protected TensorData fromDenseVectorFeatureValue(DenseVectorFeatureValue featureValue) {
        float[] floatArray = featureValue.getFloatArray();
        if (floatArray.length == 0) {
            return EMPTY_DENSE_VECTOR_TENSOR;
        }
        TensorType tensorType = QuinceFeatureTypeMapper.INSTANCE.fromFeatureType(featureValue.getFeatureType());
        return new DenseTensorBuilder(tensorType.getColumnTypes(), TensorUtils.getShape(tensorType)).build(floatArray);
    }

    @Override
    protected TensorData fromTensorFeatureValue(TensorFeatureValue featureValue) {
        return featureValue.getAsTensor();
    }

    @Override
    protected NumericFeatureValue toNumericFeatureValue(NumericFeatureType featureType, TensorData tensor) {
        if (tensor.getArity() != 1) {
            throw new IllegalArgumentException("Not a scalar: " + QuinceFeatureFormatMapper.getDebugString(tensor));
        }
        float floatValue = tensor.getTypes()[0].getRepresentation().toFloat(tensor.iterator(), 0);
        return NumericFeatureValue.fromFloat(floatValue);
    }

    @Override
    protected BooleanFeatureValue toBooleanFeatureValue(BooleanFeatureType featureType, TensorData tensor) {
        if (tensor.getArity() != 1) {
            throw new IllegalArgumentException("Not a scalar: " + QuinceFeatureFormatMapper.getDebugString(tensor));
        }
        boolean booleanValue = tensor.getTypes()[0].getRepresentation().toBoolean(tensor.iterator(), 0);
        return BooleanFeatureValue.fromBoolean(booleanValue);
    }

    @Override
    protected CategoricalFeatureValue toCategoricalFeatureValue(CategoricalFeatureType featureType, TensorData tensor) {
        if (tensor.getArity() == 2 && tensor.cardinality() == 1 || tensor.getArity() == 1 && tensor.getTypes()[0].equals(Primitive.STRING)) {
            String stringValue = tensor.getTypes()[0].getRepresentation().toString(tensor.iterator(), 0);
            return CategoricalFeatureValue.fromString(stringValue);
        }
        throw new RuntimeException("Tensor doesn't represent a categorical: " + QuinceFeatureFormatMapper.getDebugString(tensor));
    }

    @Override
    protected CategoricalSetFeatureValue toCategoricalSetFeatureValue(CategoricalSetFeatureType featureType, TensorData tensor) {
        ArrayList<String> value = new ArrayList<String>(tensor.cardinality());
        TensorIterator iter = tensor.iterator();
        Primitive rep = tensor.getTypes()[0].getRepresentation();
        while (iter.isValid()) {
            value.add(rep.toString(iter, 0));
            iter.next();
        }
        return CategoricalSetFeatureValue.fromStrings(value);
    }

    @Override
    protected TermVectorFeatureValue toTermVectorFeatureValue(TermVectorFeatureType featureType, TensorData tensor) {
        HashMap<String, Float> termVector = new HashMap<String, Float>(tensor.cardinality());
        Representable[] columnTypes = tensor.getTypes();
        TensorIterator iter = tensor.iterator();
        Primitive termRep = columnTypes[0].getRepresentation();
        Primitive valueRep = columnTypes[1].getRepresentation();
        while (iter.isValid()) {
            String term = termRep.toString(iter, 0);
            Float value = Float.valueOf(valueRep.toFloat(iter, 1));
            termVector.put(term, value);
            iter.next();
        }
        return TermVectorFeatureValue.fromMap(termVector);
    }

    @Override
    protected DenseVectorFeatureValue toDenseVectorFeatureValue(DenseVectorFeatureType featureType, TensorData tensor) {
        Primitive valueType = tensor.getTypes()[tensor.getArity() - 1].getRepresentation();
        if (tensor instanceof DenseTensor && tensor.getArity() == 2 && (valueType.equals(Primitive.FLOAT) || valueType.equals(Primitive.DOUBLE) || valueType.equals(Primitive.INT) || valueType.equals(Primitive.LONG))) {
            return DenseVectorFeatureValue.fromNumberList(((DenseTensor)tensor).asList());
        }
        throw new IllegalArgumentException("Not a DenseTensor with rank=1 and numeric value type: " + QuinceFeatureFormatMapper.getDebugString(tensor));
    }

    @Override
    protected TensorFeatureValue toTensorFeatureValue(TensorFeatureType featureType, TensorData externalValue) {
        return TensorFeatureValue.fromTensorData(featureType, externalValue);
    }

    private static String getDebugString(TensorData tensorData) {
        Representable[] columnTypes = tensorData.getTypes();
        PrimitiveType valueType = new PrimitiveType(columnTypes[columnTypes.length - 1].getRepresentation());
        List<DimensionType> dimensionTypes = Arrays.asList(columnTypes).subList(0, columnTypes.length - 1).stream().map(representable -> new PrimitiveDimensionType(representable.getRepresentation())).collect(Collectors.toList());
        TensorType tensorType = new TensorType(valueType, dimensionTypes);
        return "{" + TensorUtils.getDebugString(tensorType, tensorData, 10240) + "}";
    }
}

