/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.client;

import com.google.common.annotations.VisibleForTesting;
import com.linkedin.feathr.common.DateParam;
import com.linkedin.feathr.common.FeatureInfo;
import com.linkedin.feathr.common.FeatureRef;
import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.Header;
import com.linkedin.feathr.common.JoiningFeatureParams;
import com.linkedin.feathr.common.TaggedFeatureName;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrFeatureTransformationException;
import com.linkedin.feathr.offline.anchored.feature.FeatureAnchorWithSource;
import com.linkedin.feathr.offline.client.TypedRef$;
import com.linkedin.feathr.offline.derived.DerivedFeature;
import com.linkedin.feathr.offline.job.FeatureTransformation$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base32;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.package$;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DataFrameColName$ {
    public static DataFrameColName$ MODULE$;
    private final String UidColumnName;
    private final String FEATURE_REF_DELIM_IN_COLNAME;
    private final String KEYTAG_DELIM_IN_COLNAME;
    private final String FEATURE_REF_KEYTAG_DELIM_IN_COLNAME;
    private final String EMPTY_STRING;
    private final String ENCODED_FEATURE_COLUMN_NAME_DELIM;
    private final String ENCODED_FEATURE_REF_ENDING;
    private final String MAJOR_VERSION;
    private final String MINOR_VERSION;
    private final String FEATURE_NAME;
    private final String FEATURE_NAMESPACE;
    private final String BASE32_PADDING;
    private final String JOIN_KEY_COLUMN_EXPR_DELIMITER;
    private final String JOIN_KEY_COLUMN_RAW_EXPRESSION_DELIMITER;

    static {
        new DataFrameColName$();
    }

    public String UidColumnName() {
        return this.UidColumnName;
    }

    public String FEATURE_REF_DELIM_IN_COLNAME() {
        return this.FEATURE_REF_DELIM_IN_COLNAME;
    }

    public String KEYTAG_DELIM_IN_COLNAME() {
        return this.KEYTAG_DELIM_IN_COLNAME;
    }

    public String FEATURE_REF_KEYTAG_DELIM_IN_COLNAME() {
        return this.FEATURE_REF_KEYTAG_DELIM_IN_COLNAME;
    }

    public String EMPTY_STRING() {
        return this.EMPTY_STRING;
    }

    private String ENCODED_FEATURE_COLUMN_NAME_DELIM() {
        return this.ENCODED_FEATURE_COLUMN_NAME_DELIM;
    }

    private String ENCODED_FEATURE_REF_ENDING() {
        return this.ENCODED_FEATURE_REF_ENDING;
    }

    private String MAJOR_VERSION() {
        return this.MAJOR_VERSION;
    }

    private String MINOR_VERSION() {
        return this.MINOR_VERSION;
    }

    private String FEATURE_NAME() {
        return this.FEATURE_NAME;
    }

    private String FEATURE_NAMESPACE() {
        return this.FEATURE_NAMESPACE;
    }

    private String BASE32_PADDING() {
        return this.BASE32_PADDING;
    }

    private String JOIN_KEY_COLUMN_EXPR_DELIMITER() {
        return this.JOIN_KEY_COLUMN_EXPR_DELIMITER;
    }

    private String JOIN_KEY_COLUMN_RAW_EXPRESSION_DELIMITER() {
        return this.JOIN_KEY_COLUMN_RAW_EXPRESSION_DELIMITER;
    }

    public String getFeatureOutputColumnName(String featureRefStr, Seq<String> tags) {
        String string;
        String safeFeatureRefStr = featureRefStr.replaceAll(TypedRef$.MODULE$.DELIM(), this.FEATURE_REF_DELIM_IN_COLNAME());
        if (tags.isEmpty()) {
            string = safeFeatureRefStr;
        } else {
            String tagStr = tags.count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.matches("[\\w]+"))) != tags.size() ? ((TraversableOnce)tags.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.replaceAll("[^\\w]", MODULE$.KEYTAG_DELIM_IN_COLNAME()), Seq$.MODULE$.canBuildFrom())).mkString(this.KEYTAG_DELIM_IN_COLNAME()) : tags.mkString(this.KEYTAG_DELIM_IN_COLNAME());
            string = new StringBuilder(0).append(tagStr).append(this.FEATURE_REF_KEYTAG_DELIM_IN_COLNAME()).append(safeFeatureRefStr).toString();
        }
        return string;
    }

    public String getFeatureRefStrInColName(String featureRefStr) {
        return featureRefStr.replaceAll(TypedRef$.MODULE$.DELIM(), this.FEATURE_REF_DELIM_IN_COLNAME());
    }

    public String genFeatureColumnName(String featureRefStr, Option<Seq<String>> tags) {
        String namePrefix;
        String string = namePrefix = featureRefStr.startsWith(FeatureTransformation$.MODULE$.FEATURE_NAME_PREFIX()) ? this.EMPTY_STRING() : FeatureTransformation$.MODULE$.FEATURE_NAME_PREFIX();
        if (featureRefStr.contains(FeatureTransformation$.MODULE$.FEATURE_TAGS_PREFIX()) && tags.isDefined()) {
            throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(51).append("Should never add tags to feature column name ").append(featureRefStr).append(" twice").toString());
        }
        String tagStr = tags.isDefined() ? new StringBuilder(0).append(FeatureTransformation$.MODULE$.FEATURE_TAGS_PREFIX()).append(((TraversableOnce)((TraversableLike)tags.get()).map((Function1 & Serializable & scala.Serializable)tag -> MODULE$.encodeString((String)tag), Seq$.MODULE$.canBuildFrom())).mkString("_")).toString() : this.EMPTY_STRING();
        return new StringBuilder(0).append(namePrefix).append(featureRefStr).append(tagStr).toString();
    }

    public Option<Seq<String>> genFeatureColumnName$default$2() {
        return None$.MODULE$;
    }

    public Seq<String> getFeatureTagListFromColumn(String columnName, boolean encoded) {
        Object object;
        if (columnName.contains(FeatureTransformation$.MODULE$.FEATURE_TAGS_PREFIX())) {
            int begin = columnName.indexOf(FeatureTransformation$.MODULE$.FEATURE_TAGS_PREFIX()) + FeatureTransformation$.MODULE$.FEATURE_TAGS_PREFIX().length();
            String encodedTagsStr = columnName.substring(begin);
            object = !encoded ? (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])encodedTagsStr.split(this.KEYTAG_DELIM_IN_COLNAME()))).map((Function1 & Serializable & scala.Serializable)tag -> new String(new Base32().decode(tag)), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())) : Predef$.MODULE$.wrapRefArray((Object[])encodedTagsStr.split(this.KEYTAG_DELIM_IN_COLNAME()));
        } else {
            object = (Seq)new .colon.colon((Object)this.EMPTY_STRING(), (List)Nil$.MODULE$);
        }
        return object;
    }

    public String getDFColName(Seq<String> keyTags, String featureRefStr) {
        return this.getFeatureOutputColumnName(featureRefStr, keyTags);
    }

    public String getEncodedFeatureRefStrForColName(String featureRefStr) {
        String string;
        if (featureRefStr.contains(TypedRef$.MODULE$.DELIM())) {
            String readableFeatureRefStr = featureRefStr.replaceAll(TypedRef$.MODULE$.DELIM(), this.FEATURE_REF_DELIM_IN_COLNAME());
            FeatureRef featureRef = new FeatureRef(featureRefStr);
            String versionStr = this.EMPTY_STRING();
            String namespace = this.EMPTY_STRING();
            String encodedFeatureRefStr = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(67).append("{\n           | ").append(namespace).append("\n           | ").append(this.FEATURE_NAME()).append(" : ").append(featureRef.getName()).append("\n           | ").append(versionStr).append("\n           |}\n      ").toString())).stripMargin();
            string = new StringBuilder(0).append(readableFeatureRefStr).append(this.ENCODED_FEATURE_COLUMN_NAME_DELIM()).append(this.encodeString(encodedFeatureRefStr)).append(this.ENCODED_FEATURE_REF_ENDING()).toString();
        } else {
            string = featureRefStr;
        }
        return string;
    }

    public String getFeatureRefStrFromColumnName(String featureRefStrInColName) {
        String string;
        if (featureRefStrInColName.endsWith(this.ENCODED_FEATURE_REF_ENDING())) {
            int encodedFeatureRefStart;
            String firstPart = featureRefStrInColName.substring(0, featureRefStrInColName.indexOf(this.ENCODED_FEATURE_REF_ENDING()));
            String encodedFeatureRefStr = firstPart.substring((encodedFeatureRefStart = firstPart.lastIndexOf(this.ENCODED_FEATURE_COLUMN_NAME_DELIM())) + this.ENCODED_FEATURE_COLUMN_NAME_DELIM().length());
            String decodedFeatureRefInHOCON = new String(new Base32().decode(encodedFeatureRefStr));
            Config cfg = ConfigFactory.parseString((String)decodedFeatureRefInHOCON);
            String namespace = cfg.hasPath(this.FEATURE_NAMESPACE()) ? new StringBuilder(0).append(cfg.getString(this.FEATURE_NAMESPACE())).append(TypedRef$.MODULE$.DELIM()).toString() : this.EMPTY_STRING();
            String fn = cfg.getString(this.FEATURE_NAME());
            String version = cfg.hasPath(this.MAJOR_VERSION()) ? new StringBuilder(0).append(TypedRef$.MODULE$.DELIM()).append(cfg.getString(this.MAJOR_VERSION())).append(TypedRef$.MODULE$.DELIM()).append(cfg.getString(this.MINOR_VERSION())).toString() : this.EMPTY_STRING();
            string = new StringBuilder(0).append(namespace).append(fn).append(version).toString();
        } else {
            string = featureRefStrInColName;
        }
        return string;
    }

    public Map<TaggedFeatureName, Tuple2<String, String>> getTaggedFeatureToNewColumnName(Dataset<Row> contextDF) {
        Tuple2[] featureRefStrToColumnNameMap = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])contextDF.columns())).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (DataFrameColName$.MODULE$.getFeatureRefStrFromColumnNameOpt(A1).isDefined()) {
                    String featureName = (String)DataFrameColName$.MODULE$.getFeatureRefStrFromColumnNameOpt(A1).get();
                    object = new Tuple2((Object)featureName, A1);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                boolean bl = DataFrameColName$.MODULE$.getFeatureRefStrFromColumnNameOpt(string).isDefined();
                return bl;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        return ((TraversableOnce)((GenericTraversableTemplate)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureRefStrToColumnNameMap)).groupBy((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3._1()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String featureRefStr = (String)tuple2._1();
                Tuple2[] featureNameColumnNamePairs = (Tuple2[])tuple2._2();
                if (featureNameColumnNamePairs.length > 1) {
                    seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureNameColumnNamePairs)).map((Function1 & Serializable & scala.Serializable)featureNameColumnNamePair -> {
                        String columnName = (String)featureNameColumnNamePair._2();
                        Seq<String> tagList = MODULE$.getFeatureTagListFromColumn(columnName, false);
                        TaggedFeatureName taggedFeature = new TaggedFeatureName(package$.MODULE$.wrapAll().deprecated$u0020seqAsJavaList(tagList), featureRefStr);
                        String outputColumnName = MODULE$.getFeatureOutputColumnName(featureRefStr, tagList);
                        return new Tuple2((Object)taggedFeature, (Object)new Tuple2((Object)columnName, (Object)outputColumnName));
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toSeq();
                } else {
                    String columnName = (String)((Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureNameColumnNamePairs)).head())._2();
                    Seq<String> tags = MODULE$.getFeatureTagListFromColumn(columnName, false);
                    TaggedFeatureName taggedFeature = new TaggedFeatureName(package$.MODULE$.wrapAll().deprecated$u0020seqAsJavaList(tags), featureRefStr);
                    String outputColumnName = MODULE$.getFeatureOutputColumnName(featureRefStr, (Seq<String>)((Seq)Nil$.MODULE$));
                    seq = (Seq)new .colon.colon((Object)new Tuple2((Object)taggedFeature, (Object)new Tuple2((Object)columnName, (Object)outputColumnName)), (List)Nil$.MODULE$);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Seq seq2 = seq;
            return seq2;
        }, Iterable$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms())).toMap(Predef$.MODULE$.$conforms());
    }

    public Tuple2<Dataset<Row>, Header> adjustFeatureColNamesAndGetHeader(Dataset<Row> contextDF, Map<TaggedFeatureName, Tuple2<String, String>> taggedFeatureToColumnName, Map<String, FeatureAnchorWithSource> allAnchoredFeatures, Map<String, DerivedFeature> allDerivedFeatures, Map<String, FeatureTypeConfig> inferredFeatureTypes) {
        Dataset renamedDF = (Dataset)taggedFeatureToColumnName.foldLeft(contextDF, (Function2 & Serializable & scala.Serializable)(baseDF, renamePair) -> baseDF.withColumnRenamed((String)((Tuple2)renamePair._2())._1(), (String)((Tuple2)renamePair._2())._2()));
        Map taggedFeatureToOutputColumnName = (Map)taggedFeatureToColumnName.map((Function1 & Serializable & scala.Serializable)pr -> new Tuple2(pr._1(), ((Tuple2)pr._2())._2()), Map$.MODULE$.canBuildFrom());
        Header header = this.generateHeader((Map<TaggedFeatureName, String>)taggedFeatureToOutputColumnName, allAnchoredFeatures, allDerivedFeatures, inferredFeatureTypes);
        return new Tuple2((Object)renamedDF, (Object)header);
    }

    public Option<String> getFeatureRefStrFromColumnNameOpt(String columnName) {
        None$ none$;
        if (columnName.contains(FeatureTransformation$.MODULE$.FEATURE_NAME_PREFIX())) {
            int begin = FeatureTransformation$.MODULE$.FEATURE_NAME_PREFIX().length();
            int end = columnName.contains(FeatureTransformation$.MODULE$.FEATURE_TAGS_PREFIX()) ? columnName.indexOf(FeatureTransformation$.MODULE$.FEATURE_TAGS_PREFIX()) : columnName.length();
            String featureRefStrInColumnName = columnName.substring(begin, end);
            none$ = new Some((Object)this.getFeatureRefStrFromColumnName(featureRefStrInColumnName));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public String generateJoinKeyColumnName(Seq<String> columnNameExprs) {
        String rawExprs = ((TraversableOnce)columnNameExprs.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.replaceAll("[^\\w]", ""), Seq$.MODULE$.canBuildFrom())).mkString(this.JOIN_KEY_COLUMN_EXPR_DELIMITER());
        return new StringBuilder(0).append(rawExprs).append(this.JOIN_KEY_COLUMN_RAW_EXPRESSION_DELIMITER()).append(this.encodeString(columnNameExprs.mkString(this.JOIN_KEY_COLUMN_EXPR_DELIMITER()))).toString();
    }

    public Option<String> getFeatureAlias(Seq<JoiningFeatureParams> joiningFeatureParams, String featureRef, Seq<String> keyTags, Option<DateParam> dateParam, Option<String> timeDelay) {
        return ((IterableLike)((TraversableLike)joiningFeatureParams.filter((Function1 & Serializable & scala.Serializable)y -> BoxesRunTime.boxToBoolean((boolean)DataFrameColName$.$anonfun$getFeatureAlias$1(y)))).map((Function1 & Serializable & scala.Serializable)x -> {
            Option<String> option;
            String string = x.featureName();
            String string2 = featureRef;
            if (!(string != null ? !string.equals(string2) : string2 != null) && x.keyTags().equals((Object)keyTags)) {
                Option<DateParam> option2 = x.dateParam();
                Option option3 = dateParam;
                if (!(option2 != null ? !option2.equals((Object)option3) : option3 != null)) {
                    Option<String> option4 = x.timeDelay();
                    Option option5 = timeDelay;
                    if (!(option4 != null ? !option4.equals((Object)option5) : option5 != null)) {
                        option = x.featureAlias();
                        return option;
                    }
                }
            }
            option = None$.MODULE$;
            return option;
        }, Seq$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isDefined())).flatten(Predef$.MODULE$.$conforms());
    }

    @VisibleForTesting
    public Header generateHeader(Map<TaggedFeatureName, String> featureToColumnNameMap, Map<String, FeatureAnchorWithSource> allAnchoredFeatures, Map<String, DerivedFeature> allDerivedFeatures, Map<String, FeatureTypeConfig> inferredFeatureTypeConfigs) {
        Map anchoredFeatureTypes = (Map)allAnchoredFeatures.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String featureName = (String)tuple2._1();
            FeatureAnchorWithSource anchorWithSource = (FeatureAnchorWithSource)tuple2._2();
            Option featureTypeOpt = anchorWithSource.featureAnchor().featureTypeConfigs().get((Object)featureName);
            FeatureTypeConfig inferredType = (FeatureTypeConfig)inferredFeatureTypeConfigs.getOrElse((Object)featureName, (Function0 & Serializable & scala.Serializable)() -> FeatureTypeConfig.UNDEFINED_TYPE_CONFIG);
            FeatureTypeConfig featureType = (FeatureTypeConfig)featureTypeOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> inferredType);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), (Object)featureType);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        Map derivedFeatureTypes = (Map)allDerivedFeatures.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DerivedFeature derivedFeature = (DerivedFeature)tuple2._2();
            Map<String, FeatureTypeConfig> map = derivedFeature.featureTypeConfigs();
            return map;
        }, Map$.MODULE$.canBuildFrom());
        Map allFeatureTypes = ((MapLike)inferredFeatureTypeConfigs.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x._1(), x._2()), Map$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)derivedFeatureTypes).$plus$plus((GenTraversableOnce)anchoredFeatureTypes);
        Map featuresInfo = (Map)featureToColumnNameMap.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TaggedFeatureName taggedFeatureName = (TaggedFeatureName)tuple2._1();
            String columnName = (String)tuple2._2();
            FeatureInfo featureInfo = new FeatureInfo(columnName, (FeatureTypeConfig)allFeatureTypes.getOrElse((Object)taggedFeatureName.getFeatureName(), (Function0 & Serializable & scala.Serializable)() -> FeatureTypeConfig.UNDEFINED_TYPE_CONFIG));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)taggedFeatureName), (Object)featureInfo);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        return new Header((Map<TaggedFeatureName, FeatureInfo>)featuresInfo);
    }

    private String encodeString(String tag) {
        return new Base32().encodeAsString(tag.getBytes()).replaceAll(this.BASE32_PADDING(), "");
    }

    public static final /* synthetic */ boolean $anonfun$getFeatureAlias$1(JoiningFeatureParams y) {
        return y.featureAlias().isDefined();
    }

    private DataFrameColName$() {
        MODULE$ = this;
        this.UidColumnName = "__feathr_internal_uid__";
        this.FEATURE_REF_DELIM_IN_COLNAME = "__";
        this.KEYTAG_DELIM_IN_COLNAME = "_";
        this.FEATURE_REF_KEYTAG_DELIM_IN_COLNAME = "__";
        this.EMPTY_STRING = "";
        this.ENCODED_FEATURE_COLUMN_NAME_DELIM = "__";
        this.ENCODED_FEATURE_REF_ENDING = "__base32_encoded";
        this.MAJOR_VERSION = "major";
        this.MINOR_VERSION = "minor";
        this.FEATURE_NAME = "n";
        this.FEATURE_NAMESPACE = "ns";
        this.BASE32_PADDING = "=";
        this.JOIN_KEY_COLUMN_EXPR_DELIMITER = "__";
        this.JOIN_KEY_COLUMN_RAW_EXPRESSION_DELIMITER = "_";
    }
}

