/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.client;

import com.linkedin.feathr.common.ErasedEntityTaggedFeature;
import com.linkedin.feathr.common.FeatureInfo;
import com.linkedin.feathr.common.Header;
import com.linkedin.feathr.common.JoiningFeatureParams;
import com.linkedin.feathr.common.TaggedFeatureName;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.common.exception.FeathrException;
import com.linkedin.feathr.common.exception.FeathrInputDataException;
import com.linkedin.feathr.common.package$;
import com.linkedin.feathr.offline.anchored.feature.FeatureAnchorWithSource;
import com.linkedin.feathr.offline.client.DataFrameColName$;
import com.linkedin.feathr.offline.client.FeathrClient$;
import com.linkedin.feathr.offline.config.FeathrConfig;
import com.linkedin.feathr.offline.config.FeathrConfigLoader$;
import com.linkedin.feathr.offline.config.FeatureGroupsGenerator$;
import com.linkedin.feathr.offline.config.FeatureJoinConfig;
import com.linkedin.feathr.offline.config.sources.FeatureGroupsUpdater;
import com.linkedin.feathr.offline.config.sources.FeatureGroupsUpdater$;
import com.linkedin.feathr.offline.derived.DerivedFeature;
import com.linkedin.feathr.offline.generation.DataFrameFeatureGenerator;
import com.linkedin.feathr.offline.generation.FeatureGenKeyTagAnalyzer$;
import com.linkedin.feathr.offline.generation.StreamingFeatureGenerator;
import com.linkedin.feathr.offline.job.FeatureGenSpec;
import com.linkedin.feathr.offline.job.JoinJobContext;
import com.linkedin.feathr.offline.job.JoinJobContext$;
import com.linkedin.feathr.offline.job.LocalFeatureJoinJob$;
import com.linkedin.feathr.offline.join.DataFrameFeatureJoiner;
import com.linkedin.feathr.offline.logical.FeatureGroups;
import com.linkedin.feathr.offline.logical.LogicalPlan;
import com.linkedin.feathr.offline.logical.MultiStageJoinPlan;
import com.linkedin.feathr.offline.logical.MultiStageJoinPlanner;
import com.linkedin.feathr.offline.logical.MultiStageJoinPlanner$;
import com.linkedin.feathr.offline.mvel.plugins.FeathrExpressionExecutionContext;
import com.linkedin.feathr.offline.source.DataSource;
import com.linkedin.feathr.offline.source.accessor.DataPathHandler;
import com.linkedin.feathr.offline.util.AclCheckUtils$;
import com.linkedin.feathr.offline.util.AnchorUtils$;
import com.linkedin.feathr.offline.util.FeathrUtils$;
import com.linkedin.feathr.offline.util.FeaturizedDatasetMetadata;
import com.linkedin.feathr.offline.util.FeaturizedDatasetMetadata$;
import com.linkedin.feathr.offline.util.HdfsUtils$;
import com.linkedin.feathr.offline.util.SparkFeaturizedDataset;
import com.linkedin.feathr.sparkcommon.OutputProcessor;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r]f\u0001B)S\u0001uC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tc\u0002\u0011\t\u0011)A\u0005e\"A\u0001\u0010\u0001B\u0001B\u0003%\u0011\u0010\u0003\u0005}\u0001\t\u0005\t\u0015!\u0003~\u0011)\tY\u0001\u0001B\u0001B\u0003%\u0011Q\u0002\u0005\u000b\u0003k\u0001!\u0011!Q\u0001\n\u0005]\u0002\u0002CA'\u0001\u0011\u0005A+a\u0014\t\u0013\u0005\u0005\u0004A1A\u0005\n\u0005\r\u0004\u0002CA;\u0001\u0001\u0006I!!\u001a\u0006\r\u0005]\u0004\u0001AA=\u0011)\ty\t\u0001b\u0001\n\u0003!\u0016\u0011\u0013\u0005\t\u0003S\u0003\u0001\u0015!\u0003\u0002\u0014\"Q\u00111\u0016\u0001C\u0002\u0013\u0005A+!,\t\u0011\u0005u\u0006\u0001)A\u0005\u0003_C!\"a0\u0001\u0005\u0004%\t\u0001VAI\u0011!\t\t\r\u0001Q\u0001\n\u0005M\u0005BCAb\u0001\t\u0007I\u0011\u0001+\u0002\u0012\"A\u0011Q\u0019\u0001!\u0002\u0013\t\u0019\n\u0003\u0006\u0002H\u0002\u0011\r\u0011\"\u0001U\u0003[C\u0001\"!3\u0001A\u0003%\u0011q\u0016\u0005\b\u0003\u0017\u0004A\u0011AAg\u0011%\u0011I\u0001AI\u0001\n\u0003\u0011Y\u0001C\u0004\u0003\"\u0001!\tAa\t\t\u000f\te\u0002\u0001\"\u0003\u0003<!9!Q\t\u0001\u0005\n\t\u001d\u0003\u0002\u0003B(\u0001\u0011\u0005AK!\u0015\t\u0011\t%\u0004\u0001\"\u0001U\u0005WBqAa'\u0001\t\u0013\u0011i\n\u0003\u0005\u0003(\u0002!\t\u0001\u0016BU\u0011)\u0011y\fAI\u0001\n\u0003!&\u0011\u0019\u0005\t\u0005\u000b\u0004A\u0011\u0001+\u0003H\"A!\u0011\u001a\u0001\u0005\u0002Q\u0013Y\rC\u0004\u0003N\u0002!IAa4\t\u000f\tm\u0007\u0001\"\u0003\u0003^\u001e9!Q\u001d*\t\u0002\t\u001dhAB)S\u0011\u0003\u0011I\u000fC\u0004\u0002N\u0011\"\tAa;\t\u000f\t5H\u0005\"\u0001\u0003p\u001a1!Q\u001f\u0013\u0001\u0005oD\u0001\u0002Z\u0014\u0003\u0002\u0003\u0006I!\u001a\u0005\t\u0003\u001b:C\u0011\u0001\u0013\u0003z\"I!Q`\u0014C\u0002\u0013%!q \u0005\t\u0007\u000f9\u0003\u0015!\u0003\u0004\u0002!I1\u0011B\u0014A\u0002\u0013%11\u0002\u0005\n\u0007\u001b9\u0003\u0019!C\u0005\u0007\u001fA\u0001b!\u0006(A\u0003&!q\u001c\u0005\n\u0007/9\u0003\u0019!C\u0005\u0007\u0017A\u0011b!\u0007(\u0001\u0004%Iaa\u0007\t\u0011\r}q\u0005)Q\u0005\u0005?D\u0011b!\t(\u0001\u0004%Iaa\u0003\t\u0013\r\rr\u00051A\u0005\n\r\u0015\u0002\u0002CB\u0015O\u0001\u0006KAa8\t\u0013\r-r\u00051A\u0005\n\r-\u0001\"CB\u0017O\u0001\u0007I\u0011BB\u0018\u0011!\u0019\u0019d\nQ!\n\t}\u0007\"CB\u001bO\u0001\u0007I\u0011BB\u001c\u0011%\u0019Yd\na\u0001\n\u0013\u0019i\u0004\u0003\u0005\u0004B\u001d\u0002\u000b\u0015BB\u001d\u0011%\tYa\na\u0001\n\u0013\u0019\u0019\u0005C\u0005\u0004F\u001d\u0002\r\u0011\"\u0003\u0004H!A11J\u0014!B\u0013\ti\u0001C\u0005\u00026\u001d\u0002\r\u0011\"\u0003\u0004N!I1qJ\u0014A\u0002\u0013%1\u0011\u000b\u0005\t\u0007+:\u0003\u0015)\u0003\u00028!91qK\u0014\u0005\u0002\re\u0003bBB/O\u0011\u00051q\f\u0005\b\u0007;:C\u0011AB3\u0011\u001d\u0019Yg\nC\u0001\u0007[Bqaa\u001b(\t\u0003\u0019\t\bC\u0004\u0004x\u001d\"\ta!\u001f\t\u000f\r]t\u0005\"\u0001\u0004~!91\u0011Q\u0014\u0005\u0002\r\r\u0005bBBAO\u0011\u00051q\u0011\u0005\b\u0007\u0017;C\u0011ABG\u0011\u001d\u0019Yi\nC\u0001\u0007#C\u0001b!&(\t\u0003!6q\u0013\u0005\t\u0007+;C\u0011\u0001+\u0004\u001e\"91\u0011U\u0014\u0005\u0002\r\r\u0006bBBUO\u0011\u000511\u0016\u0005\t\u0007[;C\u0011\u0001+\u00040\naa)Z1uQJ\u001cE.[3oi*\u00111\u000bV\u0001\u0007G2LWM\u001c;\u000b\u0005U3\u0016aB8gM2Lg.\u001a\u0006\u0003/b\u000baAZ3bi\"\u0014(BA-[\u0003!a\u0017N\\6fI&t'\"A.\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001q\u0006CA0c\u001b\u0005\u0001'\"A1\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0004'AB!osJ+g-\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002g_6\tqM\u0003\u0002iS\u0006\u00191/\u001d7\u000b\u0005)\\\u0017!B:qCJ\\'B\u00017n\u0003\u0019\t\u0007/Y2iK*\ta.A\u0002pe\u001eL!\u0001]4\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u001b\u0019,\u0017\r^;sK\u001e\u0013x.\u001e9t!\t\u0019h/D\u0001u\u0015\t)H+A\u0004m_\u001eL7-\u00197\n\u0005]$(!\u0004$fCR,(/Z$s_V\u00048/\u0001\bm_\u001eL7-\u00197QY\u0006tg.\u001a:\u0011\u0005MT\u0018BA>u\u0005UiU\u000f\u001c;j'R\fw-\u001a&pS:\u0004F.\u00198oKJ\fACZ3biV\u0014Xm\u0012:pkB\u001cX\u000b\u001d3bi\u0016\u0014\bc\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011aB:pkJ\u001cWm\u001d\u0006\u0004\u0003\u000b!\u0016AB2p]\u001aLw-C\u0002\u0002\n}\u0014ACR3biV\u0014Xm\u0012:pkB\u001cX\u000b\u001d3bi\u0016\u0014\u0018\u0001\u00053bi\u0006\u0004\u0016\r\u001e5IC:$G.\u001a:t!\u0019\ty!a\b\u0002&9!\u0011\u0011CA\u000e\u001d\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!bAA\f9\u00061AH]8pizJ\u0011!Y\u0005\u0004\u0003;\u0001\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003C\t\u0019C\u0001\u0003MSN$(bAA\u000fAB!\u0011qEA\u0019\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012\u0001C1dG\u0016\u001c8o\u001c:\u000b\u0007\u0005=B+\u0001\u0004t_V\u00148-Z\u0005\u0005\u0003g\tICA\bECR\f\u0007+\u0019;i\u0011\u0006tG\r\\3s\u0003-ig/\u001a7D_:$X\r\u001f;\u0011\u000b}\u000bI$!\u0010\n\u0007\u0005m\u0002M\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003\u001d\u0001H.^4j]NT1!a\u0012U\u0003\u0011ig/\u001a7\n\t\u0005-\u0013\u0011\t\u0002!\r\u0016\fG\u000f\u001b:FqB\u0014Xm]:j_:,\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u000f\u0003#\n)&a\u0016\u0002Z\u0005m\u0013QLA0!\r\t\u0019\u0006A\u0007\u0002%\")Am\u0002a\u0001K\")\u0011o\u0002a\u0001e\")\u0001p\u0002a\u0001s\")Ap\u0002a\u0001{\"9\u00111B\u0004A\u0002\u00055\u0001bBA\u001b\u000f\u0001\u0007\u0011qG\u0001\u0004Y><WCAA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\nQ\u0001\\8hi)T1!a\u001cl\u0003\u001dawnZ4j]\u001eLA!a\u001d\u0002j\t1Aj\\4hKJ\fA\u0001\\8hA\t\t2*Z=UC\u001e\u001cFO]5oOR+\b\u000f\\3\u0011\r\u0005=\u00111PA@\u0013\u0011\ti(a\t\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u0002\u0006%e\u0002BAB\u0003\u000b\u00032!a\u0005a\u0013\r\t9\tY\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0015Q\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001d\u0005-A\nbY2\fen\u00195pe\u0016$g)Z1ukJ,7/\u0006\u0002\u0002\u0014BA\u0011\u0011QAK\u0003\u007f\nI*\u0003\u0003\u0002\u0018\u00065%aA'baB!\u00111TAS\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016a\u00024fCR,(/\u001a\u0006\u0004\u0003G#\u0016\u0001C1oG\"|'/\u001a3\n\t\u0005\u001d\u0016Q\u0014\u0002\u0018\r\u0016\fG/\u001e:f\u0003:\u001c\u0007n\u001c:XSRD7k\\;sG\u0016\fA#\u00197m\u0003:\u001c\u0007n\u001c:fI\u001a+\u0017\r^;sKN\u0004\u0013AE1mY\u0012+'/\u001b<fI\u001a+\u0017\r^;sKN,\"!a,\u0011\u0011\u0005\u0005\u0015QSA@\u0003c\u0003B!a-\u0002:6\u0011\u0011Q\u0017\u0006\u0004\u0003o#\u0016a\u00023fe&4X\rZ\u0005\u0005\u0003w\u000b)L\u0001\bEKJLg/\u001a3GK\u0006$XO]3\u0002'\u0005dG\u000eR3sSZ,GMR3biV\u0014Xm\u001d\u0011\u0002-\u0005dG\u000eU1tgRD'o\\;hQ\u001a+\u0017\r^;sKN\fq#\u00197m!\u0006\u001c8\u000f\u001e5s_V<\u0007NR3biV\u0014Xm\u001d\u0011\u0002)\u0005dGnV5oI><\u0018iZ4GK\u0006$XO]3t\u0003U\tG\u000e\\,j]\u0012|w/Q4h\r\u0016\fG/\u001e:fg\u0002\n!#\u00197m'\u0016\f(j\\5o\r\u0016\fG/\u001e:fg\u0006\u0019\u0012\r\u001c7TKFTu.\u001b8GK\u0006$XO]3tA\u0005a!n\\5o\r\u0016\fG/\u001e:fgRA\u0011qZAn\u0003O\fY\u000f\u0005\u0003\u0002R\u0006]WBAAj\u0015\r\t)\u000eV\u0001\u0005kRLG.\u0003\u0003\u0002Z\u0006M'AF*qCJ\\g)Z1ukJL'0\u001a3ECR\f7/\u001a;\t\u000f\u0005uW\u00031\u0001\u0002`\u0006Q!n\\5o\u0007>tg-[4\u0011\t\u0005\u0005\u00181]\u0007\u0003\u0003\u0007IA!!:\u0002\u0004\t\tb)Z1ukJ,'j\\5o\u0007>tg-[4\t\u000f\u0005%X\u00031\u0001\u0002P\u00069qNY:ECR\f\u0007\"CAw+A\u0005\t\u0019AAx\u0003)QwNY\"p]R,\u0007\u0010\u001e\t\u0005\u0003c\f90\u0004\u0002\u0002t*\u0019\u0011Q\u001f+\u0002\u0007)|'-\u0003\u0003\u0002z\u0006M(A\u0004&pS:TuNY\"p]R,\u0007\u0010\u001e\u0015\u0004+\u0005u\b\u0003BA\u0000\u0005\u000bi!A!\u0001\u000b\u0007\t\ra+\u0001\u0004d_6lwN\\\u0005\u0005\u0005\u000f\u0011\tAA\u0006J]R,'O\\1m\u0003BL\u0017A\u00066pS:4U-\u0019;ve\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t5!\u0006BAx\u0005\u001fY#A!\u0005\u0011\t\tM!QD\u0007\u0003\u0005+QAAa\u0006\u0003\u001a\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00057\u0001\u0017AC1o]>$\u0018\r^5p]&!!q\u0004B\u000b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0011O\u0016tWM]1uK\u001a+\u0017\r^;sKN$BA!\n\u0003.AA\u0011\u0011QAK\u0005O\ty\r\u0005\u0003\u0002\u0000\n%\u0012\u0002\u0002B\u0016\u0005\u0003\u0011\u0011\u0003V1hO\u0016$g)Z1ukJ,g*Y7f\u0011\u001d\u0011yc\u0006a\u0001\u0005c\taBZ3biV\u0014XmR3o'B,7\r\u0005\u0003\u0002r\nM\u0012\u0002\u0002B\u001b\u0003g\u0014aBR3biV\u0014XmR3o'B,7\rK\u0002\u0018\u0003{\f1\"[:TiJ,\u0017-\\5oOR!!Q\bB\"!\ry&qH\u0005\u0004\u0005\u0003\u0002'a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005_A\u0002\u0019\u0001B\u0019\u0003E\u0001(/\u001a9be\u0016,\u00050Z2vi\u0016,eN\u001e\u000b\u0003\u0005\u0013\u00022a\u0018B&\u0013\r\u0011i\u0005\u0019\u0002\u0005+:LG/\u0001\u000bhKR\fE\u000e\u001c$fCR,(/Z*pkJ\u001cWm\u001d\u000b\u0005\u0005'\u0012i\u0006\u0005\u0004\u0002\u0010\u0005}!Q\u000b\t\u0005\u0005/\u0012I&\u0004\u0002\u0002.%!!1LA\u0017\u0005)!\u0015\r^1T_V\u00148-\u001a\u0005\b\u0005?R\u0002\u0019\u0001B1\u0003E\u0011X-];fgR,GMR3biV\u0014Xm\u001d\t\u0007\u0003\u001f\tYHa\u0019\u0011\t\u0005}(QM\u0005\u0005\u0005O\u0012\tA\u0001\u000bK_&t\u0017N\\4GK\u0006$XO]3QCJ\fWn]\u0001\u0015I>Tu.\u001b8PEN\fe\u000e\u001a$fCR,(/Z:\u0015\u0011\t5$Q\u0013BL\u00053\u0003ra\u0018B8\u0005g\u0012y)C\u0002\u0003r\u0001\u0014a\u0001V;qY\u0016\u0014\u0004\u0003\u0002B;\u0005\u0013sAAa\u001e\u0003\b:!!\u0011\u0010BC\u001d\u0011\u0011YHa!\u000f\t\tu$\u0011\u0011\b\u0005\u0003'\u0011y(C\u0001o\u0013\taW.\u0003\u0002kW&\u0011\u0001.[\u0005\u0004\u0003;9\u0017\u0002\u0002BF\u0005\u001b\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005uq\r\u0005\u0003\u0002\u0000\nE\u0015\u0002\u0002BJ\u0005\u0003\u0011a\u0001S3bI\u0016\u0014\bbBAo7\u0001\u0007\u0011q\u001c\u0005\b\u0003[\\\u0002\u0019AAx\u0011\u001d\tIo\u0007a\u0001\u0005g\n\u0001DZ5oI\u000e{gN\u001a7jGR4U-\u0019;ve\u0016t\u0015-\\3t)\u0019\tIHa(\u0003$\"9!\u0011\u0015\u000fA\u0002\t\u0005\u0014!E6fsR\u000bwmZ3e\r\u0016\fG/\u001e:fg\"9!Q\u0015\u000fA\u0002\u0005e\u0014A\u00034jK2$g*Y7fg\u0006\u0001\"n\\5o\r\u0016\fG/\u001e:fg\u0006\u001bHI\u0012\u000b\u000b\u0005[\u0012YK!,\u00030\nM\u0006bBAo;\u0001\u0007\u0011q\u001c\u0005\b\u0005Ck\u0002\u0019\u0001B1\u0011\u001d\u0011\t,\ba\u0001\u0005g\nA\u0001\\3gi\"I!QW\u000f\u0011\u0002\u0003\u0007!qW\u0001\u0018e><(\t\\8p[\u001aKG\u000e^3s)\"\u0014Xm\u001d5pY\u0012\u0004RaXA\u001d\u0005s\u00032a\u0018B^\u0013\r\u0011i\f\u0019\u0002\u0004\u0013:$\u0018A\u00076pS:4U-\u0019;ve\u0016\u001c\u0018i\u001d#GI\u0011,g-Y;mi\u0012\"TC\u0001BbU\u0011\u00119La\u0004\u0002!\u001d,GOR3biV\u0014Xm\u0012:pkB\u001cH#\u0001:\u0002#\u001d,G\u000fT8hS\u000e\fG\u000e\u00157b]:,'\u000fF\u0001z\u0003U\u0019HO]5oO&4\u0017PR3biV\u0014XMT1nKN$B!a \u0003R\"9!1[\u0011A\u0002\tU\u0017a\u00028b[\u0016\u001cV\r\u001e\t\u0007\u0003\u0003\u00139.a \n\t\te\u0017Q\u0012\u0002\u0004'\u0016$\u0018A\u00064j]\u0012LeN^1mS\u00124U-\u0019;ve\u0016\u0014VMZ:\u0015\t\t}'\u0011\u001d\t\u0007\u0003\u001f\ty\"a \t\u000f\t\r(\u00051\u0001\u0003b\u0005Aa-Z1ukJ,7/\u0001\u0007GK\u0006$\bN]\"mS\u0016tG\u000fE\u0002\u0002T\u0011\u001a\"\u0001\n0\u0015\u0005\t\u001d\u0018a\u00022vS2$WM\u001d\u000b\u0005\u0005c\u001c)\fE\u0002\u0003t\u001ej\u0011\u0001\n\u0002\b\u0005VLG\u000eZ3s'\t9c\f\u0006\u0003\u0003r\nm\b\"\u00023*\u0001\u0004)\u0017A\u00054fCRD'oQ8oM&<Gj\\1eKJ,\"a!\u0001\u0011\t\u0005\u000581A\u0005\u0005\u0007\u000b\t\u0019A\u0001\u0007GK\u0006$\bN]\"p]\u001aLw-A\ngK\u0006$\bN]\"p]\u001aLw\rT8bI\u0016\u0014\b%\u0001\u0006gK\u0006$XO]3EK\u001a,\"Aa8\u0002\u001d\u0019,\u0017\r^;sK\u0012+gm\u0018\u0013fcR!!\u0011JB\t\u0011%\u0019\u0019\"LA\u0001\u0002\u0004\u0011y.A\u0002yIE\n1BZ3biV\u0014X\rR3gA\u0005\u0001Bn\\2bY>3XM\u001d:jI\u0016$UMZ\u0001\u0015Y>\u001c\u0017\r\\(wKJ\u0014\u0018\u000eZ3EK\u001a|F%Z9\u0015\t\t%3Q\u0004\u0005\n\u0007'\u0001\u0014\u0011!a\u0001\u0005?\f\u0011\u0003\\8dC2|e/\u001a:sS\u0012,G)\u001a4!\u000391W-\u0019;ve\u0016$UM\u001a)bi\"\f!CZ3biV\u0014X\rR3g!\u0006$\bn\u0018\u0013fcR!!\u0011JB\u0014\u0011%\u0019\u0019bMA\u0001\u0002\u0004\u0011y.A\bgK\u0006$XO]3EK\u001a\u0004\u0016\r\u001e5!\u0003QawnY1m\u001fZ,'O]5eK\u0012+g\rU1uQ\u0006ABn\\2bY>3XM\u001d:jI\u0016$UM\u001a)bi\"|F%Z9\u0015\t\t%3\u0011\u0007\u0005\n\u0007'1\u0014\u0011!a\u0001\u0005?\fQ\u0003\\8dC2|e/\u001a:sS\u0012,G)\u001a4QCRD\u0007%A\bgK\u0006$XO]3EK\u001a\u001cuN\u001c4t+\t\u0019I\u0004\u0005\u0004\u0002\u0010\u0005}1\u0011A\u0001\u0014M\u0016\fG/\u001e:f\t\u001647i\u001c8gg~#S-\u001d\u000b\u0005\u0005\u0013\u001ay\u0004C\u0005\u0004\u0014e\n\t\u00111\u0001\u0004:\u0005\u0001b-Z1ukJ,G)\u001a4D_:47\u000fI\u000b\u0003\u0003\u001b\tA\u0003Z1uCB\u000bG\u000f\u001b%b]\u0012dWM]:`I\u0015\fH\u0003\u0002B%\u0007\u0013B\u0011ba\u0005=\u0003\u0003\u0005\r!!\u0004\u0002#\u0011\fG/\u0019)bi\"D\u0015M\u001c3mKJ\u001c\b%\u0006\u0002\u00028\u0005yQN^3m\u0007>tG/\u001a=u?\u0012*\u0017\u000f\u0006\u0003\u0003J\rM\u0003\"CB\n\u007f\u0005\u0005\t\u0019AA\u001c\u00031ig/\u001a7D_:$X\r\u001f;!\u0003M\tG\r\u001a#bi\u0006\u0004\u0016\r\u001e5IC:$G.\u001a:t)\u0011\u0011\tpa\u0017\t\u000f\u0005-\u0011\t1\u0001\u0002\u000e\u0005\u0011\u0012\r\u001a3ECR\f\u0007+\u0019;i\u0011\u0006tG\r\\3s)\u0011\u0011\tp!\u0019\t\u000f\r\r$\t1\u0001\u0002&\u0005yA-\u0019;b!\u0006$\b\u000eS1oI2,'\u000f\u0006\u0003\u0003r\u000e\u001d\u0004bBB2\u0007\u0002\u00071\u0011\u000e\t\u0006?\u0006e\u0012QE\u0001\u000eC\u0012$g)Z1ukJ,G)\u001a4\u0015\t\tE8q\u000e\u0005\b\u0007\u0013!\u0005\u0019AA@)\u0011\u0011\tpa\u001d\t\u000f\r%Q\t1\u0001\u0004vA)q,!\u000f\u0002\u0000\u0005\u0019\u0012\r\u001a3M_\u000e\fGn\u0014<feJLG-\u001a#fMR!!\u0011_B>\u0011\u001d\u00199B\u0012a\u0001\u0003\u007f\"BA!=\u0004\u0000!91qC$A\u0002\rU\u0014!E1eI\u001a+\u0017\r^;sK\u0012+g\rU1uQR!!\u0011_BC\u0011\u001d\u0019\t\u0003\u0013a\u0001\u0003\u007f\"BA!=\u0004\n\"91\u0011E%A\u0002\rU\u0014aF1eI2{7-\u00197Pm\u0016\u0014(/\u001b3f\t\u00164\u0007+\u0019;i)\u0011\u0011\tpa$\t\u000f\r-\"\n1\u0001\u0002\u0000Q!!\u0011_BJ\u0011\u001d\u0019Yc\u0013a\u0001\u0007k\n!#\u00193e\r\u0016\fG/\u001e:f\t\u001647i\u001c8ggR!!\u0011_BM\u0011\u001d\u0019)\u0004\u0014a\u0001\u00077\u0003RaXA\u001d\u0007s!BA!=\u0004 \"91QG'A\u0002\re\u0012AG1eI\u001a+\u0017\r\u001e5s\u000bb\u0004(/Z:tS>t7i\u001c8uKb$H\u0003\u0002By\u0007KCqaa*O\u0001\u0004\t9$\u0001\u0007`[Z,GnQ8oi\u0016DH/A\u0003ck&dG\r\u0006\u0002\u0002R\u0005a!/Z1e\u0011\u001247OR5mKR!1QOBY\u0011\u001d\u0019\u0019\f\u0015a\u0001\u0007k\nA\u0001]1uQ\")AM\na\u0001K\u0002")
public class FeathrClient {
    private final SparkSession sparkSession;
    private final FeatureGroups featureGroups;
    private final MultiStageJoinPlanner logicalPlanner;
    private final FeatureGroupsUpdater featureGroupsUpdater;
    private final List<DataPathHandler> dataPathHandlers;
    private final Option<FeathrExpressionExecutionContext> mvelContext;
    private final Logger log;
    private final Map<String, FeatureAnchorWithSource> allAnchoredFeatures;
    private final Map<String, DerivedFeature> allDerivedFeatures;
    private final Map<String, FeatureAnchorWithSource> allPassthroughFeatures;
    private final Map<String, FeatureAnchorWithSource> allWindowAggFeatures;
    private final Map<String, DerivedFeature> allSeqJoinFeatures;

    public static Builder builder(SparkSession sparkSession) {
        return FeathrClient$.MODULE$.builder(sparkSession);
    }

    private Logger log() {
        return this.log;
    }

    public Map<String, FeatureAnchorWithSource> allAnchoredFeatures() {
        return this.allAnchoredFeatures;
    }

    public Map<String, DerivedFeature> allDerivedFeatures() {
        return this.allDerivedFeatures;
    }

    public Map<String, FeatureAnchorWithSource> allPassthroughFeatures() {
        return this.allPassthroughFeatures;
    }

    public Map<String, FeatureAnchorWithSource> allWindowAggFeatures() {
        return this.allWindowAggFeatures;
    }

    public Map<String, DerivedFeature> allSeqJoinFeatures() {
        return this.allSeqJoinFeatures;
    }

    public SparkFeaturizedDataset joinFeatures(FeatureJoinConfig joinConfig, SparkFeaturizedDataset obsData, JoinJobContext jobContext) {
        SparkConf sparkConf = this.sparkSession.sparkContext().getConf();
        FeathrUtils$.MODULE$.enableDebugLogging(sparkConf);
        Tuple2<Dataset<Row>, Header> tuple2 = this.doJoinObsAndFeatures(joinConfig, jobContext, obsData.data());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Dataset joinedDF = (Dataset)tuple2._1();
        Header header = (Header)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)joinedDF, (Object)header);
        Tuple2 tuple23 = tuple22;
        Dataset joinedDF2 = (Dataset)tuple23._1();
        Header header2 = (Header)tuple23._2();
        Some x$1 = new Some((Object)header2);
        Map<String, String> x$2 = FeaturizedDatasetMetadata$.MODULE$.apply$default$1();
        return new SparkFeaturizedDataset((Dataset<Row>)joinedDF2, new FeaturizedDatasetMetadata(x$2, (Option<Header>)x$1));
    }

    public JoinJobContext joinFeatures$default$3() {
        return new JoinJobContext(JoinJobContext$.MODULE$.apply$default$1(), JoinJobContext$.MODULE$.apply$default$2(), JoinJobContext$.MODULE$.apply$default$3(), JoinJobContext$.MODULE$.apply$default$4(), JoinJobContext$.MODULE$.apply$default$5());
    }

    public Map<TaggedFeatureName, SparkFeaturizedDataset> generateFeatures(FeatureGenSpec featureGenSpec) {
        Map map;
        this.prepareExecuteEnv();
        Seq<JoiningFeatureParams> keyTaggedAnchoredFeatures = FeatureGenKeyTagAnalyzer$.MODULE$.inferKeyTagsForAnchoredFeatures(featureGenSpec, this.featureGroups);
        Seq<JoiningFeatureParams> keyTaggedDerivedFeatures = FeatureGenKeyTagAnalyzer$.MODULE$.inferKeyTagsForDerivedFeatures(featureGenSpec, this.featureGroups, keyTaggedAnchoredFeatures);
        Seq keyTaggedRequiredFeatures = (Seq)keyTaggedAnchoredFeatures.$plus$plus(keyTaggedDerivedFeatures, Seq$.MODULE$.canBuildFrom());
        if (this.isStreaming(featureGenSpec)) {
            StreamingFeatureGenerator streamingFeatureGenerator = new StreamingFeatureGenerator(this.dataPathHandlers);
            streamingFeatureGenerator.generateFeatures(this.sparkSession, featureGenSpec, this.featureGroups, (Seq<JoiningFeatureParams>)keyTaggedRequiredFeatures);
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        } else {
            LogicalPlan logicalPlan = this.logicalPlanner.getLogicalPlan(this.featureGroups, keyTaggedRequiredFeatures);
            DataFrameFeatureGenerator dataFrameFeatureGenerator = new DataFrameFeatureGenerator((MultiStageJoinPlan)logicalPlan, this.dataPathHandlers, this.mvelContext);
            Map<TaggedFeatureName, Tuple2<Dataset<Row>, Header>> featureMap = dataFrameFeatureGenerator.generateFeaturesAsDF(this.sparkSession, featureGenSpec, this.featureGroups, (Seq<JoiningFeatureParams>)keyTaggedRequiredFeatures);
            map = (Map)featureMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                TaggedFeatureName taggedFeatureName;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$1;
                        if (tuple22 == null) break block2;
                        taggedFeatureName = (TaggedFeatureName)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Dataset df = (Dataset)tuple2._1();
                SparkFeaturizedDataset fds = new SparkFeaturizedDataset((Dataset<Row>)df, new FeaturizedDatasetMetadata(FeaturizedDatasetMetadata$.MODULE$.apply$default$1(), FeaturizedDatasetMetadata$.MODULE$.apply$default$2()));
                Tuple2 tuple23 = new Tuple2((Object)taggedFeatureName, (Object)fds);
                return tuple23;
            }, Map$.MODULE$.canBuildFrom());
        }
        return map;
    }

    private boolean isStreaming(FeatureGenSpec featureGenSpec) {
        Seq<OutputProcessor> outputProcessors = featureGenSpec.getProcessorList();
        return !outputProcessors.isEmpty() ? BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)outputProcessors.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FeathrClient.$anonfun$isStreaming$1(p)), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToBoolean((boolean)FeathrClient.$anonfun$isStreaming$2(BoxesRunTime.unboxToBoolean((Object)x$2), BoxesRunTime.unboxToBoolean((Object)x$3))))) : false;
    }

    private void prepareExecuteEnv() {
        SQLConf$.MODULE$.get().setConfString("spark.sql.legacy.allowUntypedScalaUDF", "true");
    }

    public List<DataSource> getAllFeatureSources(Seq<JoiningFeatureParams> requestedFeatures) {
        LogicalPlan logicalPlan = this.logicalPlanner.getLogicalPlan(this.featureGroups, (Seq)requestedFeatures);
        Seq<ErasedEntityTaggedFeature> allRequiredFeatures = ((MultiStageJoinPlan)logicalPlan).allRequiredFeatures();
        Seq sources = (Seq)((SeqLike)allRequiredFeatures.collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FeathrClient $outer;

            public final <A1 extends ErasedEntityTaggedFeature, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (this.$outer.allAnchoredFeatures().contains((Object)A1.getFeatureName())) {
                    String featureName = A1.getFeatureName();
                    object = ((FeatureAnchorWithSource)this.$outer.allAnchoredFeatures().apply((Object)featureName)).source();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ErasedEntityTaggedFeature x1) {
                ErasedEntityTaggedFeature erasedEntityTaggedFeature = x1;
                boolean bl = this.$outer.allAnchoredFeatures().contains((Object)erasedEntityTaggedFeature.getFeatureName());
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        return sources.toList();
    }

    public Tuple2<Dataset<Row>, Header> doJoinObsAndFeatures(FeatureJoinConfig joinConfig, JoinJobContext jobContext, Dataset<Row> obsData) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        this.log().info(new StringBuilder(38).append("All anchored feature names (sorted):\n\t").append(this.stringifyFeatureNames((Set<String>)this.allAnchoredFeatures().keySet())).toString());
        this.log().info(new StringBuilder(37).append("All derived feature names (sorted):\n\t").append(this.stringifyFeatureNames((Set<String>)this.allDerivedFeatures().keySet())).toString());
        this.prepareExecuteEnv();
        boolean enableCheckPoint = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(this.sparkSession, FeathrUtils$.MODULE$.ENABLE_CHECKPOINT()))).toBoolean();
        String checkpointDir = FeathrUtils$.MODULE$.getFeathrJobParam(this.sparkSession, FeathrUtils$.MODULE$.CHECKPOINT_OUTPUT_PATH());
        if (enableCheckPoint) {
            if (checkpointDir.equals("")) {
                throw new FeathrException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(46).append("Please set ").append(FeathrUtils$.MODULE$.FEATHR_PARAMS_PREFIX()).append(FeathrUtils$.MODULE$.CHECKPOINT_OUTPUT_PATH()).append(" to a folder with write permission.").toString());
            }
            HdfsUtils$.MODULE$.deletePath(checkpointDir, true, HdfsUtils$.MODULE$.deletePath$default$3());
            this.sparkSession.sparkContext().setCheckpointDir(checkpointDir);
        }
        Map<String, Seq<JoiningFeatureParams>> featureGroupings = joinConfig.featureGroupings();
        this.log().info(new StringBuilder(19).append("Join job context: ").append(jobContext).append(")").toString());
        this.log().info(new StringBuilder(12).append("joinConfig: ").append(joinConfig).toString());
        this.log().info(new StringBuilder(28).append("featureGroupings passed in: ").append(featureGroupings).toString());
        int rowBloomFilterThreshold = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(this.sparkSession, FeathrUtils$.MODULE$.ROW_BLOOMFILTER_MAX_THRESHOLD()))).toInt();
        Seq joinFeatures = (Seq)((TraversableOnce)featureGroupings.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct();
        if (featureGroupings.isEmpty()) {
            this.log().warn("Feature groupings from the join config is empty, returning the obs data without joining any features.");
            tuple22 = new Tuple2(obsData, (Object)new Header((Map<TaggedFeatureName, FeatureInfo>)Predef$.MODULE$.Map().empty()));
        } else {
            tuple22 = tuple2 = this.joinFeaturesAsDF(joinConfig, (Seq<JoiningFeatureParams>)joinFeatures, obsData, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)rowBloomFilterThreshold)));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Dataset joinedDF = (Dataset)tuple2._1();
        Header header = (Header)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)joinedDF, (Object)header);
        Tuple2 tuple24 = tuple23;
        Dataset joinedDF2 = (Dataset)tuple24._1();
        Header header2 = (Header)tuple24._2();
        if (this.log().isDebugEnabled()) {
            this.log().debug("joinedDF:");
            joinedDF2.show(false);
            this.log().debug(new StringBuilder(23).append("header featureInfoMap: ").append(header2.featureInfoMap()).toString());
        }
        return new Tuple2((Object)joinedDF2, (Object)header2);
    }

    private Seq<String> findConflictFeatureNames(Seq<JoiningFeatureParams> keyTaggedFeatures, Seq<String> fieldNames) {
        return (Seq)((SeqLike)keyTaggedFeatures.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.featureName(), Seq$.MODULE$.canBuildFrom())).intersect(fieldNames);
    }

    public Tuple2<Dataset<Row>, Header> joinFeaturesAsDF(FeatureJoinConfig joinConfig, Seq<JoiningFeatureParams> keyTaggedFeatures, Dataset<Row> left, Option<Object> rowBloomFilterThreshold) {
        BoxedUnit boxedUnit;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])left.head(1))).isEmpty()) {
            this.log().info("Observation is empty");
            return new Tuple2(left, (Object)new Header((Map<TaggedFeatureName, FeatureInfo>)Predef$.MODULE$.Map().empty()));
        }
        FeatureGroups updatedFeatureGroups = this.featureGroupsUpdater.updateFeatureGroups(this.featureGroups, keyTaggedFeatures);
        LogicalPlan logicalPlan = this.logicalPlanner.getLogicalPlan(updatedFeatureGroups, (Seq)keyTaggedFeatures);
        boolean shouldSkipFeature = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(this.sparkSession.sparkContext().getConf(), FeathrUtils$.MODULE$.SKIP_MISSING_FEATURE()))).toBoolean();
        Map featureToPathsMap = ((TraversableOnce)((MultiStageJoinPlan)logicalPlan).allRequiredFeatures().flatMap((Function1 & Serializable & scala.Serializable)requiredFeature -> Option$.MODULE$.option2Iterable(this.allAnchoredFeatures().get((Object)requiredFeature.getFeatureName()).map((Function1 & Serializable & scala.Serializable)featureAnchorWithSource -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)requiredFeature.getFeatureName()), (Object)featureAnchorWithSource.source().path()))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (!this.sparkSession.sparkContext().isLocal()) {
            Object object;
            Tuple2<Try<BoxedUnit>, Seq<String>> featurePathsTest = AclCheckUtils$.MODULE$.checkReadAuthorization(this.sparkSession, ((MultiStageJoinPlan)logicalPlan).allRequiredFeatures(), this.allAnchoredFeatures());
            Try try_ = (Try)featurePathsTest._1();
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (!(shouldSkipFeature || this.sparkSession.sparkContext().isLocal() && BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(LocalFeatureJoinJob$.MODULE$.SKIP_MISSING_FEATURE())))) {
                    throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, "Unable to verify read authorization on feature data, it can be due to the following reasons: 1) input not exist, 2) no permission.", exception);
                }
                FeatureGroups featureGroupsWithoutInvalidFeatures = FeatureGroupsUpdater$.MODULE$.apply().getUpdatedFeatureGroupsWithoutInvalidPaths((Map<String, String>)featureToPathsMap, updatedFeatureGroups, (Seq<String>)((Seq)featurePathsTest._2()));
                object = this.logicalPlanner.getLogicalPlan(featureGroupsWithoutInvalidFeatures, (Seq)keyTaggedFeatures);
            } else if (try_ instanceof Success) {
                this.log().debug("Checked read authorization on all feature data");
                object = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)try_);
            }
            boxedUnit = object;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        List<String> invalidFeatureNames = this.findInvalidFeatureRefs(keyTaggedFeatures);
        if (invalidFeatureNames.nonEmpty()) {
            throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(77).append("Feature names must conform to ").append("regular expression: ").append(AnchorUtils$.MODULE$.featureNamePattern()).append(", but found feature names: ").append(invalidFeatureNames).toString());
        }
        Seq<String> conflictFeatureNames = this.findConflictFeatureNames(keyTaggedFeatures, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])left.schema().fieldNames()));
        if (conflictFeatureNames.nonEmpty()) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(152).append("Feature names must be different from field names in the observation data. ").append("Please rename feature ").append(conflictFeatureNames).append(" or rename the same field names in the observation data.").toString());
        }
        DataFrameFeatureJoiner joiner = new DataFrameFeatureJoiner((MultiStageJoinPlan)logicalPlan, this.dataPathHandlers, this.mvelContext);
        return joiner.joinFeaturesAsDF(this.sparkSession, joinConfig, updatedFeatureGroups, keyTaggedFeatures, left, rowBloomFilterThreshold);
    }

    public Option<Object> joinFeaturesAsDF$default$4() {
        return None$.MODULE$;
    }

    public FeatureGroups getFeatureGroups() {
        return this.featureGroups;
    }

    public MultiStageJoinPlanner getLogicalPlanner() {
        return this.logicalPlanner;
    }

    private String stringifyFeatureNames(Set<String> nameSet) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)nameSet.toSeq().sorted((Ordering)Ordering.String$.MODULE$)).toArray(ClassTag$.MODULE$.apply(String.class)))).mkString("\n\t");
    }

    private List<String> findInvalidFeatureRefs(Seq<JoiningFeatureParams> features) {
        return (List)features.foldLeft((Object)List$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(acc, f) -> {
            List list;
            String featureRefStr = f.featureName().toString();
            String featureRefStrInDF = DataFrameColName$.MODULE$.getEncodedFeatureRefStrForColName(featureRefStr);
            boolean isValidSyntax = AnchorUtils$.MODULE$.featureNamePattern().matcher(featureRefStrInDF).matches();
            if (isValidSyntax) {
                list = acc;
            } else {
                String string = featureRefStr;
                list = acc.$colon$colon((Object)string);
            }
            return list;
        });
    }

    public static final /* synthetic */ boolean $anonfun$isStreaming$1(OutputProcessor p) {
        return package$.MODULE$.RichConfig(p.outputProcessorConfig().getParams()).getBooleanWithDefault("streaming", false);
    }

    public static final /* synthetic */ boolean $anonfun$isStreaming$2(boolean x$2, boolean x$3) {
        return x$2 || x$3;
    }

    public FeathrClient(SparkSession sparkSession, FeatureGroups featureGroups, MultiStageJoinPlanner logicalPlanner, FeatureGroupsUpdater featureGroupsUpdater, List<DataPathHandler> dataPathHandlers, Option<FeathrExpressionExecutionContext> mvelContext) {
        this.sparkSession = sparkSession;
        this.featureGroups = featureGroups;
        this.logicalPlanner = logicalPlanner;
        this.featureGroupsUpdater = featureGroupsUpdater;
        this.dataPathHandlers = dataPathHandlers;
        this.mvelContext = mvelContext;
        this.log = LogManager.getLogger(this.getClass());
        this.allAnchoredFeatures = featureGroups.allAnchoredFeatures();
        this.allDerivedFeatures = featureGroups.allDerivedFeatures();
        this.allPassthroughFeatures = featureGroups.allPassthroughFeatures();
        this.allWindowAggFeatures = featureGroups.allWindowAggFeatures();
        this.allSeqJoinFeatures = featureGroups.allSeqJoinFeatures();
    }

    public static class Builder {
        private final SparkSession sparkSession;
        private final FeathrConfig feathrConfigLoader;
        private List<String> featureDef;
        private List<String> localOverrideDef;
        private List<String> featureDefPath;
        private List<String> localOverrideDefPath;
        private List<FeathrConfig> featureDefConfs;
        private List<DataPathHandler> dataPathHandlers;
        private Option<FeathrExpressionExecutionContext> mvelContext;

        private FeathrConfig feathrConfigLoader() {
            return this.feathrConfigLoader;
        }

        private List<String> featureDef() {
            return this.featureDef;
        }

        private void featureDef_$eq(List<String> x$1) {
            this.featureDef = x$1;
        }

        private List<String> localOverrideDef() {
            return this.localOverrideDef;
        }

        private void localOverrideDef_$eq(List<String> x$1) {
            this.localOverrideDef = x$1;
        }

        private List<String> featureDefPath() {
            return this.featureDefPath;
        }

        private void featureDefPath_$eq(List<String> x$1) {
            this.featureDefPath = x$1;
        }

        private List<String> localOverrideDefPath() {
            return this.localOverrideDefPath;
        }

        private void localOverrideDefPath_$eq(List<String> x$1) {
            this.localOverrideDefPath = x$1;
        }

        private List<FeathrConfig> featureDefConfs() {
            return this.featureDefConfs;
        }

        private void featureDefConfs_$eq(List<FeathrConfig> x$1) {
            this.featureDefConfs = x$1;
        }

        private List<DataPathHandler> dataPathHandlers() {
            return this.dataPathHandlers;
        }

        private void dataPathHandlers_$eq(List<DataPathHandler> x$1) {
            this.dataPathHandlers = x$1;
        }

        private Option<FeathrExpressionExecutionContext> mvelContext() {
            return this.mvelContext;
        }

        private void mvelContext_$eq(Option<FeathrExpressionExecutionContext> x$1) {
            this.mvelContext = x$1;
        }

        public Builder addDataPathHandlers(List<DataPathHandler> dataPathHandlers) {
            this.dataPathHandlers_$eq((List<DataPathHandler>)((List)dataPathHandlers.$plus$plus(this.dataPathHandlers(), List$.MODULE$.canBuildFrom())));
            return this;
        }

        public Builder addDataPathHandler(DataPathHandler dataPathHandler) {
            DataPathHandler dataPathHandler2 = dataPathHandler;
            this.dataPathHandlers_$eq((List<DataPathHandler>)this.dataPathHandlers().$colon$colon((Object)dataPathHandler2));
            return this;
        }

        public Builder addDataPathHandler(Option<DataPathHandler> dataPathHandler) {
            return dataPathHandler.isDefined() ? this.addDataPathHandler((DataPathHandler)dataPathHandler.get()) : this;
        }

        public Builder addFeatureDef(String featureDef) {
            String string = featureDef;
            this.featureDef_$eq((List<String>)this.featureDef().$colon$colon((Object)string));
            return this;
        }

        public Builder addFeatureDef(Option<String> featureDef) {
            return featureDef.isDefined() ? this.addFeatureDef((String)featureDef.get()) : this;
        }

        public Builder addLocalOverrideDef(String localOverrideDef) {
            String string = localOverrideDef;
            this.localOverrideDef_$eq((List<String>)this.localOverrideDef().$colon$colon((Object)string));
            return this;
        }

        public Builder addLocalOverrideDef(Option<String> localOverrideDef) {
            return localOverrideDef.isDefined() ? this.addFeatureDef((String)localOverrideDef.get()) : this;
        }

        public Builder addFeatureDefPath(String featureDefPath) {
            String string = featureDefPath;
            this.featureDefPath_$eq((List<String>)this.featureDefPath().$colon$colon((Object)string));
            return this;
        }

        public Builder addFeatureDefPath(Option<String> featureDefPath) {
            return featureDefPath.isDefined() ? this.addFeatureDefPath((String)featureDefPath.get()) : this;
        }

        public Builder addLocalOverrideDefPath(String localOverrideDefPath) {
            String string = localOverrideDefPath;
            this.localOverrideDefPath_$eq((List<String>)this.localOverrideDefPath().$colon$colon((Object)string));
            return this;
        }

        public Builder addLocalOverrideDefPath(Option<String> localOverrideDefPath) {
            return localOverrideDefPath.isDefined() ? this.addLocalOverrideDefPath((String)localOverrideDefPath.get()) : this;
        }

        public Builder addFeatureDefConfs(Option<List<FeathrConfig>> featureDefConfs) {
            return featureDefConfs.isDefined() ? this.addFeatureDefConfs((List<FeathrConfig>)((List)featureDefConfs.get())) : this;
        }

        public Builder addFeatureDefConfs(List<FeathrConfig> featureDefConfs) {
            this.featureDefConfs_$eq(featureDefConfs);
            return this;
        }

        public Builder addFeathrExpressionContext(Option<FeathrExpressionExecutionContext> _mvelContext) {
            this.mvelContext_$eq(_mvelContext);
            return this;
        }

        public FeathrClient build() {
            Predef$.MODULE$.require(!this.localOverrideDefPath().isEmpty() || !this.localOverrideDef().isEmpty() || !this.featureDefPath().isEmpty() || !this.featureDef().isEmpty() || !this.featureDefConfs().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Cannot build feathrClient without a feature def conf file/string or local override def conf file/string");
            ObjectRef featureDefConfigs = ObjectRef.create((Object)List$.MODULE$.empty());
            ObjectRef localDefConfigs = ObjectRef.create((Object)List$.MODULE$.empty());
            Object object = this.featureDefPath().nonEmpty() ? this.featureDefPath().map((Function1 & Serializable & scala.Serializable)path -> {
                Builder.$anonfun$build$2(this, featureDefConfigs, path);
                return BoxedUnit.UNIT;
            }, List$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
            Object object2 = this.featureDef().nonEmpty() ? this.featureDef().map((Function1 & Serializable & scala.Serializable)confStr -> {
                Builder.$anonfun$build$4(this, featureDefConfigs, confStr);
                return BoxedUnit.UNIT;
            }, List$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
            Object object3 = this.localOverrideDefPath().nonEmpty() ? this.localOverrideDefPath().map((Function1 & Serializable & scala.Serializable)path -> {
                Builder.$anonfun$build$5(this, localDefConfigs, path);
                return BoxedUnit.UNIT;
            }, List$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
            Object object4 = this.localOverrideDef().nonEmpty() ? this.localOverrideDef().map((Function1 & Serializable & scala.Serializable)confStr -> {
                Builder.$anonfun$build$7(this, localDefConfigs, confStr);
                return BoxedUnit.UNIT;
            }, List$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
            featureDefConfigs.elem = (List)((List)featureDefConfigs.elem).$plus$plus(this.featureDefConfs(), List$.MODULE$.canBuildFrom());
            FeatureGroups featureGroups = FeatureGroupsGenerator$.MODULE$.apply((Seq<FeathrConfig>)((List)featureDefConfigs.elem), (Option<Seq<FeathrConfig>>)new Some((Object)((List)localDefConfigs.elem))).getFeatureGroups();
            FeathrClient feathrClient = new FeathrClient(this.sparkSession, featureGroups, MultiStageJoinPlanner$.MODULE$.apply(), FeatureGroupsUpdater$.MODULE$.apply(), this.dataPathHandlers(), this.mvelContext());
            return feathrClient;
        }

        public Option<String> readHdfsFile(Option<String> path) {
            return path.map((Function1 & Serializable & scala.Serializable)p -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.sparkSession.sparkContext().textFile(p, $this.sparkSession.sparkContext().textFile$default$2()).collect())).mkString("\n"));
        }

        public static final /* synthetic */ void $anonfun$build$3(Builder $this, ObjectRef featureDefConfigs$1, String cfg) {
            FeathrConfig feathrConfig = $this.feathrConfigLoader().load(cfg);
            featureDefConfigs$1.elem = ((List)featureDefConfigs$1.elem).$colon$colon((Object)feathrConfig);
        }

        public static final /* synthetic */ void $anonfun$build$2(Builder $this, ObjectRef featureDefConfigs$1, String path) {
            $this.readHdfsFile((Option<String>)new Some((Object)path)).foreach((Function1 & Serializable & scala.Serializable)cfg -> {
                Builder.$anonfun$build$3($this, featureDefConfigs$1, cfg);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$build$4(Builder $this, ObjectRef featureDefConfigs$1, String confStr) {
            FeathrConfig feathrConfig = $this.feathrConfigLoader().load(confStr);
            featureDefConfigs$1.elem = ((List)featureDefConfigs$1.elem).$colon$colon((Object)feathrConfig);
        }

        public static final /* synthetic */ void $anonfun$build$6(Builder $this, ObjectRef localDefConfigs$1, String cfg) {
            FeathrConfig feathrConfig = $this.feathrConfigLoader().load(cfg);
            localDefConfigs$1.elem = ((List)localDefConfigs$1.elem).$colon$colon((Object)feathrConfig);
        }

        public static final /* synthetic */ void $anonfun$build$5(Builder $this, ObjectRef localDefConfigs$1, String path) {
            $this.readHdfsFile((Option<String>)new Some((Object)path)).foreach((Function1 & Serializable & scala.Serializable)cfg -> {
                Builder.$anonfun$build$6($this, localDefConfigs$1, cfg);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$build$7(Builder $this, ObjectRef localDefConfigs$1, String confStr) {
            FeathrConfig feathrConfig = $this.feathrConfigLoader().load(confStr);
            localDefConfigs$1.elem = ((List)localDefConfigs$1.elem).$colon$colon((Object)feathrConfig);
        }

        public Builder(SparkSession sparkSession) {
            this.sparkSession = sparkSession;
            this.feathrConfigLoader = FeathrConfigLoader$.MODULE$.apply();
            this.featureDef = Nil$.MODULE$;
            this.localOverrideDef = Nil$.MODULE$;
            this.featureDefPath = Nil$.MODULE$;
            this.localOverrideDefPath = Nil$.MODULE$;
            this.featureDefConfs = Nil$.MODULE$;
            this.dataPathHandlers = Nil$.MODULE$;
            this.mvelContext = None$.MODULE$;
        }
    }
}

