/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.config.FeatureJoinConfig;
import com.linkedin.feathr.offline.config.JoinConfigSettings;
import com.linkedin.feathr.offline.config.JoinTimeSetting;
import com.linkedin.feathr.offline.config.KeyedFeatureList;
import com.linkedin.feathr.offline.config.ObservationDataTimeSetting;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0003\u0006\u0005+!)A\u0005\u0001C\u0001K\u0015!q\u0005\u0001\u0001)\u0011\u001d!\u0005A1A\u0005\n\u0015Ca!\u0014\u0001!\u0002\u00131\u0005b\u0002(\u0001\u0005\u0004%I!\u0012\u0005\u0007\u001f\u0002\u0001\u000b\u0011\u0002$\t\u000bA\u0003A\u0011I)\t\u000b}\u0003A\u0011\u00021\u0003;\u0019+\u0017\r^;sK*{\u0017N\\\"p]\u001aLw\rR3tKJL\u0017\r\\5{KJT!a\u0003\u0007\u0002\r\r|gNZ5h\u0015\tia\"A\u0004pM\u001ad\u0017N\\3\u000b\u0005=\u0001\u0012A\u00024fCRD'O\u0003\u0002\u0012%\u0005AA.\u001b8lK\u0012LgNC\u0001\u0014\u0003\r\u0019w.\\\u0002\u0001'\t\u0001a\u0003E\u0002\u0018=\u0001j\u0011\u0001\u0007\u0006\u00033i\t\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u00037q\tqA[1dWN|gN\u0003\u0002\u001e%\u0005Ia-Y:uKJDX\u000e\\\u0005\u0003?a\u0011\u0001CS:p]\u0012+7/\u001a:jC2L'0\u001a:\u0011\u0005\u0005\u0012S\"\u0001\u0006\n\u0005\rR!!\u0005$fCR,(/\u001a&pS:\u001cuN\u001c4jO\u00061A(\u001b8jiz\"\u0012A\n\t\u0003C\u0001\u00111!\u0011:h!\u0011I#'\u000e\u001d\u000f\u0005)\u0002\u0004CA\u0016/\u001b\u0005a#BA\u0017\u0015\u0003\u0019a$o\\8u})\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\u00051\u0001K]3eK\u001aL!a\r\u001b\u0003\u00075\u000b\u0007O\u0003\u00022]A\u0011\u0011FN\u0005\u0003oQ\u0012aa\u0015;sS:<\u0007cA\u001d?\u0003:\u0011!\b\u0010\b\u0003WmJ\u0011aL\u0005\u0003{9\nq\u0001]1dW\u0006<W-\u0003\u0002@\u0001\n\u00191+Z9\u000b\u0005ur\u0003CA\u0011C\u0013\t\u0019%B\u0001\tLKf,GMR3biV\u0014X\rT5ti\u0006qrJQ*F%Z\u000bE+S(O?\u0012\u000bE+Q0U\u00136+ulU#U)&suiU\u000b\u0002\rB\u0011q\tT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0005Y\u0006twMC\u0001L\u0003\u0011Q\u0017M^1\n\u0005]B\u0015aH(C'\u0016\u0013f+\u0011+J\u001f:{F)\u0011+B?RKU*R0T\u000bR#\u0016JT$TA\u0005\u0011\"jT%O?RKU*R0T\u000bR#\u0016JT$T\u0003MQu*\u0013(`)&kUiX*F)RKejR*!\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0007\u0001\u0012&\fC\u0003T\u000f\u0001\u0007A+\u0001\u0002kaB\u0011Q\u000bW\u0007\u0002-*\u0011qKG\u0001\u0005G>\u0014X-\u0003\u0002Z-\nQ!j]8o!\u0006\u00148/\u001a:\t\u000bm;\u0001\u0019\u0001/\u0002\t\r$\b\u0010\u001e\t\u0003/uK!A\u0018\r\u0003-\u0011+7/\u001a:jC2L'0\u0019;j_:\u001cuN\u001c;fqR\fa\u0004]1sg\u00164U-\u0019;ve\u0016Tu.\u001b8D_:4\u0017nZ*fiRLgnZ:\u0015\u0007\u0005$\u0017\u000e\u0005\u0002\"E&\u00111M\u0003\u0002\u0013\u0015>LgnQ8oM&<7+\u001a;uS:<7\u000fC\u0003f\u0011\u0001\u0007a-\u0001\u0007tKR$\u0018N\\4t\u001d>$W\r\u0005\u0002\u0018O&\u0011\u0001\u000e\u0007\u0002\t\u0015N|gNT8eK\")1\u000b\u0003a\u0001)\u0002")
public class FeatureJoinConfigDeserializer
extends JsonDeserializer<FeatureJoinConfig> {
    private final String OBSERVATION_DATA_TIME_SETTINGS;
    private final String JOIN_TIME_SETTINGS;

    private String OBSERVATION_DATA_TIME_SETTINGS() {
        return this.OBSERVATION_DATA_TIME_SETTINGS;
    }

    private String JOIN_TIME_SETTINGS() {
        return this.JOIN_TIME_SETTINGS;
    }

    public FeatureJoinConfig deserialize(JsonParser jp, DeserializationContext ctxt) {
        JsonNode settingsNode;
        JsonNode rootNode = (JsonNode)jp.readValueAsTree();
        ((ObjectNode)rootNode).remove("observationPath");
        ((ObjectNode)rootNode).remove("outputPath");
        JsonNode jsonNode = settingsNode = ((ObjectNode)rootNode).remove("settings");
        Object object = jsonNode == null ? None$.MODULE$ : new Some((Object)this.parseFeatureJoinConfigSettings(settingsNode, jp));
        None$ settingsConfig = object;
        TreeTraversingParser featuresTreeParser = new TreeTraversingParser(rootNode, jp.getCodec());
        Map groupFeatures = (Map)featuresTreeParser.getCodec().readValue((JsonParser)featuresTreeParser, (TypeReference)new TypeReference<Map<String, Seq<KeyedFeatureList>>>(null){});
        return new FeatureJoinConfig((Map<String, Seq<KeyedFeatureList>>)groupFeatures, (Option<JoinConfigSettings>)settingsConfig);
    }

    private JoinConfigSettings parseFeatureJoinConfigSettings(JsonNode settingsNode, JsonParser jp) {
        None$ none$;
        None$ none$2;
        Set supportedSettingFields = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.OBSERVATION_DATA_TIME_SETTINGS(), this.JOIN_TIME_SETTINGS()}));
        Set unrecognizedFields = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(settingsNode.fieldNames()).asScala()).toSet().$minus$minus((GenTraversableOnce)supportedSettingFields);
        if (unrecognizedFields.nonEmpty()) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(72).append("unrecognized: ").append(unrecognizedFields.mkString(" ")).append(" in 'settings'. current supported configurations include ").append(supportedSettingFields).append(".").toString());
        }
        JsonNode jsonNode = settingsNode.get(this.OBSERVATION_DATA_TIME_SETTINGS());
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            TreeTraversingParser observationDataTimeConfigTreeParser = new TreeTraversingParser((JsonNode)objectNode, jp.getCodec());
            none$2 = new Some(observationDataTimeConfigTreeParser.getCodec().readValue((JsonParser)observationDataTimeConfigTreeParser, ObservationDataTimeSetting.class));
        } else {
            none$2 = None$.MODULE$;
        }
        None$ observationDataTimeSettingsDefinition = none$2;
        JsonNode jsonNode2 = settingsNode.get(this.JOIN_TIME_SETTINGS());
        if (jsonNode2 instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode2;
            TreeTraversingParser joinTimeConfigTreeParser = new TreeTraversingParser((JsonNode)objectNode, jp.getCodec());
            none$ = new Some(joinTimeConfigTreeParser.getCodec().readValue((JsonParser)joinTimeConfigTreeParser, JoinTimeSetting.class));
        } else {
            none$ = None$.MODULE$;
        }
        None$ joinTimeSettingsDefinition = none$;
        return new JoinConfigSettings((Option<ObservationDataTimeSetting>)observationDataTimeSettingsDefinition, (Option<JoinTimeSetting>)joinTimeSettingsDefinition);
    }

    public FeatureJoinConfigDeserializer() {
        this.OBSERVATION_DATA_TIME_SETTINGS = "observationDataTimeSettings";
        this.JOIN_TIME_SETTINGS = "joinTimeSettings";
    }
}

