/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.anchored.WindowTimeUnit$;
import com.linkedin.feathr.offline.config.ConfigLoaderUtils$;
import com.linkedin.feathr.offline.config.JoinTimeSetting;
import com.linkedin.feathr.offline.config.TimestampColumn;
import java.time.Duration;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000153A!\u0004\b\u00053!)\u0001\u0006\u0001C\u0001S!91\u0006\u0001b\u0001\n\u0003a\u0003BB\u001b\u0001A\u0003%Q\u0006C\u00047\u0001\t\u0007I\u0011\u0001\u0017\t\r]\u0002\u0001\u0015!\u0003.\u0011\u001dA\u0004A1A\u0005\u00021Ba!\u000f\u0001!\u0002\u0013i\u0003b\u0002\u001e\u0001\u0005\u0004%\t\u0001\f\u0005\u0007w\u0001\u0001\u000b\u0011B\u0017\t\u000fq\u0002!\u0019!C\u0001Y!1Q\b\u0001Q\u0001\n5BQA\u0010\u0001\u0005B}\u00121FS8j]RKW.Z\"p]\u001aLwmU3ui&tw\rR3gS:LG/[8o\t\u0016\u001cXM]5bY&TXM\u001d\u0006\u0003\u001fA\taaY8oM&<'BA\t\u0013\u0003\u001dygM\u001a7j]\u0016T!a\u0005\u000b\u0002\r\u0019,\u0017\r\u001e5s\u0015\t)b#\u0001\u0005mS:\\W\rZ5o\u0015\u00059\u0012aA2p[\u000e\u00011C\u0001\u0001\u001b!\rY\"\u0005J\u0007\u00029)\u0011QDH\u0001\tI\u0006$\u0018MY5oI*\u0011q\u0004I\u0001\bU\u0006\u001c7n]8o\u0015\t\tc#A\u0005gCN$XM\u001d=nY&\u00111\u0005\b\u0002\u0011\u0015N|g\u000eR3tKJL\u0017\r\\5{KJ\u0004\"!\n\u0014\u000e\u00039I!a\n\b\u0003\u001f){\u0017N\u001c+j[\u0016\u001cV\r\u001e;j]\u001e\fa\u0001P5oSRtD#\u0001\u0016\u0011\u0005\u0015\u0002\u0011\u0001\u0005+J\u001b\u0016\u001bF+Q'Q?\u000e{E*V'O+\u0005i\u0003C\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003\u0011a\u0017M\\4\u000b\u0003I\nAA[1wC&\u0011Ag\f\u0002\u0007'R\u0014\u0018N\\4\u0002#QKU*R*U\u00036\u0003vlQ(M+6s\u0005%A\u000bU\u00136+5\u000bV!N!~\u001bu\nT+N\u001d~s\u0015)T#\u0002-QKU*R*U\u00036\u0003vlQ(M+6suLT!N\u000b\u0002\nq\u0003V%N\u000bN#\u0016)\u0014)`\u0007>cU+\u0014(`\r>\u0013V*\u0011+\u00021QKU*R*U\u00036\u0003vlQ(M+6suLR(S\u001b\u0006#\u0006%A\nT\u00136+F*\u0011+F?RKU*R0E\u000b2\u000b\u0015,\u0001\u000bT\u00136+F*\u0011+F?RKU*R0E\u000b2\u000b\u0015\fI\u0001\u0018+N+u\fT!U\u000bN#vLR#B)V\u0013Vi\u0018#B)\u0006\u000b\u0001$V*F?2\u000bE+R*U?\u001a+\u0015\tV+S\u000b~#\u0015\tV!!\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0007\u0011\u0002\u0005\nC\u0003B\u0019\u0001\u0007!)A\u0001q!\t\u0019e)D\u0001E\u0015\t)e$\u0001\u0003d_J,\u0017BA$E\u0005)Q5o\u001c8QCJ\u001cXM\u001d\u0005\u0006\u00132\u0001\rAS\u0001\u0005GRDH\u000f\u0005\u0002\u001c\u0017&\u0011A\n\b\u0002\u0017\t\u0016\u001cXM]5bY&T\u0018\r^5p]\u000e{g\u000e^3yi\u0002")
public class JoinTimeConfigSettingDefinitionDeserializer
extends JsonDeserializer<JoinTimeSetting> {
    private final String TIMESTAMP_COLUMN;
    private final String TIMESTAMP_COLUMN_NAME;
    private final String TIMESTAMP_COLUMN_FORMAT;
    private final String SIMULATE_TIME_DELAY;
    private final String USE_LATEST_FEATURE_DATA;

    public String TIMESTAMP_COLUMN() {
        return this.TIMESTAMP_COLUMN;
    }

    public String TIMESTAMP_COLUMN_NAME() {
        return this.TIMESTAMP_COLUMN_NAME;
    }

    public String TIMESTAMP_COLUMN_FORMAT() {
        return this.TIMESTAMP_COLUMN_FORMAT;
    }

    public String SIMULATE_TIME_DELAY() {
        return this.SIMULATE_TIME_DELAY;
    }

    public String USE_LATEST_FEATURE_DATA() {
        return this.USE_LATEST_FEATURE_DATA;
    }

    public JoinTimeSetting deserialize(JsonParser p, DeserializationContext ctxt) {
        boolean useLatestFeatureData;
        None$ simulateTimeDelay;
        TimestampColumn timeStamp;
        block11: {
            TreeNode treeNode;
            block10: {
                block12: {
                    None$ none$;
                    TimestampColumn timestampColumn;
                    ObjectCodec codec = p.getCodec();
                    TreeNode node = codec.readTree(p);
                    treeNode = node;
                    if (!(treeNode instanceof ObjectNode)) break block10;
                    ObjectNode objectNode = (ObjectNode)treeNode;
                    TreeNode treeNode2 = node.get(this.TIMESTAMP_COLUMN());
                    if (treeNode2 instanceof ObjectNode) {
                        ObjectNode objectNode2 = (ObjectNode)treeNode2;
                        JsonNode jsonNode = objectNode2.get(this.TIMESTAMP_COLUMN_NAME());
                        if (!(jsonNode instanceof TextNode)) {
                            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(37).append(this.TIMESTAMP_COLUMN_NAME()).append(" field is not ").append("correctly set in ").append(this.TIMESTAMP_COLUMN()).append(" node.").toString());
                        }
                        TextNode textNode = (TextNode)jsonNode;
                        String string = textNode.textValue();
                        String timestampColName = string;
                        JsonNode jsonNode2 = objectNode2.get(this.TIMESTAMP_COLUMN_FORMAT());
                        if (!(jsonNode2 instanceof TextNode)) {
                            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(37).append(this.TIMESTAMP_COLUMN_FORMAT()).append(" field is not ").append("correctly set in ").append(this.TIMESTAMP_COLUMN()).append(" node.").toString());
                        }
                        TextNode textNode2 = (TextNode)jsonNode2;
                        String string2 = textNode2.textValue();
                        String timestampColFormat = string2;
                        Set supportedSettingFields = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.TIMESTAMP_COLUMN_NAME(), this.TIMESTAMP_COLUMN_FORMAT()}));
                        Set unrecognizedFields = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(objectNode2.fieldNames()).asScala()).toSet().$minus$minus((GenTraversableOnce)supportedSettingFields);
                        if (unrecognizedFields.nonEmpty()) {
                            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(72).append("unrecognized: ").append(unrecognizedFields.mkString(" ")).append(" in 'settings'. current supported configurations include ").append(supportedSettingFields).append(".").toString());
                        }
                        timestampColumn = new TimestampColumn(timestampColName, timestampColFormat);
                    } else {
                        timestampColumn = new TimestampColumn("", "");
                    }
                    timeStamp = timestampColumn;
                    TreeNode treeNode3 = node.get(this.SIMULATE_TIME_DELAY());
                    if (treeNode3 instanceof TextNode) {
                        TextNode textNode = (TextNode)treeNode3;
                        none$ = new Some((Object)WindowTimeUnit$.MODULE$.parseWindowTime(textNode.textValue()));
                    } else {
                        none$ = None$.MODULE$;
                    }
                    simulateTimeDelay = none$;
                    useLatestFeatureData = ConfigLoaderUtils$.MODULE$.getBoolean(objectNode, this.USE_LATEST_FEATURE_DATA());
                    Set supportedSettingFields = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.USE_LATEST_FEATURE_DATA(), this.TIMESTAMP_COLUMN(), this.SIMULATE_TIME_DELAY()}));
                    Set unrecognizedFields = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(node.fieldNames()).asScala()).toSet().$minus$minus((GenTraversableOnce)supportedSettingFields);
                    if (unrecognizedFields.nonEmpty()) {
                        throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(72).append("unrecognized: ").append(unrecognizedFields.mkString(" ")).append(" in 'settings'. current supported configurations include ").append(supportedSettingFields).append(".").toString());
                    }
                    if (!useLatestFeatureData) break block11;
                    String string = timeStamp.name();
                    String string3 = "";
                    if (string != null ? !string.equals(string3) : string3 != null) break block12;
                    String string4 = timeStamp.format();
                    String string5 = "";
                    if (string4 != null ? !string4.equals(string5) : string5 != null) break block12;
                    None$ none$2 = simulateTimeDelay;
                    None$ none$3 = None$.MODULE$;
                    if (!(none$2 == null ? none$3 != null : !none$2.equals(none$3))) break block11;
                }
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "When useLatestFeatureData flag is set to true, there should be no other fields present in the joinTimeSettings section.");
                break block11;
            }
            throw new MatchError((Object)treeNode);
        }
        JoinTimeSetting joinTimeSetting = new JoinTimeSetting(timeStamp, (Option<Duration>)simulateTimeDelay, useLatestFeatureData);
        return joinTimeSetting;
    }

    public JoinTimeConfigSettingDefinitionDeserializer() {
        this.TIMESTAMP_COLUMN = "timestampColumn";
        this.TIMESTAMP_COLUMN_NAME = "def";
        this.TIMESTAMP_COLUMN_FORMAT = "format";
        this.SIMULATE_TIME_DELAY = "simulateTimeDelay";
        this.USE_LATEST_FEATURE_DATA = "useLatestFeatureData";
    }
}

