/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.linkedin.feathr.common.DateParam;
import com.linkedin.feathr.common.DateParam$;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.config.AbsoluteTimeRange;
import com.linkedin.feathr.offline.config.ObservationDataTimeSetting;
import com.linkedin.feathr.offline.config.RelativeTimeRange;
import java.time.LocalDateTime;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0005\n\u0005;!)A\u0006\u0001C\u0001[!9q\u0006\u0001b\u0001\n\u0003\u0001\u0004BB\u001d\u0001A\u0003%\u0011\u0007C\u0004;\u0001\t\u0007I\u0011\u0001\u0019\t\rm\u0002\u0001\u0015!\u00032\u0011\u001da\u0004A1A\u0005\u0002ABa!\u0010\u0001!\u0002\u0013\t\u0004b\u0002 \u0001\u0005\u0004%\t\u0001\r\u0005\u0007\u007f\u0001\u0001\u000b\u0011B\u0019\t\u000f\u0001\u0003!\u0019!C\u0001a!1\u0011\t\u0001Q\u0001\nEBqA\u0011\u0001C\u0002\u0013\u0005\u0001\u0007\u0003\u0004D\u0001\u0001\u0006I!\r\u0005\b\t\u0002\u0011\r\u0011\"\u00011\u0011\u0019)\u0005\u0001)A\u0005c!)a\t\u0001C!\u000f\n\u0001tJY:feZ\fG/[8o\t\u0006$\u0018\rV5nKN+G\u000f^5oO\u0012+g-\u001b8ji&|g\u000eR3tKJL\u0017\r\\5{KJT!a\u0005\u000b\u0002\r\r|gNZ5h\u0015\t)b#A\u0004pM\u001ad\u0017N\\3\u000b\u0005]A\u0012A\u00024fCRD'O\u0003\u0002\u001a5\u0005AA.\u001b8lK\u0012LgNC\u0001\u001c\u0003\r\u0019w.\\\u0002\u0001'\t\u0001a\u0004E\u0002 M!j\u0011\u0001\t\u0006\u0003C\t\n\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0003G\u0011\nqA[1dWN|gN\u0003\u0002&5\u0005Ia-Y:uKJDX\u000e\\\u0005\u0003O\u0001\u0012\u0001CS:p]\u0012+7/\u001a:jC2L'0\u001a:\u0011\u0005%RS\"\u0001\n\n\u0005-\u0012\"AG(cg\u0016\u0014h/\u0019;j_:$\u0015\r^1US6,7+\u001a;uS:<\u0017A\u0002\u001fj]&$h\bF\u0001/!\tI\u0003!A\nS\u000b2\u000bE+\u0013,F?RKU*R0S\u0003:;U)F\u00012!\t\u0011t'D\u00014\u0015\t!T'\u0001\u0003mC:<'\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003qM\u0012aa\u0015;sS:<\u0017\u0001\u0006*F\u0019\u0006#\u0016JV#`)&kUi\u0018*B\u001d\u001e+\u0005%A\nB\u0005N{E*\u0016+F?RKU*R0S\u0003:;U)\u0001\u000bB\u0005N{E*\u0016+F?RKU*R0S\u0003:;U\tI\u0001\u000b'R\u000b%\u000bV0U\u00136+\u0015aC*U\u0003J#v\fV%N\u000b\u0002\n\u0001\"\u0012(E?RKU*R\u0001\n\u000b:#u\fV%N\u000b\u0002\naaV%O\t>;\u0016aB,J\u001d\u0012{u\u000bI\u0001\u0007\u001f\u001a35+\u0012+\u0002\u000f=3eiU#UA\u0005YA+S'F?\u001a{%+T!U\u00031!\u0016*T#`\r>\u0013V*\u0011+!\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0007!B\u0005\u000bC\u0003J!\u0001\u0007!*A\u0001q!\tYe*D\u0001M\u0015\ti%%\u0001\u0003d_J,\u0017BA(M\u0005)Q5o\u001c8QCJ\u001cXM\u001d\u0005\u0006#B\u0001\rAU\u0001\u0005GRDH\u000f\u0005\u0002 '&\u0011A\u000b\t\u0002\u0017\t\u0016\u001cXM]5bY&T\u0018\r^5p]\u000e{g\u000e^3yi\u0002")
public class ObservationDataTimeSettingDefinitionDeserializer
extends JsonDeserializer<ObservationDataTimeSetting> {
    private final String RELATIVE_TIME_RANGE;
    private final String ABSOLUTE_TIME_RANGE;
    private final String START_TIME;
    private final String END_TIME;
    private final String WINDOW;
    private final String OFFSET;
    private final String TIME_FORMAT;

    public String RELATIVE_TIME_RANGE() {
        return this.RELATIVE_TIME_RANGE;
    }

    public String ABSOLUTE_TIME_RANGE() {
        return this.ABSOLUTE_TIME_RANGE;
    }

    public String START_TIME() {
        return this.START_TIME;
    }

    public String END_TIME() {
        return this.END_TIME;
    }

    public String WINDOW() {
        return this.WINDOW;
    }

    public String OFFSET() {
        return this.OFFSET;
    }

    public String TIME_FORMAT() {
        return this.TIME_FORMAT;
    }

    public ObservationDataTimeSetting deserialize(JsonParser p, DeserializationContext ctxt) {
        None$ none$;
        DateParam timeRange;
        ObjectCodec codec = p.getCodec();
        TreeNode node = codec.readTree(p);
        TreeNode treeNode = node;
        if (treeNode instanceof ObjectNode) {
            None$ none$2;
            None$ none$3;
            TreeNode treeNode2 = node.get(this.RELATIVE_TIME_RANGE());
            if (treeNode2 instanceof ObjectNode) {
                None$ none$4;
                ObjectNode objectNode = (ObjectNode)treeNode2;
                JsonNode jsonNode = objectNode.get(this.WINDOW());
                if (!(jsonNode instanceof TextNode)) {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(30).append(this.WINDOW()).append(" field is a required field in ").append(objectNode).toString());
                }
                TextNode textNode = (TextNode)jsonNode;
                String string = textNode.textValue();
                String window = string;
                JsonNode jsonNode2 = objectNode.get(this.OFFSET());
                if (jsonNode2 instanceof TextNode) {
                    TextNode textNode2 = (TextNode)jsonNode2;
                    none$4 = new Some((Object)textNode2.textValue());
                } else {
                    none$4 = None$.MODULE$;
                }
                None$ offset = none$4;
                Set supportedSettingFields = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.WINDOW(), this.OFFSET()}));
                Set unrecognizedFields = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(objectNode.fieldNames()).asScala()).toSet().$minus$minus((GenTraversableOnce)supportedSettingFields);
                if (unrecognizedFields.nonEmpty()) {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(72).append("unrecognized: ").append(unrecognizedFields.mkString(" ")).append(" in 'settings'. current supported configurations include ").append(supportedSettingFields).append(".").toString());
                }
                none$3 = new Some((Object)new RelativeTimeRange(window, (Option<String>)offset));
            } else {
                none$3 = None$.MODULE$;
            }
            None$ relativeTimeRange = none$3;
            TreeNode treeNode3 = node.get(this.ABSOLUTE_TIME_RANGE());
            if (treeNode3 instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)treeNode3;
                JsonNode jsonNode = objectNode.get(this.TIME_FORMAT());
                if (!(jsonNode instanceof TextNode)) {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(30).append(this.TIME_FORMAT()).append(" field is a required field in ").append(node).toString());
                }
                TextNode textNode = (TextNode)jsonNode;
                String string = textNode.textValue();
                String timeFormat = string;
                JsonNode jsonNode3 = objectNode.get(this.START_TIME());
                if (!(jsonNode3 instanceof TextNode)) {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(30).append(this.START_TIME()).append(" field is a required field in ").append(node).toString());
                }
                TextNode textNode3 = (TextNode)jsonNode3;
                String string2 = textNode3.textValue();
                String startTime = string2;
                JsonNode jsonNode4 = objectNode.get(this.END_TIME());
                if (!(jsonNode4 instanceof TextNode)) {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(30).append(this.END_TIME()).append(" field is a required field in ").append(node).toString());
                }
                TextNode textNode4 = (TextNode)jsonNode4;
                String string3 = textNode4.textValue();
                String endTime = string3;
                Set supportedSettingFields = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.TIME_FORMAT(), this.START_TIME(), this.END_TIME()}));
                Set unrecognizedFields = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(objectNode.fieldNames()).asScala()).toSet().$minus$minus((GenTraversableOnce)supportedSettingFields);
                if (unrecognizedFields.nonEmpty()) {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(72).append("unrecognized: ").append(unrecognizedFields.mkString(" ")).append(" in 'settings'. current supported configurations include ").append(supportedSettingFields).append(".").toString());
                }
                none$2 = new Some((Object)new AbsoluteTimeRange(startTime, endTime, timeFormat));
            } else {
                none$2 = None$.MODULE$;
            }
            None$ absoluteTimeRange = none$2;
            if (relativeTimeRange.isDefined() && absoluteTimeRange.isDefined()) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(25).append("Both ").append(this.RELATIVE_TIME_RANGE()).append(" and ").append(this.ABSOLUTE_TIME_RANGE()).append(" cannot be set.").toString());
            }
            if (relativeTimeRange.isEmpty() && absoluteTimeRange.isEmpty()) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(149).append(this.RELATIVE_TIME_RANGE()).append(" and ").append(this.ABSOLUTE_TIME_RANGE()).append(" are not set. If intention is to not").append("restrict the size of the observation data, please remove the observationDataTimeSettings section completely.").toString());
            }
            Set supportedSettingFields = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.ABSOLUTE_TIME_RANGE(), this.RELATIVE_TIME_RANGE()}));
            Set unrecognizedFields = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(node.fieldNames()).asScala()).toSet().$minus$minus((GenTraversableOnce)supportedSettingFields);
            if (unrecognizedFields.nonEmpty()) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(72).append("unrecognized: ").append(unrecognizedFields.mkString(" ")).append(" in 'settings'. current supported configurations include ").append(supportedSettingFields).append(".").toString());
            }
            timeRange = relativeTimeRange.isDefined() ? new DateParam((Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, ((RelativeTimeRange)relativeTimeRange.get()).offset(), (Option<String>)new Some((Object)((RelativeTimeRange)relativeTimeRange.get()).window())) : (absoluteTimeRange.isDefined() ? new DateParam((Option<String>)new Some((Object)((AbsoluteTimeRange)absoluteTimeRange.get()).startTime()), (Option<String>)new Some((Object)((AbsoluteTimeRange)absoluteTimeRange.get()).endTime()), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$) : new DateParam((Option<String>)new Some((Object)LocalDateTime.now().toString()), (Option<String>)new Some((Object)LocalDateTime.now().toString()), DateParam$.MODULE$.apply$default$3(), DateParam$.MODULE$.apply$default$4()));
            None$ none$5 = absoluteTimeRange;
            if (none$5 instanceof Some) {
                Some some = (Some)none$5;
                AbsoluteTimeRange range = (AbsoluteTimeRange)some.value();
                none$ = new Some((Object)range.timeFormat());
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            throw new MatchError((Object)treeNode);
        }
        None$ timeFormat = none$;
        ObservationDataTimeSetting observationDataTimeSetting = new ObservationDataTimeSetting(timeRange, (Option<String>)timeFormat);
        return observationDataTimeSetting;
    }

    public ObservationDataTimeSettingDefinitionDeserializer() {
        this.RELATIVE_TIME_RANGE = "relativeTimeRange";
        this.ABSOLUTE_TIME_RANGE = "absoluteTimeRange";
        this.START_TIME = "startTime";
        this.END_TIME = "endTime";
        this.WINDOW = "window";
        this.OFFSET = "offset";
        this.TIME_FORMAT = "timeFormat";
    }
}

