/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.anchored.WindowTimeUnit$;
import com.linkedin.feathr.offline.config.ConfigLoaderUtils$;
import com.linkedin.feathr.offline.config.TimeWindowFeatureDefinition;
import com.linkedin.feathr.offline.config.TimeWindowFeatureDefinition$;
import com.linkedin.feathr.swj.aggregate.AggregationType$;
import java.time.Duration;
import java.util.NoSuchElementException;
import scala.Enumeration;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A2Aa\u0001\u0003\u0001\u001f!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C!E\t9C+[7f/&tGm\\<GK\u0006$XO]3EK\u001aLg.\u001b;j_:$Um]3sS\u0006d\u0017N_3s\u0015\t)a!\u0001\u0004d_:4\u0017n\u001a\u0006\u0003\u000f!\tqa\u001c4gY&tWM\u0003\u0002\n\u0015\u00051a-Z1uQJT!a\u0003\u0007\u0002\u00111Lgn[3eS:T\u0011!D\u0001\u0004G>l7\u0001A\n\u0003\u0001A\u00012!\u0005\r\u001b\u001b\u0005\u0011\"BA\n\u0015\u0003!!\u0017\r^1cS:$'BA\u000b\u0017\u0003\u001dQ\u0017mY6t_:T!a\u0006\u0007\u0002\u0013\u0019\f7\u000f^3sq6d\u0017BA\r\u0013\u0005AQ5o\u001c8EKN,'/[1mSj,'\u000f\u0005\u0002\u001c95\tA!\u0003\u0002\u001e\t\tYB+[7f/&tGm\\<GK\u0006$XO]3EK\u001aLg.\u001b;j_:\fa\u0001P5oSRtD#\u0001\u0011\u0011\u0005m\u0001\u0011a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$2AG\u0012,\u0011\u0015!#\u00011\u0001&\u0003\u0005\u0001\bC\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0015\u0003\u0011\u0019wN]3\n\u0005):#A\u0003&t_:\u0004\u0016M]:fe\")AF\u0001a\u0001[\u0005!1\r\u001e=u!\t\tb&\u0003\u00020%\t1B)Z:fe&\fG.\u001b>bi&|gnQ8oi\u0016DH\u000f")
public class TimeWindowFeatureDefinitionDeserializer
extends JsonDeserializer<TimeWindowFeatureDefinition> {
    public TimeWindowFeatureDefinition deserialize(JsonParser p, DeserializationContext ctxt) {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        None$ none$5;
        None$ none$6;
        None$ none$7;
        None$ none$8;
        None$ none$9;
        Duration duration;
        Enumeration.Value value;
        String string;
        ObjectCodec codec = p.getCodec();
        TreeNode node = codec.readTree(p);
        Option<FeatureTypeConfig> typeConfig = ConfigLoaderUtils$.MODULE$.getTypeConfig(node);
        TreeNode treeNode = node;
        if (treeNode instanceof ObjectNode) {
            TreeNode treeNode2 = node.get("def");
            if (!(treeNode2 instanceof TextNode)) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(73).append("'def' field is required in aggregation feature but it's not provided in ").append(node).append(".").toString());
            }
            TextNode textNode = (TextNode)treeNode2;
            string = textNode.textValue();
            TreeNode treeNode3 = node.get("aggregation");
            if (!(treeNode3 instanceof TextNode)) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(79).append("'aggregation' field is required in aggregation feature but is not provided in ").append(node).append(".").toString());
            }
            TextNode textNode2 = (TextNode)treeNode3;
            value = TimeWindowFeatureDefinitionDeserializer.liftedTree1$1(textNode2);
            TreeNode treeNode4 = node.get("window");
            if (!(treeNode4 instanceof TextNode)) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(71).append("'window' field is required in aggregation feature but is not provided ").append(node).append(".").toString());
            }
            TextNode textNode3 = (TextNode)treeNode4;
            duration = WindowTimeUnit$.MODULE$.parseWindowTime(textNode3.textValue());
            TreeNode treeNode5 = node.get("groupBy");
            if (treeNode5 instanceof TextNode) {
                TextNode textNode4 = (TextNode)treeNode5;
                none$9 = Option$.MODULE$.apply((Object)textNode4.textValue());
            } else {
                none$9 = None$.MODULE$;
            }
            TreeNode treeNode6 = node.get("limit");
            if (treeNode6 instanceof IntNode) {
                IntNode intNode = (IntNode)treeNode6;
                none$8 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)intNode.intValue()));
            } else {
                none$8 = None$.MODULE$;
            }
            TreeNode treeNode7 = node.get("filter");
            if (treeNode7 instanceof TextNode) {
                TextNode textNode5 = (TextNode)treeNode7;
                none$7 = Option$.MODULE$.apply((Object)textNode5.textValue());
            } else {
                none$7 = None$.MODULE$;
            }
            TreeNode treeNode8 = node.get("decay");
            if (treeNode8 instanceof TextNode) {
                TextNode textNode6 = (TextNode)treeNode8;
                none$6 = Option$.MODULE$.apply((Object)textNode6.textValue());
            } else {
                none$6 = None$.MODULE$;
            }
            TreeNode treeNode9 = node.get("weight");
            if (treeNode9 instanceof TextNode) {
                TextNode textNode7 = (TextNode)treeNode9;
                none$5 = Option$.MODULE$.apply((Object)textNode7.textValue());
            } else {
                none$5 = None$.MODULE$;
            }
            TreeNode treeNode10 = node.get("normalization");
            if (treeNode10 instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)treeNode10;
                none$4 = Option$.MODULE$.apply((Object)objectNode.toString());
            } else {
                none$4 = None$.MODULE$;
            }
            TreeNode treeNode11 = node.get("advancedDecay");
            if (treeNode11 instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)treeNode11;
                none$3 = Option$.MODULE$.apply((Object)objectNode.toString());
            } else {
                none$3 = None$.MODULE$;
            }
            TreeNode treeNode12 = node.get("topK");
            if (treeNode12 instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)treeNode12;
                none$2 = Option$.MODULE$.apply((Object)objectNode.toString());
            } else {
                none$2 = None$.MODULE$;
            }
            TreeNode treeNode13 = node.get("embeddingSize");
            if (treeNode13 instanceof NumericNode) {
                NumericNode numericNode = (NumericNode)treeNode13;
                none$ = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numericNode.asInt()));
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            throw new MatchError((Object)treeNode);
        }
        TimeWindowFeatureDefinition timeWindowFeatureDefinition = new TimeWindowFeatureDefinition(string, value, duration, (Option<String>)none$9, (Option<Object>)none$8, (Option<String>)none$7, (Option<String>)none$6, (Option<String>)none$5, (Option<String>)none$4, (Option<String>)none$3, (Option<String>)none$2, (Option<Object>)none$, typeConfig, TimeWindowFeatureDefinition$.MODULE$.apply$default$14());
        return timeWindowFeatureDefinition;
    }

    private static final /* synthetic */ Enumeration.Value liftedTree1$1(TextNode x2$1) {
        Enumeration.Value value;
        try {
            value = AggregationType$.MODULE$.withName(x2$1.textValue());
        }
        catch (NoSuchElementException e) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(195).append("Trying to deserialize the config into TimeWindowFeatureDefinition.").append("Aggregation type ").append(x2$1.textValue()).append(" is not supported. Supported types are: SUM, COUNT, AVG, MAX, TIMESINCE.").append("Please use a supported aggregation type.").toString(), e);
        }
        return value;
    }
}

