/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.config.join.converters;

import com.linkedin.data.template.GetMode;
import com.linkedin.feathr.common.DateParam;
import com.linkedin.feathr.common.DateParam$;
import com.linkedin.feathr.config.join.AbsoluteTimeRange;
import com.linkedin.feathr.config.join.InputDataTimeSettings;
import com.linkedin.feathr.config.join.JoinTimeSettings;
import com.linkedin.feathr.config.join.RelativeTimeRange;
import com.linkedin.feathr.config.join.Settings;
import com.linkedin.feathr.config.join.TimestampColJoinTimeSettings;
import com.linkedin.feathr.exception.ErrorLabel;
import com.linkedin.feathr.exception.FeathrConfigException;
import com.linkedin.feathr.offline.anchored.WindowTimeUnit$;
import com.linkedin.feathr.offline.config.JoinConfigSettings;
import com.linkedin.feathr.offline.config.JoinTimeSetting;
import com.linkedin.feathr.offline.config.ObservationDataTimeSetting;
import com.linkedin.feathr.offline.config.TimestampColumn;
import com.linkedin.feathr.offline.config.join.converters.PegasusRecordDateTimeConverter$;
import com.linkedin.feathr.offline.config.join.converters.PegasusRecordSettingsConverter;
import com.linkedin.feathr.offline.util.datetime.OfflineDateTimeUtils$;
import java.io.Serializable;
import java.time.Duration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;

public final class PegasusRecordSettingsConverter$
implements PegasusRecordSettingsConverter {
    public static PegasusRecordSettingsConverter$ MODULE$;

    static {
        new PegasusRecordSettingsConverter$();
    }

    @Override
    public JoinConfigSettings convert(Settings settings) {
        Option inputDataTimeSettings2 = Option$.MODULE$.apply((Object)settings.getInputDataTimeSettings(GetMode.DEFAULT)).map((Function1 & Serializable & scala.Serializable)inputDataTimeSettings -> MODULE$.convertInputDataTimeSettings((InputDataTimeSettings)inputDataTimeSettings));
        Option joinTimeSetting = Option$.MODULE$.apply((Object)settings.getJoinTimeSettings(GetMode.DEFAULT)).map((Function1 & Serializable & scala.Serializable)joinTimeSettings -> MODULE$.convertJoinTimeSettings((JoinTimeSettings)joinTimeSettings));
        return new JoinConfigSettings((Option<ObservationDataTimeSetting>)inputDataTimeSettings2, (Option<JoinTimeSetting>)joinTimeSetting);
    }

    private JoinTimeSetting convertJoinTimeSettings(JoinTimeSettings joinTimeSettings) {
        JoinTimeSetting joinTimeSetting;
        if (joinTimeSettings.isTimestampColJoinTimeSettings()) {
            TimestampColJoinTimeSettings settings = joinTimeSettings.getTimestampColJoinTimeSettings();
            com.linkedin.feathr.config.join.TimestampColumn pdlTimestampColumn = settings.getTimestampColumn();
            String timestampColumnDefinition = pdlTimestampColumn.getDefinition().isColumnName() ? pdlTimestampColumn.getDefinition().getColumnName() : pdlTimestampColumn.getDefinition().getSparkSqlExpression().getExpression();
            TimestampColumn timeStampColumn = new TimestampColumn(timestampColumnDefinition, pdlTimestampColumn.getFormat());
            Option simulateTimeDelay = Option$.MODULE$.apply((Object)settings.getSimulateTimeDelay(GetMode.DEFAULT)).map((Function1 & Serializable & scala.Serializable)delay -> WindowTimeUnit$.MODULE$.parseWindowTime(PegasusRecordDateTimeConverter$.MODULE$.convertDuration(Predef$.MODULE$.Long2long(delay.getLength()), delay.getUnit())));
            joinTimeSetting = new JoinTimeSetting(timeStampColumn, (Option<Duration>)simulateTimeDelay, false);
        } else if (joinTimeSettings.isUseLatestJoinTimeSettings()) {
            Boolean useLatestFeatureData = joinTimeSettings.getUseLatestJoinTimeSettings().isUseLatestFeatureData();
            joinTimeSetting = new JoinTimeSetting(new TimestampColumn("", ""), (Option<Duration>)None$.MODULE$, Predef$.MODULE$.Boolean2boolean(useLatestFeatureData));
        } else {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(98).append("joinTimeSettings ").append(joinTimeSettings).append(" should have either SettingsWithTimestampCol or SettingsWithUseLatestFeatureData.").toString());
        }
        return joinTimeSetting;
    }

    private ObservationDataTimeSetting convertInputDataTimeSettings(InputDataTimeSettings inputDataTimeSettings) {
        ObservationDataTimeSetting observationDataTimeSetting;
        InputDataTimeSettings.TimeRange timeRange = inputDataTimeSettings.getTimeRange();
        if (timeRange.isAbsoluteTimeRange()) {
            AbsoluteTimeRange absoluteTimeRange = timeRange.getAbsoluteTimeRange();
            AbsoluteTimeRange.StartTime startTime = absoluteTimeRange.getStartTime();
            AbsoluteTimeRange.EndTime endTime = absoluteTimeRange.getEndTime();
            if (!(startTime.isDate() && endTime.isDate() || startTime.isHourTime() && endTime.isHourTime())) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(109).append("AbsoluteTimeRange ").append(absoluteTimeRange).append(" has different granularity for startTime and endTime. One is daily and the other is hourly.").toString());
            }
            String formatString = startTime.isDate() ? OfflineDateTimeUtils$.MODULE$.DEFAULT_TIME_FORMAT() : OfflineDateTimeUtils$.MODULE$.DEFAULT_HOURLY_TIME_FORMAT();
            String startTimeString = startTime.isDate() ? PegasusRecordDateTimeConverter$.MODULE$.convertDate(startTime.getDate(), formatString) : PegasusRecordDateTimeConverter$.MODULE$.convertHourTime(startTime.getHourTime(), formatString);
            String endTimeString = endTime.isDate() ? PegasusRecordDateTimeConverter$.MODULE$.convertDate(endTime.getDate(), formatString) : PegasusRecordDateTimeConverter$.MODULE$.convertHourTime(endTime.getHourTime(), formatString);
            DateParam dateParam = new DateParam((Option<String>)new Some((Object)startTimeString), (Option<String>)new Some((Object)endTimeString), DateParam$.MODULE$.apply$default$3(), DateParam$.MODULE$.apply$default$4());
            observationDataTimeSetting = new ObservationDataTimeSetting(dateParam, (Option<String>)new Some((Object)formatString));
        } else if (timeRange.isRelativeTimeRange()) {
            RelativeTimeRange relativeTimeRange = timeRange.getRelativeTimeRange();
            String offset = PegasusRecordDateTimeConverter$.MODULE$.convertDuration(Predef$.MODULE$.Long2long(relativeTimeRange.getOffset()), relativeTimeRange.getWindow().getUnit());
            String window = PegasusRecordDateTimeConverter$.MODULE$.convertDuration(Predef$.MODULE$.Long2long(relativeTimeRange.getWindow().getLength()), relativeTimeRange.getWindow().getUnit());
            DateParam dateParam = new DateParam((Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)offset), (Option<String>)new Some((Object)window));
            observationDataTimeSetting = new ObservationDataTimeSetting(dateParam, (Option<String>)None$.MODULE$);
        } else {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(198).append("RelativeTimeRange and AbsoluteTimeRange are not set in InputDataTimeSettings ").append(inputDataTimeSettings).append(". ").append("If intention is to not restrict the size of the input data, please remove the inputDataTimeSettings section completely.").toString());
        }
        return observationDataTimeSetting;
    }

    private PegasusRecordSettingsConverter$() {
        MODULE$ = this;
    }
}

