/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.derived;

import com.linkedin.feathr.common.ErasedEntityTaggedFeature;
import com.linkedin.feathr.common.FeatureDerivationFunction;
import com.linkedin.feathr.common.FeatureDerivationFunctionBase;
import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.FeatureTypes;
import com.linkedin.feathr.common.FeatureValue;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrException;
import com.linkedin.feathr.offline.FeatureDataFrame;
import com.linkedin.feathr.offline.client.DataFrameColName$;
import com.linkedin.feathr.offline.client.plugins.FeathrUdfPluginContext$;
import com.linkedin.feathr.offline.client.plugins.FeatureDerivationFunctionAdaptor;
import com.linkedin.feathr.offline.client.plugins.UdfAdaptor;
import com.linkedin.feathr.offline.derived.DerivedFeature;
import com.linkedin.feathr.offline.derived.DerivedFeatureEvaluator$;
import com.linkedin.feathr.offline.derived.functions.SQLFeatureDerivationFunction;
import com.linkedin.feathr.offline.derived.functions.SeqJoinDerivationFunction;
import com.linkedin.feathr.offline.derived.strategies.DerivationStrategies;
import com.linkedin.feathr.offline.logical.FeatureGroups;
import com.linkedin.feathr.offline.mvel.plugins.FeathrExpressionExecutionContext;
import com.linkedin.feathr.offline.source.accessor.DataPathHandler;
import com.linkedin.feathr.offline.util.FeaturizedDatasetUtils$;
import com.linkedin.feathr.sparkcommon.FeatureDerivationFunctionSpark;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=f!\u0002\t\u0012\u0001MY\u0002\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\t\u0011)\u0002!\u0011!Q\u0001\n-BQA\u000e\u0001\u0005\u0002]BQ\u0001\u0010\u0001\u0005\u0002uBQa\u001f\u0001\u0005\u0002qDq!!\u0002\u0001\t\u0013\t9\u0001C\u0004\u0002(\u0001!I!!\u000b\b\u0011\u0005M\u0012\u0003#\u0001\u0014\u0003k1q\u0001E\t\t\u0002M\t9\u0004\u0003\u00047\u0013\u0011\u0005\u0011\u0011\b\u0005\n\u0003wI!\u0019!C\u0005\u0003{A\u0001\"a\u0014\nA\u0003%\u0011q\b\u0005\b\u0003#JA\u0011AA*\u0011\u001d\t\t&\u0003C\u0001\u00033Bq!a%\n\t\u0003\t)JA\fEKJLg/\u001a3GK\u0006$XO]3Fm\u0006dW/\u0019;pe*\u0011!cE\u0001\bI\u0016\u0014\u0018N^3e\u0015\t!R#A\u0004pM\u001ad\u0017N\\3\u000b\u0005Y9\u0012A\u00024fCRD'O\u0003\u0002\u00193\u0005AA.\u001b8lK\u0012LgNC\u0001\u001b\u0003\r\u0019w.\\\n\u0003\u0001q\u0001\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0017\u0001\u00063fe&4\u0018\r^5p]N#(/\u0019;fO&,7o\u0001\u0001\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d\n\u0012AC:ue\u0006$XmZ5fg&\u0011\u0011F\n\u0002\u0015\t\u0016\u0014\u0018N^1uS>t7\u000b\u001e:bi\u0016<\u0017.Z:\u0002\u001754X\r\\\"p]R,\u0007\u0010\u001e\t\u0004;1r\u0013BA\u0017\u001f\u0005\u0019y\u0005\u000f^5p]B\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\ba2,x-\u001b8t\u0015\t\u00194#\u0001\u0003nm\u0016d\u0017BA\u001b1\u0005\u00012U-\u0019;ie\u0016C\bO]3tg&|g.\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\rA$h\u000f\t\u0003s\u0001i\u0011!\u0005\u0005\u0006E\r\u0001\r\u0001\n\u0005\u0006U\r\u0001\raK\u0001\tKZ\fG.^1uKR)aHQ*_mB\u0011q\bQ\u0007\u0002'%\u0011\u0011i\u0005\u0002\u0011\r\u0016\fG/\u001e:f\t\u0006$\u0018M\u0012:b[\u0016DQa\u0011\u0003A\u0002\u0011\u000baa[3z)\u0006<\u0007cA#N!:\u0011ai\u0013\b\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013\u000e\na\u0001\u0010:p_Rt\u0014\"A\u0010\n\u00051s\u0012a\u00029bG.\fw-Z\u0005\u0003\u001d>\u00131aU3r\u0015\tae\u0004\u0005\u0002\u001e#&\u0011!K\b\u0002\u0004\u0013:$\b\"\u0002+\u0005\u0001\u0004)\u0016AC6fsR\u000bw\rT5tiB\u0019Q)\u0014,\u0011\u0005][fB\u0001-Z!\t9e$\u0003\u0002[=\u00051\u0001K]3eK\u001aL!\u0001X/\u0003\rM#(/\u001b8h\u0015\tQf\u0004C\u0003`\t\u0001\u0007\u0001-A\u0005d_:$X\r\u001f;E\rB\u0011\u0011m\u001d\b\u0003EFt!a\u00198\u000f\u0005\u0011\\gBA3i\u001d\t9e-C\u0001h\u0003\ry'oZ\u0005\u0003S*\fa!\u00199bG\",'\"A4\n\u00051l\u0017!B:qCJ\\'BA5k\u0013\ty\u0007/A\u0002tc2T!\u0001\\7\n\u00051\u0013(BA8q\u0013\t!XOA\u0005ECR\fgI]1nK*\u0011AJ\u001d\u0005\u0006o\u0012\u0001\r\u0001_\u0001\u000fI\u0016\u0014\u0018N^3e\r\u0016\fG/\u001e:f!\tI\u00140\u0003\u0002{#\tqA)\u001a:jm\u0016$g)Z1ukJ,\u0017aH2p]Z,'\u000f\u001e$fCR,(/Z\"pYVlg\u000eV8Rk&t7-\u001a$egR)a(`@\u0002\u0002!)a0\u0002a\u0001-\u0006Q1m\u001c7v[:t\u0015-\\3\t\u000b],\u0001\u0019\u0001=\t\r\u0005\rQ\u00011\u0001a\u0003\t!g-A\u0013hKR4U-\u0019;ve\u0016\u001cu\u000e\u001c(b[\u0016$vNR3biV\u0014XMT1nK\u0006sG\rV=qKRA\u0011\u0011BA\u0011\u0003G\t)\u0003\u0005\u0004X\u0003\u00171\u0016qB\u0005\u0004\u0003\u001bi&aA'baB1Q$!\u0005W\u0003+I1!a\u0005\u001f\u0005\u0019!V\u000f\u001d7feA!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001cU\taaY8n[>t\u0017\u0002BA\u0010\u00033\u0011\u0011CR3biV\u0014X\rV=qK\u000e{gNZ5h\u0011\u0015qh\u00011\u0001W\u0011\u00159h\u00011\u0001y\u0011\u0019\t\u0019A\u0002a\u0001A\u0006qq-\u001a;UsB,7i\u001c8gS\u001e\u001cH\u0003CA\u0016\u0003[\ty#!\r\u0011\r]\u000bYAVA\u000b\u0011\u0015qx\u00011\u0001W\u0011\u00159x\u00011\u0001y\u0011\u0019\t\u0019a\u0002a\u0001A\u00069B)\u001a:jm\u0016$g)Z1ukJ,WI^1mk\u0006$xN\u001d\t\u0003s%\u0019\"!\u0003\u000f\u0015\u0005\u0005U\u0012a\u00017pOV\u0011\u0011q\b\t\u0005\u0003\u0003\nY%\u0004\u0002\u0002D)!\u0011QIA$\u0003\u0015awn\u001a\u001bk\u0015\r\tI%\\\u0001\bY><w-\u001b8h\u0013\u0011\ti%a\u0011\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000ba\n)&a\u0016\t\u000b\tj\u0001\u0019\u0001\u0013\t\u000b)j\u0001\u0019A\u0016\u0015\u0013a\nY&a\u001a\u0002x\u0005E\u0005bBA/\u001d\u0001\u0007\u0011qL\u0001\u0003gN\u0004B!!\u0019\u0002d5\t!/C\u0002\u0002fI\u0014Ab\u00159be.\u001cVm]:j_:Dq!!\u001b\u000f\u0001\u0004\tY'A\u0007gK\u0006$XO]3He>,\bo\u001d\t\u0005\u0003[\n\u0019(\u0004\u0002\u0002p)\u0019\u0011\u0011O\n\u0002\u000f1|w-[2bY&!\u0011QOA8\u000551U-\u0019;ve\u0016<%o\\;qg\"9\u0011\u0011\u0010\bA\u0002\u0005m\u0014\u0001\u00053bi\u0006\u0004\u0016\r\u001e5IC:$G.\u001a:t!\u0015)\u0015QPAA\u0013\r\tyh\u0014\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0004\u00065UBAAC\u0015\u0011\t9)!#\u0002\u0011\u0005\u001c7-Z:t_JT1!a#\u0014\u0003\u0019\u0019x.\u001e:dK&!\u0011qRAC\u0005=!\u0015\r^1QCRD\u0007*\u00198eY\u0016\u0014\b\"\u0002\u0016\u000f\u0001\u0004Y\u0013!G3wC2,\u0018\r^3Ge>lg)Z1ukJ,g+\u00197vKN$\"\"a&\u0002&\u0006\u001d\u0016\u0011VAW!\u001d9\u00161BAM\u0003?\u0003B!a\u0006\u0002\u001c&!\u0011QTA\r\u0005e)%/Y:fI\u0016sG/\u001b;z)\u0006<w-\u001a3GK\u0006$XO]3\u0011\t\u0005]\u0011\u0011U\u0005\u0005\u0003G\u000bIB\u0001\u0007GK\u0006$XO]3WC2,X\rC\u0003D\u001f\u0001\u0007A\tC\u0003x\u001f\u0001\u0007\u0001\u0010C\u0004\u0002,>\u0001\r!a&\u0002)\r|g\u000e^3yi\u001a+\u0017\r^;sKZ\u000bG.^3t\u0011\u0015Qs\u00021\u0001,\u0001")
public class DerivedFeatureEvaluator {
    private final DerivationStrategies derivationStrategies;
    private final Option<FeathrExpressionExecutionContext> mvelContext;

    public static Map<ErasedEntityTaggedFeature, FeatureValue> evaluateFromFeatureValues(Seq<Object> seq, DerivedFeature derivedFeature, Map<ErasedEntityTaggedFeature, FeatureValue> map, Option<FeathrExpressionExecutionContext> option) {
        return DerivedFeatureEvaluator$.MODULE$.evaluateFromFeatureValues(seq, derivedFeature, map, option);
    }

    public static DerivedFeatureEvaluator apply(SparkSession sparkSession, FeatureGroups featureGroups, List<DataPathHandler> list, Option<FeathrExpressionExecutionContext> option) {
        return DerivedFeatureEvaluator$.MODULE$.apply(sparkSession, featureGroups, list, option);
    }

    public static DerivedFeatureEvaluator apply(DerivationStrategies derivationStrategies, Option<FeathrExpressionExecutionContext> option) {
        return DerivedFeatureEvaluator$.MODULE$.apply(derivationStrategies, option);
    }

    public FeatureDataFrame evaluate(Seq<Object> keyTag, Seq<String> keyTagList, Dataset<Row> contextDF, DerivedFeature derivedFeature) {
        FeatureDataFrame featureDataFrame;
        Some tags = new Some((Object)((TraversableOnce)keyTag.map(keyTagList, Seq$.MODULE$.canBuildFrom())).toList());
        String producedFeatureColName = DataFrameColName$.MODULE$.genFeatureColumnName((String)derivedFeature.producedFeatureNames().head(), (Option<Seq<String>>)tags);
        Object object = derivedFeature.derivation();
        if (object instanceof SeqJoinDerivationFunction) {
            SeqJoinDerivationFunction seqJoinDerivationFunction = (SeqJoinDerivationFunction)object;
            Dataset<Row> resultDF = this.derivationStrategies.sequentialJoinDerivationStrategy().apply(keyTag, keyTagList, contextDF, derivedFeature, seqJoinDerivationFunction, this.mvelContext);
            featureDataFrame = this.convertFeatureColumnToQuinceFds(producedFeatureColName, derivedFeature, resultDF);
        } else if (object instanceof FeatureDerivationFunctionSpark) {
            FeatureDerivationFunctionSpark featureDerivationFunctionSpark = (FeatureDerivationFunctionSpark)object;
            Dataset<Row> resultDF = this.derivationStrategies.customDerivationSparkStrategy().apply(keyTag, keyTagList, contextDF, derivedFeature, featureDerivationFunctionSpark, this.mvelContext);
            featureDataFrame = this.convertFeatureColumnToQuinceFds(producedFeatureColName, derivedFeature, resultDF);
        } else if (object instanceof SQLFeatureDerivationFunction) {
            SQLFeatureDerivationFunction sQLFeatureDerivationFunction = (SQLFeatureDerivationFunction)object;
            Dataset<Row> resultDF = this.derivationStrategies.sqlDerivationSparkStrategy().apply(keyTag, keyTagList, contextDF, derivedFeature, sQLFeatureDerivationFunction, this.mvelContext);
            featureDataFrame = this.convertFeatureColumnToQuinceFds(producedFeatureColName, derivedFeature, resultDF);
        } else if (object instanceof FeatureDerivationFunction) {
            FeatureDerivationFunction featureDerivationFunction = (FeatureDerivationFunction)object;
            Dataset<Row> resultDF = this.derivationStrategies.rowBasedDerivationStrategy().apply(keyTag, keyTagList, contextDF, derivedFeature, (FeatureDerivationFunctionBase)((Object)featureDerivationFunction), this.mvelContext);
            featureDataFrame = new FeatureDataFrame(resultDF, this.getTypeConfigs(producedFeatureColName, derivedFeature, resultDF));
        } else {
            Some some;
            UdfAdaptor adaptor;
            Option<UdfAdaptor<?>> option = FeathrUdfPluginContext$.MODULE$.getRegisteredUdfAdaptor(object.getClass());
            if (!(option instanceof Some) || !((adaptor = (UdfAdaptor)(some = (Some)option).value()) instanceof FeatureDerivationFunctionAdaptor)) {
                throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(53).append("Unsupported feature derivation function for feature ").append(derivedFeature.producedFeatureNames().head()).append(".").toString());
            }
            FeatureDerivationFunctionAdaptor featureDerivationFunctionAdaptor = (FeatureDerivationFunctionAdaptor)adaptor;
            FeatureDerivationFunction featureDerivationFunction = (FeatureDerivationFunction)featureDerivationFunctionAdaptor.adaptUdf(object);
            Dataset<Row> resultDF = this.derivationStrategies.rowBasedDerivationStrategy().apply(keyTag, keyTagList, contextDF, derivedFeature, (FeatureDerivationFunctionBase)((Object)featureDerivationFunction), this.mvelContext);
            FeatureDataFrame featureDataFrame2 = new FeatureDataFrame(resultDF, this.getTypeConfigs(producedFeatureColName, derivedFeature, resultDF));
            featureDataFrame = featureDataFrame2;
        }
        return featureDataFrame;
    }

    public FeatureDataFrame convertFeatureColumnToQuinceFds(String columnName, DerivedFeature derivedFeature, Dataset<Row> df) {
        Map<String, Tuple2<String, FeatureTypeConfig>> featureColNameToFeatureNameAndType = this.getFeatureColNameToFeatureNameAndType(columnName, derivedFeature, df);
        Map<String, FeatureTypeConfig> inferredFeatureTypeConfigs = this.getTypeConfigs(columnName, derivedFeature, df);
        Dataset<Row> quinceFdsDf = FeaturizedDatasetUtils$.MODULE$.convertRawDFtoQuinceFDS(df, featureColNameToFeatureNameAndType);
        return new FeatureDataFrame(quinceFdsDf, inferredFeatureTypeConfigs);
    }

    private Map<String, Tuple2<String, FeatureTypeConfig>> getFeatureColNameToFeatureNameAndType(String columnName, DerivedFeature derivedFeature, Dataset<Row> df) {
        Map featureColNameToFeatureNameAndType = ((TraversableOnce)((TraversableLike)new .colon.colon((Object)new Tuple2(derivedFeature.producedFeatureNames().head(), (Object)columnName), (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String featureName = (String)tuple2._1();
            String colName = (String)tuple2._2();
            DataType colType = df.schema().fields()[df.schema().fieldIndex(colName)].dataType();
            FeatureTypes inferredType = FeaturizedDatasetUtils$.MODULE$.inferFeatureTypeFromColumnDataType(colType);
            FeatureTypeConfig featureTypeConfig = (FeatureTypeConfig)derivedFeature.featureTypeConfigs().getOrElse((Object)featureName, (Function0 & Serializable & scala.Serializable)() -> new FeatureTypeConfig(inferredType));
            Tuple2 tuple22 = new Tuple2((Object)colName, (Object)new Tuple2((Object)featureName, (Object)featureTypeConfig));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return featureColNameToFeatureNameAndType;
    }

    private Map<String, FeatureTypeConfig> getTypeConfigs(String columnName, DerivedFeature derivedFeature, Dataset<Row> df) {
        Map<String, Tuple2<String, FeatureTypeConfig>> featureColNameToFeatureNameAndType = this.getFeatureColNameToFeatureNameAndType(columnName, derivedFeature, df);
        Map inferredFeatureTypeConfigs = (Map)featureColNameToFeatureNameAndType.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                throw new MatchError((Object)tuple22);
            }
            String featureName = (String)tuple2._1();
            FeatureTypeConfig featureTypeConfig = (FeatureTypeConfig)tuple2._2();
            Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), (Object)featureTypeConfig);
            return tuple23;
        }, Map$.MODULE$.canBuildFrom());
        return inferredFeatureTypeConfigs;
    }

    public DerivedFeatureEvaluator(DerivationStrategies derivationStrategies, Option<FeathrExpressionExecutionContext> mvelContext) {
        this.derivationStrategies = derivationStrategies;
        this.mvelContext = mvelContext;
    }
}

