/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.derived.strategies;

import com.linkedin.feathr.common.ErasedEntityTaggedFeature;
import com.linkedin.feathr.common.FeatureDerivationFunction;
import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.FeatureTypes;
import com.linkedin.feathr.common.FeatureValue;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrException;
import com.linkedin.feathr.common.exception.FeathrFeatureTransformationException;
import com.linkedin.feathr.common.tensor.TensorType;
import com.linkedin.feathr.offline.ErasedEntityTaggedFeature$;
import com.linkedin.feathr.offline.client.DataFrameColName$;
import com.linkedin.feathr.offline.derived.DerivedFeature;
import com.linkedin.feathr.offline.derived.DerivedFeatureEvaluator$;
import com.linkedin.feathr.offline.derived.strategies.RowBasedDerivationStrategy;
import com.linkedin.feathr.offline.mvel.plugins.FeathrExpressionExecutionContext;
import com.linkedin.feathr.offline.testfwk.TestFwkUtils$;
import com.linkedin.feathr.offline.transformation.FDSConversionUtils$;
import com.linkedin.feathr.offline.util.CoercionUtilsScala$;
import com.linkedin.feathr.offline.util.FeaturizedDatasetUtils$;
import com.linkedin.feathr.sparkcommon.FeatureDerivationFunctionSpark;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001\u0002\u0004\b\u0001QA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\to\u0001\u0011)\u0019!C\u0001q!AA\t\u0001B\u0001B\u0003%\u0011\bC\u0003F\u0001\u0011\u0005a\tC\u0003K\u0001\u0011\u00053J\u0001\nS_^\u0014\u0015m]3e\t\u0016\u0014\u0018N^1uS>t'B\u0001\u0005\n\u0003)\u0019HO]1uK\u001eLWm\u001d\u0006\u0003\u0015-\tq\u0001Z3sSZ,GM\u0003\u0002\r\u001b\u00059qN\u001a4mS:,'B\u0001\b\u0010\u0003\u00191W-\u0019;ie*\u0011\u0001#E\u0001\tY&t7.\u001a3j]*\t!#A\u0002d_6\u001c\u0001a\u0005\u0003\u0001+my\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\r\u0005\u0002\u001d;5\tq!\u0003\u0002\u001f\u000f\tQ\"k\\<CCN,G\rR3sSZ\fG/[8o'R\u0014\u0018\r^3hsB\u0011a\u0003I\u0005\u0003C]\u0011AbU3sS\u0006d\u0017N_1cY\u0016\f1\u0004Z3qK:$WM\u001c;GK\u0006$XO]3UsB,7i\u001c8gS\u001e\u001c\b\u0003\u0002\u0013,]Er!!J\u0015\u0011\u0005\u0019:R\"A\u0014\u000b\u0005!\u001a\u0012A\u0002\u001fs_>$h(\u0003\u0002+/\u00051\u0001K]3eK\u001aL!\u0001L\u0017\u0003\u00075\u000b\u0007O\u0003\u0002+/A\u0011AeL\u0005\u0003a5\u0012aa\u0015;sS:<\u0007C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u000e\u0003\u0019\u0019w.\\7p]&\u0011ag\r\u0002\u0012\r\u0016\fG/\u001e:f)f\u0004XmQ8oM&<\u0017aC7wK2\u001cuN\u001c;fqR,\u0012!\u000f\t\u0004-ib\u0014BA\u001e\u0018\u0005\u0019y\u0005\u000f^5p]B\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\ba2,x-\u001b8t\u0015\t\t5\"\u0001\u0003nm\u0016d\u0017BA\"?\u0005\u00012U-\u0019;ie\u0016C\bO]3tg&|g.\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u001954X\r\\\"p]R,\u0007\u0010\u001e\u0011\u0002\rqJg.\u001b;?)\r9\u0005*\u0013\t\u00039\u0001AQA\t\u0003A\u0002\rBQa\u000e\u0003A\u0002e\nQ!\u00199qYf$\u0002\u0002T2qgV\\\u0018\u0011\u0001\t\u0003\u001b\u0002t!AT/\u000f\u0005=SfB\u0001)X\u001d\t\tFK\u0004\u0002'%&\t1+A\u0002pe\u001eL!!\u0016,\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0016B\u0001-Z\u0003\u0015\u0019\b/\u0019:l\u0015\t)f+\u0003\u0002\\9\u0006\u00191/\u001d7\u000b\u0005aK\u0016B\u00010`\u0003\u001d\u0001\u0018mY6bO\u0016T!a\u0017/\n\u0005\u0005\u0014'!\u0003#bi\u00064%/Y7f\u0015\tqv\fC\u0003e\u000b\u0001\u0007Q-A\u0004lKf$\u0016mZ:\u0011\u0007\u0019TWN\u0004\u0002hS:\u0011a\u0005[\u0005\u00021%\u0011alF\u0005\u0003W2\u00141aU3r\u0015\tqv\u0003\u0005\u0002\u0017]&\u0011qn\u0006\u0002\u0004\u0013:$\b\"B9\u0006\u0001\u0004\u0011\u0018AC6fsR\u000bw\rT5tiB\u0019aM\u001b\u0018\t\u000bQ,\u0001\u0019\u0001'\u0002\u0005\u00114\u0007\"\u0002<\u0006\u0001\u00049\u0018A\u00043fe&4X\r\u001a$fCR,(/\u001a\t\u0003qfl\u0011!C\u0005\u0003u&\u0011a\u0002R3sSZ,GMR3biV\u0014X\rC\u0003}\u000b\u0001\u0007Q0\u0001\neKJLg/\u0019;j_:4UO\\2uS>t\u0007C\u0001\u001a\u007f\u0013\ty8GA\rGK\u0006$XO]3EKJLg/\u0019;j_:4UO\\2uS>t\u0007\"B\u001c\u0006\u0001\u0004I\u0004")
public class RowBasedDerivation
implements RowBasedDerivationStrategy,
scala.Serializable {
    private final Map<String, FeatureTypeConfig> dependentFeatureTypeConfigs;
    private final Option<FeathrExpressionExecutionContext> mvelContext;

    public Option<FeathrExpressionExecutionContext> mvelContext() {
        return this.mvelContext;
    }

    @Override
    public Dataset<Row> apply(Seq<Object> keyTags, Seq<String> keyTagList, Dataset<Row> df, DerivedFeature derivedFeature, FeatureDerivationFunction derivationFunction, Option<FeathrExpressionExecutionContext> mvelContext) {
        if (derivationFunction instanceof FeatureDerivationFunctionSpark) {
            throw new FeathrException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(44).append("Unsupported user customized derived feature ").append(derivedFeature.producedFeatureNames()).toString());
        }
        Some tagsThisStage = new Some((Object)((TraversableOnce)keyTags.map(keyTagList, Seq$.MODULE$.canBuildFrom())).toList());
        Seq<String> featureNames = derivedFeature.producedFeatureNames();
        Map derivedFeatureSchema = ((TraversableOnce)featureNames.map((Function1 & Serializable & scala.Serializable)featureName -> {
            FeatureTypeConfig featureTypeConfig = (FeatureTypeConfig)derivedFeature.featureTypeConfigs().getOrElse(featureName, (Function0 & Serializable & scala.Serializable)() -> new FeatureTypeConfig(FeatureTypes.UNSPECIFIED));
            TensorType tensorType = FeaturizedDatasetUtils$.MODULE$.lookupTensorTypeForFeatureRef((String)featureName, FeatureTypes.UNSPECIFIED, featureTypeConfig);
            DataType newSchema = FeaturizedDatasetUtils$.MODULE$.tensorTypeToDataFrameSchema(tensorType);
            return new Tuple2(featureName, (Object)newSchema);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        StructType outputSchema = StructType$.MODULE$.apply((Seq)df.schema().union((GenSeq)StructType$.MODULE$.apply((Seq)featureNames.map((Function1 & Serializable & scala.Serializable)featureName -> {
            String standardizedName = DataFrameColName$.MODULE$.genFeatureColumnName((String)featureName, (Option<Seq<String>>)tagsThisStage);
            return new StructField(standardizedName, (DataType)derivedFeatureSchema.apply(featureName), true, StructField$.MODULE$.apply$default$4());
        }, Seq$.MODULE$.canBuildFrom())), Seq$.MODULE$.canBuildFrom()));
        ExpressionEncoder encoder = RowEncoder$.MODULE$.apply(outputSchema);
        StructType contextDFSchema = df.schema();
        if (TestFwkUtils$.MODULE$.IS_DEBUGGER_ENABLED()) {
            String arg$macro$1 = "\u001b[32m";
            String arg$macro$2 = "\u001b[0m";
            Predef$.MODULE$.println((Object)new StringOps("%sYour input table to the derived feature is: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2})));
            df.show(10);
        }
        Dataset outputDF = df.map((Function1 & Serializable & scala.Serializable)row -> {
            Row row2;
            try {
                scala.collection.mutable.Map contextFeatureValues = Map$.MODULE$.empty();
                Seq linkedInputParams = (Seq)derivedFeature.consumedFeatureNames().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    ErasedEntityTaggedFeature erasedEntityTaggedFeature = x0$1;
                    Option<Tuple2<Seq<Object>, String>> option = ErasedEntityTaggedFeature$.MODULE$.unapply(erasedEntityTaggedFeature);
                    if (option.isEmpty()) {
                        throw new MatchError((Object)erasedEntityTaggedFeature);
                    }
                    Seq calleeTag = (Seq)((Tuple2)option.get())._1();
                    String featureName = (String)((Tuple2)option.get())._2();
                    ErasedEntityTaggedFeature erasedEntityTaggedFeature2 = ErasedEntityTaggedFeature$.MODULE$.apply((Seq<Object>)((Seq)calleeTag.map((Function1)keyTags, Seq$.MODULE$.canBuildFrom())), featureName);
                    return erasedEntityTaggedFeature2;
                }, Seq$.MODULE$.canBuildFrom());
                linkedInputParams.foreach((Function1 & Serializable & scala.Serializable)dependFeature -> {
                    Buffer tagInfo = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(dependFeature.getBinding()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)keyTagList.apply(Predef$.MODULE$.Integer2int(x$1)), Buffer$.MODULE$.canBuildFrom());
                    String standardizedName = DataFrameColName$.MODULE$.genFeatureColumnName(dependFeature.getFeatureName(), (Option<Seq<String>>)new Some((Object)tagInfo));
                    String featureColumn = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])contextDFSchema.fields())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).contains((Object)standardizedName) ? standardizedName : DataFrameColName$.MODULE$.genFeatureColumnName(dependFeature.getFeatureName(), DataFrameColName$.MODULE$.genFeatureColumnName$default$2());
                    String dependentFeatureName = dependFeature.getFeatureName();
                    FeatureTypeConfig featureTypeConfig = (FeatureTypeConfig)$this.dependentFeatureTypeConfigs.getOrElse((Object)dependentFeatureName, (Function0 & Serializable & scala.Serializable)() -> FeatureTypeConfig.UNDEFINED_TYPE_CONFIG);
                    FeatureValue featureValue = CoercionUtilsScala$.MODULE$.coerceFieldToFeatureValue((Row)row, contextDFSchema, featureColumn, featureTypeConfig);
                    return contextFeatureValues.put((Object)ErasedEntityTaggedFeature$.MODULE$.apply(dependFeature.getBinding(), dependFeature.getFeatureName()), (Object)featureValue);
                });
                Map<ErasedEntityTaggedFeature, FeatureValue> features = DerivedFeatureEvaluator$.MODULE$.evaluateFromFeatureValues(keyTags, derivedFeature, (Map<ErasedEntityTaggedFeature, FeatureValue>)contextFeatureValues.toMap(Predef$.MODULE$.$conforms()), mvelContext);
                Map taggFeatures = (Map)features.map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2((Object)((ErasedEntityTaggedFeature)kv._1()).getErasedTagFeatureName(), kv._2()), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                Seq featureValues = (Seq)featureNames.map((Function1 & Serializable & scala.Serializable)featureName -> taggFeatures.get((Object)ErasedEntityTaggedFeature$.MODULE$.apply(keyTags, (String)featureName).getErasedTagFeatureName()).map((Function1 & Serializable & scala.Serializable)featureValue -> {
                    FeatureTypes featureType = ((FeatureTypeConfig)derivedFeature.featureTypeConfigs().getOrElse(featureName, (Function0 & Serializable & scala.Serializable)() -> FeatureTypeConfig.UNDEFINED_TYPE_CONFIG)).getFeatureType();
                    DataType schemaType = (DataType)derivedFeatureSchema.apply(featureName);
                    FeatureTypes featureTypes = featureType;
                    FeatureTypes featureTypes2 = FeatureTypes.TENSOR;
                    return !(featureTypes != null ? !((Object)((Object)featureTypes)).equals((Object)featureTypes2) : featureTypes2 != null) ? FDSConversionUtils$.MODULE$.rawToFDSRow(featureValue.getAsTensorData(), schemaType) : FDSConversionUtils$.MODULE$.rawToFDSRow(JavaConverters$.MODULE$.mapAsScalaMapConverter(featureValue.getAsTermVector()).asScala(), schemaType);
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> null), Seq$.MODULE$.canBuildFrom());
                row2 = Row$.MODULE$.fromSeq((Seq)outputSchema.indices().map((Function1 & Serializable & scala.Serializable)i -> RowBasedDerivation.$anonfun$apply$15(contextDFSchema, featureValues, row, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()));
            }
            catch (Exception e) {
                throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(34).append("Fail to calculate derived feature ").append(derivedFeature.producedFeatureNames()).toString(), e);
            }
            return row2;
        }, (Encoder)encoder);
        return outputDF;
    }

    public static final /* synthetic */ Object $anonfun$apply$15(StructType contextDFSchema$1, Seq featureValues$1, Row row$1, int i) {
        return i >= contextDFSchema$1.size() ? featureValues$1.apply(i - contextDFSchema$1.size()) : row$1.get(i);
    }

    public RowBasedDerivation(Map<String, FeatureTypeConfig> dependentFeatureTypeConfigs, Option<FeathrExpressionExecutionContext> mvelContext) {
        this.dependentFeatureTypeConfigs = dependentFeatureTypeConfigs;
        this.mvelContext = mvelContext;
    }
}

