/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.derived.strategies;

import com.linkedin.feathr.common.ErasedEntityTaggedFeature;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrException;
import com.linkedin.feathr.offline.ErasedEntityTaggedFeature$;
import com.linkedin.feathr.offline.client.DataFrameColName$;
import com.linkedin.feathr.offline.derived.DerivedFeature;
import com.linkedin.feathr.offline.derived.strategies.SparkUdfDerivationStrategy;
import com.linkedin.feathr.offline.exception.FeatureTransformationException;
import com.linkedin.feathr.offline.mvel.plugins.FeathrExpressionExecutionContext;
import com.linkedin.feathr.sparkcommon.FeatureDerivationFunctionSpark;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A4Aa\u0001\u0003\u0001#!)A\u0004\u0001C\u0001;!)q\u0004\u0001C!A\t\u00112\u000b]1sWV#g\rR3sSZ\fG/[8o\u0015\t)a!\u0001\u0006tiJ\fG/Z4jKNT!a\u0002\u0005\u0002\u000f\u0011,'/\u001b<fI*\u0011\u0011BC\u0001\b_\u001a4G.\u001b8f\u0015\tYA\"\u0001\u0004gK\u0006$\bN\u001d\u0006\u0003\u001b9\t\u0001\u0002\\5oW\u0016$\u0017N\u001c\u0006\u0002\u001f\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\tI\"$D\u0001\u0005\u0013\tYBA\u0001\u000eTa\u0006\u00148.\u00163g\t\u0016\u0014\u0018N^1uS>t7\u000b\u001e:bi\u0016<\u00170\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011\u0011\u0004A\u0001\u0006CB\u0004H.\u001f\u000b\bCmB5+V.d!\t\u0011\u0003H\u0004\u0002$k9\u0011AE\r\b\u0003K=r!A\n\u0017\u000f\u0005\u001dRS\"\u0001\u0015\u000b\u0005%\u0002\u0012A\u0002\u001fs_>$h(C\u0001,\u0003\ry'oZ\u0005\u0003[9\na!\u00199bG\",'\"A\u0016\n\u0005A\n\u0014!B:qCJ\\'BA\u0017/\u0013\t\u0019D'A\u0002tc2T!\u0001M\u0019\n\u0005Y:\u0014a\u00029bG.\fw-\u001a\u0006\u0003gQJ!!\u000f\u001e\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u0001\u001c8\u0011\u0015a$\u00011\u0001>\u0003\u001dYW-\u001f+bON\u00042A\u0010\"F\u001d\ty\u0014I\u0004\u0002(\u0001&\tQ#\u0003\u00027)%\u00111\t\u0012\u0002\u0004'\u0016\f(B\u0001\u001c\u0015!\t\u0019b)\u0003\u0002H)\t\u0019\u0011J\u001c;\t\u000b%\u0013\u0001\u0019\u0001&\u0002\u0015-,\u0017\u0010V1h\u0019&\u001cH\u000fE\u0002?\u0005.\u0003\"\u0001\u0014)\u000f\u00055s\u0005CA\u0014\u0015\u0013\tyE#\u0001\u0004Qe\u0016$WMZ\u0005\u0003#J\u0013aa\u0015;sS:<'BA(\u0015\u0011\u0015!&\u00011\u0001\"\u0003\t!g\rC\u0003W\u0005\u0001\u0007q+\u0001\beKJLg/\u001a3GK\u0006$XO]3\u0011\u0005aKV\"\u0001\u0004\n\u0005i3!A\u0004#fe&4X\r\u001a$fCR,(/\u001a\u0005\u00069\n\u0001\r!X\u0001\u0013I\u0016\u0014\u0018N^1uS>tg)\u001e8di&|g\u000e\u0005\u0002_C6\tqL\u0003\u0002a\u0015\u0005Y1\u000f]1sW\u000e|W.\\8o\u0013\t\u0011wL\u0001\u0010GK\u0006$XO]3EKJLg/\u0019;j_:4UO\\2uS>t7\u000b]1sW\")AM\u0001a\u0001K\u0006YQN^3m\u0007>tG/\u001a=u!\r\u0019b\r[\u0005\u0003OR\u0011aa\u00149uS>t\u0007CA5o\u001b\u0005Q'BA6m\u0003\u001d\u0001H.^4j]NT!!\u001c\u0005\u0002\t54X\r\\\u0005\u0003_*\u0014\u0001ER3bi\"\u0014X\t\u001f9sKN\u001c\u0018n\u001c8Fq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002")
public class SparkUdfDerivation
implements SparkUdfDerivationStrategy {
    @Override
    public Dataset<Row> apply(Seq<Object> keyTags, Seq<String> keyTagList, Dataset<Row> df, DerivedFeature derivedFeature, FeatureDerivationFunctionSpark derivationFunction, Option<FeathrExpressionExecutionContext> mvelContext) {
        if (derivedFeature.parameterNames().isEmpty()) {
            throw new FeathrException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(62).append("User customized derived feature ").append(derivedFeature.producedFeatureNames()).append(" does not have parameter names").toString());
        }
        Seq linkedInputParams = (Seq)derivedFeature.consumedFeatureNames().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ErasedEntityTaggedFeature erasedEntityTaggedFeature = x0$1;
            Option<Tuple2<Seq<Object>, String>> option = ErasedEntityTaggedFeature$.MODULE$.unapply(erasedEntityTaggedFeature);
            if (option.isEmpty()) {
                throw new MatchError((Object)erasedEntityTaggedFeature);
            }
            Seq calleeTag = (Seq)((Tuple2)option.get())._1();
            String featureName = (String)((Tuple2)option.get())._2();
            ErasedEntityTaggedFeature erasedEntityTaggedFeature2 = ErasedEntityTaggedFeature$.MODULE$.apply((Seq<Object>)((Seq)calleeTag.map((Function1)keyTags, Seq$.MODULE$.canBuildFrom())), featureName);
            return erasedEntityTaggedFeature2;
        }, Seq$.MODULE$.canBuildFrom());
        Seq featureColumnNameToParamNameMap = (Seq)((TraversableLike)linkedInputParams.zip((GenIterable)derivedFeature.parameterNames().get(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)taggedWithParam -> {
            ErasedEntityTaggedFeature tagged = (ErasedEntityTaggedFeature)taggedWithParam._1();
            Some tags = new Some(((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tagged.getBinding()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)keyTagList.apply(Predef$.MODULE$.Integer2int(x$1)), Buffer$.MODULE$.canBuildFrom()));
            String featureColumnName = DataFrameColName$.MODULE$.genFeatureColumnName(tagged.getFeatureName(), (Option<Seq<String>>)tags);
            return new Tuple2((Object)featureColumnName, taggedWithParam._2());
        }, Seq$.MODULE$.canBuildFrom());
        Dataset withRenamedFeaturesDF = (Dataset)featureColumnNameToParamNameMap.foldLeft(df, (Function2 & Serializable & scala.Serializable)(acc, featureNameToArg) -> acc.withColumn((String)featureNameToArg._2(), acc.apply((String)featureNameToArg._1())));
        Dataset<Row> transformedDF = derivationFunction.transform((Dataset<Row>)withRenamedFeaturesDF);
        Seq callerKeyTags = (Seq)derivedFeature.producedFeatureNames().map((Function1 & Serializable & scala.Serializable)x$2 -> ErasedEntityTaggedFeature$.MODULE$.apply(keyTags, (String)x$2), Seq$.MODULE$.canBuildFrom());
        Seq featureNameToStandardizedColumnNameMap = (Seq)callerKeyTags.map((Function1 & Serializable & scala.Serializable)tagged -> {
            Some tags = new Some(((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tagged.getBinding()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> (String)keyTagList.apply(Predef$.MODULE$.Integer2int(x$3)), Buffer$.MODULE$.canBuildFrom()));
            String standardizedName = DataFrameColName$.MODULE$.genFeatureColumnName(tagged.getFeatureName(), (Option<Seq<String>>)tags);
            return new Tuple2((Object)tagged.getFeatureName(), (Object)standardizedName);
        }, Seq$.MODULE$.canBuildFrom());
        Set expectColumns = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])withRenamedFeaturesDF.columns())).$plus$plus((GenTraversableOnce)featureNameToStandardizedColumnNameMap.map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4._1(), Seq$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        Set returnedColumns = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])transformedDF.columns())).toSet();
        Seq undeclaredColumns = returnedColumns.diff((GenSet)expectColumns).toSeq();
        Set missingColumns = (Set)expectColumns.diff((GenSet)returnedColumns);
        if (missingColumns.nonEmpty()) {
            throw new FeatureTransformationException(new StringBuilder(141).append("Expected columns: ").append(missingColumns.mkString(",")).append(" are missing after derived feature ").append(derivedFeature).append(" evaluation, its derivation function should generate or passthrough all expected columns").toString());
        }
        Dataset withOutputFeatureDF = (Dataset)featureNameToStandardizedColumnNameMap.foldLeft(transformedDF, (Function2 & Serializable & scala.Serializable)(acc, featueNameToStandardizeName) -> acc.withColumnRenamed((String)featueNameToStandardizeName._1(), (String)featueNameToStandardizeName._2()));
        return withOutputFeatureDF.drop((Seq)featureColumnNameToParamNameMap.map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5._2(), Seq$.MODULE$.canBuildFrom())).drop(undeclaredColumns);
    }
}

