/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.evaluator.transformation;

import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.compute.NodeReference;
import com.linkedin.feathr.compute.Transformation;
import com.linkedin.feathr.offline.anchored.anchorExtractor.SimpleConfigurableAnchorExtractor;
import com.linkedin.feathr.offline.anchored.keyExtractor.MVELSourceKeyExtractor;
import com.linkedin.feathr.offline.anchored.keyExtractor.MVELSourceKeyExtractor$;
import com.linkedin.feathr.offline.config.MVELFeatureDefinition;
import com.linkedin.feathr.offline.evaluator.transformation.TransformationOperator;
import com.linkedin.feathr.offline.evaluator.transformation.TransformationOperatorUtils$;
import com.linkedin.feathr.offline.graph.DataframeAndColumnMetadata;
import com.linkedin.feathr.offline.graph.FCMGraphTraverser;
import com.linkedin.feathr.offline.graph.NodeUtils$;
import com.linkedin.feathr.offline.job.FeatureTransformation$;
import com.linkedin.feathr.offline.source.accessor.DataPathHandler;
import com.linkedin.feathr.offline.transformation.DataFrameBasedRowEvaluator$;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class AnchorMVELOperator$
implements TransformationOperator {
    public static AnchorMVELOperator$ MODULE$;

    static {
        new AnchorMVELOperator$();
    }

    public Tuple2<Dataset<Row>, Seq<String>> computeMVELResult(Seq<Transformation> nodes, FCMGraphTraverser graphTraverser, Dataset<Row> contextDf, boolean appendKeyColumns) {
        Integer inputNodeId = ((NodeReference)((Transformation)nodes.head()).getInputs().get(0)).getId();
        Seq<String> keySeq = ((DataframeAndColumnMetadata)graphTraverser.nodeIdToDataframeAndColumnMetadataMap().apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(inputNodeId)))).keyExpression();
        Dataset<Row> inputDf = appendKeyColumns ? ((DataframeAndColumnMetadata)graphTraverser.nodeIdToDataframeAndColumnMetadataMap().apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(inputNodeId)))).df() : contextDf;
        Map<String, FeatureTypeConfig> featureTypeConfigs = NodeUtils$.MODULE$.getFeatureTypeConfigsMapForTransformationNodes(nodes);
        Map featureNameToMvelExpr = ((TraversableOnce)nodes.map((Function1 & Serializable & scala.Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(graphTraverser.nodeIdToFeatureName().apply((Object)node.getId())), (Object)new MVELFeatureDefinition((String)node.getFunction().getParameters().get((Object)"expression"), (Option<FeatureTypeConfig>)featureTypeConfigs.get((Object)node.getFeatureName()))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq featureNamesInBatch = featureNameToMvelExpr.keys().toSeq();
        SimpleConfigurableAnchorExtractor mvelExtractor = new SimpleConfigurableAnchorExtractor(keySeq, (Map<String, MVELFeatureDefinition>)featureNameToMvelExpr);
        MVELSourceKeyExtractor mvelKeyExtractor = new MVELSourceKeyExtractor(mvelExtractor, MVELSourceKeyExtractor$.MODULE$.$lessinit$greater$default$2());
        Dataset<Row> withKeyColumnDF = appendKeyColumns ? mvelKeyExtractor.appendKeyColumns(inputDf) : inputDf;
        Seq<String> outputJoinKeyColumnNames = FeatureTransformation$.MODULE$.getFeatureKeyColumnNames(mvelKeyExtractor, withKeyColumnDF);
        Dataset<Row> transformationResult = DataFrameBasedRowEvaluator$.MODULE$.transform(mvelExtractor, withKeyColumnDF, (Seq<Tuple2<String, String>>)((Seq)featureNamesInBatch.map((Function1 & Serializable & scala.Serializable)x$1 -> new Tuple2(x$1, (Object)" "), Seq$.MODULE$.canBuildFrom())), featureTypeConfigs, graphTraverser.mvelExpressionContext()).df();
        return new Tuple2(transformationResult, outputJoinKeyColumnNames);
    }

    @Override
    public Dataset<Row> batchCompute(Seq<Transformation> nodes, FCMGraphTraverser graphTraverser, Dataset<Row> contextDf, List<DataPathHandler> dataPathHandlers) {
        Tuple2<Dataset<Row>, Seq<String>> tuple2 = this.computeMVELResult(nodes, graphTraverser, contextDf, true);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Dataset transformationResult = (Dataset)tuple2._1();
        Seq outputJoinKeyColumnNames = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)transformationResult, (Object)outputJoinKeyColumnNames);
        Tuple2 tuple23 = tuple22;
        Dataset transformationResult2 = (Dataset)tuple23._1();
        Seq outputJoinKeyColumnNames2 = (Seq)tuple23._2();
        Seq featureNamesInBatch = (Seq)nodes.map((Function1 & Serializable & scala.Serializable)node -> (String)graphTraverser.nodeIdToFeatureName().apply((Object)node.getId()), Seq$.MODULE$.canBuildFrom());
        Tuple2<Dataset<Row>, Seq<String>> tuple24 = TransformationOperatorUtils$.MODULE$.dropAndRenameCols((Dataset<Row>)transformationResult2, (Seq<String>)outputJoinKeyColumnNames2, (Seq<String>)featureNamesInBatch);
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        Dataset prunedResult = (Dataset)tuple24._1();
        Seq keyColumns = (Seq)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)prunedResult, (Object)keyColumns);
        Tuple2 tuple26 = tuple25;
        Dataset prunedResult2 = (Dataset)tuple26._1();
        Seq keyColumns2 = (Seq)tuple26._2();
        return TransformationOperatorUtils$.MODULE$.joinResultToContextDfAndApplyDefaults(nodes, graphTraverser, (Dataset<Row>)prunedResult2, (Seq<String>)keyColumns2, contextDf);
    }

    @Override
    public Dataset<Row> compute(Transformation node, FCMGraphTraverser graphTraverser, Dataset<Row> contextDf, List<DataPathHandler> dataPathHandlers) {
        return this.batchCompute((Seq<Transformation>)((Seq)new .colon.colon((Object)node, (List)Nil$.MODULE$)), graphTraverser, contextDf, dataPathHandlers);
    }

    private AnchorMVELOperator$() {
        MODULE$ = this;
    }
}

