/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.generation;

import com.linkedin.feathr.common.DateParam;
import com.linkedin.feathr.common.DateTimeParam;
import com.linkedin.feathr.common.DateTimeParam$;
import com.linkedin.feathr.common.DateTimeUtils$;
import com.linkedin.feathr.common.JoiningFeatureParams;
import com.linkedin.feathr.common.JoiningFeatureParams$;
import com.linkedin.feathr.common.TaggedFeatureName;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.common.exception.FeathrException;
import com.linkedin.feathr.offline.anchored.anchorExtractor.TimeWindowConfigurableAnchorExtractor;
import com.linkedin.feathr.offline.anchored.feature.FeatureAnchorWithSource;
import com.linkedin.feathr.offline.config.TimeWindowFeatureDefinition;
import com.linkedin.feathr.offline.derived.DerivedFeature;
import com.linkedin.feathr.offline.generation.FeatureGenKeyTagAnalyzer;
import com.linkedin.feathr.offline.job.FeatureGenSpec;
import com.linkedin.feathr.offline.logical.FeatureGroups;
import com.linkedin.feathr.sparkcommon.SourceKeyExtractor;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class FeatureGenKeyTagAnalyzer$
implements FeatureGenKeyTagAnalyzer {
    public static FeatureGenKeyTagAnalyzer$ MODULE$;

    static {
        new FeatureGenKeyTagAnalyzer$();
    }

    @Override
    public Seq<JoiningFeatureParams> inferKeyTagsForAnchoredFeatures(FeatureGenSpec featureGenSpec, FeatureGroups featureGroups) {
        Seq<String> features = this.getDependentFeatures(featureGenSpec.getFeatures(), featureGroups);
        Seq passthroughFeatures = (Seq)features.filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)FeatureGenKeyTagAnalyzer$.$anonfun$inferKeyTagsForAnchoredFeatures$1(featureGroups, key)));
        if (passthroughFeatures.nonEmpty()) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(182).append("Feature generation does not support Passthrough features. Following passthrough features are explicitly requested,").append(" or have been evaluated as required to generate derived features: [").append(passthroughFeatures.mkString(",")).append("]").toString());
        }
        Seq anchoredFeatures = (Seq)features.filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)FeatureGenKeyTagAnalyzer$.$anonfun$inferKeyTagsForAnchoredFeatures$2(featureGroups, key)));
        Map<String, FeatureAnchorWithSource> allAnchoredFeatures = featureGroups.allAnchoredFeatures();
        Seq inferredAnchorFeatures = ((TraversableOnce)anchoredFeatures.groupBy((Function1 & Serializable & scala.Serializable)f -> ((FeatureAnchorWithSource)allAnchoredFeatures.apply(f)).source()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq featureWithSameSource = (Seq)tuple2._2();
            Seq featureToKeyExprs = (Seq)featureWithSameSource.map((Function1 & Serializable & scala.Serializable)f -> {
                SourceKeyExtractor keyExtractor = ((FeatureAnchorWithSource)allAnchoredFeatures.apply(f)).featureAnchor().sourceKeyExtractor();
                Seq<String> keyAlias = keyExtractor.getKeyColumnAlias(keyExtractor.getKeyColumnAlias$default$1());
                if (keyAlias.isEmpty()) {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(177).append("Inferred key tags from ").append(keyExtractor).append(" is empty, this seems to ").append("be an unsupported user customized class extends AnchorExtractor[_], please add keyAlias to the feature definition of the feature ").append((String)f).toString());
                }
                String keyExtractorIdentifier = keyExtractor.getClass().getCanonicalName();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f), (Object)new Tuple2((Object)keyExtractorIdentifier, keyAlias));
            }, Seq$.MODULE$.canBuildFrom());
            Iterable iterable = (Iterable)featureToKeyExprs.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> (Tuple2)x$1._2()).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Seq featureWithSameKeys;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$2;
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        featureWithSameKeys = (Seq)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Seq keyTags = (Seq)tuple2._2();
                Seq featureNames = (Seq)featureWithSameKeys.map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2._1(), Seq$.MODULE$.canBuildFrom());
                Seq seq = (Seq)featureNames.map((Function1 & Serializable & scala.Serializable)f -> new TaggedFeatureName(package$.MODULE$.wrapAll().deprecated$u0020seqAsJavaList(keyTags), (String)f), Seq$.MODULE$.canBuildFrom());
                return seq;
            }, Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        return this.convertToJoiningFeatureParams((Seq<TaggedFeatureName>)inferredAnchorFeatures, featureGenSpec, featureGroups);
    }

    private Seq<JoiningFeatureParams> convertToJoiningFeatureParams(Seq<TaggedFeatureName> taggedFeature, FeatureGenSpec featureGenSpec, FeatureGroups featureGroups) {
        DateTimeParam refTime = featureGenSpec.dateTimeParam();
        return (Seq)taggedFeature.map((Function1 & Serializable & scala.Serializable)f -> {
            DateParam dateParam;
            String featureName = f.getFeatureName();
            FeatureAnchorWithSource featureAnchorWithSource = (FeatureAnchorWithSource)featureGroups.allAnchoredFeatures().apply((Object)featureName);
            Object object = featureAnchorWithSource.featureAnchor().extractor();
            if (object instanceof TimeWindowConfigurableAnchorExtractor) {
                TimeWindowConfigurableAnchorExtractor timeWindowConfigurableAnchorExtractor = (TimeWindowConfigurableAnchorExtractor)object;
                TimeWindowFeatureDefinition aggFeature = (TimeWindowFeatureDefinition)timeWindowConfigurableAnchorExtractor.features().apply((Object)featureName);
                DateTimeParam dateTimeParam = DateTimeParam$.MODULE$.shiftStartTime(refTime, aggFeature.window());
                dateParam = DateTimeUtils$.MODULE$.toDateParam(dateTimeParam);
            } else {
                dateParam = featureGenSpec.dateParam();
            }
            DateParam dateParam2 = dateParam;
            return new JoiningFeatureParams((Seq<String>)((WrapAsScala)package$.MODULE$.wrapAll()).deprecated$u0020asScalaBuffer(f.getKeyTag()), f.getFeatureName(), (Option<DateParam>)Option$.MODULE$.apply((Object)dateParam2), JoiningFeatureParams$.MODULE$.$lessinit$greater$default$4(), JoiningFeatureParams$.MODULE$.$lessinit$greater$default$5());
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<String> getDependentFeatures(Seq<String> features, FeatureGroups featureGroups) {
        Seq derived;
        Tuple2 tuple2 = features.partition((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)FeatureGenKeyTagAnalyzer$.$anonfun$getDependentFeatures$4(featureGroups, key)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq seq = derived = (Seq)tuple2._1();
        Seq derived2 = seq;
        return (Seq)this.visit$1(features, derived2, featureGroups).distinct();
    }

    @Override
    public Seq<JoiningFeatureParams> inferKeyTagsForDerivedFeatures(FeatureGenSpec featureGenSpec, FeatureGroups featureGroups, Seq<JoiningFeatureParams> keyTaggedAnchoredFeatures) {
        Map<String, FeatureAnchorWithSource> allAnchoredFeatures = featureGroups.allAnchoredFeatures();
        Map<String, DerivedFeature> allDerivedFeatures = featureGroups.allDerivedFeatures();
        Seq derivedFeatures = (Seq)featureGenSpec.getFeatures().filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)allDerivedFeatures.contains((Object)key)));
        Map anchoredToKeyTagsMap = ((TraversableOnce)keyTaggedAnchoredFeatures.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JoiningFeatureParams joiningFeatureParams = x0$1;
            Tuple2 tuple2 = new Tuple2((Object)joiningFeatureParams.featureName(), joiningFeatureParams.keyTags());
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map derivedToInferredKeyTagsMap = ((TraversableOnce)derivedFeatures.map((Function1 & Serializable & scala.Serializable)f -> new Tuple2(f, FeatureGenKeyTagAnalyzer$.getKeyTagsForConsumedFeature$1(f, anchoredToKeyTagsMap, allAnchoredFeatures, allDerivedFeatures).distinct()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        FeatureGenKeyTagAnalyzer$.validateNoCrossJoin$1(anchoredToKeyTagsMap.$plus$plus((GenTraversableOnce)derivedToInferredKeyTagsMap), derivedFeatures, allDerivedFeatures);
        return ((TraversableOnce)derivedToInferredKeyTagsMap.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String feature = (String)tuple2._1();
            Seq keyTags = (Seq)tuple2._2();
            JoiningFeatureParams joiningFeatureParams = new JoiningFeatureParams((Seq<String>)keyTags, feature, JoiningFeatureParams$.MODULE$.apply$default$3(), JoiningFeatureParams$.MODULE$.apply$default$4(), JoiningFeatureParams$.MODULE$.apply$default$5());
            return joiningFeatureParams;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$inferKeyTagsForAnchoredFeatures$1(FeatureGroups featureGroups$1, String key) {
        return featureGroups$1.allPassthroughFeatures().contains((Object)key);
    }

    public static final /* synthetic */ boolean $anonfun$inferKeyTagsForAnchoredFeatures$2(FeatureGroups featureGroups$1, String key) {
        return featureGroups$1.allAnchoredFeatures().contains((Object)key);
    }

    public static final /* synthetic */ boolean $anonfun$getDependentFeatures$3(FeatureGroups featureGroups$3, String key) {
        return featureGroups$3.allDerivedFeatures().contains((Object)key);
    }

    private final Seq visit$1(Seq acc, Seq derivedFeatures, FeatureGroups featureGroups$3) {
        while (!derivedFeatures.isEmpty()) {
            Seq derived;
            Seq derived2;
            Seq dependentFeatures = (Seq)((TraversableLike)derivedFeatures.map(featureGroups$3.allDerivedFeatures(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)f -> (Seq)f.consumedFeatureNames().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getFeatureName(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            Tuple2 tuple2 = dependentFeatures.partition((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)FeatureGenKeyTagAnalyzer$.$anonfun$getDependentFeatures$3(featureGroups$3, key)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq seq = derived2 = (Seq)tuple2._1();
            derivedFeatures = derived = seq;
            acc = (Seq)acc.$plus$plus((GenTraversableOnce)dependentFeatures, Seq$.MODULE$.canBuildFrom());
        }
        return acc;
    }

    public static final /* synthetic */ boolean $anonfun$getDependentFeatures$4(FeatureGroups featureGroups$3, String key) {
        return featureGroups$3.allDerivedFeatures().contains((Object)key);
    }

    public static final /* synthetic */ boolean $anonfun$inferKeyTagsForDerivedFeatures$3(Map inferredKeyTagsMap$1, String f$1, String x) {
        return !BoxesRunTime.equals((Object)inferredKeyTagsMap$1.apply((Object)x), (Object)inferredKeyTagsMap$1.apply((Object)f$1));
    }

    public static final /* synthetic */ boolean $anonfun$inferKeyTagsForDerivedFeatures$1(Map allDerivedFeatures$1, Map inferredKeyTagsMap$1, String f) {
        return ((IterableLike)((DerivedFeature)allDerivedFeatures$1.apply((Object)f)).consumedFeatureNames().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getFeatureName(), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)FeatureGenKeyTagAnalyzer$.$anonfun$inferKeyTagsForDerivedFeatures$3(inferredKeyTagsMap$1, f, x)));
    }

    private static final void validateNoCrossJoin$1(Map inferredKeyTagsMap, Seq derivedFeatures, Map allDerivedFeatures$1) {
        Seq failedFeatures = (Seq)derivedFeatures.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FeatureGenKeyTagAnalyzer$.$anonfun$inferKeyTagsForDerivedFeatures$1(allDerivedFeatures$1, inferredKeyTagsMap, f)));
        if (failedFeatures.nonEmpty()) {
            throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(133).append("Feature Generation currently does not support cross join and sequential join, at the moment. ").append("Features violating this constraint: : [").append(failedFeatures.mkString(", ")).append("]").toString());
        }
    }

    private static final Seq getKeyTagsForConsumedFeature$1(String feature2, Map anchoredToKeyTagMap, Map allAnchoredFeatures$2, Map allDerivedFeatures$1) {
        Seq seq;
        String string = feature2;
        if (allAnchoredFeatures$2.contains((Object)string)) {
            if (!anchoredToKeyTagMap.contains((Object)string)) {
                throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(53).append("Could not find inferred keyTags for anchored feature ").append(feature2).toString());
            }
            seq = (Seq)anchoredToKeyTagMap.apply((Object)string);
        } else if (allDerivedFeatures$1.contains((Object)string)) {
            seq = (Seq)((TraversableOnce)((DerivedFeature)allDerivedFeatures$1.apply((Object)string)).consumedFeatureNames().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getFeatureName(), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(acc, feature) -> (Seq)acc.$plus$plus((GenTraversableOnce)FeatureGenKeyTagAnalyzer$.getKeyTagsForConsumedFeature$1(feature, anchoredToKeyTagMap, allAnchoredFeatures$2, allDerivedFeatures$1), Seq$.MODULE$.canBuildFrom()));
        } else {
            throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(114).append("Unrecognized feature group for feature generation. Feature ").append(feature2).append(" does not belong to anchored or derived feature groups.").toString());
        }
        return seq;
    }

    private FeatureGenKeyTagAnalyzer$() {
        MODULE$ = this;
    }
}

