/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.generation;

import com.linkedin.feathr.common.ErasedEntityTaggedFeature;
import com.linkedin.feathr.common.FeatureInfo;
import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.Header;
import com.linkedin.feathr.common.TaggedFeatureName;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrException;
import com.linkedin.feathr.offline.ErasedEntityTaggedFeature$;
import com.linkedin.feathr.offline.FeatureDataFrame;
import com.linkedin.feathr.offline.client.DataFrameColName$;
import com.linkedin.feathr.offline.generation.PostGenPruner$;
import com.linkedin.feathr.offline.job.FeatureTransformation$;
import com.linkedin.feathr.offline.logical.FeatureGroups;
import com.linkedin.feathr.offline.logical.MultiStageJoinPlan;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.convert.package$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc!B\u0005\u000b\u00011!\u0002\"B\u000e\u0001\t\u0003i\u0002\"\u0002\u0011\u0001\t\u0003\t\u0003\"\u0002>\u0001\t\u0013Y\bbBA\u0014\u0001\u0011\u0005\u0011\u0011F\u0004\t\u0003{Q\u0001\u0012\u0001\u0007\u0002@\u00199\u0011B\u0003E\u0001\u0019\u0005\u0005\u0003BB\u000e\u0007\t\u0003\t\u0019\u0005\u0003\u0004\u0002F\u0019!\t!\b\u0002\u000e!>\u001cHoR3o!J,h.\u001a:\u000b\u0005-a\u0011AC4f]\u0016\u0014\u0018\r^5p]*\u0011QBD\u0001\b_\u001a4G.\u001b8f\u0015\ty\u0001#\u0001\u0004gK\u0006$\bN\u001d\u0006\u0003#I\t\u0001\u0002\\5oW\u0016$\u0017N\u001c\u0006\u0002'\u0005\u00191m\\7\u0014\u0005\u0001)\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005q\u0002CA\u0010\u0001\u001b\u0005Q\u0011!\u00029sk:,G#\u0002\u0012QA6,\b\u0003B\u0012+[Mr!\u0001\n\u0015\u0011\u0005\u0015:R\"\u0001\u0014\u000b\u0005\u001db\u0012A\u0002\u001fs_>$h(\u0003\u0002*/\u00051\u0001K]3eK\u001aL!a\u000b\u0017\u0003\u00075\u000b\u0007O\u0003\u0002*/A\u0011a&M\u0007\u0002_)\u0011\u0001GD\u0001\u0007G>lWn\u001c8\n\u0005Iz#!\u0005+bO\u001e,GMR3biV\u0014XMT1nKB!a\u0003\u000e\u001cN\u0013\t)tC\u0001\u0004UkBdWM\r\t\u0003o)s!\u0001O$\u000f\u0005e\"eB\u0001\u001eB\u001d\tYdH\u0004\u0002&y%\tQ(A\u0002pe\u001eL!a\u0010!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0014B\u0001\"D\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0004)\u0003\u0002F\r\u0006\u00191/\u001d7\u000b\u0005\t\u001b\u0015B\u0001%J\u0003\u001d\u0001\u0018mY6bO\u0016T!!\u0012$\n\u0005-c%!\u0003#bi\u00064%/Y7f\u0015\tA\u0015\n\u0005\u0002/\u001d&\u0011qj\f\u0002\u0007\u0011\u0016\fG-\u001a:\t\u000bE\u0013\u0001\u0019\u0001*\u0002\u0017\u0019,\u0017\r^;sK\u0012\u000bG/\u0019\t\u0003'vs!\u0001\u0016/\u000f\u0005U[fB\u0001,[\u001d\t9\u0016L\u0004\u0002&1&\t1#\u0003\u0002\u0012%%\u0011q\u0002E\u0005\u0003\u001b9I!\u0001\u0013\u0007\n\u0005y{&a\u0006$fCR,(/\u001a#bi\u0006<\u0016\u000e\u001e5K_&t7*Z=t\u0015\tAE\u0002C\u0003b\u0005\u0001\u0007!-A\tsKF,Xm\u001d;fI\u001a+\u0017\r^;sKN\u00042aY4k\u001d\t!gM\u0004\u0002&K&\t\u0001$\u0003\u0002I/%\u0011\u0001.\u001b\u0002\u0004'\u0016\f(B\u0001%\u0018!\t\u00196.\u0003\u0002m?\nYa)Z1ukJ,g*Y7f\u0011\u0015q'\u00011\u0001p\u0003-awnZ5dC2\u0004F.\u00198\u0011\u0005A\u001cX\"A9\u000b\u0005Id\u0011a\u00027pO&\u001c\u0017\r\\\u0005\u0003iF\u0014!#T;mi&\u001cF/Y4f\u0015>Lg\u000e\u00157b]\")aO\u0001a\u0001o\u0006ia-Z1ukJ,wI]8vaN\u0004\"\u0001\u001d=\n\u0005e\f(!\u0004$fCR,(/Z$s_V\u00048/\u0001\u0007qeVtWmQ8mk6t7\u000fF\u0006}\u0003\u0003\ti!a\u0006\u0002\"\u0005\u0015\u0002\u0003B\u0012+{N\u0002\"a\t@\n\u0005}d#AB*ue&tw\rC\u0004\u0002\u0004\r\u0001\r!!\u0002\u0002!\u0019,\u0017\r^;sK\u0012\u000bG/\u0019$sC6,\u0007\u0003BA\u0004\u0003\u0013i\u0011\u0001D\u0005\u0004\u0003\u0017a!\u0001\u0005$fCR,(/\u001a#bi\u00064%/Y7f\u0011\u001d\tya\u0001a\u0001\u0003#\t\u0001B[8j].+\u0017p\u001d\t\u0004'\u0006M\u0011bAA\u000b?\nA!j\\5o\u0017\u0016L8\u000fC\u0004\u0002\u001a\r\u0001\r!a\u0007\u0002\u0017-,\u0017\u0010V1hg&sgm\u001c\t\u0005G\u0006uQ0C\u0002\u0002 %\u0014A\u0001T5ti\"1\u00111E\u0002A\u0002\t\faBZ3biV\u0014Xm\u001d+p\u0017\u0016,\u0007\u000fC\u0003w\u0007\u0001\u0007q/\u0001\nti\u0006tG-\u0019:eSj,7i\u001c7v[:\u001cH\u0003CA\u0016\u0003c\t\u0019$!\u000f\u0011\u0007\u00055\"JD\u0002\u00020\u001dk\u0011!\u0013\u0005\b\u0003\u001f!\u0001\u0019AA\t\u0011\u001d\t)\u0004\u0002a\u0001\u0003o\tab[3z\u0007>dW/\u001c8OC6,7\u000fE\u0002dOvDa!a\u000f\u0005\u0001\u00041\u0014!C2mK\u0006tW\r\u001a#G\u00035\u0001vn\u001d;HK:\u0004&/\u001e8feB\u0011qDB\n\u0003\rU!\"!a\u0010\u0002\u000b\u0005\u0004\b\u000f\\=")
public class PostGenPruner {
    public static PostGenPruner apply() {
        return PostGenPruner$.MODULE$.apply();
    }

    public Map<TaggedFeatureName, Tuple2<Dataset<Row>, Header>> prune(Map<String, Tuple2<FeatureDataFrame, Seq<String>>> featureData, Seq<String> requestedFeatures, MultiStageJoinPlan logicalPlan, FeatureGroups featureGroups) {
        Map featureNameToKeyTagMap = ((TraversableOnce)logicalPlan.allRequiredFeatures().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq;
            String featureName;
            block3: {
                ErasedEntityTaggedFeature erasedEntityTaggedFeature;
                block2: {
                    erasedEntityTaggedFeature = x0$1;
                    Option<Tuple2<Seq<Object>, String>> option = ErasedEntityTaggedFeature$.MODULE$.unapply(erasedEntityTaggedFeature);
                    if (option.isEmpty()) break block2;
                    Seq keyTags = (Seq)((Tuple2)option.get())._1();
                    featureName = (String)((Tuple2)option.get())._2();
                    if (keyTags == null) break block2;
                    seq = keyTags;
                    if (featureName != null) break block3;
                }
                throw new MatchError((Object)erasedEntityTaggedFeature);
            }
            String string = featureName;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)string), (Object)seq);
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map filteredFeatureData = (Map)featureData.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)requestedFeatures.contains(f._1())));
        return (Map)filteredFeatureData.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> (FeatureDataFrame)((Tuple2)x$1._2())._1()).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map featureDataOnDf = (Map)tuple2._2();
            FeatureDataFrame df = (FeatureDataFrame)((Tuple2)((Tuple2)featureDataOnDf.head())._2())._1();
            Seq joinKeys = (Seq)((Tuple2)((Tuple2)featureDataOnDf.head())._2())._2();
            Seq featuresToPrune = featureDataOnDf.keys().toSeq();
            Seq keyTags = (Seq)featureNameToKeyTagMap.apply(featuresToPrune.head());
            Map<String, Tuple2<Dataset<Row>, Header>> prunedFeatureData = this.pruneColumns(df, (Seq<String>)joinKeys, (List<String>)((TraversableOnce)keyTags.map(logicalPlan.keyTagIntsToStrings(), Seq$.MODULE$.canBuildFrom())).toList(), (Seq<String>)featuresToPrune, featureGroups);
            IndexedSeq<String> keyColumnNames = FeatureTransformation$.MODULE$.getStandardizedKeyNames(keyTags.size());
            Map map = (Map)prunedFeatureData.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String featureName = (String)tuple2._1();
                Tuple2 dfWithHeader = (Tuple2)tuple2._2();
                TaggedFeatureName taggedFeatureName = new TaggedFeatureName(package$.MODULE$.wrapAll().deprecated$u0020seqAsJavaList((Seq)keyColumnNames), featureName);
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)taggedFeatureName), (Object)dfWithHeader);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            return map;
        }, Map$.MODULE$.canBuildFrom());
    }

    private Map<String, Tuple2<Dataset<Row>, Header>> pruneColumns(FeatureDataFrame featureDataFrame, Seq<String> joinKeys, List<String> keyTagsInfo, Seq<String> featuresToKeep, FeatureGroups featureGroups) {
        Map<TaggedFeatureName, Tuple2<String, String>> taggedFeatureToColumnNameMap;
        Dataset<Row> df = featureDataFrame.df();
        Map<String, FeatureTypeConfig> featureTypeMap = featureDataFrame.inferredFeatureType();
        String[] columnsToProcess = df.columns();
        Dataset<Row> cleanedDF = FeatureTransformation$.MODULE$.pruneAndRenameColumnWithTags(df, joinKeys, featuresToKeep, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])columnsToProcess), keyTagsInfo);
        if (joinKeys.size() != keyTagsInfo.size()) {
            throw new FeathrException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(161).append("Number of transformer returned join key names of features ").append(featuresToKeep.mkString(",")).append(" ").append("does not match the number of key tags declared in the features, returned: ").append(joinKeys.mkString(",")).append(", size: ").append(joinKeys.size()).append(", ").append("expected: ").append(keyTagsInfo.mkString(",")).append(", size: ").append(keyTagsInfo.size()).toString());
        }
        IndexedSeq<String> keyColumnNames = FeatureTransformation$.MODULE$.getStandardizedKeyNames(keyTagsInfo.size());
        Dataset<Row> resultFDS = this.standardizeColumns(joinKeys, (Seq<String>)keyColumnNames, cleanedDF);
        Tuple2<Dataset<Row>, Header> tuple2 = DataFrameColName$.MODULE$.adjustFeatureColNamesAndGetHeader(resultFDS, taggedFeatureToColumnNameMap = DataFrameColName$.MODULE$.getTaggedFeatureToNewColumnName(resultFDS), featureGroups.allAnchoredFeatures(), featureGroups.allDerivedFeatures(), featureTypeMap);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Dataset dfWithoutFDSMetadata = (Dataset)tuple2._1();
        Header header = (Header)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)dfWithoutFDSMetadata, (Object)header);
        Tuple2 tuple23 = tuple22;
        Dataset dfWithoutFDSMetadata2 = (Dataset)tuple23._1();
        Header header2 = (Header)tuple23._2();
        Map headerInfo = (Map)header2.featureInfoMap().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TaggedFeatureName taggedFeatureName = (TaggedFeatureName)tuple2._1();
            FeatureInfo v = (FeatureInfo)tuple2._2();
            TaggedFeatureName newTaggedFeatureName = new TaggedFeatureName(package$.MODULE$.wrapAll().deprecated$u0020seqAsJavaList((Seq)keyColumnNames), taggedFeatureName.getFeatureName());
            Tuple2 tuple22 = new Tuple2((Object)newTaggedFeatureName, (Object)v);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        Header newHeader = new Header((Map<TaggedFeatureName, FeatureInfo>)headerInfo);
        return ((TraversableOnce)featuresToKeep.map((Function1 & Serializable & scala.Serializable)f -> new Tuple2(f, (Object)new Tuple2((Object)dfWithoutFDSMetadata2, (Object)newHeader)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Dataset<Row> standardizeColumns(Seq<String> joinKeys, Seq<String> keyColumnNames, Dataset<Row> cleanedDF) {
        Dataset keyColumnRenamedDF = (Dataset)((TraversableOnce)joinKeys.zip(keyColumnNames, Seq$.MODULE$.canBuildFrom())).foldLeft(cleanedDF, (Function2 & Serializable & scala.Serializable)(inputDF, renamePair) -> inputDF.withColumnRenamed((String)renamePair._1(), (String)renamePair._2()));
        StructType schemaWithNonNullKeys = StructType$.MODULE$.apply((Seq)keyColumnRenamedDF.schema().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField == null) {
                throw new MatchError((Object)structField);
            }
            String name = structField.name();
            DataType dataType = structField.dataType();
            Metadata metadata = structField.metadata();
            StructField structField2 = keyColumnNames.contains((Object)name) ? new StructField(name, dataType, false, metadata) : new StructField(name, dataType, true, metadata);
            return structField2;
        }, Seq$.MODULE$.canBuildFrom()));
        Dataset resultFDS = keyColumnRenamedDF.sqlContext().createDataFrame(keyColumnRenamedDF.rdd(), schemaWithNonNullKeys);
        return resultFDS;
    }
}

