/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.generation;

import com.linkedin.feathr.common.Header;
import com.linkedin.feathr.offline.config.location.DataLocation;
import com.linkedin.feathr.offline.config.location.SimplePath;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderHandler;
import com.linkedin.feathr.offline.source.dataloader.hdfs.FileFormat$;
import java.io.Serializable;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;

public final class SparkIOUtils$ {
    public static SparkIOUtils$ MODULE$;
    private final String OUTPUT_SCHEMA;
    private final String DATA_FORMAT;
    private final String OUTPUT_PARALLELISM;
    private final String SPLIT_SIZE;
    private final String OVERWRITE_MODE;
    private final String FILTER_EXP;

    static {
        new SparkIOUtils$();
    }

    public Dataset<Row> createUnionDataFrame(Seq<String> existingHdfsPaths, Map<String, String> dataIOParameters, JobConf jobConf, List<DataLoaderHandler> dataLoaderHandlers) {
        Dataset<Row> dataset;
        ObjectRef dfOpt = ObjectRef.create((Object)None$.MODULE$);
        String firstPath = (String)existingHdfsPaths.head();
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> dataLoaderHandlers.foreach((Function1 & Serializable & scala.Serializable)dataLoaderHandler -> {
            SparkIOUtils$.$anonfun$createUnionDataFrame$2(firstPath, dfOpt, existingHdfsPaths, dataIOParameters, jobConf, dataLoaderHandler);
            return BoxedUnit.UNIT;
        }));
        Option option = (Option)dfOpt.elem;
        if (option instanceof Some) {
            dataset = (Dataset<Row>)((Option)dfOpt.elem).get();
        } else {
            String format = FileFormat$.MODULE$.getTypeForUnionDF(existingHdfsPaths, dataIOParameters);
            dataset = FileFormat$.MODULE$.loadHdfsDataFrame(format, existingHdfsPaths);
        }
        Dataset<Row> df = dataset;
        return df;
    }

    public Map<String, String> createUnionDataFrame$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Dataset<Row> createDataFrame(DataLocation location, Map<String, String> dataIOParams, JobConf jobConf, List<DataLoaderHandler> dataLoaderHandlers) {
        ObjectRef dfOpt = ObjectRef.create((Object)None$.MODULE$);
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> dataLoaderHandlers.foreach((Function1 & Serializable & scala.Serializable)dataLoaderHandler -> {
            SparkIOUtils$.$anonfun$createDataFrame$2(location, dfOpt, dataIOParams, jobConf, dataLoaderHandler);
            return BoxedUnit.UNIT;
        }));
        Option option = (Option)dfOpt.elem;
        Dataset<Row> dataset = option instanceof Some ? (Dataset<Row>)((Option)dfOpt.elem).get() : location.loadDf(SparkSession$.MODULE$.builder().getOrCreate(), dataIOParams);
        Dataset<Row> df = dataset;
        return df;
    }

    public Map<String, String> createDataFrame$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Dataset<Row> writeDataFrame(Dataset<Row> outputDF, DataLocation outputLocation, Map<String, String> parameters, List<DataLoaderHandler> dataLoaderHandlers) {
        BoxedUnit boxedUnit;
        BooleanRef dfWritten = BooleanRef.create((boolean)false);
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> dataLoaderHandlers.foreach((Function1 & Serializable & scala.Serializable)dataLoaderHandler -> {
            SparkIOUtils$.$anonfun$writeDataFrame$2(outputLocation, outputDF, parameters, dfWritten, dataLoaderHandler);
            return BoxedUnit.UNIT;
        }));
        if (!dfWritten.elem) {
            Dataset<Row> dataset;
            DataLocation dataLocation = outputLocation;
            if (dataLocation instanceof SimplePath) {
                SimplePath simplePath = (SimplePath)dataLocation;
                String path = simplePath.path();
                String output_format = outputDF.sqlContext().getConf("spark.feathr.outputFormat", "avro");
                outputDF.write().mode(SaveMode.Overwrite).format(output_format).save(path);
                dataset = outputDF;
            } else {
                outputLocation.writeDf(SparkSession$.MODULE$.builder().getOrCreate(), outputDF, (Option<Header>)None$.MODULE$);
                dataset = BoxedUnit.UNIT;
            }
            boxedUnit = dataset;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return outputDF;
    }

    public Map<String, String> writeDataFrame$default$3() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public RDD<GenericRecord> createGenericRDD(String inputPath, Map<String, String> dataIOParameters, JobConf jobConf) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public String OUTPUT_SCHEMA() {
        return this.OUTPUT_SCHEMA;
    }

    public String DATA_FORMAT() {
        return this.DATA_FORMAT;
    }

    public String OUTPUT_PARALLELISM() {
        return this.OUTPUT_PARALLELISM;
    }

    public String SPLIT_SIZE() {
        return this.SPLIT_SIZE;
    }

    public String OVERWRITE_MODE() {
        return this.OVERWRITE_MODE;
    }

    public String FILTER_EXP() {
        return this.FILTER_EXP;
    }

    public static final /* synthetic */ void $anonfun$createUnionDataFrame$2(String firstPath$1, ObjectRef dfOpt$1, Seq existingHdfsPaths$1, Map dataIOParameters$1, JobConf jobConf$1, DataLoaderHandler dataLoaderHandler) {
        if (BoxesRunTime.unboxToBoolean((Object)dataLoaderHandler.validatePath().apply((Object)firstPath$1))) {
            dfOpt$1.elem = new Some(dataLoaderHandler.createUnionDataFrame().apply((Object)existingHdfsPaths$1, (Object)dataIOParameters$1, (Object)jobConf$1));
            throw Breaks$.MODULE$.break();
        }
    }

    public static final /* synthetic */ void $anonfun$createDataFrame$2(DataLocation location$1, ObjectRef dfOpt$2, Map dataIOParams$1, JobConf jobConf$2, DataLoaderHandler dataLoaderHandler) {
        if (BoxesRunTime.unboxToBoolean((Object)dataLoaderHandler.validatePath().apply((Object)location$1.getPath()))) {
            dfOpt$2.elem = new Some(dataLoaderHandler.createDataFrame().apply((Object)location$1.getPath(), (Object)dataIOParams$1, (Object)jobConf$2));
            throw Breaks$.MODULE$.break();
        }
    }

    public static final /* synthetic */ void $anonfun$writeDataFrame$2(DataLocation outputLocation$1, Dataset outputDF$1, Map parameters$1, BooleanRef dfWritten$1, DataLoaderHandler dataLoaderHandler) {
        DataLocation dataLocation = outputLocation$1;
        if (dataLocation instanceof SimplePath) {
            SimplePath simplePath = (SimplePath)dataLocation;
            String path = simplePath.path();
            if (BoxesRunTime.unboxToBoolean((Object)dataLoaderHandler.validatePath().apply((Object)path))) {
                dataLoaderHandler.writeDataFrame().apply((Object)outputDF$1, (Object)path, (Object)parameters$1);
                dfWritten$1.elem = true;
                throw Breaks$.MODULE$.break();
            }
        } else {
            throw new MatchError((Object)dataLocation);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SparkIOUtils$() {
        MODULE$ = this;
        this.OUTPUT_SCHEMA = "output.schema";
        this.DATA_FORMAT = "data.format";
        this.OUTPUT_PARALLELISM = "output.parallelism";
        this.SPLIT_SIZE = "split.size";
        this.OVERWRITE_MODE = "override.mode";
        this.FILTER_EXP = "filter.exp";
    }
}

