/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.job;

import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrInputDataException;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class DataSourceUtils$ {
    public static DataSourceUtils$ MODULE$;
    private final Logger log;
    private final String AVRO_EXTENSION;

    static {
        new DataSourceUtils$();
    }

    public Logger log() {
        return this.log;
    }

    private String AVRO_EXTENSION() {
        return this.AVRO_EXTENSION;
    }

    public Schema getSchemaForAvroData(Configuration conf, String inputDir) {
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] status = fs.listStatus(new Path(inputDir));
        FileStatus[] avroFiles = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])status)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataSourceUtils$.$anonfun$getSchemaForAvroData$1(x$1)));
        if (avroFiles.length == 0) {
            throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(75).append("Load the Avro schema for Avro data set in HDFS but no avro files found in ").append(inputDir).append(".").toString());
        }
        String dataFileName = avroFiles[0].getPath().getName();
        String dataFilePath = new Path(inputDir, dataFileName).toString();
        return this.getSchemaFromAvroDataFile(dataFilePath, new JobConf(conf));
    }

    public Schema getSchemaFromAvroDataFile(String avroPath, JobConf jobConf) {
        FileSystem fs = FileSystem.get((Configuration)jobConf);
        FileStatus[] avroFilePath = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(avroPath)))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataSourceUtils$.$anonfun$getSchemaFromAvroDataFile$1(x$2)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])avroFilePath)).isEmpty()) {
            throw new RuntimeException(new StringBuilder(37).append("Input path does not have avro files: ").append(avroPath).toString());
        }
        FsInput fsInput = new FsInput(avroFilePath[0].getPath(), new Configuration());
        GenericDatumReader reader = new GenericDatumReader();
        FileReader dataFileReader = DataFileReader.openReader((SeekableInput)fsInput, (DatumReader)reader);
        Schema schema = dataFileReader.getSchema();
        try {
            dataFileReader.close();
        }
        catch (Exception e) {}
        return schema;
    }

    public JobConf getSchemaFromAvroDataFile$default$2() {
        return new JobConf();
    }

    public static final /* synthetic */ boolean $anonfun$getSchemaForAvroData$1(FileStatus x$1) {
        return x$1.getPath().getName().endsWith(".avro");
    }

    public static final /* synthetic */ boolean $anonfun$getSchemaFromAvroDataFile$1(FileStatus x$2) {
        return x$2.getPath().getName().endsWith(MODULE$.AVRO_EXTENSION());
    }

    private DataSourceUtils$() {
        MODULE$ = this;
        this.log = LogManager.getLogger(this.getClass());
        this.AVRO_EXTENSION = "avro";
    }
}

