/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.job;

import com.linkedin.feathr.common.DateParam;
import com.linkedin.feathr.common.DateTimeParam;
import com.linkedin.feathr.common.DateTimeParam$;
import com.linkedin.feathr.common.DateTimeUtils$;
import com.linkedin.feathr.common.configObj.configbuilder.OutputProcessorBuilder;
import com.linkedin.feathr.common.configObj.generation.FeatureGenConfig;
import com.linkedin.feathr.common.configObj.generation.OfflineOperationalConfig;
import com.linkedin.feathr.common.configObj.generation.OutputProcessorConfig;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrDataOutputException;
import com.linkedin.feathr.common.package$;
import com.linkedin.feathr.offline.generation.outputProcessor.FeatureMonitoringProcessor;
import com.linkedin.feathr.offline.generation.outputProcessor.PushToRedisOutputProcessor;
import com.linkedin.feathr.offline.generation.outputProcessor.WriteToHDFSOutputProcessor;
import com.linkedin.feathr.offline.job.FeatureGenJobContext;
import com.linkedin.feathr.offline.job.FeatureGenSpec$;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderHandler;
import com.linkedin.feathr.offline.util.FeatureGenConstants$;
import com.linkedin.feathr.offline.util.IncrementalAggUtils$;
import com.linkedin.feathr.sparkcommon.OutputProcessor;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.temporal.ChronoUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001\u0002\u000f\u001e\u0001!B\u0001b\f\u0001\u0003\u0006\u0004%I\u0001\r\u0005\tw\u0001\u0011\t\u0011)A\u0005c!AA\b\u0001B\u0001B\u0003%Q\bC\u0003R\u0001\u0011\u0005!\u000bC\u0004X\u0001\t\u0007I\u0011\u0001-\t\rq\u0003\u0001\u0015!\u0003Z\u0011\u001di\u0006A1A\u0005\u0002yCa!\u001b\u0001!\u0002\u0013y\u0006\u0002\u00036\u0001\u0011\u000b\u0007I\u0011A6\t\u000fA\u0004!\u0019!C\u0001c\"1Q\u000f\u0001Q\u0001\nIDqA\u001e\u0001C\u0002\u0013\u0005q\u000f\u0003\u0004\u007f\u0001\u0001\u0006I\u0001\u001f\u0005\b\u007f\u0002\u0011\r\u0011\"\u0001x\u0011\u001d\t\t\u0001\u0001Q\u0001\naD\u0011\"a\u0001\u0001\u0005\u0004%\t!!\u0002\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u000fA\u0011\"a\u0006\u0001\u0005\u0004%\t!!\u0007\t\u0011\u0005e\u0002\u0001)A\u0005\u00037Aq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002F\u0001!\t!a\u0012\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u0011\u0011\r\u0001\u0005\u0002\u0005\rtaBA4;!\u0005\u0011\u0011\u000e\u0004\u00079uA\t!a\u001b\t\rEKB\u0011AA7\u0011\u001d\ty'\u0007C\u0001\u0003c\u0012aBR3biV\u0014XmR3o'B,7M\u0003\u0002\u001f?\u0005\u0019!n\u001c2\u000b\u0005\u0001\n\u0013aB8gM2Lg.\u001a\u0006\u0003E\r\naAZ3bi\"\u0014(B\u0001\u0013&\u0003!a\u0017N\\6fI&t'\"\u0001\u0014\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001I\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g-\u0001\tgK\u0006$XO]3HK:\u001cuN\u001c4jOV\t\u0011\u0007\u0005\u00023s5\t1G\u0003\u00025k\u0005Qq-\u001a8fe\u0006$\u0018n\u001c8\u000b\u0005Y:\u0014!C2p]\u001aLwm\u00142k\u0015\tA\u0014%\u0001\u0004d_6lwN\\\u0005\u0003uM\u0012\u0001CR3biV\u0014XmR3o\u0007>tg-[4\u0002#\u0019,\u0017\r^;sK\u001e+gnQ8oM&<\u0007%\u0001\neCR\fGj\\1eKJD\u0015M\u001c3mKJ\u001c\bc\u0001 G\u0013:\u0011q\b\u0012\b\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u001e\na\u0001\u0010:p_Rt\u0014\"\u0001\u0017\n\u0005\u0015[\u0013a\u00029bG.\fw-Z\u0005\u0003\u000f\"\u0013A\u0001T5ti*\u0011Qi\u000b\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000b!\u0002Z1uC2|\u0017\rZ3s\u0015\tqu$\u0001\u0004t_V\u00148-Z\u0005\u0003!.\u0013\u0011\u0003R1uC2{\u0017\rZ3s\u0011\u0006tG\r\\3s\u0003\u0019a\u0014N\\5u}Q\u00191+\u0016,\u0011\u0005Q\u0003Q\"A\u000f\t\u000b=\"\u0001\u0019A\u0019\t\u000bq\"\u0001\u0019A\u001f\u00021=4g\r\\5oK>\u0003XM]1uS>t\u0017\r\\\"p]\u001aLw-F\u0001Z!\t\u0011$,\u0003\u0002\\g\tArJ\u001a4mS:,w\n]3sCRLwN\\1m\u0007>tg-[4\u00023=4g\r\\5oK>\u0003XM]1uS>t\u0017\r\\\"p]\u001aLw\rI\u0001\u0017_V$\b/\u001e;Qe>\u001cWm]:pe\u000e{gNZ5hgV\tq\fE\u0002aK\u001al\u0011!\u0019\u0006\u0003E\u000e\fA!\u001e;jY*\tA-\u0001\u0003kCZ\f\u0017BA$b!\t\u0011t-\u0003\u0002ig\t)r*\u001e;qkR\u0004&o\\2fgN|'oQ8oM&<\u0017aF8viB,H\u000f\u0015:pG\u0016\u001c8o\u001c:D_:4\u0017nZ:!\u00035!\u0017\r^3US6,\u0007+\u0019:b[V\tA\u000e\u0005\u0002n]6\tq'\u0003\u0002po\tiA)\u0019;f)&lW\rU1sC6\f\u0011\u0002Z1uKB\u000b'/Y7\u0016\u0003I\u0004\"!\\:\n\u0005Q<$!\u0003#bi\u0016\u0004\u0016M]1n\u0003)!\u0017\r^3QCJ\fW\u000eI\u0001\u000eK:$G+[7f\r>\u0014X.\u0019;\u0016\u0003a\u0004\"!\u001f?\u000e\u0003iT!a_2\u0002\t1\fgnZ\u0005\u0003{j\u0014aa\u0015;sS:<\u0017AD3oIRKW.\u001a$pe6\fG\u000fI\u0001\u0010S:\u0004X\u000f\u001e+j[\u00164uN]7bi\u0006\u0001\u0012N\u001c9viRKW.\u001a$pe6\fG\u000fI\u0001\u000bK:$G+[7f'R\u0014XCAA\u0004!\u0011\tI!!\u0005\u000f\t\u0005-\u0011Q\u0002\t\u0003\u0001.J1!a\u0004,\u0003\u0019\u0001&/\u001a3fM&\u0019Q0a\u0005\u000b\u0007\u0005=1&A\u0006f]\u0012$\u0016.\\3TiJ\u0004\u0013\u0001E8viB,H\u000f\u0015:pG\u0016\u001c8o\u001c:t+\t\tY\u0002\u0005\u0004\u0002\u001e\u0005\u001d\u00121F\u0007\u0003\u0003?QA!!\t\u0002$\u00059Q.\u001e;bE2,'bAA\u0013W\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u0012q\u0004\u0002\u0007\u0005V4g-\u001a:\u0011\t\u00055\u0012QG\u0007\u0003\u0003_QA!!\r\u00024\u0005yq.\u001e;qkR\u0004&o\\2fgN|'O\u0003\u00025?%!\u0011qGA\u0018\u0005i9&/\u001b;f)>DEIR*PkR\u0004X\u000f\u001e)s_\u000e,7o]8s\u0003EyW\u000f\u001e9viB\u0013xnY3tg>\u00148\u000fI\u0001\u0017SN,e.\u00192mK&s7M]3nK:$\u0018\r\\!hOR\u0011\u0011q\b\t\u0004U\u0005\u0005\u0013bAA\"W\t9!i\\8mK\u0006t\u0017!G4fi>+H\u000f];u!J|7-Z:t_J\u001cuN\u001c4jON,\"!!\u0013\u0011\ty\nYEZ\u0005\u0004\u0003\u001bB%aA*fc\u0006\u0001r-\u001a;Qe>\u001cWm]:pe2K7\u000f\u001e\u000b\u0003\u0003'\u0002RAPA&\u0003+\u0002B!a\u0016\u0002^5\u0011\u0011\u0011\f\u0006\u0004\u00037\n\u0013aC:qCJ\\7m\\7n_:LA!a\u0018\u0002Z\tyq*\u001e;qkR\u0004&o\\2fgN|'/A\u0006hKR4U-\u0019;ve\u0016\u001cHCAA3!\u0015q\u00141JA\u0004\u000391U-\u0019;ve\u0016<UM\\*qK\u000e\u0004\"\u0001V\r\u0014\u0005eICCAA5\u0003\u0015\u0001\u0018M]:f)\u001d\u0019\u00161OA<\u0003\u0003Cq!!\u001e\u001c\u0001\u0004\t9!A\ngK\u0006$XO]3HK:\u001cuN\u001c4jON#(\u000fC\u0004\u0002zm\u0001\r!a\u001f\u0002)\u0019,\u0017\r^;sK\u001e+gNS8c\u0007>tG/\u001a=u!\r!\u0016QP\u0005\u0004\u0003\u007fj\"\u0001\u0006$fCR,(/Z$f]*{'mQ8oi\u0016DH\u000fC\u0003=7\u0001\u0007Q\b")
public class FeatureGenSpec {
    private DateTimeParam dateTimeParam;
    private final FeatureGenConfig featureGenConfig;
    private final List<DataLoaderHandler> dataLoaderHandlers;
    private final OfflineOperationalConfig offlineOperationalConfig;
    private final java.util.List<OutputProcessorConfig> outputProcessorConfigs;
    private final DateParam dateParam;
    private final String endTimeFormat;
    private final String inputTimeFormat;
    private final String endTimeStr;
    private final Buffer<WriteToHDFSOutputProcessor> outputProcessors;
    private volatile boolean bitmap$0;

    public static FeatureGenSpec parse(String string, FeatureGenJobContext featureGenJobContext, List<DataLoaderHandler> list) {
        return FeatureGenSpec$.MODULE$.parse(string, featureGenJobContext, list);
    }

    private FeatureGenConfig featureGenConfig() {
        return this.featureGenConfig;
    }

    public OfflineOperationalConfig offlineOperationalConfig() {
        return this.offlineOperationalConfig;
    }

    public java.util.List<OutputProcessorConfig> outputProcessorConfigs() {
        return this.outputProcessorConfigs;
    }

    private DateTimeParam dateTimeParam$lzycompute() {
        FeatureGenSpec featureGenSpec = this;
        synchronized (featureGenSpec) {
            if (!this.bitmap$0) {
                DateTimeParam timeConfig = DateTimeParam$.MODULE$.apply(this.offlineOperationalConfig().getTimeSetting());
                this.dateTimeParam = DateTimeParam$.MODULE$.shiftEndTime(timeConfig, this.offlineOperationalConfig().getSimulateTimeDelay());
                this.bitmap$0 = true;
            }
        }
        return this.dateTimeParam;
    }

    public DateTimeParam dateTimeParam() {
        return !this.bitmap$0 ? this.dateTimeParam$lzycompute() : this.dateTimeParam;
    }

    public DateParam dateParam() {
        return this.dateParam;
    }

    public String endTimeFormat() {
        return this.endTimeFormat;
    }

    public String inputTimeFormat() {
        return this.inputTimeFormat;
    }

    public String endTimeStr() {
        return this.endTimeStr;
    }

    public Buffer<WriteToHDFSOutputProcessor> outputProcessors() {
        return this.outputProcessors;
    }

    public boolean isEnableIncrementalAgg() {
        return Predef$.MODULE$.Boolean2boolean(this.offlineOperationalConfig().getEnableIncremental());
    }

    public Seq<OutputProcessorConfig> getOutputProcessorConfigs() {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.offlineOperationalConfig().getOutputProcessorsListConfig()).asScala();
    }

    public Seq<OutputProcessor> getProcessorList() {
        return this.outputProcessors();
    }

    public Seq<String> getFeatures() {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.featureGenConfig().getFeatures()).asScala();
    }

    public FeatureGenSpec(FeatureGenConfig featureGenConfig, List<DataLoaderHandler> dataLoaderHandlers) {
        String string;
        String string2;
        this.featureGenConfig = featureGenConfig;
        this.dataLoaderHandlers = dataLoaderHandlers;
        Predef$.MODULE$.require(featureGenConfig.getOperationalConfig() instanceof OfflineOperationalConfig, (Function0 & Serializable & scala.Serializable)() -> "The operational config should be of type OfflineOperationalConfig.");
        this.offlineOperationalConfig = (OfflineOperationalConfig)featureGenConfig.getOperationalConfig();
        this.outputProcessorConfigs = this.offlineOperationalConfig().getOutputProcessorsListConfig();
        this.dateParam = DateTimeUtils$.MODULE$.toDateParam(this.dateTimeParam());
        ChronoUnit chronoUnit = this.dateTimeParam().resolution();
        if (ChronoUnit.DAYS.equals(chronoUnit)) {
            string2 = "yyyy/MM/dd";
        } else if (ChronoUnit.HOURS.equals(chronoUnit)) {
            string2 = "yyyy/MM/dd/HH";
        } else {
            throw new MatchError((Object)chronoUnit);
        }
        this.endTimeFormat = string2;
        ChronoUnit chronoUnit2 = this.dateTimeParam().resolution();
        if (ChronoUnit.DAYS.equals(chronoUnit2)) {
            string = "yyyyMMdd";
        } else if (ChronoUnit.HOURS.equals(chronoUnit2)) {
            string = "yyyyMMddHH";
        } else {
            throw new MatchError((Object)chronoUnit2);
        }
        this.inputTimeFormat = string;
        this.endTimeStr = IncrementalAggUtils$.MODULE$.transformDateString((String)this.dateParam().endDate().get(), this.inputTimeFormat(), this.endTimeFormat());
        this.outputProcessors = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.outputProcessorConfigs()).asScala()).map((Function1 & Serializable & scala.Serializable)config -> {
            WriteToHDFSOutputProcessor writeToHDFSOutputProcessor;
            String string = config.getName();
            String string2 = FeatureGenConstants$.MODULE$.HDFS_OUTPUT_PROCESSOR_NAME();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                boolean useOutputTimePath = package$.MODULE$.RichConfig(config.getParams()).getBooleanWithDefault(FeatureGenConstants$.MODULE$.OUTPUT_TIME_PATH(), true);
                None$ endTimeOpt = useOutputTimePath ? new Some((Object)this.endTimeStr()) : None$.MODULE$;
                writeToHDFSOutputProcessor = new WriteToHDFSOutputProcessor((OutputProcessorConfig)config, (Option<String>)endTimeOpt, $this.dataLoaderHandlers);
            } else {
                String string4 = FeatureGenConstants$.MODULE$.REDIS_OUTPUT_PROCESSOR_NAME();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    Config params = config.getParams();
                    OutputProcessorConfig decoratedConfig = OutputProcessorBuilder.build(config.getName(), params);
                    writeToHDFSOutputProcessor = new PushToRedisOutputProcessor(decoratedConfig, (Option<String>)None$.MODULE$);
                } else {
                    String string6 = FeatureGenConstants$.MODULE$.MONITORING_OUTPUT_PROCESSOR_NAME();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        Config params = config.getParams();
                        OutputProcessorConfig decoratedConfig = OutputProcessorBuilder.build(config.getName(), params);
                        writeToHDFSOutputProcessor = new FeatureMonitoringProcessor(decoratedConfig, (Option<String>)None$.MODULE$);
                    } else {
                        throw new FeathrDataOutputException(ErrorLabel.FEATHR_USER_ERROR, "Custom output processor is not yet supported.");
                    }
                }
            }
            return writeToHDFSOutputProcessor;
        }, Buffer$.MODULE$.canBuildFrom());
    }
}

