/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.job;

import com.linkedin.feathr.common.TaggedFeatureName;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrException;
import com.linkedin.feathr.offline.client.FeathrClient;
import com.linkedin.feathr.offline.client.FeathrClient$;
import com.linkedin.feathr.offline.config.FeathrConfig;
import com.linkedin.feathr.offline.config.FeathrConfigLoader$;
import com.linkedin.feathr.offline.generation.outputProcessor.WriteToHDFSOutputProcessor;
import com.linkedin.feathr.offline.job.FeatureGenConfigOverrider$;
import com.linkedin.feathr.offline.job.FeatureGenJobContext;
import com.linkedin.feathr.offline.job.FeatureGenJobContext$;
import com.linkedin.feathr.offline.job.FeatureGenSpec;
import com.linkedin.feathr.offline.job.FeatureGenSpec$;
import com.linkedin.feathr.offline.source.accessor.DataPathHandler;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderHandler;
import com.linkedin.feathr.offline.util.FeathrTestUtils$;
import com.linkedin.feathr.offline.util.SparkFeaturizedDataset;
import com.linkedin.feathr.sparkcommon.OutputProcessor;
import java.io.Serializable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class LocalFeatureGenJob$ {
    public static LocalFeatureGenJob$ MODULE$;
    private final FeathrConfig feathrConfigLoader;
    private final SparkSession ss;

    static {
        new LocalFeatureGenJob$();
    }

    private FeathrConfig feathrConfigLoader() {
        return this.feathrConfigLoader;
    }

    public SparkSession ss() {
        return this.ss;
    }

    public Map<TaggedFeatureName, SparkFeaturizedDataset> localFeatureGenerate(String featureGenConfigStr, String featureDefAsString, List<DataPathHandler> dataPathHandlers) {
        String workDir = "featureGen/localFeatureGenerate/";
        FeatureGenJobContext jobContext = new FeatureGenJobContext(workDir, FeatureGenJobContext$.MODULE$.$lessinit$greater$default$2(), FeatureGenJobContext$.MODULE$.$lessinit$greater$default$3());
        return this.localFeatureGenerate(featureGenConfigStr, featureDefAsString, jobContext, dataPathHandlers);
    }

    public Map<TaggedFeatureName, SparkFeaturizedDataset> localFeatureGenerate(Seq<String> features, String featureDefAsString, List<DataPathHandler> dataPathHandlers) {
        Seq configs = (Seq)new .colon.colon((Object)this.feathrConfigLoader().load(featureDefAsString), (List)Nil$.MODULE$);
        String outputDir = "featureGen/generateWithDefaultParams/";
        FeatureGenJobContext jobContext = new FeatureGenJobContext(outputDir, FeatureGenJobContext$.MODULE$.$lessinit$greater$default$2(), FeatureGenJobContext$.MODULE$.$lessinit$greater$default$3());
        String featureGenConfigStr = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(235).append("\n         |operational: {\n         |  name: generateWithDefaultParams\n         |  endTime: 2022-12-10\n         |  endTimeFormat: \"yyyy-MM-dd\"\n         |  resolution: DAILY\n         |  output:[]\n         |}\n         |features: [").append(features.mkString(",")).append("]\n      ").toString())).stripMargin();
        return this.generateFeatures(featureGenConfigStr, (Seq<FeathrConfig>)configs, jobContext, dataPathHandlers);
    }

    public Map<TaggedFeatureName, SparkFeaturizedDataset> localFeatureGenerate(String featureGenConfigStr, String featureDefAsString, String[] extraParams, List<DataPathHandler> dataPathHandlers) {
        String[] defaultParams = (String[])((Object[])new String[]{"--work-dir", "featureGen/localFeatureGenerate/"});
        FeatureGenJobContext jobContext = FeatureGenJobContext$.MODULE$.parse((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])defaultParams)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])extraParams)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        return this.localFeatureGenerate(featureGenConfigStr, featureDefAsString, jobContext, dataPathHandlers);
    }

    public Map<TaggedFeatureName, SparkFeaturizedDataset> localFeatureGenerate(String featureGenConfigStr, String featureDefAsString, FeatureGenJobContext jobContext, List<DataPathHandler> dataPathHandlers) {
        Option overriddenFeatureDef;
        Logger.getRootLogger().setLevel(Level.ERROR);
        Tuple2<Option<String>, Option<String>> tuple2 = FeatureGenConfigOverrider$.MODULE$.overrideFeatureDefs((Option<String>)new Some((Object)featureDefAsString), (Option<String>)None$.MODULE$, jobContext);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option option = overriddenFeatureDef = (Option)tuple2._1();
        Option overriddenFeatureDef2 = option;
        Seq configs = (Seq)new .colon.colon((Object)this.feathrConfigLoader().load((String)overriddenFeatureDef2.get()), (List)Nil$.MODULE$);
        return this.generateFeatures(featureGenConfigStr, (Seq<FeathrConfig>)configs, jobContext, dataPathHandlers);
    }

    private Map<TaggedFeatureName, SparkFeaturizedDataset> generateFeatures(String featureGenConfig, Seq<FeathrConfig> feathrConfigs, FeatureGenJobContext jobContext, List<DataPathHandler> dataPathHandlers) {
        FeathrClient feathrClient = FeathrClient$.MODULE$.builder(this.ss()).addFeatureDefConfs((Option<List<FeathrConfig>>)new Some((Object)feathrConfigs.toList())).addDataPathHandlers(dataPathHandlers).build();
        List dataLoaderHandlers = (List)dataPathHandlers.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataLoaderHandler(), List$.MODULE$.canBuildFrom());
        FeatureGenSpec featureGenSpec = FeatureGenSpec$.MODULE$.parse(featureGenConfig, jobContext, (List<DataLoaderHandler>)dataLoaderHandlers);
        Seq fdsOutputProcessors = (Seq)featureGenSpec.getProcessorList().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends OutputProcessor, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof WriteToHDFSOutputProcessor) {
                    WriteToHDFSOutputProcessor writeToHDFSOutputProcessor = (WriteToHDFSOutputProcessor)A1;
                    object = writeToHDFSOutputProcessor;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(OutputProcessor x1) {
                OutputProcessor outputProcessor = x1;
                boolean bl = outputProcessor instanceof WriteToHDFSOutputProcessor;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (fdsOutputProcessors.nonEmpty() && fdsOutputProcessors.size() != featureGenSpec.getProcessorList().size()) {
            throw new FeathrException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(103).append("Either none or all of the output processors in the generation config ").append("should have output format of FDS. ").toString());
        }
        return feathrClient.generateFeatures(featureGenSpec);
    }

    private LocalFeatureGenJob$() {
        MODULE$ = this;
        this.feathrConfigLoader = FeathrConfigLoader$.MODULE$.apply();
        this.ss = FeathrTestUtils$.MODULE$.createSparkSession(true, FeathrTestUtils$.MODULE$.createSparkSession$default$2(), FeathrTestUtils$.MODULE$.createSparkSession$default$3(), FeathrTestUtils$.MODULE$.createSparkSession$default$4());
    }
}

