/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.job;

import com.linkedin.feathr.offline.client.FeathrClient;
import com.linkedin.feathr.offline.client.FeathrClient$;
import com.linkedin.feathr.offline.config.FeatureJoinConfig;
import com.linkedin.feathr.offline.config.FeatureJoinConfig$;
import com.linkedin.feathr.offline.job.FeatureJoinJob$;
import com.linkedin.feathr.offline.job.JoinJobContext;
import com.linkedin.feathr.offline.mvel.plugins.FeathrExpressionExecutionContext;
import com.linkedin.feathr.offline.source.DataSource;
import com.linkedin.feathr.offline.source.DataSource$;
import com.linkedin.feathr.offline.source.SourceFormatType$;
import com.linkedin.feathr.offline.source.accessor.DataPathHandler;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderFactory;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderFactory$;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderHandler;
import com.linkedin.feathr.offline.util.FeathrTestUtils$;
import com.linkedin.feathr.offline.util.FeaturizedDatasetMetadata;
import com.linkedin.feathr.offline.util.FeaturizedDatasetMetadata$;
import com.linkedin.feathr.offline.util.SparkFeaturizedDataset;
import java.io.Serializable;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class LocalFeatureJoinJob$ {
    public static LocalFeatureJoinJob$ MODULE$;
    private final SparkSession ss;
    private final ConfigEntry<Object> SKIP_MISSING_FEATURE;
    private final ConfigEntry<Object> MAX_DATA_LOAD_RETRY;

    static {
        new LocalFeatureJoinJob$();
    }

    public SparkSession ss() {
        return this.ss;
    }

    public ConfigEntry<Object> SKIP_MISSING_FEATURE() {
        return this.SKIP_MISSING_FEATURE;
    }

    public ConfigEntry<Object> MAX_DATA_LOAD_RETRY() {
        return this.MAX_DATA_LOAD_RETRY;
    }

    public SparkFeaturizedDataset joinWithObsDFAndHoconJoinConfig(String joinConfigAsHoconString, String featureDefAsString, SparkFeaturizedDataset observationData, String[] extraParams, SparkSession ss, List<DataPathHandler> dataPathHandlers, Option<FeathrExpressionExecutionContext> mvelContext) {
        FeatureJoinConfig joinConfig = FeatureJoinConfig$.MODULE$.parseJoinConfig(joinConfigAsHoconString);
        FeathrClient feathrClient = FeathrClient$.MODULE$.builder(ss).addFeatureDef(featureDefAsString).addDataPathHandlers(dataPathHandlers).addFeathrExpressionContext(mvelContext).build();
        String outputPath = FeatureJoinJob$.MODULE$.SKIP_OUTPUT();
        String[] defaultParams = (String[])((Object[])new String[]{"--local-mode", "--feathr-config", "", "--output", outputPath});
        JoinJobContext jobContext = FeatureJoinJob$.MODULE$.parseInputArgument((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])defaultParams)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])extraParams)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).jobJoinContext();
        return new SparkFeaturizedDataset(feathrClient.joinFeatures(joinConfig, observationData, jobContext).data(), new FeaturizedDatasetMetadata(FeaturizedDatasetMetadata$.MODULE$.apply$default$1(), FeaturizedDatasetMetadata$.MODULE$.apply$default$2()));
    }

    public String[] joinWithObsDFAndHoconJoinConfig$default$4() {
        return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    }

    public SparkSession joinWithObsDFAndHoconJoinConfig$default$5() {
        return this.ss();
    }

    public SparkFeaturizedDataset joinWithHoconJoinConfig(String joinConfigAsHoconString, String featureDefAsString, String observationDataPath, String[] extraParams, SparkSession ss, List<DataPathHandler> dataPathHandlers, Option<FeathrExpressionExecutionContext> mvelContext) {
        List dataLoaderHandlers = (List)dataPathHandlers.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataLoaderHandler(), List$.MODULE$.canBuildFrom());
        SparkFeaturizedDataset obsDf = this.loadObservationAsFDS(ss, observationDataPath, (List<DataLoaderHandler>)dataLoaderHandlers);
        return this.joinWithObsDFAndHoconJoinConfig(joinConfigAsHoconString, featureDefAsString, obsDf, extraParams, ss, dataPathHandlers, mvelContext);
    }

    public String[] joinWithHoconJoinConfig$default$4() {
        return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    }

    public SparkSession joinWithHoconJoinConfig$default$5() {
        return this.ss();
    }

    public Option<FeathrExpressionExecutionContext> joinWithHoconJoinConfig$default$7() {
        return None$.MODULE$;
    }

    public SparkFeaturizedDataset loadObservationAsFDS(SparkSession ss, String obsDataPath, List<DataLoaderHandler> dataLoaderHandlers) {
        DataSource source = DataSource$.MODULE$.apply(obsDataPath, SourceFormatType$.MODULE$.FIXED_PATH(), DataSource$.MODULE$.apply$default$3(), DataSource$.MODULE$.apply$default$4(), DataSource$.MODULE$.apply$default$5());
        SparkSession x$1 = ss;
        List<DataLoaderHandler> x$22 = dataLoaderHandlers;
        boolean x$32 = DataLoaderFactory$.MODULE$.apply$default$2();
        DataLoaderFactory dataLoaderFactory = DataLoaderFactory$.MODULE$.apply(x$1, x$32, x$22);
        Dataset data = (Dataset)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])source.pathList())).map((Function1 & Serializable & scala.Serializable)x$2 -> dataLoaderFactory.create((String)x$2).loadDataFrame(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Dataset.class))))).reduce((Function2 & Serializable & scala.Serializable)(x$3, x$4) -> x$3.union(x$4));
        return new SparkFeaturizedDataset((Dataset<Row>)data, new FeaturizedDatasetMetadata(FeaturizedDatasetMetadata$.MODULE$.apply$default$1(), FeaturizedDatasetMetadata$.MODULE$.apply$default$2()));
    }

    private LocalFeatureJoinJob$() {
        MODULE$ = this;
        this.ss = FeathrTestUtils$.MODULE$.createSparkSession(true, FeathrTestUtils$.MODULE$.createSparkSession$default$2(), FeathrTestUtils$.MODULE$.createSparkSession$default$3(), FeathrTestUtils$.MODULE$.createSparkSession$default$4());
        this.SKIP_MISSING_FEATURE = SQLConf$.MODULE$.buildConf("spark.feathr.skip.missing.feature").doc("Whether to skip features if data is missing.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.MAX_DATA_LOAD_RETRY = SQLConf$.MODULE$.buildConf("spark.feathr.max.data.load.retry").doc("Number of retries if data is missing.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)0));
    }
}

