/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.join.algorithms;

import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrFeatureJoinException;
import com.linkedin.feathr.offline.join.algorithms.JoinType$;
import com.linkedin.feathr.offline.join.algorithms.SaltedSparkJoin$;
import com.linkedin.feathr.offline.join.algorithms.SparkJoin;
import com.linkedin.feathr.offline.join.util.FrequentItemEstimator;
import com.linkedin.feathr.offline.join.util.PreComputedFrequentItemEstimator;
import com.linkedin.feathr.offline.util.FeathrUtils$;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tMe!B\u0015+\u000192\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u0011=\u0003!\u0011!Q\u0001\nACQA\u0016\u0001\u0005\u0002]Cqa\u0017\u0001C\u0002\u0013\u0005A\f\u0003\u0004l\u0001\u0001\u0006I!\u0018\u0005\bY\u0002\u0011\r\u0011\"\u0001n\u0011\u0019\t\b\u0001)A\u0005]\")Q\u0006\u0001C!e\"9\u0011q\f\u0001\u0005\n\u0005\u0005\u0004bBAA\u0001\u0011%\u00111Q\u0004\b\u0003\u0017S\u0003\u0012AAG\r\u0019I#\u0006#\u0001\u0002\u0010\"1a\u000b\u0004C\u0001\u0003/C!\"!'\r\u0011\u000b\u0007I\u0011BAN\u0011\u001d\t)\f\u0004C\u0001\u0003o3a!!4\r\u0001\u0006=\u0007BCAl!\tU\r\u0011\"\u0001\u0002Z\"I\u00111\u001c\t\u0003\u0012\u0003\u0006I\u0001\u0015\u0005\u000b\u0003;\u0004\"Q3A\u0005\u0002\u0005}\u0007BCAq!\tE\t\u0015!\u0003\u0002H\"1a\u000b\u0005C\u0001\u0003GD\u0011\"!<\u0011\u0003\u0003%\t!a<\t\u0013\u0005U\b#%A\u0005\u0002\u0005]\b\"\u0003B\u0007!E\u0005I\u0011\u0001B\b\u0011%\u0011\u0019\u0002EA\u0001\n\u0003\u0012)\u0002\u0003\u0005\u0003&A\t\t\u0011\"\u0001n\u0011%\u00119\u0003EA\u0001\n\u0003\u0011I\u0003C\u0005\u00036A\t\t\u0011\"\u0011\u00038!I!q\b\t\u0002\u0002\u0013\u0005!\u0011\t\u0005\n\u0005\u0017\u0002\u0012\u0011!C!\u0005\u001bB\u0011Ba\u0014\u0011\u0003\u0003%\tE!\u0015\t\u0013\tM\u0003#!A\u0005B\tUs!\u0003B-\u0019\u0005\u0005\t\u0012\u0001B.\r%\ti\rDA\u0001\u0012\u0003\u0011i\u0006\u0003\u0004WE\u0011\u0005!1\u000e\u0005\n\u0005\u001f\u0012\u0013\u0011!C#\u0005#B\u0011B!\u001c#\u0003\u0003%\tIa\u001c\t\u0013\tU$%!A\u0005\u0002\n]\u0004\"\u0003BEE\u0005\u0005I\u0011\u0002BF\u0011%\u0011I\tDA\u0001\n\u0013\u0011YIA\bTC2$X\rZ*qCJ\\'j\\5o\u0015\tYC&\u0001\u0006bY\u001e|'/\u001b;i[NT!!\f\u0018\u0002\t)|\u0017N\u001c\u0006\u0003_A\nqa\u001c4gY&tWM\u0003\u00022e\u00051a-Z1uQJT!a\r\u001b\u0002\u00111Lgn[3eS:T\u0011!N\u0001\u0004G>l7c\u0001\u00018{A\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t1\u0011I\\=SK\u001a\u0004\"AP \u000e\u0003)J!\u0001\u0011\u0016\u0003\u0013M\u0003\u0018M]6K_&t\u0017AA:t\u0007\u0001\u0001\"\u0001R'\u000e\u0003\u0015S!AR$\u0002\u0007M\fHN\u0003\u0002I\u0013\u0006)1\u000f]1sW*\u0011!jS\u0001\u0007CB\f7\r[3\u000b\u00031\u000b1a\u001c:h\u0013\tqUI\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u000bge\u0016\fX/\u001a8u\u0013R,W.R:uS6\fGo\u001c:\u0011\u0005E#V\"\u0001*\u000b\u0005Mc\u0013\u0001B;uS2L!!\u0016*\u0003+\u0019\u0013X-];f]RLE/Z7FgRLW.\u0019;pe\u00061A(\u001b8jiz\"2\u0001W-[!\tq\u0004\u0001C\u0003B\u0007\u0001\u00071\tC\u0003P\u0007\u0001\u0007\u0001+\u0001\ntkB\u0004xN\u001d;fI*{\u0017N\u001c+za\u0016\u001cX#A/\u0011\u0007y\u000b7-D\u0001`\u0015\t\u0001\u0017(\u0001\u0006d_2dWm\u0019;j_:L!AY0\u0003\u0007M+\u0017\u000f\u0005\u0002eO:\u0011a(Z\u0005\u0003M*\n\u0001BS8j]RK\b/Z\u0005\u0003Q&\u0014QAV1mk\u0016L!A[\u001d\u0003\u0017\u0015sW/\\3sCRLwN\\\u0001\u0014gV\u0004\bo\u001c:uK\u0012Tu.\u001b8UsB,7\u000fI\u0001\u0017%\u0016\u0003F*S\"B)&{ej\u0018$B\u0007R{%k\u0018'P/V\ta\u000e\u0005\u00029_&\u0011\u0001/\u000f\u0002\u0004\u0013:$\u0018a\u0006*F!2K5)\u0011+J\u001f:{f)Q\"U\u001fJ{FjT,!)-\u0019\u00181BA\u0017\u0003c\t)$!\u000f\u0011\u0007Q\f)AD\u0002v\u0003\u0003q!A^@\u000f\u0005]thB\u0001=~\u001d\tIH0D\u0001{\u0015\tY()\u0001\u0004=e>|GOP\u0005\u0002\u0019&\u0011!jS\u0005\u0003\u0011&K!AR$\n\u0007\u0005\rQ)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0011\u0011\u0002\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!a\u0001F\u0011\u001d\ti\u0001\u0003a\u0001\u0003\u001f\tq\u0002\\3gi*{\u0017N\\\"pYVlgn\u001d\t\u0007\u0003#\tI\"!\b\u000f\t\u0005M\u0011q\u0003\b\u0004s\u0006U\u0011\"\u0001\u001e\n\u0007\u0005\r\u0011(C\u0002c\u00037Q1!a\u0001:!\u0011\ty\"a\n\u000f\t\u0005\u0005\u00121\u0005\t\u0003sfJ1!!\n:\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011FA\u0016\u0005\u0019\u0019FO]5oO*\u0019\u0011QE\u001d\t\r\u0005=\u0002\u00021\u0001t\u0003\u0019aWM\u001a;E\r\"9\u00111\u0007\u0005A\u0002\u0005=\u0011\u0001\u0005:jO\"$(j\\5o\u0007>dW/\u001c8t\u0011\u0019\t9\u0004\u0003a\u0001g\u00069!/[4ii\u00123\u0005bBA\u001e\u0011\u0001\u0007\u0011QH\u0001\tU>Lg\u000eV=qKB!\u0011qHA-\u001d\r\t\t%\u001a\b\u0005\u0003\u0007\n9F\u0004\u0003\u0002F\u0005Uc\u0002BA$\u0003'rA!!\u0013\u0002R9!\u00111JA(\u001d\rI\u0018QJ\u0005\u0002k%\u00111\u0007N\u0005\u0003cIJ!a\f\u0019\n\u00055r\u0013BA\u0016-\u0013\u0011\tY&!\u0018\u0003\u0011){\u0017N\u001c+za\u0016T!A\u001a\u0016\u0002/\r\u0014X-\u0019;f\u0003\u0012$'+\u001a9mS\u000e\fG/[8o+\u00124G\u0003CA2\u0003_\nI(! \u0011\t\u0005\u0015\u00141N\u0007\u0003\u0003OR1!!\u001bF\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u00055\u0014q\r\u0002\u0014+N,'\u000fR3gS:,GMR;oGRLwN\u001c\u0005\b\u0003cJ\u0001\u0019AA:\u0003)1'/Z9LKf\u001cV\r\u001e\t\u0007\u0003?\t)(!\b\n\t\u0005]\u00141\u0006\u0002\u0004'\u0016$\bBBA>\u0013\u0001\u0007a.A\u000bsKBd\u0017nY1uS>tg)Y2u_JD\u0015n\u001a5\t\r\u0005}\u0014\u00021\u0001o\u0003Q\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d'po\u0006\u00012M]3bi\u0016\fE\rZ*bYR,FM\u001a\u000b\t\u0003G\n))a\"\u0002\n\"9\u0011\u0011\u000f\u0006A\u0002\u0005M\u0004BBA>\u0015\u0001\u0007a\u000e\u0003\u0004\u0002\u0000)\u0001\rA\\\u0001\u0010'\u0006dG/\u001a3Ta\u0006\u00148NS8j]B\u0011a\bD\n\u0005\u0019]\n\t\nE\u00029\u0003'K1!!&:\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\ti)A\u0002m_\u001e,\"!!(\u0011\t\u0005}\u0015\u0011V\u0007\u0003\u0003CSA!a)\u0002&\u0006)An\\45U*\u0019\u0011qU%\u0002\u000f1|wmZ5oO&!\u00111VAQ\u0005\u0019aunZ4fe\"\u001aa\"a,\u0011\u0007a\n\t,C\u0002\u00024f\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u00023\u001d,GO\u0012:fcV,g\u000e^%uK6\u001cH)\u0019;b\rJ\fW.\u001a\u000b\ng\u0006e\u00161XA`\u0003\u0007DQaT\bA\u0002ACa!!0\u0010\u0001\u0004\u0019\u0018aB5oaV$HI\u001a\u0005\b\u0003\u0003|\u0001\u0019AA\u000f\u00031!\u0018M]4fi\u000e{G.^7o\u0011\u001d\t)m\u0004a\u0001\u0003\u000f\fQB\u001a:fcRC'/Z:i_2$\u0007c\u0001\u001d\u0002J&\u0019\u00111Z\u001d\u0003\u000b\u0019cw.\u0019;\u0003\u001d){\u0017N\u001c)be\u0006lW\r^3sgN1\u0001cNAi\u0003#\u00032\u0001OAj\u0013\r\t).\u000f\u0002\b!J|G-^2u\u0003%)7\u000f^5nCR|'/F\u0001Q\u0003))7\u000f^5nCR|'\u000fI\u0001\u0016MJ,\u0017/^3oi&#X-\u001c+ie\u0016\u001c\bn\u001c7e+\t\t9-\u0001\fge\u0016\fX/\u001a8u\u0013R,W\u000e\u00165sKNDw\u000e\u001c3!)\u0019\t)/!;\u0002lB\u0019\u0011q\u001d\t\u000e\u00031Aa!a6\u0016\u0001\u0004\u0001\u0006bBAo+\u0001\u0007\u0011qY\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002f\u0006E\u00181\u001f\u0005\t\u0003/4\u0002\u0013!a\u0001!\"I\u0011Q\u001c\f\u0011\u0002\u0003\u0007\u0011qY\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIPK\u0002Q\u0003w\\#!!@\u0011\t\u0005}(\u0011B\u0007\u0003\u0005\u0003QAAa\u0001\u0003\u0006\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u000fI\u0014AC1o]>$\u0018\r^5p]&!!1\u0002B\u0001\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\tB\u000b\u0003\u0002H\u0006m\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u0018A!!\u0011\u0004B\u0012\u001b\t\u0011YB\u0003\u0003\u0003\u001e\t}\u0011\u0001\u00027b]\u001eT!A!\t\u0002\t)\fg/Y\u0005\u0005\u0003S\u0011Y\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t-\"\u0011\u0007\t\u0004q\t5\u0012b\u0001B\u0018s\t\u0019\u0011I\\=\t\u0011\tM2$!AA\u00029\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u001d!\u0015q&1\bB\u0016\u0013\r\u0011id\u0018\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003D\t%\u0003c\u0001\u001d\u0003F%\u0019!qI\u001d\u0003\u000f\t{w\u000e\\3b]\"I!1G\u000f\u0002\u0002\u0003\u0007!1F\u0001\tQ\u0006\u001c\bnQ8eKR\ta.\u0001\u0005u_N#(/\u001b8h)\t\u00119\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005\u0007\u00129\u0006C\u0005\u00034\u0001\n\t\u00111\u0001\u0003,\u0005q!j\\5o!\u0006\u0014\u0018-\\3uKJ\u001c\bcAAtEM)!Ea\u0018\u0002\u0012BI!\u0011\rB4!\u0006\u001d\u0017Q]\u0007\u0003\u0005GR1A!\u001a:\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u001b\u0003d\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\tm\u0013!B1qa2LHCBAs\u0005c\u0012\u0019\b\u0003\u0004\u0002X\u0016\u0002\r\u0001\u0015\u0005\b\u0003;,\u0003\u0019AAd\u0003\u001d)h.\u00199qYf$BA!\u001f\u0003\u0006B)\u0001Ha\u001f\u0003\u0000%\u0019!QP\u001d\u0003\r=\u0003H/[8o!\u0019A$\u0011\u0011)\u0002H&\u0019!1Q\u001d\u0003\rQ+\b\u000f\\33\u0011%\u00119IJA\u0001\u0002\u0004\t)/A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!Q\u0012\t\u0005\u00053\u0011y)\u0003\u0003\u0003\u0012\nm!AB(cU\u0016\u001cG\u000f")
public class SaltedSparkJoin
implements SparkJoin {
    private final SparkSession ss;
    private final FrequentItemEstimator frequentItemEstimator;
    private final Seq<Enumeration.Value> supportedJoinTypes;
    private final int REPLICATION_FACTOR_LOW;

    public static Dataset<Row> getFrequentItemsDataFrame(FrequentItemEstimator frequentItemEstimator, Dataset<Row> dataset, String string, float f) {
        return SaltedSparkJoin$.MODULE$.getFrequentItemsDataFrame(frequentItemEstimator, dataset, string, f);
    }

    public Seq<Enumeration.Value> supportedJoinTypes() {
        return this.supportedJoinTypes;
    }

    public int REPLICATION_FACTOR_LOW() {
        return this.REPLICATION_FACTOR_LOW;
    }

    @Override
    public Dataset<Row> join(Seq<String> leftJoinColumns, Dataset<Row> leftDF, Seq<String> rightJoinColumns, Dataset<Row> rightDF, Enumeration.Value joinType) {
        if (!this.supportedJoinTypes().contains((Object)joinType)) {
            throw new FeathrFeatureJoinException(ErrorLabel.FEATHR_ERROR, new StringBuilder(62).append("Salted join does not support join type ").append(joinType).append(", supported types are: ").append(this.supportedJoinTypes()).toString());
        }
        if (leftJoinColumns.size() != 1 || rightJoinColumns.size() != 1) {
            throw new FeathrFeatureJoinException(ErrorLabel.FEATHR_ERROR, new StringBuilder(84).append("In salted join, there should be only one ").append("join columns, but found left: [").append(leftJoinColumns.mkString(", ")).append("], right: [").append(rightJoinColumns.mkString(", ")).append("]").toString());
        }
        Dataset<Row> left = leftDF;
        Dataset right = rightDF.dropDuplicates(rightJoinColumns).withColumnRenamed((String)rightJoinColumns.head(), (String)leftJoinColumns.head());
        String joinColumn = (String)leftJoinColumns.head();
        SparkConf conf = this.ss.sparkContext().getConf();
        boolean persist = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(conf, FeathrUtils$.MODULE$.SALTED_JOIN_PERSIST()))).toBoolean() && !(this.frequentItemEstimator instanceof PreComputedFrequentItemEstimator);
        Object object = persist ? left.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
        float freqThreshold = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(conf, FeathrUtils$.MODULE$.SALTED_JOIN_FREQ_ITEM_THRESHOLD()))).toFloat();
        Dataset<Row> freqKeyDf = SaltedSparkJoin$.MODULE$.getFrequentItemsDataFrame(this.frequentItemEstimator, left, joinColumn, freqThreshold);
        Set freqKeySet = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])freqKeyDf.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.expr(joinColumn).cast((DataType)StringType$.MODULE$).as(joinColumn)})).collect())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        SaltedSparkJoin$.MODULE$.com$linkedin$feathr$offline$join$algorithms$SaltedSparkJoin$$log().info(new StringBuilder(50).append("Salted Join: applying salted join for join column:").append(joinColumn).toString());
        String newJoinKeyColumn = new StringBuilder(13).append("new_join_key_").append(joinColumn).toString();
        String replicationColumn = "replicate_id";
        Column newJoinKeyExpr = functions$.MODULE$.concat_ws("#", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.expr(joinColumn), functions$.MODULE$.expr(replicationColumn)}));
        int replicationFactorHigh = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(conf, FeathrUtils$.MODULE$.SALTED_JOIN_REPLICATION_FACTOR_HIGH()))).toInt();
        UserDefinedFunction addReplicationUdf = this.createAddReplicationUdf((Set<String>)freqKeySet, replicationFactorHigh, this.REPLICATION_FACTOR_LOW());
        Dataset rightWithSalt = right.withColumn(replicationColumn, functions$.MODULE$.explode(addReplicationUdf.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.expr(joinColumn)})))).withColumn(newJoinKeyColumn, newJoinKeyExpr).drop(replicationColumn).drop(joinColumn);
        UserDefinedFunction addSaltUdf = this.createAddSaltUdf((Set<String>)freqKeySet, replicationFactorHigh, this.REPLICATION_FACTOR_LOW());
        Dataset leftWithSalt = left.withColumn(newJoinKeyColumn, addSaltUdf.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.expr(joinColumn)})));
        return leftWithSalt.join(rightWithSalt, (Seq)new .colon.colon((Object)newJoinKeyColumn, (List)Nil$.MODULE$), joinType.toString()).drop(newJoinKeyColumn);
    }

    private UserDefinedFunction createAddReplicationUdf(Set<String> freqKeySet, int replicationFactorHigh, int replicationFactorLow) {
        int[] replicationHigh = (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), replicationFactorHigh).toArray(ClassTag$.MODULE$.Int());
        int[] replicationLow = (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), replicationFactorLow).toArray(ClassTag$.MODULE$.Int());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(SaltedSparkJoin.class.getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(SaltedSparkJoin.class.getClassLoader());
        public final class Com_linkedin_feathr_offline_join_algorithms_SaltedSparkJoin$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Com_linkedin_feathr_offline_join_algorithms_SaltedSparkJoin$$typecreator1$1(SaltedSparkJoin $outer) {
            }
        }
        public final class Com_linkedin_feathr_offline_join_algorithms_SaltedSparkJoin$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Com_linkedin_feathr_offline_join_algorithms_SaltedSparkJoin$$typecreator2$1(SaltedSparkJoin $outer) {
            }
        }
        return functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x -> freqKeySet.contains(x) ? replicationHigh : replicationLow, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_linkedin_feathr_offline_join_algorithms_SaltedSparkJoin$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Com_linkedin_feathr_offline_join_algorithms_SaltedSparkJoin$$typecreator2$1(null)));
    }

    private UserDefinedFunction createAddSaltUdf(Set<String> freqKeySet, int replicationFactorHigh, int replicationFactorLow) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(SaltedSparkJoin.class.getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(SaltedSparkJoin.class.getClassLoader());
        public final class Com_linkedin_feathr_offline_join_algorithms_SaltedSparkJoin$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.String").asType().toTypeConstructor();
            }

            public Com_linkedin_feathr_offline_join_algorithms_SaltedSparkJoin$$typecreator1$2(SaltedSparkJoin $outer) {
            }
        }
        public final class Com_linkedin_feathr_offline_join_algorithms_SaltedSparkJoin$$typecreator2$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Com_linkedin_feathr_offline_join_algorithms_SaltedSparkJoin$$typecreator2$2(SaltedSparkJoin $outer) {
            }
        }
        return functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x -> freqKeySet.contains(x) ? new StringBuilder(1).append((String)x).append("#").append(Random$.MODULE$.nextInt(replicationFactorHigh)).toString() : new StringBuilder(1).append((String)x).append("#").append(Random$.MODULE$.nextInt(replicationFactorLow)).toString(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_linkedin_feathr_offline_join_algorithms_SaltedSparkJoin$$typecreator1$2(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Com_linkedin_feathr_offline_join_algorithms_SaltedSparkJoin$$typecreator2$2(null)));
    }

    public SaltedSparkJoin(SparkSession ss, FrequentItemEstimator frequentItemEstimator) {
        this.ss = ss;
        this.frequentItemEstimator = frequentItemEstimator;
        this.supportedJoinTypes = (Seq)new .colon.colon((Object)JoinType$.MODULE$.inner(), (List)new .colon.colon((Object)JoinType$.MODULE$.left_outer(), (List)Nil$.MODULE$));
        this.REPLICATION_FACTOR_LOW = 1;
    }

    public static class JoinParameters
    implements Product,
    scala.Serializable {
        private final FrequentItemEstimator estimator;
        private final float frequentItemThreshold;

        public FrequentItemEstimator estimator() {
            return this.estimator;
        }

        public float frequentItemThreshold() {
            return this.frequentItemThreshold;
        }

        public JoinParameters copy(FrequentItemEstimator estimator, float frequentItemThreshold) {
            return new JoinParameters(estimator, frequentItemThreshold);
        }

        public FrequentItemEstimator copy$default$1() {
            return this.estimator();
        }

        public float copy$default$2() {
            return this.frequentItemThreshold();
        }

        public String productPrefix() {
            return "JoinParameters";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.estimator();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToFloat((float)this.frequentItemThreshold());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof JoinParameters;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.estimator()));
            n = Statics.mix((int)n, (int)Statics.floatHash((float)this.frequentItemThreshold()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof JoinParameters)) return false;
            boolean bl = true;
            if (!bl) return false;
            JoinParameters joinParameters = (JoinParameters)x$1;
            FrequentItemEstimator frequentItemEstimator = this.estimator();
            FrequentItemEstimator frequentItemEstimator2 = joinParameters.estimator();
            if (frequentItemEstimator == null) {
                if (frequentItemEstimator2 != null) {
                    return false;
                }
            } else if (!frequentItemEstimator.equals(frequentItemEstimator2)) return false;
            if (this.frequentItemThreshold() != joinParameters.frequentItemThreshold()) return false;
            if (!joinParameters.canEqual(this)) return false;
            return true;
        }

        public JoinParameters(FrequentItemEstimator estimator, float frequentItemThreshold) {
            this.estimator = estimator;
            this.frequentItemThreshold = frequentItemThreshold;
            Product.$init$((Product)this);
        }
    }
}

