/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.join.algorithms;

import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrFeatureJoinException;
import com.linkedin.feathr.offline.join.algorithms.SparkJoinConditionBuilder;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;

public final class SequentialJoinConditionBuilder$
implements SparkJoinConditionBuilder {
    public static SequentialJoinConditionBuilder$ MODULE$;

    static {
        new SequentialJoinConditionBuilder$();
    }

    @Override
    public Column buildJoinCondition(Seq<String> leftJoinColumns, Dataset<Row> left, Seq<String> rightJoinColumns, Dataset<Row> right) {
        return (Column)((TraversableOnce)((TraversableLike)leftJoinColumns.zip(rightJoinColumns, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Column column;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String x = (String)tuple2._1();
            String y = (String)tuple2._2();
            int leftFieldIndex = left.schema().fieldIndex((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x.split("\\."))).head());
            StructField leftFieldType = (StructField)left.schema().toList().apply(leftFieldIndex);
            DataType dataType = leftFieldType.dataType();
            if (dataType instanceof StringType) {
                column = left.apply(x).$eq$eq$eq((Object)right.apply(y));
                return column;
            } else if (dataType instanceof NumericType) {
                column = left.apply(x).$eq$eq$eq((Object)right.apply(y));
                return column;
            } else if (dataType instanceof StructType) {
                column = left.apply(x).$eq$eq$eq((Object)right.apply(y));
                return column;
            } else {
                if (!(dataType instanceof ArrayType)) throw new FeathrFeatureJoinException(ErrorLabel.FEATHR_ERROR, new StringBuilder(148).append("The left feature key ").append(x).append(" is of ").append(leftFieldType.dataType()).append(" type. Currently in Sequential Join, we only support ").append("StringType, NumericType and ArrayType columns as left join columns.").toString());
                column = functions$.MODULE$.expr(new StringBuilder(18).append("array_contains(").append(x).append(", ").append(y).append(")").toString());
            }
            return column;
        }, Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$3, x$4) -> x$3.$amp$amp(x$4));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SequentialJoinConditionBuilder$() {
        MODULE$ = this;
    }
}

