/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.join.algorithms;

import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrFeatureJoinException;
import com.linkedin.feathr.offline.join.algorithms.SparkJoin;
import com.linkedin.feathr.offline.join.algorithms.SparkJoinWithNoJoinCondition$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Enumeration;
import scala.Function2;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y4Q\u0001C\u0005\u0001\u001bUAQ\u0001\t\u0001\u0005\u0002\tBQ\u0001\u0004\u0001\u0005B\u0011:a\u0001\\\u0005\t\u00025igA\u0002\u0005\n\u0011\u0003ia\u000eC\u0003!\t\u0011\u0005!\u000fC\u0003t\t\u0011\u0005!\u0005C\u0004u\t\u0005\u0005I\u0011B;\u00039M\u0003\u0018M]6K_&tw+\u001b;i\u001d>Tu.\u001b8D_:$\u0017\u000e^5p]*\u0011!bC\u0001\u000bC2<wN]5uQ6\u001c(B\u0001\u0007\u000e\u0003\u0011Qw.\u001b8\u000b\u00059y\u0011aB8gM2Lg.\u001a\u0006\u0003!E\taAZ3bi\"\u0014(B\u0001\n\u0014\u0003!a\u0017N\\6fI&t'\"\u0001\u000b\u0002\u0007\r|WnE\u0002\u0001-q\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f\u001f\u001b\u0005I\u0011BA\u0010\n\u0005%\u0019\u0006/\u0019:l\u0015>Lg.\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0019\u0003CA\u000f\u0001)\u0019)s(U*V/B\u0011a\u0005\u0010\b\u0003Oer!\u0001\u000b\u001c\u000f\u0005%\u001adB\u0001\u00161\u001d\tYc&D\u0001-\u0015\ti\u0013%\u0001\u0004=e>|GOP\u0005\u0002_\u0005\u0019qN]4\n\u0005E\u0012\u0014AB1qC\u000eDWMC\u00010\u0013\t!T'A\u0003ta\u0006\u00148N\u0003\u00022e%\u0011q\u0007O\u0001\u0004gFd'B\u0001\u001b6\u0013\tQ4(A\u0004qC\u000e\\\u0017mZ3\u000b\u0005]B\u0014BA\u001f?\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002;w!)\u0001I\u0001a\u0001\u0003\u0006yA.\u001a4u\u0015>LgnQ8mk6t7\u000fE\u0002C\r&s!aQ#\u000f\u0005-\"\u0015\"A\r\n\u0005iB\u0012BA$I\u0005\r\u0019V-\u001d\u0006\u0003ua\u0001\"A\u0013(\u000f\u0005-c\u0005CA\u0016\u0019\u0013\ti\u0005$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001fB\u0013aa\u0015;sS:<'BA'\u0019\u0011\u0015\u0011&\u00011\u0001&\u0003\u0019aWM\u001a;E\r\")AK\u0001a\u0001\u0003\u0006\u0001\"/[4ii*{\u0017N\\\"pYVlgn\u001d\u0005\u0006-\n\u0001\r!J\u0001\be&<\u0007\u000e\u001e#G\u0011\u0015A&\u00011\u0001Z\u0003!Qw.\u001b8UsB,\u0007C\u0001.j\u001d\tYvM\u0004\u0002]M:\u0011Q,\u001a\b\u0003=\u0012t!aX2\u000f\u0005\u0001\u0014gBA\u0016b\u0013\u0005!\u0012B\u0001\n\u0014\u0013\t\u0001\u0012#\u0003\u0002\u000f\u001f%\u0011A\"D\u0005\u0003\u0015-I!\u0001[\u0005\u0002\u0011){\u0017N\u001c+za\u0016L!A[6\u0003\u0011){\u0017N\u001c+za\u0016T!\u0001[\u0005\u00029M\u0003\u0018M]6K_&tw+\u001b;i\u001d>Tu.\u001b8D_:$\u0017\u000e^5p]B\u0011Q\u0004B\n\u0004\tYy\u0007CA\fq\u0013\t\t\bD\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001n\u0003\u0015\t\u0007\u000f\u001d7z\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003Y\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\t1\fgn\u001a\u0006\u0002w\u0006!!.\u0019<b\u0013\ti\bP\u0001\u0004PE*,7\r\u001e")
public class SparkJoinWithNoJoinCondition
implements SparkJoin {
    public static SparkJoinWithNoJoinCondition apply() {
        return SparkJoinWithNoJoinCondition$.MODULE$.apply();
    }

    @Override
    public Dataset<Row> join(Seq<String> leftJoinColumns, Dataset<Row> leftDF, Seq<String> rightJoinColumns, Dataset<Row> rightDF, Enumeration.Value joinType) {
        if (leftJoinColumns.size() != rightJoinColumns.size()) {
            throw new FeathrFeatureJoinException(ErrorLabel.FEATHR_ERROR, new StringBuilder(115).append("left join key column size is not equal to right join key column size. ").append("Left join columns: [").append(leftJoinColumns.mkString(", ")).append("], Right join columns: [").append(rightJoinColumns.mkString(", ")).append("]").toString());
        }
        Dataset renamedRightDF = (Dataset)((TraversableOnce)rightJoinColumns.zip(leftJoinColumns, Seq$.MODULE$.canBuildFrom())).foldLeft(rightDF, (Function2 & java.io.Serializable & Serializable)(baseDF, namePair) -> baseDF.withColumnRenamed((String)namePair._1(), (String)namePair._2()));
        return leftDF.join(renamedRightDF, leftJoinColumns, joinType.toString());
    }
}

