/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.mvel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.linkedin.feathr.common.FeatureValue;
import com.linkedin.feathr.common.util.MvelContextUDFs;
import com.linkedin.feathr.offline.mvel.plugins.FeathrExpressionExecutionContext;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.PropertyHandlerFactory;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.OptimizerFactory;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.mutable.WrappedArray;

public class MvelContext {
    private static final ParserConfiguration PARSER_CONFIG = new ParserConfiguration();
    public static Optional<Broadcast<Class<?>>> mvelAlienUDFRegisterClazz = Optional.empty();
    public static Boolean alienUDFInitialized = false;

    private MvelContext() {
    }

    private static void loadJavaClasses() {
        PARSER_CONFIG.addImport("System", System.class);
        PARSER_CONFIG.addImport("String", String.class);
        PARSER_CONFIG.addImport("CharSequence", CharSequence.class);
        PARSER_CONFIG.addImport("Integer", Integer.class);
        PARSER_CONFIG.addImport("int", Integer.TYPE);
        PARSER_CONFIG.addImport("Long", Long.class);
        PARSER_CONFIG.addImport("long", Long.TYPE);
        PARSER_CONFIG.addImport("Boolean", Boolean.class);
        PARSER_CONFIG.addImport("boolean", Boolean.TYPE);
        PARSER_CONFIG.addImport("Short", Short.class);
        PARSER_CONFIG.addImport("short", Short.TYPE);
        PARSER_CONFIG.addImport("Character", Character.class);
        PARSER_CONFIG.addImport("char", Character.TYPE);
        PARSER_CONFIG.addImport("Double", Double.class);
        PARSER_CONFIG.addImport("double", Double.TYPE);
        PARSER_CONFIG.addImport("Float", Float.class);
        PARSER_CONFIG.addImport("float", Float.TYPE);
        PARSER_CONFIG.addImport("Byte", Byte.class);
        PARSER_CONFIG.addImport("byte", Byte.TYPE);
        PARSER_CONFIG.addImport("Math", Math.class);
        PARSER_CONFIG.addImport("Void", Void.class);
        PARSER_CONFIG.addImport("Object", Object.class);
        PARSER_CONFIG.addImport("Number", Number.class);
    }

    public static void ensureInitialized() {
        if (!alienUDFInitialized.booleanValue() && mvelAlienUDFRegisterClazz.isPresent()) {
            MvelContextUDFs.registerUDFs((Class)mvelAlienUDFRegisterClazz.get().getValue(), PARSER_CONFIG);
            alienUDFInitialized = true;
        }
    }

    public static ParserContext newParserContext() {
        return new ParserContext(PARSER_CONFIG);
    }

    public static Object executeExpressionWithPluginSupport(Object compiledExpression, Object ctx, FeathrExpressionExecutionContext mvelContext) {
        Object output = MVEL.executeExpression((Object)compiledExpression, (Object)ctx);
        return MvelContext.coerceToFeatureValueViaMvelDataConversionPlugins(output, mvelContext);
    }

    public static Object executeExpressionWithPluginSupportWithFactory(Object compiledExpression, Object ctx, VariableResolverFactory variableResolverFactory, FeathrExpressionExecutionContext mvelContext) {
        Object output = MVEL.executeExpression((Object)compiledExpression, (Object)ctx, (VariableResolverFactory)variableResolverFactory);
        return MvelContext.coerceToFeatureValueViaMvelDataConversionPlugins(output, mvelContext);
    }

    private static Object coerceToFeatureValueViaMvelDataConversionPlugins(Object input, FeathrExpressionExecutionContext mvelContext) {
        if (input != null && mvelContext != null && mvelContext.canConvert(FeatureValue.class, input.getClass())) {
            return mvelContext.convert(input, FeatureValue.class);
        }
        return input;
    }

    private static Object sanitize(Object input) {
        if (input instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)input;
            if (!map.isEmpty() && map.keySet().iterator().next() instanceof Utf8) {
                return new AvroDecoratorMap((java.util.Map)input);
            }
            return map;
        }
        if (input instanceof Utf8 || input instanceof GenericEnumSymbol || input instanceof Enum) {
            return input.toString();
        }
        return input;
    }

    static {
        MvelContextUDFs.registerUDFs(MvelContextUDFs.class, PARSER_CONFIG);
        MvelContext.loadJavaClasses();
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        PropertyHandlerFactory.registerPropertyHandler(GenericRecord.class, (PropertyHandler)GenericRecordPropertyHandler.INSTANCE);
        PropertyHandlerFactory.registerPropertyHandler(GenericRowWithSchema.class, (PropertyHandler)GenericRowWithSchemaPropertyHandler.INSTANCE);
    }

    private static class AvroDecoratorMap
    implements java.util.Map<String, Object> {
        private final java.util.Map<Utf8, Object> _underlying;
        private Set<String> _keys = null;
        private Collection<Object> _values = null;
        private Set<Map.Entry<String, Object>> _entries = null;

        public AvroDecoratorMap(java.util.Map<Utf8, Object> map) {
            this._underlying = map;
        }

        @Override
        public boolean containsKey(Object key) {
            if (!(key instanceof String)) {
                return false;
            }
            return this._underlying.containsKey(new Utf8((String)key));
        }

        @Override
        public Object get(Object key) {
            return MvelContext.sanitize(this._underlying.get(new Utf8((String)key)));
        }

        @Override
        public Set<String> keySet() {
            if (this._keys != null) {
                return this._keys;
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Utf8 key : this._underlying.keySet()) {
                builder.add((Object)key.toString());
            }
            this._keys = builder.build();
            return this._keys;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            if (this._entries != null) {
                return this._entries;
            }
            ImmutableSet.Builder output = ImmutableSet.builder();
            for (Map.Entry<Utf8, Object> entry : this._underlying.entrySet()) {
                output.add(new AbstractMap.SimpleImmutableEntry<String, Object>(entry.getKey().toString(), MvelContext.sanitize(entry.getValue())));
            }
            this._entries = output.build();
            return this._entries;
        }

        @Override
        public Collection<Object> values() {
            if (this._values != null) {
                return this._values;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object value : this._underlying.values()) {
                builder.add(MvelContext.sanitize(value));
            }
            this._values = builder.build();
            return this._values;
        }

        @Override
        public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AvroDecoratorMap) {
                AvroDecoratorMap other = (AvroDecoratorMap)o;
                if (this._underlying == other._underlying) {
                    return true;
                }
                return this._underlying.equals(other._underlying);
            }
            if (o instanceof java.util.Map) {
                return this.entrySet().equals(((java.util.Map)o).entrySet());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.entrySet().hashCode();
        }

        @Override
        public int size() {
            return this._underlying.size();
        }

        @Override
        public boolean isEmpty() {
            return this._underlying.isEmpty();
        }

        public String toString() {
            return this._underlying.toString();
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(java.util.Map<? extends String, ? extends Object> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class GenericRowWithSchemaPropertyHandler
    implements PropertyHandler {
        public static final GenericRowWithSchemaPropertyHandler INSTANCE = new GenericRowWithSchemaPropertyHandler();

        private GenericRowWithSchemaPropertyHandler() {
        }

        public Object getProperty(String name, Object contextObj, VariableResolverFactory variableFactory) {
            int index;
            GenericRowWithSchema row = (GenericRowWithSchema)contextObj;
            try {
                index = row.fieldIndex(name);
            }
            catch (IllegalArgumentException e1) {
                try {
                    index = row.fieldIndex(name.toLowerCase());
                }
                catch (IllegalArgumentException e2) {
                    throw e1;
                }
            }
            Object output = ((GenericRowWithSchema)contextObj).get(index);
            if (output == null) {
                return output;
            }
            if (output instanceof scala.collection.immutable.Map) {
                return JavaConverters.mapAsJavaMapConverter((Map)((scala.collection.immutable.Map)output)).asJava();
            }
            if (output instanceof WrappedArray) {
                WrappedArray arr = (WrappedArray)output;
                ArrayList<Object> newOutput = new ArrayList<Object>();
                for (int i = 0; i < arr.length(); ++i) {
                    newOutput.add(arr.apply(i));
                }
                return newOutput;
            }
            return output;
        }

        public Object setProperty(String name, Object contextObj, VariableResolverFactory variableFactory, Object value) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class GenericRecordPropertyHandler
    implements PropertyHandler {
        public static final GenericRecordPropertyHandler INSTANCE = new GenericRecordPropertyHandler();

        private GenericRecordPropertyHandler() {
        }

        public Object getProperty(String name, Object contextObj, VariableResolverFactory variableFactory) {
            Object output = ((GenericRecord)contextObj).get(name);
            return MvelContext.sanitize(output);
        }

        public Object setProperty(String name, Object contextObj, VariableResolverFactory variableFactory, Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

