/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.source.accessor;

import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrInputDataException;
import com.linkedin.feathr.offline.source.DataSource;
import com.linkedin.feathr.offline.source.accessor.DataSourceAccessor;
import com.linkedin.feathr.offline.source.accessor.DatePartition;
import com.linkedin.feathr.offline.source.accessor.PathPartitionedTimeSeriesSourceAccessor;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderFactory;
import com.linkedin.feathr.offline.source.pathutil.PathChecker;
import com.linkedin.feathr.offline.source.pathutil.PathInfo;
import com.linkedin.feathr.offline.source.pathutil.TimeBasedHdfsPathGenerator;
import com.linkedin.feathr.offline.util.PartitionLimiter;
import com.linkedin.feathr.offline.util.datetime.DateTimeInterval;
import com.linkedin.feathr.offline.util.datetime.DateTimeInterval$;
import com.linkedin.feathr.offline.util.datetime.OfflineDateTimeUtils$;
import java.io.Serializable;
import java.time.ZonedDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;

public final class PathPartitionedTimeSeriesSourceAccessor$ {
    public static PathPartitionedTimeSeriesSourceAccessor$ MODULE$;
    private final Logger com$linkedin$feathr$offline$source$accessor$PathPartitionedTimeSeriesSourceAccessor$$log;

    static {
        new PathPartitionedTimeSeriesSourceAccessor$();
    }

    public Logger com$linkedin$feathr$offline$source$accessor$PathPartitionedTimeSeriesSourceAccessor$$log() {
        return this.com$linkedin$feathr$offline$source$accessor$PathPartitionedTimeSeriesSourceAccessor$$log;
    }

    public DataSourceAccessor apply(PathChecker pathChecker, DataLoaderFactory fileLoaderFactory, PartitionLimiter partitionLimiter, PathInfo pathInfo, DataSource source, DateTimeInterval timeInterval, boolean failOnMissingPartition, boolean addTimestampColumn) {
        String timeFormatString;
        String postPath;
        String postfixPath;
        TimeBasedHdfsPathGenerator pathGenerator = new TimeBasedHdfsPathGenerator(pathChecker);
        Enumeration.Value dateTimeResolution = pathInfo.dateTimeResolution();
        Seq<String> pathList = pathGenerator.generate(pathInfo, timeInterval, !failOnMissingPartition, postfixPath = (postPath = source.postPath()).isEmpty() || postPath.startsWith("/") ? postPath : new StringBuilder(1).append("/").append(postPath).toString());
        Seq dataframes = (Seq)pathList.map(arg_0 -> PathPartitionedTimeSeriesSourceAccessor$.$anonfun$apply$1(timeFormatString = pathInfo.datePathPattern(), postfixPath, dateTimeResolution, fileLoaderFactory, arg_0), Seq$.MODULE$.canBuildFrom());
        if (dataframes.isEmpty()) {
            String errMsg = new StringBuilder(117).append("Input data is empty for creating TimeSeriesSource. No available ").append("date partition exist in HDFS for path ").append(pathInfo.basePath()).append(" between ").append(timeInterval.getStart()).append(" and ").append(timeInterval.getEnd()).append(" ").toString();
            String errMsgPf = new StringBuilder(18).append(errMsg).append("with postfix path ").append(postfixPath).toString();
            if (postfixPath.isEmpty()) {
                throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, errMsg);
            }
            throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, errMsgPf);
        }
        Seq datePartitions = (Seq)dataframes.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Dataset df = (Dataset)tuple2._1();
            DateTimeInterval interval = (DateTimeInterval)tuple2._2();
            DatePartition datePartition = new DatePartition((Dataset<Row>)df, interval);
            return datePartition;
        }, Seq$.MODULE$.canBuildFrom());
        return new PathPartitionedTimeSeriesSourceAccessor((Seq<DatePartition>)datePartitions, source, timeInterval, dateTimeResolution, failOnMissingPartition, addTimestampColumn, partitionLimiter);
    }

    public static final /* synthetic */ Tuple2 $anonfun$apply$1(String timeFormatString$1, String postfixPath$1, Enumeration.Value dateTimeResolution$1, DataLoaderFactory fileLoaderFactory$1, String path) {
        String timeStr = path.substring(path.length() - (timeFormatString$1.length() + postfixPath$1.length()), path.length() - postfixPath$1.length());
        ZonedDateTime time = OfflineDateTimeUtils$.MODULE$.createTimeFromString(timeStr, timeFormatString$1, OfflineDateTimeUtils$.MODULE$.createTimeFromString$default$3());
        DateTimeInterval interval = DateTimeInterval$.MODULE$.createFromInclusive(time, time, dateTimeResolution$1);
        Dataset<Row> df = fileLoaderFactory$1.create(path).loadDataFrame();
        return new Tuple2(df, (Object)interval);
    }

    private PathPartitionedTimeSeriesSourceAccessor$() {
        MODULE$ = this;
        this.com$linkedin$feathr$offline$source$accessor$PathPartitionedTimeSeriesSourceAccessor$$log = LogManager.getLogger(this.getClass());
    }
}

