/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.source.accessor;

import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrInputDataException;
import com.linkedin.feathr.offline.source.DataSource;
import com.linkedin.feathr.offline.source.accessor.DataSourceAccessor;
import com.linkedin.feathr.offline.source.accessor.DatePartition;
import com.linkedin.feathr.offline.source.accessor.PathPartitionedTimeSeriesSourceAccessor$;
import com.linkedin.feathr.offline.source.accessor.TimeBasedDataSourceAccessor;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderFactory;
import com.linkedin.feathr.offline.source.pathutil.PathChecker;
import com.linkedin.feathr.offline.source.pathutil.PathInfo;
import com.linkedin.feathr.offline.swa.SlidingWindowFeatureUtils$;
import com.linkedin.feathr.offline.transformation.DataFrameExt$;
import com.linkedin.feathr.offline.util.PartitionLimiter;
import com.linkedin.feathr.offline.util.datetime.DateTimeInterval;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]e!B\n\u0015\u0001a\u0001\u0003\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u0013]\u0001!\u0011!Q\u0001\nab\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011!\u0003!\u0011!Q\u0001\n%C\u0001B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\t?\u0002\u0011\t\u0011)A\u00057\"A\u0001\r\u0001B\u0001B\u0003%\u0011\rC\u0003f\u0001\u0011\u0005a\rC\u0003p\u0001\u0011\u0005\u0003\u000fC\u0004\u0002\u001a\u0001!\t!a\u0007\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!9\u0011q\u0005\u0001\u0005\n\u0005%r\u0001CA\u001d)!\u0005\u0001$a\u000f\u0007\u000fM!\u0002\u0012\u0001\r\u0002>!1QM\u0004C\u0001\u0003\u000bB\u0011\"a\u0012\u000f\u0005\u0004%I!!\u0013\t\u0011\u0005mc\u0002)A\u0005\u0003\u0017Bq!!\u0018\u000f\t\u0003\tyFA\u0014QCRD\u0007+\u0019:uSRLwN\\3e)&lWmU3sS\u0016\u001c8k\\;sG\u0016\f5mY3tg>\u0014(BA\u000b\u0017\u0003!\t7mY3tg>\u0014(BA\f\u0019\u0003\u0019\u0019x.\u001e:dK*\u0011\u0011DG\u0001\b_\u001a4G.\u001b8f\u0015\tYB$\u0001\u0004gK\u0006$\bN\u001d\u0006\u0003;y\t\u0001\u0002\\5oW\u0016$\u0017N\u001c\u0006\u0002?\u0005\u00191m\\7\u0014\u0005\u0001\t\u0003C\u0001\u0012$\u001b\u0005!\u0012B\u0001\u0013\u0015\u0005m!\u0016.\\3CCN,G\rR1uCN{WO]2f\u0003\u000e\u001cWm]:pe\u0006qA-\u0019;f!\u0006\u0014H/\u001b;j_:\u001c8\u0001\u0001\t\u0004QI*dBA\u00150\u001d\tQS&D\u0001,\u0015\tac%\u0001\u0004=e>|GOP\u0005\u0002]\u0005)1oY1mC&\u0011\u0001'M\u0001\ba\u0006\u001c7.Y4f\u0015\u0005q\u0013BA\u001a5\u0005\r\u0019V-\u001d\u0006\u0003aE\u0002\"A\t\u001c\n\u0005]\"\"!\u0004#bi\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002:u5\ta#\u0003\u0002<-\tQA)\u0019;b'>,(oY3\n\u0005]i\u0014B\u0001 \u0015\u0005I!\u0015\r^1T_V\u00148-Z!dG\u0016\u001c8o\u001c:\u0002%M|WO]2f)&lW-\u00138uKJ4\u0018\r\u001c\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000b\u0001\u0002Z1uKRLW.\u001a\u0006\u0003\u000bb\tA!\u001e;jY&\u0011qI\u0011\u0002\u0011\t\u0006$X\rV5nK&sG/\u001a:wC2\f!\u0003Z1uKRKW.\u001a*fg>dW\u000f^5p]B\u0011!j\u0016\b\u0003\u0017Rs!\u0001\u0014*\u000f\u00055\u000bfB\u0001(Q\u001d\tQs*C\u0001 \u0013\tib$\u0003\u0002\u001c9%\u00111KG\u0001\u0007G>lWn\u001c8\n\u0005U3\u0016A\u0005#bi\u0016$\u0016.\\3SKN|G.\u001e;j_:T!a\u0015\u000e\n\u0005aK&A\u0005#bi\u0016$\u0016.\\3SKN|G.\u001e;j_:T!!\u0016,\u0002-\u0019\f\u0017\u000e\\(o\u001b&\u001c8/\u001b8h!\u0006\u0014H/\u001b;j_:\u0004\"\u0001X/\u000e\u0003EJ!AX\u0019\u0003\u000f\t{w\u000e\\3b]\u0006\u0011\u0012\r\u001a3US6,7\u000f^1na\u000e{G.^7o\u0003A\u0001\u0018M\u001d;ji&|g\u000eT5nSR,'\u000f\u0005\u0002cG6\tA)\u0003\u0002e\t\n\u0001\u0002+\u0019:uSRLwN\u001c'j[&$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011\u001dD\u0017N[6m[:\u0004\"A\t\u0001\t\u000b\u0015B\u0001\u0019A\u0014\t\u000b]A\u0001\u0019\u0001\u001d\t\u000b}B\u0001\u0019\u0001!\t\u000b!C\u0001\u0019A%\t\u000biC\u0001\u0019A.\t\u000b}C\u0001\u0019A.\t\u000b\u0001D\u0001\u0019A1\u0002\u0007\u001d,G\u000fF\u0002r\u0003\u001f\u00012A]A\u0005\u001d\r\u0019\u0018Q\u0001\b\u0003i~t!!\u001e?\u000f\u0005YLhB\u0001\u0016x\u0013\u0005A\u0018aA8sO&\u0011!p_\u0001\u0007CB\f7\r[3\u000b\u0003aL!! @\u0002\u000bM\u0004\u0018M]6\u000b\u0005i\\\u0018\u0002BA\u0001\u0003\u0007\t1a]9m\u0015\tih0C\u00021\u0003\u000fQA!!\u0001\u0002\u0004%!\u00111BA\u0007\u0005%!\u0015\r^1Ge\u0006lWMC\u00021\u0003\u000fAq!!\u0005\n\u0001\u0004\t\u0019\"A\buS6,\u0017J\u001c;feZ\fGn\u00149u!\u0011a\u0016Q\u0003!\n\u0007\u0005]\u0011G\u0001\u0004PaRLwN\\\u0001\u001fO\u0016$H)\u0019;f!\u0006\u0014H/\u001b;j_:<\u0016\u000e\u001e5j]&sG/\u001a:wC2$2aJA\u000f\u0011\u001d\t\tB\u0003a\u0001\u0003'\t1c\u001c<fe2\f\u0007oV5uQ&sG/\u001a:wC2$2aWA\u0012\u0011\u0019\t)c\u0003a\u0001\u0001\u0006A\u0011N\u001c;feZ\fG.A\u000bwC2LG-\u0019;f\t\u0006$X\rU1si&$\u0018n\u001c8\u0015\r\u0005-\u0012\u0011GA\u001b!\ra\u0016QF\u0005\u0004\u0003_\t$\u0001B+oSRDa!a\r\r\u0001\u00049\u0013AF:fY\u0016\u001cG/\u001a3ECR,\u0007+\u0019:uSRLwN\\:\t\r\u0005]B\u00021\u0001A\u00031!\u0018.\\3J]R,'O^1m\u0003\u001d\u0002\u0016\r\u001e5QCJ$\u0018\u000e^5p]\u0016$G+[7f'\u0016\u0014\u0018.Z:T_V\u00148-Z!dG\u0016\u001c8o\u001c:\u0011\u0005\tr1c\u0001\b\u0002@A\u0019A,!\u0011\n\u0007\u0005\r\u0013G\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003w\t1\u0001\\8h+\t\tY\u0005\u0005\u0003\u0002N\u0005]SBAA(\u0015\u0011\t\t&a\u0015\u0002\u000b1|w\r\u000e6\u000b\u0007\u0005Uc0A\u0004m_\u001e<\u0017N\\4\n\t\u0005e\u0013q\n\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\rI\u0001\u0006CB\u0004H.\u001f\u000b\u0013\u0003C\n\u0019'a\u001d\u0002\u0004\u0006\u0015\u0015qRAI\u0003'\u000b)\n\u0005\u0002#{!9\u0011Q\r\nA\u0002\u0005\u001d\u0014a\u00039bi\"\u001c\u0005.Z2lKJ\u0004B!!\u001b\u0002p5\u0011\u00111\u000e\u0006\u0004\u0003[2\u0012\u0001\u00039bi\",H/\u001b7\n\t\u0005E\u00141\u000e\u0002\f!\u0006$\bn\u00115fG.,'\u000fC\u0004\u0002vI\u0001\r!a\u001e\u0002#\u0019LG.\u001a'pC\u0012,'OR1di>\u0014\u0018\u0010\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\tiHF\u0001\u000bI\u0006$\u0018\r\\8bI\u0016\u0014\u0018\u0002BAA\u0003w\u0012\u0011\u0003R1uC2{\u0017\rZ3s\r\u0006\u001cGo\u001c:z\u0011\u0015\u0001'\u00031\u0001b\u0011\u001d\t9I\u0005a\u0001\u0003\u0013\u000b\u0001\u0002]1uQ&sgm\u001c\t\u0005\u0003S\nY)\u0003\u0003\u0002\u000e\u0006-$\u0001\u0003)bi\"LeNZ8\t\u000b]\u0011\u0002\u0019\u0001\u001d\t\r\u0005]\"\u00031\u0001A\u0011\u0015Q&\u00031\u0001\\\u0011\u0015y&\u00031\u0001\\\u0001")
public class PathPartitionedTimeSeriesSourceAccessor
extends TimeBasedDataSourceAccessor {
    private final Seq<DatePartition> datePartitions;
    private final Enumeration.Value dateTimeResolution;
    private final boolean failOnMissingPartition;
    private final boolean addTimestampColumn;
    private final PartitionLimiter partitionLimiter;

    public static DataSourceAccessor apply(PathChecker pathChecker, DataLoaderFactory dataLoaderFactory, PartitionLimiter partitionLimiter, PathInfo pathInfo, DataSource dataSource, DateTimeInterval dateTimeInterval, boolean bl, boolean bl2) {
        return PathPartitionedTimeSeriesSourceAccessor$.MODULE$.apply(pathChecker, dataLoaderFactory, partitionLimiter, pathInfo, dataSource, dateTimeInterval, bl, bl2);
    }

    @Override
    public Dataset<Row> get(Option<DateTimeInterval> timeIntervalOpt) {
        Seq seq;
        Seq<DatePartition> selectedDatePartitions = this.getDatePartitionWithinInterval(timeIntervalOpt);
        if (timeIntervalOpt.isDefined() && this.failOnMissingPartition) {
            this.validateDatePartition(selectedDatePartitions, (DateTimeInterval)timeIntervalOpt.get());
        }
        if (this.addTimestampColumn) {
            PathPartitionedTimeSeriesSourceAccessor$.MODULE$.com$linkedin$feathr$offline$source$accessor$PathPartitionedTimeSeriesSourceAccessor$$log().info(new StringBuilder(34).append("added timestamp column to source ").append(super.source().path()).append(".").toString());
            seq = (Seq)selectedDatePartitions.map((Function1 & Serializable & scala.Serializable)partition -> partition.df().withColumn(SlidingWindowFeatureUtils$.MODULE$.TIMESTAMP_PARTITION_COLUMN(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)partition.dateInterval().getStart().toEpochSecond()))), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)selectedDatePartitions.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.df(), Seq$.MODULE$.canBuildFrom());
        }
        Seq dataFrames = seq;
        Dataset df = (Dataset)dataFrames.reduce((Function2 & Serializable & scala.Serializable)(x, y) -> DataFrameExt$.MODULE$.DataFrameMethods((Dataset<Row>)x).fuzzyUnion((Dataset<Row>)y));
        return this.partitionLimiter.limitPartition((Dataset<Row>)df);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<DatePartition> getDatePartitionWithinInterval(Option<DateTimeInterval> timeIntervalOpt) {
        void var3_6;
        Seq seq;
        Option<DateTimeInterval> option = timeIntervalOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            DateTimeInterval interval = (DateTimeInterval)some.value();
            seq = (Seq)this.datePartitions.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PathPartitionedTimeSeriesSourceAccessor.$anonfun$getDatePartitionWithinInterval$1(interval, x$2)));
        } else if (None$.MODULE$.equals(option)) {
            seq = this.datePartitions;
        } else {
            throw new MatchError(option);
        }
        Seq selectedPartitions = seq;
        if (selectedPartitions.isEmpty()) {
            throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(106).append("Trying to create TimeSeriesSource but no data ").append("is found to create source data. Source path: ").append(super.source().path()).append(", source type: ").append(super.source().sourceType()).toString());
        }
        return var3_6;
    }

    @Override
    public boolean overlapWithInterval(DateTimeInterval interval) {
        return this.datePartitions.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PathPartitionedTimeSeriesSourceAccessor.$anonfun$overlapWithInterval$1(interval, x$3)));
    }

    private void validateDatePartition(Seq<DatePartition> selectedDatePartitions, DateTimeInterval timeInterval) {
        Seq availableDates;
        Set allDates = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timeInterval.getAllTimeWithinInterval(this.dateTimeResolution))).toSet();
        Set missingDates = (Set)allDates.$minus$minus((GenTraversableOnce)(availableDates = (Seq)selectedDatePartitions.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.dateInterval().getStart(), Seq$.MODULE$.canBuildFrom())));
        if (missingDates.nonEmpty()) {
            String missingDateStr = missingDates.mkString(",");
            throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(93).append("The following date partitions ").append(missingDateStr).append(" are missing from the source data. ").append("Source path: ").append(super.source().path()).append(", source type: ").append(super.source().sourceType()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$getDatePartitionWithinInterval$1(DateTimeInterval interval$1, DatePartition x$2) {
        return x$2.dateInterval().overlaps(interval$1);
    }

    public static final /* synthetic */ boolean $anonfun$overlapWithInterval$1(DateTimeInterval interval$2, DatePartition x$3) {
        return x$3.dateInterval().overlaps(interval$2);
    }

    public PathPartitionedTimeSeriesSourceAccessor(Seq<DatePartition> datePartitions, DataSource source, DateTimeInterval sourceTimeInterval, Enumeration.Value dateTimeResolution, boolean failOnMissingPartition, boolean addTimestampColumn, PartitionLimiter partitionLimiter) {
        this.datePartitions = datePartitions;
        this.dateTimeResolution = dateTimeResolution;
        this.failOnMissingPartition = failOnMissingPartition;
        this.addTimestampColumn = addTimestampColumn;
        this.partitionLimiter = partitionLimiter;
        super(source, sourceTimeInterval, failOnMissingPartition);
    }
}

