/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.source.dataloader;

import com.databricks.spark.avro.SchemaConverterUtils$;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jasonclawson.jackson.dataformat.hocon.HoconFactory;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.util.Try$;

public final class AvroJsonDataLoader$
implements scala.Serializable {
    public static AvroJsonDataLoader$ MODULE$;

    static {
        new AvroJsonDataLoader$();
    }

    public Dataset<Row> convertRDD2DF(SparkSession ss, Tuple2<RDD<?>, Schema> res) {
        Schema schema = (Schema)res._2();
        StructType sqlType = (StructType)SchemaConverters$.MODULE$.toSqlType(schema).dataType();
        Function1<Object, Object> converter = SchemaConverterUtils$.MODULE$.converterSql(schema, (DataType)sqlType);
        Row[] rows = (Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((RDD)res._1()).collect())).flatMap((Function1 & Serializable & scala.Serializable)record -> Option$.MODULE$.option2Iterable(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Row)converter.apply(record)).toOption()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
        return ss.createDataFrame(Arrays.asList((Object[])rows), sqlType);
    }

    public <T> Tuple2<RDD<?>, Schema> parseJsonAsAvroRDD(SparkSession ss, JsonNode jsonDataNode, String schemaAsString, ClassTag<T> tag) {
        SparkContext sc = ss.sparkContext();
        Schema schema = Schema.parse((String)schemaAsString);
        Iterable records = (Iterable)((WrapAsScala)package$.MODULE$.wrapAll()).deprecated$u0020iterableAsScalaIterable((java.lang.Iterable)jsonDataNode).map((Function1 & Serializable & scala.Serializable)jsonNode -> {
            Object object;
            ByteArrayInputStream input = new ByteArrayInputStream(jsonNode.toString().getBytes());
            DataInputStream din = new DataInputStream(input);
            JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, (InputStream)din);
            if (!SpecificRecordBase.class.isAssignableFrom(scala.reflect.package$.MODULE$.classTag(tag).runtimeClass())) {
                GenericDatumReader reader = new GenericDatumReader(schema);
                object = reader.read(null, (Decoder)decoder);
            } else {
                SpecificDatumReader reader = new SpecificDatumReader(scala.reflect.package$.MODULE$.classTag(tag).runtimeClass());
                object = reader.read(null, (Decoder)decoder);
            }
            return object;
        }, Iterable$.MODULE$.canBuildFrom());
        return new Tuple2((Object)sc.parallelize(records.toSeq(), sc.parallelize$default$2(), ClassTag$.MODULE$.Any()), (Object)schema);
    }

    public <T> Tuple2<RDD<?>, Schema> loadJsonFileAsAvroToRDD(SparkSession ss, String path, ClassTag<T> tag) {
        SparkContext sc = ss.sparkContext();
        Predef$.MODULE$.require(sc.isLocal());
        Predef$.MODULE$.require(path.endsWith(".avro.json"));
        String contents = Source$.MODULE$.fromResource(path, Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
        ObjectMapper jackson = new ObjectMapper((JsonFactory)new HoconFactory());
        JsonNode tree = jackson.readTree(contents);
        JsonNode jsonDataArray = tree.get("data");
        return this.parseJsonAsAvroRDD(ss, jsonDataArray, tree.get("schema").toString(), tag);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private AvroJsonDataLoader$() {
        MODULE$ = this;
    }
}

