/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.source.dataloader.jdbc;

import com.linkedin.feathr.offline.source.dataloader.jdbc.JdbcConnector;
import com.linkedin.feathr.offline.source.dataloader.jdbc.JdbcConnectorChooser$;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;

public final class JdbcUtils$ {
    public static JdbcUtils$ MODULE$;
    private final String DRIVER_CONF;
    private final String DBTABLE_CONF;
    private final String USER_CONF;
    private final String PASSWORD_CONF;
    private final String AUTH_FLAG_CONF;
    private final String TOKEN_FLAG;
    private final String TOKEN_CONF;

    static {
        new JdbcUtils$();
    }

    public String DRIVER_CONF() {
        return this.DRIVER_CONF;
    }

    public String DBTABLE_CONF() {
        return this.DBTABLE_CONF;
    }

    public String USER_CONF() {
        return this.USER_CONF;
    }

    public String PASSWORD_CONF() {
        return this.PASSWORD_CONF;
    }

    public String AUTH_FLAG_CONF() {
        return this.AUTH_FLAG_CONF;
    }

    public String TOKEN_FLAG() {
        return this.TOKEN_FLAG;
    }

    public String TOKEN_CONF() {
        return this.TOKEN_CONF;
    }

    public Map<String, String> getJDBCOptionsWithoutAuth(SparkSession ss) {
        Map$ map$ = Predef$.MODULE$.Map();
        Tuple2[] tuple2Array = new Tuple2[1];
        Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)ss.conf().get(this.DBTABLE_CONF()));
        tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"driver"), ss.conf().getOption(this.DRIVER_CONF()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> ""));
        return (Map)map$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
    }

    public Map<String, String> getJDBCOptionsWithPassword(SparkSession ss) {
        Map$ map$ = Predef$.MODULE$.Map();
        Tuple2[] tuple2Array = new Tuple2[1];
        Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)ss.conf().get(this.DBTABLE_CONF()));
        Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)ss.conf().get(this.USER_CONF()));
        Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"password"), (Object)ss.conf().get(this.PASSWORD_CONF()));
        tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"driver"), (Object)ss.conf().get(this.DRIVER_CONF()));
        return (Map)map$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
    }

    public Map<String, String> getJDBCOptionsWithToken(SparkSession ss) {
        Map$ map$ = Predef$.MODULE$.Map();
        Tuple2[] tuple2Array = new Tuple2[1];
        Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)ss.conf().get(this.DBTABLE_CONF()));
        Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"accessToken"), (Object)ss.conf().get(this.TOKEN_CONF()));
        tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"driver"), (Object)ss.conf().get(this.DRIVER_CONF()));
        return (Map)map$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
    }

    public void parseJDBCConfigs(SparkConf sparkConf, String dbTable, String user, String password, String driver) {
        sparkConf.set(this.DBTABLE_CONF(), dbTable);
        sparkConf.set(this.USER_CONF(), user);
        sparkConf.set(this.PASSWORD_CONF(), password);
        sparkConf.set(this.DRIVER_CONF(), driver);
    }

    public void parseJDBCConfigs(SparkConf sparkConf, String dbTable, String accessToken, String driver) {
        sparkConf.set(this.DBTABLE_CONF(), dbTable);
        sparkConf.set(this.TOKEN_CONF(), accessToken);
        sparkConf.set(this.DRIVER_CONF(), driver);
    }

    public Dataset<Row> loadDataFrame(SparkSession ss, String url) {
        JdbcConnector jdbcConnector = JdbcConnectorChooser$.MODULE$.getJdbcConnector(ss, url);
        Map<String, String> jdbcOptions = jdbcConnector.extractJdbcOptions(ss, url);
        return jdbcConnector.loadDataFrame(url, jdbcOptions);
    }

    private JdbcUtils$() {
        MODULE$ = this;
        this.DRIVER_CONF = "feathr.jdbc.driver";
        this.DBTABLE_CONF = "feathr.jdbc.dbtable";
        this.USER_CONF = "feathr.jdbc.user";
        this.PASSWORD_CONF = "feathr.jdbc.password";
        this.AUTH_FLAG_CONF = "feathr.jdbc.authflag";
        this.TOKEN_FLAG = "token";
        this.TOKEN_CONF = "feathr.jdbc.token";
    }
}

