/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.source.dataloader.stream;

import com.linkedin.feathr.offline.config.datasource.KafkaResourceInfoSetter$;
import com.linkedin.feathr.offline.config.location.KafkaEndpoint;
import com.linkedin.feathr.offline.source.dataloader.stream.StreamDataLoader;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.DataStreamReader;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y4A\u0001D\u0007\u00019!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0011\u00159\u0004\u0001\"\u00019\u0011\u001da\u0004A1A\u0005\u0002uBaA\u0012\u0001!\u0002\u0013q\u0004bB$\u0001\u0005\u0004%\t!\u0010\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002 \t\u000b%\u0003A\u0011\u0002&\t\u000ba\u0003A\u0011I-\t\u000b\u0015\u0004A\u0011\t4\t\u000bY\u0004A\u0011I<\u0003\u001f-\u000bgm[1ECR\fGj\\1eKJT!AD\b\u0002\rM$(/Z1n\u0015\t\u0001\u0012#\u0001\u0006eCR\fGn\\1eKJT!AE\n\u0002\rM|WO]2f\u0015\t!R#A\u0004pM\u001ad\u0017N\\3\u000b\u0005Y9\u0012A\u00024fCRD'O\u0003\u0002\u00193\u0005AA.\u001b8lK\u0012LgNC\u0001\u001b\u0003\r\u0019w.\\\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001f?5\tQ\"\u0003\u0002!\u001b\t\u00012\u000b\u001e:fC6$\u0015\r^1M_\u0006$WM]\u0001\u0003gN\u0004\"a\t\u0017\u000e\u0003\u0011R!!\n\u0014\u0002\u0007M\fHN\u0003\u0002(Q\u0005)1\u000f]1sW*\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0013\tiCE\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0003j]B,H\u000f\u0005\u00021k5\t\u0011G\u0003\u00023g\u0005AAn\\2bi&|gN\u0003\u00025'\u000511m\u001c8gS\u001eL!AN\u0019\u0003\u001b-\u000bgm[1F]\u0012\u0004x.\u001b8u\u0003\u0019a\u0014N\\5u}Q\u0019\u0011HO\u001e\u0011\u0005y\u0001\u0001\"B\u0011\u0004\u0001\u0004\u0011\u0003\"\u0002\u0018\u0004\u0001\u0004y\u0013A\u00024pe6\fG/F\u0001?!\tyD)D\u0001A\u0015\t\t%)\u0001\u0003mC:<'\"A\"\u0002\t)\fg/Y\u0005\u0003\u000b\u0002\u0013aa\u0015;sS:<\u0017a\u00024pe6\fG\u000fI\u0001\u0010W\u000647.Y*bg2\u001cuN\u001c4jO\u0006\u00012.\u00194lCN\u000b7\u000f\\\"p]\u001aLw\rI\u0001\rO\u0016$8*\u00194lC\u0006+H\u000f\u001b\u000b\u0003\u0017^\u0003\"\u0001T+\u000f\u00055\u001b\u0006C\u0001(R\u001b\u0005y%B\u0001)\u001c\u0003\u0019a$o\\8u})\t!+A\u0003tG\u0006d\u0017-\u0003\u0002U#\u00061\u0001K]3eK\u001aL!!\u0012,\u000b\u0005Q\u000b\u0006\"B\u0011\t\u0001\u0004\u0011\u0013aC4fi\u00123%+Z1eKJ$\"A\u00171\u0011\u0005msV\"\u0001/\u000b\u0005u#\u0013!C:ue\u0016\fW.\u001b8h\u0013\tyFL\u0001\tECR\f7\u000b\u001e:fC6\u0014V-\u00193fe\")\u0011-\u0003a\u0001E\u0006a1.\u00194lC>\u0003H/[8ogB!AjY&L\u0013\t!gKA\u0002NCB\fQ\u0002\\8bI\u0012\u000bG/\u0019$sC6,G#A4\u0011\u0005!\u001chBA5r\u001d\tQ\u0007O\u0004\u0002l_:\u0011AN\u001c\b\u0003\u001d6L\u0011aK\u0005\u0003S)J!a\n\u0015\n\u0005\u00152\u0013B\u0001:%\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001^;\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u0001:%\u0003)aw.\u00193TG\",W.\u0019\u000b\u0002qB\u0011\u0011\u0010`\u0007\u0002u*\u00111\u0010K\u0001\u0005CZ\u0014x.\u0003\u0002~u\n11k\u00195f[\u0006\u0004")
public class KafkaDataLoader
extends StreamDataLoader {
    private final SparkSession ss;
    private final KafkaEndpoint input;
    private final String format;
    private final String kafkaSaslConfig;

    public String format() {
        return this.format;
    }

    public String kafkaSaslConfig() {
        return this.kafkaSaslConfig;
    }

    private String getKafkaAuth(SparkSession ss) {
        Option option = ss.conf().getOption(this.kafkaSaslConfig());
        if (!(option instanceof Some)) {
            throw new RuntimeException(new StringBuilder(56).append("Invalid Kafka authentication! ").append(this.kafkaSaslConfig()).append(" is not set in Spark conf.").toString());
        }
        Some some = (Some)option;
        String sasl = (String)some.value();
        String string = new StringBuilder(106).append("org.apache.kafka.common.security.plain.PlainLoginModule required username=\"$ConnectionString\" password=\"").append(sasl).append("\";").toString();
        return string;
    }

    @Override
    public DataStreamReader getDFReader(Map<String, String> kafkaOptions) {
        String EH_SASL = this.getKafkaAuth(this.ss);
        return this._ss().readStream().format(this.format()).options(kafkaOptions).option("kafka.group.id", UUID.randomUUID().toString()).option("kafka.sasl.jaas.config", EH_SASL).option("kafka.sasl.mechanism", "PLAIN").option("kafka.security.protocol", "SASL_SSL").option("kafka.request.timeout.ms", "60000").option("kafka.session.timeout.ms", "60000").option("failOnDataLoss", "false");
    }

    @Override
    public Dataset<Row> loadDataFrame() {
        String topic = this.input.topics().mkString(",");
        String bootstrapServers = this.input.brokers().mkString(",");
        return this.getDFReader((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))).option("subscribe", topic).option("kafka.bootstrap.servers", bootstrapServers).load();
    }

    @Override
    public Schema loadSchema() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public KafkaDataLoader(SparkSession ss, KafkaEndpoint input) {
        this.ss = ss;
        this.input = input;
        super(ss);
        this.format = "kafka";
        this.kafkaSaslConfig = KafkaResourceInfoSetter$.MODULE$.SASL_JAAS_CONFIG();
    }
}

