/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.transformation;

import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.FeatureTypes;
import com.linkedin.feathr.common.FeatureValue;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.offline.transformation.DataFrameDefaultValueSubstituter;
import com.linkedin.feathr.offline.transformation.DefaultFeatureValueToColumnConverterFactory$;
import com.linkedin.feathr.offline.transformation.DefaultValueSubstituter;
import com.linkedin.feathr.offline.transformation.FeatureValueToColumnConverter;
import com.linkedin.feathr.offline.util.FeaturizedDatasetUtils$;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.WrappedArray;

public final class DataFrameDefaultValueSubstituter$
implements DataFrameDefaultValueSubstituter {
    public static DataFrameDefaultValueSubstituter$ MODULE$;

    static {
        new DataFrameDefaultValueSubstituter$();
    }

    @Override
    public Function1<String, String> substituteDefaults$default$6() {
        return DefaultValueSubstituter.substituteDefaults$default$6$(this);
    }

    @Override
    public Dataset<Row> substituteDefaults(Dataset<Row> inputDF, Seq<String> featureNames, Map<String, FeatureValue> parsedDefaults, Map<String, FeatureTypeConfig> featureTypes, SparkSession ss, Function1<String, String> featureFieldResolver) {
        return (Dataset)featureNames.foldLeft(inputDF, (Function2 & Serializable & scala.Serializable)(baseDF, featureName) -> MODULE$.processDefaultSingleFeature((Dataset<Row>)baseDF, (String)featureName, parsedDefaults, featureTypes, ss, featureFieldResolver, DefaultFeatureValueToColumnConverterFactory$.MODULE$.getConverter((String)featureName, DefaultFeatureValueToColumnConverterFactory$.MODULE$.getConverter$default$2())));
    }

    private Dataset<Row> processDefaultSingleFeature(Dataset<Row> inputDF, String featureName, Map<String, FeatureValue> parsedDefaults, Map<String, FeatureTypeConfig> featureTypes, SparkSession ss, Function1<String, String> featureFieldResolver, FeatureValueToColumnConverter valueToColumnConverter) {
        Dataset dataset;
        Option rawMaybeDefaultVal = parsedDefaults.get((Object)featureName);
        if (rawMaybeDefaultVal.isEmpty()) {
            dataset = inputDF;
        } else {
            Column column;
            FeatureValue defaultFeatureValue = (FeatureValue)rawMaybeDefaultVal.get();
            String featureColumnName = (String)featureFieldResolver.apply((Object)featureName);
            int fieldIndex = inputDF.schema().fieldIndex(featureColumnName);
            StructField field = (StructField)inputDF.schema().toList().apply(fieldIndex);
            FeatureTypes inferredType = FeaturizedDatasetUtils$.MODULE$.inferFeatureType(FeatureTypes.UNSPECIFIED, (Option<DataType>)new Some((Object)field.dataType()));
            FeatureTypeConfig featureTypeConfig = (FeatureTypeConfig)featureTypes.getOrElse((Object)featureName, (Function0 & Serializable & scala.Serializable)() -> new FeatureTypeConfig(inferredType));
            FeatureTypes featureTypes2 = featureTypeConfig.getFeatureType();
            FeatureTypes featureTypes3 = FeatureTypes.TENSOR;
            if (!(featureTypes2 != null ? !((Object)((Object)featureTypes2)).equals((Object)featureTypes3) : featureTypes3 != null)) {
                DataType schema = field.dataType();
                TensorData tensorData = defaultFeatureValue.getAsTensorData();
                Object ts = FeaturizedDatasetUtils$.MODULE$.tensorToFDSDataFrameRow(tensorData, (Option<DataType>)new Some((Object)schema));
                UserDefinedFunction fdsTensorDefaultUDF = this.getFDSTensorDefaultUDF(schema, ts);
                ss.udf().register("tz_udf", fdsTensorDefaultUDF);
                column = functions$.MODULE$.expr(new StringBuilder(8).append("tz_udf(").append(featureColumnName).append(")").toString());
            } else {
                column = valueToColumnConverter.convert(featureName, (FeatureValue)rawMaybeDefaultVal.get(), field.dataType(), featureTypeConfig.getFeatureType());
            }
            Column defaultTypedLit = column;
            String tempFeatureColumnName = new StringBuilder(31).append("_temp_column_for_default_value_").append(featureColumnName).toString();
            dataset = inputDF.withColumn(tempFeatureColumnName, functions$.MODULE$.when(functions$.MODULE$.col(featureColumnName).isNull(), (Object)defaultTypedLit).otherwise((Object)functions$.MODULE$.col(featureColumnName))).drop(featureColumnName).withColumnRenamed(tempFeatureColumnName, featureColumnName);
        }
        return dataset;
    }

    private UserDefinedFunction getFDSTensorDefaultUDF(DataType schema, Object tensorData) {
        return functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x -> DataFrameDefaultValueSubstituter$.getFDSTensorDefaultUDF$1(x, tensorData), schema);
    }

    private static final Object getFDSTensorDefaultUDF$1(WrappedArray inputRow, Object tensorData$1) {
        return tensorData$1;
    }

    private DataFrameDefaultValueSubstituter$() {
        MODULE$ = this;
    }
}

