/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.transformation;

import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrException;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.util.CoercionUtils;
import com.linkedin.feathr.offline.util.FeaturizedDatasetUtils$;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.Wrappers;
import scala.collection.convert.Wrappers$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.WrappedArray;
import scala.collection.mutable.WrappedArray$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class FDSConversionUtils$ {
    public static FDSConversionUtils$ MODULE$;
    private final Wrappers.JMapWrapper<String, Object> trueValueMap;

    static {
        new FDSConversionUtils$();
    }

    public Wrappers.JMapWrapper<String, Object> trueValueMap() {
        return this.trueValueMap;
    }

    public Object rawToFDSRow(Object rawFeatureValue, DataType targetDataType) {
        Object object;
        if (rawFeatureValue == null) {
            return null;
        }
        Object object2 = rawFeatureValue;
        if (object2 instanceof TensorData) {
            TensorData tensorData = (TensorData)object2;
            object = FeaturizedDatasetUtils$.MODULE$.tensorToFDSDataFrameRow(tensorData, (Option<DataType>)new Some((Object)targetDataType));
        } else {
            ArrayType arrayType;
            StructType structType;
            Object object3;
            DataType dataType = targetDataType;
            if (IntegerType$.MODULE$.equals(dataType)) {
                object3 = BoxesRunTime.boxToInteger((int)this.parseIntValue(rawFeatureValue));
            } else if (LongType$.MODULE$.equals(dataType)) {
                object3 = BoxesRunTime.boxToLong((long)this.parseLongValue(rawFeatureValue));
            } else if (StringType$.MODULE$.equals(dataType)) {
                object3 = rawFeatureValue.toString();
            } else if (FloatType$.MODULE$.equals(dataType)) {
                object3 = this.parseFloatValue(rawFeatureValue);
            } else if (DoubleType$.MODULE$.equals(dataType)) {
                object3 = BoxesRunTime.boxToDouble((double)this.parseDoubleValue(rawFeatureValue));
            } else if (BooleanType$.MODULE$.equals(dataType)) {
                object3 = BoxesRunTime.boxToBoolean((boolean)this.parseBooleanValue(rawFeatureValue));
            } else if (dataType instanceof StructType && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(structType = (StructType)dataType).fields())).size() == 2) {
                object3 = this.convertRawValueTo1DFDSSparseTensorRow(rawFeatureValue, structType);
            } else if (dataType instanceof ArrayType && !((arrayType = (ArrayType)dataType).elementType() instanceof ArrayType)) {
                object3 = this.convertRawValueTo1DFDSDenseTensorRow(rawFeatureValue, arrayType);
            } else {
                throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(87).append("Converting ").append(rawFeatureValue).append(" to FDS Tensor type ").append(dataType).append(" is not supported. Only 0-D and 1-D tensor is supported.").toString());
            }
            object = object3;
        }
        return object;
    }

    private long parseLongValue(Object input) {
        Object object = input;
        if (!(object instanceof Number)) {
            throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(42).append("Provided data ").append(input).append(" can't be converted to Long.").toString());
        }
        Number number = (Number)object;
        long l = number.longValue();
        return l;
    }

    private double parseDoubleValue(Object input) {
        Object object = input;
        if (!(object instanceof Number)) {
            throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(44).append("Provided data ").append(input).append(" can't be converted to Double.").toString());
        }
        Number number = (Number)object;
        double d = number.doubleValue();
        return d;
    }

    private int parseIntValue(Object input) {
        int n;
        Object object = input;
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            n = (int)f;
        } else if (object instanceof Integer) {
            int n2;
            n = n2 = BoxesRunTime.unboxToInt((Object)object);
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            n = (int)l;
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            n = (int)d;
        } else if (object instanceof Number) {
            Number number = (Number)object;
            n = number.intValue();
        } else {
            n = object instanceof scala.collection.immutable.Map ? (int)BoxesRunTime.unboxToFloat((Object)((scala.collection.immutable.Map)object).values().head()) : new StringOps(Predef$.MODULE$.augmentString(object.toString())).toInt();
        }
        return n;
    }

    private Object parseFloatValue(Object input) {
        Float f;
        Object object = input;
        if (object instanceof Float) {
            float f2 = BoxesRunTime.unboxToFloat((Object)object);
            f = BoxesRunTime.boxToFloat((float)f2);
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            f = BoxesRunTime.boxToFloat((float)n);
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            f = BoxesRunTime.boxToFloat((float)l);
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            f = BoxesRunTime.boxToFloat((float)((float)d));
        } else if (object instanceof Number) {
            Number number = (Number)object;
            f = BoxesRunTime.boxToFloat((float)number.floatValue());
        } else {
            Wrappers.JMapWrapper nums;
            Seq nums2;
            Float f3 = object instanceof scala.collection.immutable.Map ? BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)((scala.collection.immutable.Map)object).values().head())) : (object instanceof GenericRowWithSchema ? ((nums2 = (Seq)((GenericRowWithSchema)object).getAs(FeaturizedDatasetUtils$.MODULE$.FDS_1D_TENSOR_VALUE())).nonEmpty() ? BoxesRunTime.boxToFloat((float)((Number)nums2.head()).floatValue()) : null) : (object instanceof Wrappers.JMapWrapper ? ((nums = (Wrappers.JMapWrapper)object).nonEmpty() ? BoxesRunTime.boxToFloat((float)((Number)((Tuple2)nums.head())._2()).floatValue()) : null) : BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(object.toString())).toFloat())));
            f = f3;
        }
        return f;
    }

    public boolean parseBooleanValue(Object input) {
        boolean bl;
        Object object = input;
        if (object instanceof Boolean) {
            boolean bl2;
            bl = bl2 = BoxesRunTime.unboxToBoolean((Object)object);
        } else if (object instanceof Wrappers.JMapWrapper && ((Wrappers.JMapWrapper)object).scala$collection$convert$Wrappers$JMapWrapper$$$outer() == Wrappers$.MODULE$) {
            boolean bl3;
            Wrappers.JMapWrapper jMapWrapper = (Wrappers.JMapWrapper)object;
            if (jMapWrapper.isEmpty()) {
                bl3 = false;
            } else if (jMapWrapper.equals(this.trueValueMap())) {
                bl3 = true;
            } else {
                throw new FeathrException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(132).append("Converting Map[String, Float] to boolean. Only empty ").append("map(false) or map from empty string to 1.0(true) is supported. But the map is: ").append(jMapWrapper).toString());
            }
            bl = bl3;
        } else {
            throw new FeathrException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(111).append("Can not convert unsupported data type ").append(input.getClass()).append(" ").append("for data ").append(input).append(" into boolean. Only boolean or Map[String, Float] is supported.").toString());
        }
        return bl;
    }

    public Object[] convertMapToFDS(scala.collection.immutable.Map<?, ?> mapValues, DataType valType, DataType dimType) {
        Object object;
        Object[] objectArray;
        Seq items = mapValues.toSeq();
        DataType dataType = dimType;
        if (dataType instanceof StringType) {
            objectArray = (Object[])((TraversableOnce)items.map((Function1 & Serializable & scala.Serializable)item -> item._1().toString(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        } else if (dataType instanceof IntegerType) {
            objectArray = (Object[])((TraversableOnce)items.map((Function1 & Serializable & scala.Serializable)item -> (Integer)item._1(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Integer.class));
        } else if (dataType instanceof LongType) {
            objectArray = (Object[])((TraversableOnce)items.map((Function1 & Serializable & scala.Serializable)item -> (Long)item._1(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Long.class));
        } else if (dataType instanceof BooleanType) {
            objectArray = (Object[])((TraversableOnce)items.map((Function1 & Serializable & scala.Serializable)item -> (Boolean)item._1(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Boolean.class));
        } else {
            throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(71).append("Converting ").append(mapValues).append(" to FDS Tensor type with dimension ").append("type of ").append(dimType).append(" is not supported").toString());
        }
        Object[] dimensions = objectArray;
        DataType dataType2 = valType;
        if (dataType2 instanceof IntegerType) {
            object = ((TraversableOnce)items.map((Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToInteger((int)FDSConversionUtils$.MODULE$.parseIntValue(value._2())), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        } else if (dataType2 instanceof LongType) {
            object = ((TraversableOnce)items.map((Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToLong((long)FDSConversionUtils$.MODULE$.parseLongValue(value._2())), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
        } else if (dataType2 instanceof StringType) {
            object = ((TraversableOnce)items.map((Function1 & Serializable & scala.Serializable)value -> value._2(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
        } else if (dataType2 instanceof FloatType) {
            object = ((TraversableOnce)items.map((Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToFloat((float)FDSConversionUtils$.$anonfun$convertMapToFDS$8(value)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Float());
        } else if (dataType2 instanceof DoubleType) {
            object = ((TraversableOnce)items.map((Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToDouble((double)FDSConversionUtils$.MODULE$.parseDoubleValue(value._2())), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
        } else if (dataType2 instanceof BooleanType) {
            object = ((TraversableOnce)items.map((Function1 & Serializable & scala.Serializable)value -> value._2(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
        } else {
            throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(67).append("Converting ").append(mapValues).append(" to FDS Tensor type with value type ").append("of ").append(valType).append(" is not supported").toString());
        }
        Object values = object;
        return new Object[]{dimensions, values};
    }

    private Object[] convertRawArrayToFDS1dTensor(Object values, DataType dataType, DataType dimType) {
        Object[] objectArray;
        int size = Predef$.MODULE$.genericArrayOps(values).size();
        if (size == 0) {
            objectArray = new Object[]{Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing()), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing())};
        } else {
            Object[] objectArray2;
            Object object = Predef$.MODULE$.genericArrayOps(values).head();
            if (object instanceof GenericRowWithSchema) {
                Tuple2[] termValues = (Tuple2[])Predef$.MODULE$.genericArrayOps(values).map((Function1 & Serializable & scala.Serializable)ele -> {
                    GenericRowWithSchema row = (GenericRowWithSchema)ele;
                    return new Tuple2((Object)row.get(0).toString(), (Object)BoxesRunTime.boxToFloat((float)((Number)row.getAs(1)).floatValue()));
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                Tuple2 tuple2 = new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])termValues)).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])termValues)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToFloat((float)FDSConversionUtils$.$anonfun$convertRawArrayToFDS1dTensor$3(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String[] terms = (String[])tuple2._1();
                float[] vals = (float[])tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)terms, (Object)vals);
                Tuple2 tuple23 = tuple22;
                String[] terms2 = (String[])tuple23._1();
                float[] vals2 = (float[])tuple23._2();
                objectArray2 = new Object[]{terms2, vals2};
            } else if (object instanceof Number) {
                String[] dims = (String[])Predef$.MODULE$.genericArrayOps(values).map((Function1 & Serializable & scala.Serializable)num -> CoercionUtils.safeToString(num), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                objectArray2 = new Object[]{dims, Array$.MODULE$.fill(size, (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 1.0f, ClassTag$.MODULE$.Float())};
            } else if (object instanceof java.util.Map) {
                scala.collection.immutable.Map flattenMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(values).flatMap((Function1 & Serializable & scala.Serializable)map -> ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)map).asScala()).toMap(Predef$.MODULE$.$conforms()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                objectArray2 = this.convertMapToFDS(flattenMap, dataType, dimType);
            } else {
                objectArray2 = new Object[]{Predef$.MODULE$.genericArrayOps(values).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), Array$.MODULE$.fill(size, (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 1.0f, ClassTag$.MODULE$.Float())};
            }
            objectArray = objectArray2;
        }
        return objectArray;
    }

    private Object convertRawValueTo1DFDSDenseTensorRowAutoTz(Object rawFeatureValue) {
        float[] fArray;
        Object object = rawFeatureValue;
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            fArray = (float[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)arrayList).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToFloat((float)x$5.floatValue()), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Float());
        } else if (object instanceof WrappedArray) {
            WrappedArray wrappedArray = (WrappedArray)object;
            fArray = (float[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])wrappedArray.toArray(ClassTag$.MODULE$.apply(Number.class)))).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToFloat((float)x$6.floatValue()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        } else if (object instanceof List) {
            List list = (List)object;
            fArray = (float[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])list.toArray(ClassTag$.MODULE$.apply(Number.class)))).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToFloat((float)x$7.floatValue()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        } else if (object instanceof scala.collection.immutable.Map) {
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)object;
            fArray = this.convertMapTo1dDenseTensor((scala.collection.immutable.Map<String, Number>)map);
        } else if (object instanceof Wrappers.JMapWrapper && ((Wrappers.JMapWrapper)object).scala$collection$convert$Wrappers$JMapWrapper$$$outer() == Wrappers$.MODULE$) {
            Wrappers.JMapWrapper jMapWrapper = (Wrappers.JMapWrapper)object;
            fArray = this.convertMapTo1dDenseTensor((scala.collection.immutable.Map<String, Number>)jMapWrapper.toMap(Predef$.MODULE$.$conforms()));
        } else if (object instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)object;
            fArray = this.convertMapTo1dDenseTensor((scala.collection.immutable.Map<String, Number>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).toMap(Predef$.MODULE$.$conforms()));
        } else {
            throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(55).append("Converting ").append(rawFeatureValue).append(" of type ").append(rawFeatureValue.getClass()).append(" ").append("to FDS Tensor is not yet supported").toString());
        }
        return fArray;
    }

    public Object convertRawValueTo1DFDSDenseTensorRowTz(Object rawFeatureValue) {
        Object[] objectArray;
        Object object = rawFeatureValue;
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            objectArray = (Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)arrayList).asScala()).toArray(ClassTag$.MODULE$.Any());
        } else if (object instanceof WrappedArray) {
            WrappedArray wrappedArray = (WrappedArray)object;
            objectArray = wrappedArray.nonEmpty() && wrappedArray.apply(0) instanceof GenericRowWithSchema ? (Object[])((WrappedArray)wrappedArray.map((Function1 & Serializable & scala.Serializable)v -> v.get(v.size() - 1), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toArray(ClassTag$.MODULE$.Any()) : (Object[])wrappedArray.toArray(ClassTag$.MODULE$.Any());
        } else if (object instanceof List) {
            List list = (List)object;
            objectArray = (Object[])list.toArray(ClassTag$.MODULE$.Any());
        } else if (object instanceof scala.collection.immutable.Map) {
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)object;
            objectArray = this.convertMapTo1dDenseTensorTz((scala.collection.immutable.Map<Integer, Object>)map);
        } else if (object instanceof Wrappers.JMapWrapper && ((Wrappers.JMapWrapper)object).scala$collection$convert$Wrappers$JMapWrapper$$$outer() == Wrappers$.MODULE$) {
            Wrappers.JMapWrapper jMapWrapper = (Wrappers.JMapWrapper)object;
            objectArray = this.convertMapTo1dDenseTensorTz((scala.collection.immutable.Map<Integer, Object>)jMapWrapper.toMap(Predef$.MODULE$.$conforms()));
        } else if (object instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)object;
            objectArray = this.convertMapTo1dDenseTensorTz((scala.collection.immutable.Map<Integer, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).toMap(Predef$.MODULE$.$conforms()));
        } else {
            throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(55).append("Converting ").append(rawFeatureValue).append(" of type ").append(rawFeatureValue.getClass()).append(" ").append("to FDS Tensor is not yet supported").toString());
        }
        return objectArray;
    }

    private Object convertRawValueTo1DFDSDenseTensorRow(Object rawFeatureValue, ArrayType targetType) {
        DataType dataType = targetType.elementType();
        Object object = dataType instanceof FloatType ? this.convertRawValueTo1DFDSDenseTensorRowAutoTz(rawFeatureValue) : this.convertRawValueTo1DFDSDenseTensorRowTz(rawFeatureValue);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private float[] convertMapTo1dDenseTensor(scala.collection.immutable.Map<String, Number> mapValues) {
        void var3_3;
        Seq items = mapValues.toSeq();
        float[] sortedValues = (float[])((TraversableOnce)((TraversableLike)items.sortBy((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToInteger((int)FDSConversionUtils$.$anonfun$convertMapTo1dDenseTensor$1(item)), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToFloat((float)FDSConversionUtils$.$anonfun$convertMapTo1dDenseTensor$2(x$8)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Float());
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Object[] convertMapTo1dDenseTensorTz(scala.collection.immutable.Map<Integer, Object> mapValues) {
        void var3_3;
        Seq items = mapValues.toSeq();
        Object[] sortedValues = (Object[])((TraversableOnce)((TraversableLike)items.sortBy((Function1 & Serializable & scala.Serializable)item -> ((Integer)item._1()).toString(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9._2(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
        return var3_3;
    }

    private Row convertRawValueTo1DFDSSparseTensorRow(Object rawFeatureValue, StructType targetType) {
        Object[] objectArray;
        Object[] objectArray2;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targetType.fields())).size() != 2) {
            throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(35).append("Cannot convert ").append(rawFeatureValue).append(" to FDS row of type ").append(targetType).toString());
        }
        if (rawFeatureValue instanceof GenericRowWithSchema && this.equalsIgnoreNullability((DataType)((GenericRowWithSchema)rawFeatureValue).schema(), (DataType)targetType)) {
            objectArray2 = (Object[])((TraversableOnce)((GenericRowWithSchema)rawFeatureValue).toSeq().map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toArray(ClassTag$.MODULE$.apply(Object.class)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Object.class));
        } else {
            Object[] objectArray3;
            DataType dimType = ((ArrayType)targetType.fields()[0].dataType()).elementType();
            DataType valType = ((ArrayType)targetType.fields()[1].dataType()).elementType();
            DataType dataType = dimType;
            if (StringType$.MODULE$.equals(dataType)) {
                Object[] objectArray4;
                Object object = rawFeatureValue;
                if (object instanceof String) {
                    String string = (String)object;
                    objectArray4 = new Object[]{new String[]{string}, new float[]{1.0f}};
                } else if (object instanceof ArrayList) {
                    ArrayList arrayList = (ArrayList)object;
                    objectArray4 = this.convertRawArrayToFDS1dTensor(arrayList.toArray(), valType, dimType);
                } else if (object instanceof scala.collection.immutable.Map) {
                    scala.collection.immutable.Map map = (scala.collection.immutable.Map)object;
                    objectArray4 = this.convertMapToFDS(map, valType, dimType);
                } else if (object instanceof Wrappers.JMapWrapper && ((Wrappers.JMapWrapper)object).scala$collection$convert$Wrappers$JMapWrapper$$$outer() == Wrappers$.MODULE$) {
                    Wrappers.JMapWrapper jMapWrapper = (Wrappers.JMapWrapper)object;
                    objectArray4 = this.convertMapToFDS(jMapWrapper.toMap(Predef$.MODULE$.$conforms()), valType, dimType);
                } else if (object instanceof java.util.Map) {
                    java.util.Map map = (java.util.Map)object;
                    objectArray4 = this.convertMapToFDS(((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).toMap(Predef$.MODULE$.$conforms()), valType, dimType);
                } else if (object instanceof Number) {
                    Number number = (Number)object;
                    objectArray4 = new Object[]{new String[]{CoercionUtils.safeToString(BoxesRunTime.boxToLong((long)number.longValue()))}, new float[]{1.0f}};
                } else if (object instanceof WrappedArray) {
                    WrappedArray wrappedArray = (WrappedArray)object;
                    objectArray4 = this.convertRawArrayToFDS1dTensor(wrappedArray.toArray(ClassTag$.MODULE$.Any()), valType, dimType);
                } else {
                    throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(48).append("Converting ").append(rawFeatureValue).append(" to FDS Tensor type ").append(targetType).append(" is not supported").toString());
                }
                objectArray3 = objectArray4;
            } else {
                boolean bl = IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : BooleanType$.MODULE$.equals(dataType));
                if (bl) {
                    Object[] objectArray5;
                    Object object = rawFeatureValue;
                    if (object instanceof Seq) {
                        Seq seq = (Seq)object;
                        int[] indices = (int[])((TraversableOnce)((TraversableLike)seq.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11._2$mcI$sp()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
                        objectArray5 = new Object[]{indices, ((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToFloat((float)x$12.floatValue()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Float())};
                    } else if (object instanceof ArrayList) {
                        ArrayList arrayList = (ArrayList)object;
                        int[] indices = (int[])((TraversableOnce)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)arrayList).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13._2$mcI$sp()), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
                        objectArray5 = new Object[]{indices, ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)arrayList).asScala()).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToFloat((float)x$14.floatValue()), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Float())};
                    } else if (object instanceof scala.collection.immutable.Map) {
                        scala.collection.immutable.Map map = (scala.collection.immutable.Map)object;
                        objectArray5 = this.convertMapToFDS(map, valType, dimType);
                    } else if (object instanceof Wrappers.JMapWrapper && ((Wrappers.JMapWrapper)object).scala$collection$convert$Wrappers$JMapWrapper$$$outer() == Wrappers$.MODULE$) {
                        Wrappers.JMapWrapper jMapWrapper = (Wrappers.JMapWrapper)object;
                        objectArray5 = this.convertMapToFDS(jMapWrapper.toMap(Predef$.MODULE$.$conforms()), valType, dimType);
                    } else if (object instanceof java.util.Map) {
                        java.util.Map map = (java.util.Map)object;
                        objectArray5 = this.convertMapToFDS(((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).toMap(Predef$.MODULE$.$conforms()), valType, dimType);
                    } else if (object instanceof GenericRowWithSchema) {
                        GenericRowWithSchema genericRowWithSchema = (GenericRowWithSchema)object;
                        int[] indices = (int[])((WrappedArray)genericRowWithSchema.get(0)).toArray(ClassTag$.MODULE$.Int());
                        float[] values = (float[])((WrappedArray)genericRowWithSchema.get(1)).toArray(ClassTag$.MODULE$.Float());
                        objectArray5 = new Object[]{indices, values};
                    } else {
                        throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(52).append("Converting ").append(rawFeatureValue).append(" to FDS Tensor type ").append(targetType).append(" is not yet supported").toString());
                    }
                    objectArray3 = objectArray5;
                } else {
                    throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(48).append("Converting ").append(rawFeatureValue).append(" to FDS Tensor type ").append(targetType).append(" is yet supported").toString());
                }
            }
            Object[] arrays = objectArray3;
            objectArray2 = arrays;
        }
        Object[] arrays = objectArray2;
        DataType valType = ((ArrayType)targetType.fields()[1].dataType()).elementType();
        Object indexArray = Predef$.MODULE$.genericArrayOps(arrays[0]).toArray(ClassTag$.MODULE$.apply(Object.class));
        if (Predef$.MODULE$.genericArrayOps(indexArray).nonEmpty()) {
            Tuple2 tuple2;
            Object firstElement = Predef$.MODULE$.genericArrayOps(indexArray).head();
            Object object = firstElement;
            if (object instanceof String) {
                Tuple2 tuple22;
                DataType dataType = valType;
                FloatType$ floatType$ = FloatType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(floatType$) : floatType$ != null)) {
                    Tuple2[] dimToValArray = (Tuple2[])Predef$.MODULE$.genericArrayOps(arrays[0]).zip((GenIterable)Predef$.MODULE$.wrapFloatArray((float[])Predef$.MODULE$.genericArrayOps(arrays[1]).map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToFloat((float)FDSConversionUtils$.$anonfun$convertRawValueTo1DFDSSparseTensorRow$6(x$15)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                    Tuple2[] sortedArray = FDSConversionUtils$.liftedTree1$1(dimToValArray);
                    tuple22 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortedArray)).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Any(), ClassTag$.MODULE$.Float());
                } else {
                    tuple22 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(arrays[0]).zip((GenIterable)Predef$.MODULE$.genericWrapArray(arrays[1]), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).sortBy((Function1 & Serializable & scala.Serializable)p -> p._1().toString(), (Ordering)Ordering.String$.MODULE$))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(Object.class), ClassTag$.MODULE$.apply(Object.class));
                }
                tuple2 = tuple22;
            } else if (object instanceof Integer) {
                tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(arrays[0]).zip((GenIterable)Predef$.MODULE$.genericWrapArray(arrays[1]), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).sortBy((Function1 & Serializable & scala.Serializable)p -> Integer.valueOf(p._1().toString()), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(Object.class), ClassTag$.MODULE$.apply(Object.class));
            } else if (object instanceof Long) {
                tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(arrays[0]).zip((GenIterable)Predef$.MODULE$.genericWrapArray(arrays[1]), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).sortBy((Function1 & Serializable & scala.Serializable)p -> Long.valueOf(p._1().toString()), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(Object.class), ClassTag$.MODULE$.apply(Object.class));
            } else if (object instanceof Boolean) {
                tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(arrays[0]).zip((GenIterable)Predef$.MODULE$.genericWrapArray(arrays[1]), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).sortBy((Function1 & Serializable & scala.Serializable)p -> Boolean.valueOf(p._1().toString()), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(Object.class), ClassTag$.MODULE$.apply(Object.class));
            } else {
                throw new MatchError(object);
            }
            Tuple2 sortedArrays = tuple2;
            objectArray = new Object[]{sortedArrays._1(), sortedArrays._2()};
        } else {
            objectArray = arrays;
        }
        Object[] sortedArrays = objectArray;
        return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.wrapRefArray(sortedArrays));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equalsIgnoreNullability(DataType left, DataType right) {
        Tuple2 tuple2;
        while (true) {
            if ((tuple2 = new Tuple2((Object)left, (Object)right)) != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType2 = (DataType)tuple2._2();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType leftElementType = arrayType.elementType();
                    if (dataType2 instanceof ArrayType) {
                        DataType rightElementType;
                        ArrayType arrayType2 = (ArrayType)dataType2;
                        right = rightElementType = arrayType2.elementType();
                        left = leftElementType;
                        continue;
                    }
                }
            }
            if (tuple2 == null) break;
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (!(dataType instanceof MapType)) break;
            MapType mapType = (MapType)dataType;
            DataType leftKeyType = mapType.keyType();
            DataType leftValueType = mapType.valueType();
            if (!(dataType3 instanceof MapType)) break;
            MapType mapType2 = (MapType)dataType3;
            DataType rightKeyType = mapType2.keyType();
            DataType rightValueType = mapType2.valueType();
            if (!this.equalsIgnoreNullability(leftKeyType, rightKeyType)) return false;
            right = rightValueType;
            left = leftValueType;
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] leftFields = structType.fields();
                if (dataType4 instanceof StructType) {
                    StructType structType2 = (StructType)dataType4;
                    StructField[] rightFields = structType2.fields();
                    if (leftFields.length != rightFields.length) return false;
                    if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftFields)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])rightFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FDSConversionUtils$.$anonfun$equalsIgnoreNullability$1(x0$1)))) return false;
                    return true;
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        DataType l = (DataType)tuple2._1();
        DataType r = (DataType)tuple2._2();
        DataType dataType = l;
        DataType dataType5 = r;
        if (dataType != null) {
            if (!dataType.equals(dataType5)) return false;
            return true;
        }
        if (dataType5 == null) return true;
        return false;
    }

    public static final /* synthetic */ float $anonfun$convertMapToFDS$8(Tuple2 value) {
        return BoxesRunTime.unboxToFloat((Object)MODULE$.parseFloatValue(value._2()));
    }

    public static final /* synthetic */ float $anonfun$convertRawArrayToFDS1dTensor$3(Tuple2 x$2) {
        return BoxesRunTime.unboxToFloat((Object)x$2._2());
    }

    public static final /* synthetic */ int $anonfun$convertMapTo1dDenseTensor$1(Tuple2 item) {
        return new StringOps(Predef$.MODULE$.augmentString(((String)item._1()).toString())).toInt();
    }

    public static final /* synthetic */ float $anonfun$convertMapTo1dDenseTensor$2(Tuple2 x$8) {
        return ((Number)x$8._2()).floatValue();
    }

    public static final /* synthetic */ float $anonfun$convertRawValueTo1DFDSSparseTensorRow$6(Object x$15) {
        return new StringOps(Predef$.MODULE$.augmentString(x$15.toString())).toFloat();
    }

    private static final /* synthetic */ Tuple2[] liftedTree1$1(Tuple2[] dimToValArray$1) {
        Tuple2[] tuple2Array;
        try {
            tuple2Array = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dimToValArray$1)).sortBy((Function1 & Serializable & scala.Serializable)p -> Float.valueOf(p._1().toString()), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        }
        catch (Exception e) {
            tuple2Array = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dimToValArray$1)).sortBy((Function1 & Serializable & scala.Serializable)p -> p._1().toString(), (Ordering)Ordering.String$.MODULE$);
        }
        return tuple2Array;
    }

    public static final /* synthetic */ boolean $anonfun$equalsIgnoreNullability$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructField l = (StructField)tuple2._1();
        StructField r = (StructField)tuple2._2();
        String string = l.name();
        String string2 = r.name();
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null) && MODULE$.equalsIgnoreNullability(l.dataType(), r.dataType());
        return bl;
    }

    private FDSConversionUtils$() {
        MODULE$ = this;
        this.trueValueMap = new Wrappers.JMapWrapper((Wrappers)Wrappers$.MODULE$, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)BoxesRunTime.boxToFloat((float)1.0f))}))).asJava());
    }
}

