/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.util;

import com.linkedin.feathr.common.ErasedEntityTaggedFeature;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrException;
import com.linkedin.feathr.common.time.TimeUnit;
import com.linkedin.feathr.offline.anchored.feature.FeatureAnchorWithSource;
import com.linkedin.feathr.offline.util.FeathrUtils$;
import com.linkedin.feathr.offline.util.ResolvedTime;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class AclCheckUtils$ {
    public static AclCheckUtils$ MODULE$;
    private final String LATEST_PATTERN;
    private final Logger log;

    static {
        new AclCheckUtils$();
    }

    public String LATEST_PATTERN() {
        return this.LATEST_PATTERN;
    }

    private Logger log() {
        return this.log;
    }

    public Seq<Tuple2<String, String>> checkReadAuthorization(Configuration conf, Seq<String> pathList) {
        return (Seq)((TraversableLike)pathList.map((Function1 & Serializable & scala.Serializable)path -> new Tuple2(path, MODULE$.checkReadAuthorization(conf, (String)path)), Seq$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, Try<BoxedUnit>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String path = (String)A1._1();
                    Try try_ = (Try)A1._2();
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        object = new Tuple2((Object)new StringBuilder(3).append(path).append(" , ").append(e.getMessage()).toString(), (Object)path);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, Try<BoxedUnit>> x1) {
                Try try_;
                Tuple2<String, Try<BoxedUnit>> tuple2 = x1;
                boolean bl = tuple2 != null && (try_ = (Try)tuple2._2()) instanceof Failure;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Try<BoxedUnit> checkReadAuthorization(Configuration conf, String pathName) {
        Success success;
        if (pathName.startsWith("jdbc:")) {
            success = new Success((Object)BoxedUnit.UNIT);
        } else {
            Path path = new Path(pathName);
            if (pathName.startsWith("hdfs") || pathName.startsWith("/")) {
                FileSystem fs = path.getFileSystem(conf);
                String resolvedPathName = this.getLatestPath(fs, pathName);
                Path resolvedPath = new Path(resolvedPathName);
                success = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.access(resolvedPath, FsAction.READ));
            } else {
                success = new Success((Object)BoxedUnit.UNIT);
            }
        }
        return success;
    }

    public Tuple2<Try<BoxedUnit>, Seq<String>> checkReadAuthorization(SparkSession ss, Seq<ErasedEntityTaggedFeature> allRequiredFeatures, Map<String, FeatureAnchorWithSource> allAnchoredFeatures) {
        Configuration conf = ss.sparkContext().hadoopConfiguration();
        Seq allRequiredPaths = (Seq)allRequiredFeatures.flatMap((Function1 & Serializable & scala.Serializable)requiredFeature -> Option$.MODULE$.option2Iterable(allAnchoredFeatures.get((Object)requiredFeature.getFeatureName()).map((Function1 & Serializable & scala.Serializable)featureAnchorWithSource -> featureAnchorWithSource.source().path())), Seq$.MODULE$.canBuildFrom());
        boolean shouldSkipFeature = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(ss.sparkContext().getConf(), FeathrUtils$.MODULE$.SKIP_MISSING_FEATURE()))).toBoolean();
        Seq<Tuple2<String, String>> invalidPaths = this.checkReadAuthorization(conf, (Seq<String>)((Seq)allRequiredPaths.distinct()));
        return invalidPaths.isEmpty() ? new Tuple2((Object)new Success((Object)BoxedUnit.UNIT), invalidPaths.map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._2(), Seq$.MODULE$.canBuildFrom())) : (!shouldSkipFeature ? new Tuple2((Object)new Failure((Throwable)new RuntimeException(new StringBuilder(180).append("Can not verify read authorization on the following paths. This can be due to 1) the user does not have correct ACL, 2) path does not exist, 3) IO exception when reading the data :\n").append(((TraversableOnce)invalidPaths.map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2._1(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).toString())), invalidPaths.map((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3._2(), Seq$.MODULE$.canBuildFrom())) : new Tuple2((Object)new Success((Object)BoxedUnit.UNIT), invalidPaths.map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4._2(), Seq$.MODULE$.canBuildFrom())));
    }

    public Try<BoxedUnit> checkWriteAuthorization(Configuration conf, String pathName) {
        Success success;
        Path path2 = new Path(pathName);
        if (pathName.startsWith("hdfs") || pathName.startsWith("/")) {
            FileSystem fs = path2.getFileSystem(conf);
            String resolvedPathName = this.getLatestPath(fs, pathName);
            Path resolvedPath = new Path(resolvedPathName);
            Path parentPath = resolvedPath.getParent();
            success = this.getNearestAncestor(fs, parentPath).flatMap((Function1 & Serializable & scala.Serializable)path -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.access(path, FsAction.WRITE_EXECUTE)));
        } else {
            success = new Success((Object)BoxedUnit.UNIT);
        }
        return success;
    }

    private Try<Path> getNearestAncestor(FileSystem fs, Path path) {
        return AclCheckUtils$.recurse$1(path, fs);
    }

    public String getLatestPath(FileSystem fs, String inputPath) {
        String string;
        Predef$.MODULE$.require(inputPath != null && !inputPath.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "The path to resolve is either null or empty");
        if (inputPath.contains(this.LATEST_PATTERN())) {
            String[] split = inputPath.replaceAll(this.LATEST_PATTERN(), new StringBuilder(1).append("/").append(this.LATEST_PATTERN()).toString()).split(this.LATEST_PATTERN());
            ObjectRef resolvedPath = ObjectRef.create((Object)split[0]);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), split.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                resolvedPath$2.elem = new StringBuilder(0).append(MODULE$.getLatestPathHelper(fs, (String)resolvedPath$2.elem)).append(split[i]).toString();
            });
            if (inputPath.endsWith(this.LATEST_PATTERN())) {
                resolvedPath.elem = this.getLatestPathHelper(fs, (String)resolvedPath.elem);
            }
            string = (String)resolvedPath.elem;
        } else {
            string = inputPath;
        }
        return string;
    }

    private String getLatestPathHelper(FileSystem fs, String inputPath) {
        FileStatus[] statuses;
        LazyRef filter$lzy = new LazyRef();
        Path path = new Path(inputPath);
        return fs.exists(path) ? (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(statuses = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path, AclCheckUtils$.filter$1(filter$lzy)))).sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)AclCheckUtils$.$anonfun$getLatestPathHelper$1(a, b)))))).isEmpty() ? inputPath : new StringBuilder(0).append(inputPath).append(((FileStatus)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).last()).getPath().getName()).toString()) : inputPath;
    }

    public int countOccurrences(String src, String target) {
        return new StringOps(Predef$.MODULE$.augmentString(src)).sliding(target.length()).count((Function1 & Serializable & scala.Serializable)window -> BoxesRunTime.boxToBoolean((boolean)AclCheckUtils$.$anonfun$countOccurrences$1(target, window)));
    }

    public Option<String> getLatestPath(FileSystem fs, String inputPath, LocalDateTime cutOffDate) {
        None$ none$;
        Predef$.MODULE$.require(inputPath != null && !inputPath.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "The path to resolve is either null or empty");
        int count = this.countOccurrences(inputPath, this.LATEST_PATTERN());
        Seq timeUnits = (Seq)new .colon.colon((Object)TimeUnit.YEAR, (List)new .colon.colon((Object)TimeUnit.MONTH, (List)new .colon.colon((Object)TimeUnit.DAY, (List)new .colon.colon((Object)TimeUnit.HOUR, (List)Nil$.MODULE$))));
        if (count != 3) {
            throw new FeathrException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(81).append("getLatestPath only support HDFS path with 3 ").append(this.LATEST_PATTERN()).append(" in yyyy/MM/dd, e.g., ").append(this.LATEST_PATTERN()).append("/").append(this.LATEST_PATTERN()).append("/").append(this.LATEST_PATTERN()).append(", but found ").append(inputPath).append(" ").toString());
        }
        String refinedPath = inputPath.replaceAll(this.LATEST_PATTERN(), new StringBuilder(1).append("/").append(this.LATEST_PATTERN()).toString());
        LocalDateTime initTime = LocalDateTime.of(0, 1, 1, 0, 0);
        ResolvedTime resolvedTime = new ResolvedTime(initTime);
        this.getLatestPathRecursive(fs, refinedPath, (Seq<TimeUnit>)timeUnits, 0, initTime, cutOffDate, resolvedTime);
        if (!resolvedTime.time().equals(initTime)) {
            String yearStr = this.padWithPrefix(Integer.toString(resolvedTime.time().getYear()), 4, '0');
            String monthStr = this.padWithPrefix(Integer.toString(resolvedTime.time().getMonthValue()), 2, '0');
            String dayStr = this.padWithPrefix(Integer.toString(resolvedTime.time().getDayOfMonth()), 2, '0');
            String latestPath = refinedPath.replaceFirst(this.LATEST_PATTERN(), yearStr).replaceFirst(this.LATEST_PATTERN(), monthStr).replaceFirst(this.LATEST_PATTERN(), dayStr);
            none$ = new Some((Object)latestPath);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private String padWithPrefix(String input, int len, char pad) {
        return (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(input)).reverse())).padTo(len, (Object)BoxesRunTime.boxToCharacter((char)pad), Predef$.MODULE$.StringCanBuildFrom()))).reverse();
    }

    private void getLatestPathRecursive(FileSystem fs, String inputPath, Seq<TimeUnit> timeUnits, int index, LocalDateTime currentFolderDateTime, LocalDateTime cutOffDateTime, ResolvedTime resolvedOutputTime) {
        LazyRef filter$lzy = new LazyRef();
        String baseInputPath = inputPath.replaceAll(this.LATEST_PATTERN(), "");
        try {
            FileStatus[] statuses = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(baseInputPath), AclCheckUtils$.filter$2(filter$lzy)))).sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)AclCheckUtils$.$anonfun$getLatestPathRecursive$1(a, b)));
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).isEmpty()) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).foreach((Function1 & Serializable & scala.Serializable)status -> {
                    AclCheckUtils$.$anonfun$getLatestPathRecursive$2(inputPath, timeUnits, index, currentFolderDateTime, cutOffDateTime, resolvedOutputTime, fs, status);
                    return BoxedUnit.UNIT;
                });
            }
        }
        catch (Exception e) {
            this.log().trace(new StringBuilder(29).append("Unsupported path found under ").append(inputPath).append(e.getMessage()).toString());
        }
    }

    public AclEntry aclEntry(AclEntryScope scope, AclEntryType aclEntryType, String name, FsAction permission) {
        return new AclEntry.Builder().setScope(scope).setType(aclEntryType).setName(name).setPermission(permission).build();
    }

    public AclEntry aclEntry(AclEntryScope scope, AclEntryType aclEntryType, FsAction permission) {
        return new AclEntry.Builder().setScope(scope).setType(aclEntryType).setPermission(permission).build();
    }

    public static final /* synthetic */ Try $anonfun$getNearestAncestor$2(Path p$1, FileSystem fs$3, boolean x0$1) {
        Try<Path> try_;
        boolean bl = x0$1;
        if (bl) {
            try_ = new Try<Path>((Object)p$1);
        } else if (!bl) {
            try_ = MODULE$.getNearestAncestor(fs$3, p$1.getParent());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return try_;
    }

    private static final Try recurse$1(Path p, FileSystem fs$3) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> fs$3.exists(p)).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> AclCheckUtils$.$anonfun$getNearestAncestor$2(p, fs$3, BoxesRunTime.unboxToBoolean((Object)x0$1)));
    }

    private static final /* synthetic */ PathFilter filter$lzycompute$1(LazyRef filter$lzy$1) {
        PathFilter pathFilter;
        LazyRef lazyRef = filter$lzy$1;
        synchronized (lazyRef) {
            pathFilter = filter$lzy$1.initialized() ? (PathFilter)filter$lzy$1.value() : (PathFilter)filter$lzy$1.initialize((Object)new PathFilter(){

                public boolean accept(Path path) {
                    return !path.getName().startsWith("_") && !path.getName().startsWith(".");
                }
            });
        }
        return pathFilter;
    }

    private static final PathFilter filter$1(LazyRef filter$lzy$1) {
        return filter$lzy$1.initialized() ? (PathFilter)filter$lzy$1.value() : AclCheckUtils$.filter$lzycompute$1(filter$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$getLatestPathHelper$1(FileStatus a, FileStatus b) {
        return a.compareTo(b) < 0;
    }

    public static final /* synthetic */ boolean $anonfun$countOccurrences$1(String target$1, String window) {
        String string = window;
        String string2 = target$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final /* synthetic */ PathFilter filter$lzycompute$2(LazyRef filter$lzy$2) {
        PathFilter pathFilter;
        LazyRef lazyRef = filter$lzy$2;
        synchronized (lazyRef) {
            pathFilter = filter$lzy$2.initialized() ? (PathFilter)filter$lzy$2.value() : (PathFilter)filter$lzy$2.initialize((Object)new PathFilter(){

                public boolean accept(Path path) {
                    return !path.getName().startsWith("_") && !path.getName().startsWith(".");
                }
            });
        }
        return pathFilter;
    }

    private static final PathFilter filter$2(LazyRef filter$lzy$2) {
        return filter$lzy$2.initialized() ? (PathFilter)filter$lzy$2.value() : AclCheckUtils$.filter$lzycompute$2(filter$lzy$2);
    }

    public static final /* synthetic */ boolean $anonfun$getLatestPathRecursive$1(FileStatus a, FileStatus b) {
        return a.compareTo(b) < 0;
    }

    public static final /* synthetic */ void $anonfun$getLatestPathRecursive$2(String inputPath$1, Seq timeUnits$1, int index$1, LocalDateTime currentFolderDateTime$1, LocalDateTime cutOffDateTime$1, ResolvedTime resolvedOutputTime$1, FileSystem fs$5, FileStatus status) {
        block7: {
            boolean allPlaceholdersResolved;
            LocalDateTime localDateTime;
            String timeStr = status.getPath().getName();
            int timeInt = Integer.parseInt(timeStr);
            String resolvedPath = inputPath$1.replaceFirst(MODULE$.LATEST_PATTERN(), timeStr);
            TimeUnit timeUnit = (TimeUnit)((Object)timeUnits$1.apply(index$1));
            if (((Object)((Object)TimeUnit.YEAR)).equals((Object)timeUnit)) {
                localDateTime = currentFolderDateTime$1.withYear(timeInt);
            } else if (((Object)((Object)TimeUnit.MONTH)).equals((Object)timeUnit)) {
                localDateTime = currentFolderDateTime$1.withMonth(timeInt);
            } else if (((Object)((Object)TimeUnit.DAY)).equals((Object)timeUnit)) {
                localDateTime = currentFolderDateTime$1.withDayOfMonth(timeInt);
            } else {
                throw new MatchError((Object)timeUnit);
            }
            LocalDateTime resolvedTime = localDateTime;
            boolean bl = allPlaceholdersResolved = !resolvedPath.contains(MODULE$.LATEST_PATTERN());
            if (allPlaceholdersResolved && resolvedTime.isBefore(cutOffDateTime$1) && resolvedTime.isAfter(resolvedOutputTime$1.time())) {
                resolvedOutputTime$1.time_$eq(resolvedTime);
            }
            if (!resolvedPath.contains(MODULE$.LATEST_PATTERN()) || !cutOffDateTime$1.isAfter(resolvedTime)) break block7;
            MODULE$.getLatestPathRecursive(fs$5, resolvedPath, (Seq<TimeUnit>)timeUnits$1, index$1 + 1, resolvedTime, cutOffDateTime$1, resolvedOutputTime$1);
        }
    }

    private AclCheckUtils$() {
        MODULE$ = this;
        this.LATEST_PATTERN = "#LATEST";
        this.log = LogManager.getLogger(this.getClass());
    }
}

