/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.util;

import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;

public final class FeathrUtils$ {
    public static FeathrUtils$ MODULE$;
    private final String ENVIRONMENT;
    private final String ENABLE_DEBUG_OUTPUT;
    private final String DEBUG_OUTPUT_PATH;
    private final String DEBUG_OUTPUT_PART_NUM;
    private final String FEATHR_PARAMS_PREFIX;
    private final String FAIL_ON_MISSING_PARTITION;
    private final String SEQ_JOIN_ARRAY_EXPLODE_ENABLED;
    private final String ENABLE_SALTED_JOIN;
    private final String SKIP_MISSING_FEATURE;
    private final String SALTED_JOIN_FREQ_ITEM_THRESHOLD;
    private final String SALTED_JOIN_FREQ_ITEM_ESTIMATOR;
    private final String SALTED_JOIN_PERSIST;
    private final String SALTED_JOIN_REPLICATION_FACTOR_HIGH;
    private final String ENABLE_SLICK_JOIN;
    private final String ENABLE_METRICS;
    private final String ENABLE_CHECKPOINT;
    private final String ROW_BLOOMFILTER_MAX_THRESHOLD;
    private final String SPARK_JOIN_MAX_PARALLELISM;
    private final String CHECKPOINT_OUTPUT_PATH;
    private final String SPARK_JOIN_MIN_PARALLELISM;
    private final String MAX_DATA_LOAD_RETRY;
    private final String DATA_LOAD_WAIT_IN_MS;
    private final Map<String, String> defaultParams;

    static {
        new FeathrUtils$();
    }

    public String ENVIRONMENT() {
        return this.ENVIRONMENT;
    }

    public String ENABLE_DEBUG_OUTPUT() {
        return this.ENABLE_DEBUG_OUTPUT;
    }

    public String DEBUG_OUTPUT_PATH() {
        return this.DEBUG_OUTPUT_PATH;
    }

    public String DEBUG_OUTPUT_PART_NUM() {
        return this.DEBUG_OUTPUT_PART_NUM;
    }

    public String FEATHR_PARAMS_PREFIX() {
        return this.FEATHR_PARAMS_PREFIX;
    }

    public String FAIL_ON_MISSING_PARTITION() {
        return this.FAIL_ON_MISSING_PARTITION;
    }

    public String SEQ_JOIN_ARRAY_EXPLODE_ENABLED() {
        return this.SEQ_JOIN_ARRAY_EXPLODE_ENABLED;
    }

    public String ENABLE_SALTED_JOIN() {
        return this.ENABLE_SALTED_JOIN;
    }

    public String SKIP_MISSING_FEATURE() {
        return this.SKIP_MISSING_FEATURE;
    }

    public String SALTED_JOIN_FREQ_ITEM_THRESHOLD() {
        return this.SALTED_JOIN_FREQ_ITEM_THRESHOLD;
    }

    public String SALTED_JOIN_FREQ_ITEM_ESTIMATOR() {
        return this.SALTED_JOIN_FREQ_ITEM_ESTIMATOR;
    }

    public String SALTED_JOIN_PERSIST() {
        return this.SALTED_JOIN_PERSIST;
    }

    public String SALTED_JOIN_REPLICATION_FACTOR_HIGH() {
        return this.SALTED_JOIN_REPLICATION_FACTOR_HIGH;
    }

    public String ENABLE_SLICK_JOIN() {
        return this.ENABLE_SLICK_JOIN;
    }

    public String ENABLE_METRICS() {
        return this.ENABLE_METRICS;
    }

    public String ENABLE_CHECKPOINT() {
        return this.ENABLE_CHECKPOINT;
    }

    public String ROW_BLOOMFILTER_MAX_THRESHOLD() {
        return this.ROW_BLOOMFILTER_MAX_THRESHOLD;
    }

    public String SPARK_JOIN_MAX_PARALLELISM() {
        return this.SPARK_JOIN_MAX_PARALLELISM;
    }

    public String CHECKPOINT_OUTPUT_PATH() {
        return this.CHECKPOINT_OUTPUT_PATH;
    }

    public String SPARK_JOIN_MIN_PARALLELISM() {
        return this.SPARK_JOIN_MIN_PARALLELISM;
    }

    public String MAX_DATA_LOAD_RETRY() {
        return this.MAX_DATA_LOAD_RETRY;
    }

    public String DATA_LOAD_WAIT_IN_MS() {
        return this.DATA_LOAD_WAIT_IN_MS;
    }

    public Map<String, String> defaultParams() {
        return this.defaultParams;
    }

    public String feathrVersion() {
        Properties versionProperties = new Properties();
        InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream("metric.properties");
        versionProperties.load(resourceStream);
        return versionProperties.getProperty("version");
    }

    public String getFeathrJobParam(SparkSession ss, String paramName) {
        SparkConf sparkConf = ss.sparkContext().getConf();
        return this.getFeathrJobParam(sparkConf, paramName);
    }

    public String getFeathrJobParam(SparkConf sparkConf, String paramName) {
        return sparkConf.get(new StringBuilder(0).append(this.FEATHR_PARAMS_PREFIX()).append(paramName).toString(), (String)this.defaultParams().apply((Object)paramName));
    }

    public void enableDebugLogging(SparkConf sparkConf) {
        block0: {
            boolean enableDebugLog = this.isDebugOutputEnabled(sparkConf);
            if (!enableDebugLog) break block0;
            Logger.getRootLogger().setLevel(Level.DEBUG);
        }
    }

    public String readFileFromHDFS(SparkSession ss, String path) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ss.sparkContext().textFile(path, ss.sparkContext().textFile$default$2()).collect())).mkString("\n");
    }

    private boolean isDebugOutputEnabled(SparkConf sparkConf) {
        return new StringOps(Predef$.MODULE$.augmentString(this.getFeathrJobParam(sparkConf, this.ENABLE_DEBUG_OUTPUT()))).toBoolean();
    }

    private FeathrUtils$() {
        MODULE$ = this;
        this.ENVIRONMENT = "offline";
        this.ENABLE_DEBUG_OUTPUT = "debug.enabled";
        this.DEBUG_OUTPUT_PATH = "debug.output.path";
        this.DEBUG_OUTPUT_PART_NUM = "debug.output.num.parts";
        this.FEATHR_PARAMS_PREFIX = "spark.feathr.";
        this.FAIL_ON_MISSING_PARTITION = "fail.on.missing.partition";
        this.SEQ_JOIN_ARRAY_EXPLODE_ENABLED = "seq.join.array.explode.enabled";
        this.ENABLE_SALTED_JOIN = "enable.salted.join";
        this.SKIP_MISSING_FEATURE = "skip.missing.feature";
        this.SALTED_JOIN_FREQ_ITEM_THRESHOLD = "salted.join.freq.item.threshold";
        this.SALTED_JOIN_FREQ_ITEM_ESTIMATOR = "salted.join.freq.item.estimator";
        this.SALTED_JOIN_PERSIST = "salted.join.persist";
        this.SALTED_JOIN_REPLICATION_FACTOR_HIGH = "salted.join.replication.factor.high";
        this.ENABLE_SLICK_JOIN = "enable.slickJoin";
        this.ENABLE_METRICS = "enable.metrics";
        this.ENABLE_CHECKPOINT = "enable.checkpoint";
        this.ROW_BLOOMFILTER_MAX_THRESHOLD = "row.bloomfilter.maxThreshold";
        this.SPARK_JOIN_MAX_PARALLELISM = "max.parallelism";
        this.CHECKPOINT_OUTPUT_PATH = "checkpoint.dir";
        this.SPARK_JOIN_MIN_PARALLELISM = "min.parallelism";
        this.MAX_DATA_LOAD_RETRY = "max.data.load.retry";
        this.DATA_LOAD_WAIT_IN_MS = "data.load.wait.in.ms";
        this.defaultParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ENABLE_DEBUG_OUTPUT()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.DEBUG_OUTPUT_PATH()), (Object)"/tmp/debug/feathr/output"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.CHECKPOINT_OUTPUT_PATH()), (Object)"/tmp/feathr/checkpoints"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ENABLE_CHECKPOINT()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.DEBUG_OUTPUT_PART_NUM()), (Object)"200"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.FAIL_ON_MISSING_PARTITION()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SEQ_JOIN_ARRAY_EXPLODE_ENABLED()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ENABLE_SALTED_JOIN()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SKIP_MISSING_FEATURE()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MAX_DATA_LOAD_RETRY()), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.DATA_LOAD_WAIT_IN_MS()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SALTED_JOIN_FREQ_ITEM_THRESHOLD()), (Object)"0.0002"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SALTED_JOIN_REPLICATION_FACTOR_HIGH()), (Object)"10"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SALTED_JOIN_FREQ_ITEM_ESTIMATOR()), (Object)"spark"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ENABLE_SLICK_JOIN()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SALTED_JOIN_PERSIST()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ROW_BLOOMFILTER_MAX_THRESHOLD()), (Object)"-1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ENABLE_METRICS()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SPARK_JOIN_MAX_PARALLELISM()), (Object)"10000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SPARK_JOIN_MIN_PARALLELISM()), (Object)"10")}));
    }
}

