/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.util;

import com.linkedin.feathr.common.DateTimeUtils$;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrInputDataException;
import com.linkedin.feathr.offline.util.AclCheckUtils$;
import com.linkedin.feathr.offline.util.HdfsUtils$;
import com.linkedin.feathr.offline.util.datetime.DateTimeInterval;
import com.linkedin.feathr.offline.util.datetime.OfflineDateTimeUtils$;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class IncrementalAggUtils$ {
    public static IncrementalAggUtils$ MODULE$;
    private final Configuration conf;
    private final FileSystem fs;

    static {
        new IncrementalAggUtils$();
    }

    private final Configuration conf() {
        return this.conf;
    }

    private final String LATEST_PATTERN() {
        return "#LATEST";
    }

    private final FileSystem fs() {
        return this.fs;
    }

    public Option<String> getLatestHistoricalAggregationPath(String rootAggDir, LocalDateTime cutOffDate) {
        return AclCheckUtils$.MODULE$.getLatestPath(this.fs(), new StringBuilder(21).append(rootAggDir).append("#LATEST").append("#LATEST").append("#LATEST").toString(), cutOffDate);
    }

    public Option<ZonedDateTime> getLatestHistoricalAggregationDate(String rootAggDir, LocalDateTime cutOffDate) {
        Option<String> resolvedLatestPathName = this.getLatestHistoricalAggregationPath(rootAggDir, cutOffDate);
        return resolvedLatestPathName.map((Function1 & Serializable & scala.Serializable)pathName -> {
            String latestDateStr = (String)new StringOps(Predef$.MODULE$.augmentString(pathName)).drop(rootAggDir.length() + 1);
            return OfflineDateTimeUtils$.MODULE$.createTimeFromString(latestDateStr, "yyyy/MM/dd", OfflineDateTimeUtils$.MODULE$.createTimeFromString$default$3());
        });
    }

    public DateTimeInterval getOldDeltaWindowDateParam(String rootAggDir, int aggWindow, int incrementalWindow, String newDeltaEndDateStr) {
        ZonedDateTime endDate = OfflineDateTimeUtils$.MODULE$.createTimeFromString(newDeltaEndDateStr, "yyyyMMdd", OfflineDateTimeUtils$.MODULE$.createTimeFromString$default$3());
        ZonedDateTime start = endDate.minusDays(aggWindow + incrementalWindow);
        ZonedDateTime end = endDate.minusDays(aggWindow);
        return new DateTimeInterval(start, end);
    }

    public Tuple2<DateTimeInterval, Object> getNewDeltaWindowInterval(String rootAggDir, int aggWindow, String newDeltaWindowEndDateStr) {
        LocalDateTime endDate = OfflineDateTimeUtils$.MODULE$.createTimeFromString(newDeltaWindowEndDateStr, "yyyyMMdd", OfflineDateTimeUtils$.MODULE$.createTimeFromString$default$3()).toLocalDateTime();
        ZonedDateTime startDateBasedOnPreAgg = this.getNewDeltaWindowStartDate(rootAggDir, endDate);
        String startDateBasedOnPreAggStr = this.formatDateAsString(startDateBasedOnPreAgg, this.formatDateAsString$default$2());
        String startDateBasedOnRuntime = DateTimeUtils$.MODULE$.minusTime(newDeltaWindowEndDateStr, "yyyyMMdd", "yyyyMMdd", TimeZone.getTimeZone("America/Los_Angeles"), aggWindow, ChronoUnit.DAYS);
        String newDeltaWindowStartDateStr = new StringOps(Predef$.MODULE$.augmentString(startDateBasedOnRuntime)).$greater((Object)startDateBasedOnPreAggStr) ? startDateBasedOnRuntime : startDateBasedOnPreAggStr;
        ZonedDateTime newDeltaWindowStartDate = OfflineDateTimeUtils$.MODULE$.createTimeFromString(newDeltaWindowStartDateStr, "yyyyMMdd", OfflineDateTimeUtils$.MODULE$.createTimeFromString$default$3());
        ZonedDateTime newDeltaWindowEndDate = OfflineDateTimeUtils$.MODULE$.createTimeFromString(newDeltaWindowEndDateStr, "yyyyMMdd", OfflineDateTimeUtils$.MODULE$.createTimeFromString$default$3());
        long incrementalWindowSize = ChronoUnit.DAYS.between(newDeltaWindowStartDate, newDeltaWindowEndDate);
        DateTimeInterval interval = new DateTimeInterval(newDeltaWindowStartDate, newDeltaWindowEndDate);
        return new Tuple2((Object)interval, (Object)BoxesRunTime.boxToLong((long)incrementalWindowSize));
    }

    public String formatDateAsString(ZonedDateTime date, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern).withZone(OfflineDateTimeUtils$.MODULE$.DEFAULT_ZONE_ID());
        return formatter.format(date);
    }

    public String formatDateAsString$default$2() {
        return "yyyyMMdd";
    }

    public String transformDateString(String sourceDateStr, String sourcePattern, String destPattern) {
        ZonedDateTime sourceDate = OfflineDateTimeUtils$.MODULE$.createTimeFromString(sourceDateStr, sourcePattern, OfflineDateTimeUtils$.MODULE$.createTimeFromString$default$3());
        return this.formatDateAsString(sourceDate, destPattern);
    }

    public String transformDateString$default$2() {
        return "yyyyMMdd";
    }

    public String transformDateString$default$3() {
        return "yyyy/MM/dd";
    }

    public Seq<String> getSubfolderPaths(String basePath, Seq<String> excludeDirsPrefixList, Configuration conf) {
        FileSystem fs = FileSystem.get((Configuration)conf);
        Seq directories = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(basePath)))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory())))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)dirName -> BoxesRunTime.boxToBoolean((boolean)IncrementalAggUtils$.$anonfun$getSubfolderPaths$3(excludeDirsPrefixList, dirName))))).map((Function1 & Serializable & scala.Serializable)x$3 -> HdfsUtils$.MODULE$.createStringPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{basePath, x$3})), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        return directories;
    }

    public Seq<String> getSubfolderPaths$default$2() {
        return new .colon.colon((Object)".", (List)new .colon.colon((Object)"_", (List)Nil$.MODULE$));
    }

    public Configuration getSubfolderPaths$default$3() {
        return this.conf();
    }

    public Option<String> getLatestAggSnapshotDFPath(String basePath, LocalDateTime cutOffDate) {
        return this.getLatestHistoricalAggregationPath(basePath, cutOffDate);
    }

    public Option<Object> getDaysGapBetweenLatestAggSnapshotAndEndTime(String basePath, String endTime, String endTimeFormat) {
        LocalDateTime endDate = OfflineDateTimeUtils$.MODULE$.createTimeFromString(endTime, endTimeFormat, OfflineDateTimeUtils$.MODULE$.createTimeFromString$default$3()).toLocalDateTime();
        Option<ZonedDateTime> latestAggDate = this.getLatestHistoricalAggregationDate(basePath, endDate);
        return latestAggDate.map((Function1 & Serializable & scala.Serializable)aggDate -> BoxesRunTime.boxToLong((long)ChronoUnit.DAYS.between(aggDate.toInstant(), OfflineDateTimeUtils$.MODULE$.createTimeFromString(endTime, endTimeFormat, OfflineDateTimeUtils$.MODULE$.createTimeFromString$default$3()).toInstant())));
    }

    private ZonedDateTime getNewDeltaWindowStartDate(String rootAggDir, LocalDateTime cutOffDate) {
        Option<ZonedDateTime> latestDateWithAgg = this.getLatestHistoricalAggregationDate(rootAggDir, cutOffDate);
        return (ZonedDateTime)latestDateWithAgg.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(60).append("Cannot getNewDeltaWindowStartDate for path ").append(rootAggDir).append(" with cutOffDate ").append(cutOffDate).toString());
        });
    }

    public static final /* synthetic */ boolean $anonfun$getSubfolderPaths$3(Seq excludeDirsPrefixList$1, String dirName) {
        return !excludeDirsPrefixList$1.exists((Function1 & Serializable & scala.Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)dirName.startsWith(prefix)));
    }

    private IncrementalAggUtils$() {
        MODULE$ = this;
        this.conf = new Configuration();
        this.fs = FileSystem.get((Configuration)this.conf());
    }
}

