/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.util;

import com.linkedin.feathr.offline.util.FeathrUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%4QAC\u0006\u0001\u001bUA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\u0006U\u0001!\ta\u000b\u0005\b_\u0001\u0011\r\u0011\"\u00011\u0011\u0019!\u0004\u0001)A\u0005c!9Q\u0007\u0001b\u0001\n\u0003\u0001\u0004B\u0002\u001c\u0001A\u0003%\u0011\u0007C\u00038\u0001\u0011\u0005\u0001\bC\u00038\u0001\u0011\u0005\u0011\u000bC\u00038\u0001\u0011\u00051K\u0001\tQCJ$\u0018\u000e^5p]2KW.\u001b;fe*\u0011A\"D\u0001\u0005kRLGN\u0003\u0002\u000f\u001f\u00059qN\u001a4mS:,'B\u0001\t\u0012\u0003\u00191W-\u0019;ie*\u0011!cE\u0001\tY&t7.\u001a3j]*\tA#A\u0002d_6\u001c\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g\u0003\t\u00198o\u0001\u0001\u0011\u0005}AS\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013aA:rY*\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014x-\u0003\u0002*A\ta1\u000b]1sWN+7o]5p]\u00061A(\u001b8jiz\"\"\u0001\f\u0018\u0011\u00055\u0002Q\"A\u0006\t\u000bq\u0011\u0001\u0019\u0001\u0010\u0002=M\u0003\u0016IU&`\u0015>Kej\u0018)B%\u0006cE*\u0012'J'6{F)\u0012$B+2#V#A\u0019\u0011\u0005]\u0011\u0014BA\u001a\u0019\u0005\rIe\u000e^\u0001 'B\u000b%kS0K\u001f&su\fU!S\u00032cU\tT%T\u001b~#UIR!V\u0019R\u0003\u0013!I*Q\u0003J[uLS(J\u001d~c\u0015*T%U?B\u000b%\u000bV%U\u0013>suLR!D)>\u0013\u0016AI*Q\u0003J[uLS(J\u001d~c\u0015*T%U?B\u000b%\u000bV%U\u0013>suLR!D)>\u0013\u0006%\u0001\bmS6LG\u000fU1si&$\u0018n\u001c8\u0015\teZUj\u0014\t\u0003u!s!a\u000f$\u000f\u0005q*eBA\u001fE\u001d\tq4I\u0004\u0002@\u00056\t\u0001I\u0003\u0002B;\u00051AH]8pizJ\u0011aJ\u0005\u0003K\u0019J!a\t\u0013\n\u0005\u0005\u0012\u0013BA$!\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0013&\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA$!\u0011\u0015au\u00011\u0001:\u0003\t!g\rC\u0003O\u000f\u0001\u0007\u0011'A\u0011nCb\u001c\u0006/\u0019:l\u0015>Lg\u000eU1sC2dW\r\\5t[\n+gm\u001c:f\u0015>Lg\u000eC\u0003Q\u000f\u0001\u0007\u0011'A\u0011nS:\u001c\u0006/\u0019:l\u0015>Lg\u000eU1sC2dW\r\\5t[\n+gm\u001c:f\u0015>Lg\u000e\u0006\u0002:%\")A\n\u0003a\u0001sU\u0011A+\u0018\u000b\u0005+\u001a<\u0007\u000eE\u0002W3nk\u0011a\u0016\u0006\u00031\n\n1A\u001d3e\u0013\tQvKA\u0002S\t\u0012\u0003\"\u0001X/\r\u0001\u0011)a,\u0003b\u0001?\n\tA+\u0005\u0002aGB\u0011q#Y\u0005\u0003Eb\u0011qAT8uQ&tw\r\u0005\u0002\u0018I&\u0011Q\r\u0007\u0002\u0004\u0003:L\b\"\u0002-\n\u0001\u0004)\u0006\"\u0002(\n\u0001\u0004\t\u0004\"\u0002)\n\u0001\u0004\t\u0004")
public class PartitionLimiter {
    private final SparkSession ss;
    private final int SPARK_JOIN_PARALLELISM_DEFAULT;
    private final int SPARK_JOIN_LIMIT_PARTITION_FACTOR;

    public int SPARK_JOIN_PARALLELISM_DEFAULT() {
        return this.SPARK_JOIN_PARALLELISM_DEFAULT;
    }

    public int SPARK_JOIN_LIMIT_PARTITION_FACTOR() {
        return this.SPARK_JOIN_LIMIT_PARTITION_FACTOR;
    }

    public Dataset<Row> limitPartition(Dataset<Row> df, int maxSparkJoinParallelismBeforeJoin, int minSparkJoinParallelismBeforeJoin) {
        int numParts = df.rdd().getNumPartitions();
        boolean isLocal = this.ss.sparkContext().isLocal();
        return minSparkJoinParallelismBeforeJoin < 0 || isLocal ? df : (maxSparkJoinParallelismBeforeJoin == minSparkJoinParallelismBeforeJoin && numParts != maxSparkJoinParallelismBeforeJoin ? df.repartition(maxSparkJoinParallelismBeforeJoin) : (numParts > maxSparkJoinParallelismBeforeJoin * this.SPARK_JOIN_LIMIT_PARTITION_FACTOR() ? df.coalesce(maxSparkJoinParallelismBeforeJoin) : (numParts < minSparkJoinParallelismBeforeJoin / this.SPARK_JOIN_LIMIT_PARTITION_FACTOR() ? df.repartition(Math.max(this.SPARK_JOIN_PARALLELISM_DEFAULT(), minSparkJoinParallelismBeforeJoin)) : df)));
    }

    public Dataset<Row> limitPartition(Dataset<Row> df) {
        int maxSparkJoinParallelismBeforeJoin = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(this.ss, FeathrUtils$.MODULE$.SPARK_JOIN_MAX_PARALLELISM()))).toInt();
        int minSparkJoinParallelismBeforeJoin = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(this.ss, FeathrUtils$.MODULE$.SPARK_JOIN_MIN_PARALLELISM()))).toInt();
        return this.limitPartition(df, maxSparkJoinParallelismBeforeJoin, minSparkJoinParallelismBeforeJoin);
    }

    public <T> RDD<T> limitPartition(RDD<T> rdd, int maxSparkJoinParallelismBeforeJoin, int minSparkJoinParallelismBeforeJoin) {
        RDD rDD;
        int numParts = rdd.getNumPartitions();
        boolean isLocal = this.ss.sparkContext().isLocal();
        if (minSparkJoinParallelismBeforeJoin < 0 || isLocal) {
            rDD = rdd;
        } else if (maxSparkJoinParallelismBeforeJoin == minSparkJoinParallelismBeforeJoin && numParts != maxSparkJoinParallelismBeforeJoin) {
            int x$1 = maxSparkJoinParallelismBeforeJoin;
            Ordering x$2 = rdd.repartition$default$2(x$1);
            rDD = rdd.repartition(x$1, x$2);
        } else if (rdd.getNumPartitions() > maxSparkJoinParallelismBeforeJoin * this.SPARK_JOIN_LIMIT_PARTITION_FACTOR()) {
            int x$3 = maxSparkJoinParallelismBeforeJoin;
            boolean x$4 = rdd.coalesce$default$2();
            Option x$5 = rdd.coalesce$default$3();
            Ordering x$6 = rdd.coalesce$default$4(x$3, x$4, x$5);
            rDD = rdd.coalesce(x$3, x$4, x$5, x$6);
        } else if (rdd.getNumPartitions() < minSparkJoinParallelismBeforeJoin / this.SPARK_JOIN_LIMIT_PARTITION_FACTOR()) {
            int x$7 = minSparkJoinParallelismBeforeJoin;
            Ordering x$8 = rdd.repartition$default$2(x$7);
            rDD = rdd.repartition(x$7, x$8);
        } else {
            rDD = rdd;
        }
        return rDD;
    }

    public PartitionLimiter(SparkSession ss) {
        this.ss = ss;
        this.SPARK_JOIN_PARALLELISM_DEFAULT = 5000;
        this.SPARK_JOIN_LIMIT_PARTITION_FACTOR = 2;
    }
}

