/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.util.datetime;

import com.linkedin.feathr.offline.util.datetime.DateTimeInterval$;
import com.linkedin.feathr.offline.util.datetime.OfflineDateTimeUtils$;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\u0005]c!B\u000e\u001d\u0001\u0001B\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011e\u0002!\u0011!Q\u0001\nEBQA\u000f\u0001\u0005\u0002mBq\u0001\u0011\u0001C\u0002\u0013%\u0011\t\u0003\u0004C\u0001\u0001\u0006I!\r\u0005\b\u0007\u0002\u0011\r\u0011\"\u0003B\u0011\u0019!\u0005\u0001)A\u0005c!)!\b\u0001C\u0001\u000b\")1\n\u0001C\u0001\u0019\")Q\n\u0001C\u0001\u0019\")a\n\u0001C\u0001\u001f\")Q\u000b\u0001C\u0001-\")\u0001\f\u0001C\u00013\")1\f\u0001C\u00019\")a\f\u0001C\u0001?\")\u0001\r\u0001C\u0001C\")\u0001\u0010\u0001C\u0001s\"1q\u0010\u0001C!\u0003\u0003Aq!!\u0004\u0001\t\u0003\ny\u0001C\u0004\u0002\u0018\u0001!\t%!\u0007\b\u0011\u0005-B\u0004#\u0001!\u0003[1qa\u0007\u000f\t\u0002\u0001\ny\u0003\u0003\u0004;-\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003g1B\u0011AA\u001b\u0011\u001d\t\u0019D\u0006C\u0001\u0003\u0003Bq!!\u0013\u0017\t\u0013\tYE\u0001\tECR,G+[7f\u0013:$XM\u001d<bY*\u0011QDH\u0001\tI\u0006$X\r^5nK*\u0011q\u0004I\u0001\u0005kRLGN\u0003\u0002\"E\u00059qN\u001a4mS:,'BA\u0012%\u0003\u00191W-\u0019;ie*\u0011QEJ\u0001\tY&t7.\u001a3j]*\tq%A\u0002d_6\u001c\"\u0001A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g\u00039\u0019H/\u0019:u\u0013:\u001cG.^:jm\u0016\u001c\u0001\u0001\u0005\u00023o5\t1G\u0003\u00025k\u0005!A/[7f\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u001a\u0003\u000f%s7\u000f^1oi\u0006aQM\u001c3Fq\u000edWo]5wK\u00061A(\u001b8jiz\"2\u0001\u0010 @!\ti\u0004!D\u0001\u001d\u0011\u0015y3\u00011\u00012\u0011\u0015I4\u00011\u00012\u0003\u0015\u0019H/\u0019:u+\u0005\t\u0014AB:uCJ$\b%A\u0002f]\u0012\fA!\u001a8eAQ\u0019AH\u0012&\t\u000b=B\u0001\u0019A$\u0011\u0005IB\u0015BA%4\u00055QvN\\3e\t\u0006$X\rV5nK\")\u0011\b\u0003a\u0001\u000f\u0006Aq-\u001a;Ti\u0006\u0014H/F\u0001H\u0003\u00199W\r^#oI\u0006AqN^3sY\u0006\u00048\u000f\u0006\u0002Q'B\u0011!&U\u0005\u0003%.\u0012qAQ8pY\u0016\fg\u000eC\u0003U\u0017\u0001\u0007A(A\u0003pi\",'/\u0001\u0003ta\u0006tGC\u0001\u001fX\u0011\u0015!F\u00021\u0001=\u00031Ig\u000e^3sg\u0016\u001cG/[8o)\ta$\fC\u0003U\u001b\u0001\u0007A(A\u0006nS:\u001cuN^3sC\u001e,GC\u0001\u001f^\u0011\u0015!f\u00021\u0001=\u0003\u001dI7/R7qif$\u0012\u0001U\u0001\u001dC\u0012TWo\u001d;XSRDG)\u0019;f)&lWMU3t_2,H/[8o)\ta$\rC\u0003d!\u0001\u0007A-A\u0007oK^\u0014Vm]8mkRLwN\u001c\t\u0003KVt!A\u001a:\u000f\u0005\u001d\u0004hB\u00015p\u001d\tIgN\u0004\u0002k[6\t1N\u0003\u0002ma\u00051AH]8pizJ\u0011aJ\u0005\u0003K\u0019J!a\t\u0013\n\u0005E\u0014\u0013AB2p[6|g.\u0003\u0002ti\u0006\u0011B)\u0019;f)&lWMU3t_2,H/[8o\u0015\t\t(%\u0003\u0002wo\n\u0011B)\u0019;f)&lWMU3t_2,H/[8o\u0015\t\u0019H/\u0001\rhKR\fE\u000e\u001c+j[\u0016<\u0016\u000e\u001e5j]&sG/\u001a:wC2$\"A_?\u0011\u0007)Zx)\u0003\u0002}W\t)\u0011I\u001d:bs\")a0\u0005a\u0001I\u0006Q!/Z:pYV$\u0018n\u001c8\u0002\r\u0015\fX/\u00197t)\r\u0001\u00161\u0001\u0005\b\u0003\u000b\u0011\u0002\u0019AA\u0004\u0003\u0011!\b.\u0019;\u0011\u0007)\nI!C\u0002\u0002\f-\u00121!\u00118z\u0003!A\u0017m\u001d5D_\u0012,GCAA\t!\rQ\u00131C\u0005\u0004\u0003+Y#aA%oi\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u001cA!\u0011QDA\u0013\u001d\u0011\ty\"!\t\u0011\u0005)\\\u0013bAA\u0012W\u00051\u0001K]3eK\u001aLA!a\n\u0002*\t11\u000b\u001e:j]\u001eT1!a\t,\u0003A!\u0015\r^3US6,\u0017J\u001c;feZ\fG\u000e\u0005\u0002>-M\u0011a#\u000b\u000b\u0003\u0003[\t1c\u0019:fCR,gI]8n\u0013:\u001cG.^:jm\u0016$r\u0001PA\u001c\u0003s\ti\u0004C\u000301\u0001\u0007\u0011\u0007\u0003\u0004\u0002<a\u0001\r!M\u0001\rK:$\u0017J\\2mkNLg/\u001a\u0005\u0007\u0003\u007fA\u0002\u0019\u00013\u0002%\u0011\fG/\u001a+j[\u0016\u0014Vm]8mkRLwN\u001c\u000b\by\u0005\r\u0013QIA$\u0011\u0015y\u0013\u00041\u0001H\u0011\u0019\tY$\u0007a\u0001\u000f\"1\u0011qH\rA\u0002\u0011\fA\u0001\u001e:j[R9q)!\u0014\u0002R\u0005M\u0003BBA(5\u0001\u0007q)\u0001\u0005eCR,G+[7f\u0011\u0019\tyD\u0007a\u0001I\"1\u0011Q\u000b\u000eA\u0002A\u000bqA]8v]\u0012,\u0006\u000f")
public class DateTimeInterval {
    private final Instant start;
    private final Instant end;

    public static DateTimeInterval createFromInclusive(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, Enumeration.Value value) {
        return DateTimeInterval$.MODULE$.createFromInclusive(zonedDateTime, zonedDateTime2, value);
    }

    public static DateTimeInterval createFromInclusive(Instant instant, Instant instant2, Enumeration.Value value) {
        return DateTimeInterval$.MODULE$.createFromInclusive(instant, instant2, value);
    }

    private Instant start() {
        return this.start;
    }

    private Instant end() {
        return this.end;
    }

    public ZonedDateTime getStart() {
        return this.start().atZone(OfflineDateTimeUtils$.MODULE$.DEFAULT_ZONE_ID());
    }

    public ZonedDateTime getEnd() {
        return this.end().atZone(OfflineDateTimeUtils$.MODULE$.DEFAULT_ZONE_ID());
    }

    public boolean overlaps(DateTimeInterval other) {
        return other.equals(this) || this.start().compareTo(other.end()) < 0 && other.start().compareTo(this.end()) < 0;
    }

    public DateTimeInterval span(DateTimeInterval other) {
        Instant minStart = this.start().compareTo(other.start()) <= 0 ? this.start() : other.start();
        Instant maxEnd = this.end().compareTo(other.end()) >= 0 ? this.end() : other.end();
        return new DateTimeInterval(minStart, maxEnd);
    }

    public DateTimeInterval intersection(DateTimeInterval other) {
        Instant maxStart = this.start().compareTo(other.start()) >= 0 ? this.start() : other.start();
        Instant minEnd = this.end().compareTo(other.end()) <= 0 ? this.end() : other.end();
        return maxStart.compareTo(minEnd) < 0 ? new DateTimeInterval(maxStart, minEnd) : new DateTimeInterval(maxStart, maxStart);
    }

    public DateTimeInterval minCoverage(DateTimeInterval other) {
        Instant minStart = this.start().compareTo(other.start()) < 0 ? this.start() : other.start();
        Instant maxEnd = this.end().compareTo(other.end()) > 0 ? this.end() : other.end();
        return new DateTimeInterval(minStart, maxEnd);
    }

    public boolean isEmpty() {
        return this.start().compareTo(this.end()) == 0;
    }

    public DateTimeInterval adjustWithDateTimeResolution(Enumeration.Value newResolution) {
        DateTimeInterval dateTimeInterval;
        Instant newStart = DateTimeInterval$.MODULE$.com$linkedin$feathr$offline$util$datetime$DateTimeInterval$$trim(this.getStart(), newResolution, false).toInstant();
        if (this.isEmpty()) {
            dateTimeInterval = new DateTimeInterval(newStart, newStart);
        } else {
            Instant newEnd = DateTimeInterval$.MODULE$.com$linkedin$feathr$offline$util$datetime$DateTimeInterval$$trim(this.getEnd(), newResolution, true).toInstant();
            dateTimeInterval = new DateTimeInterval(newStart, newEnd);
        }
        return dateTimeInterval;
    }

    public ZonedDateTime[] getAllTimeWithinInterval(Enumeration.Value resolution) {
        DateTimeInterval adjusted = this.adjustWithDateTimeResolution(resolution);
        ChronoUnit chronoUnit = OfflineDateTimeUtils$.MODULE$.dateTimeResolutionToChronoUnit(resolution);
        long length = chronoUnit.between(adjusted.getStart(), adjusted.getEnd());
        ZonedDateTime startTime = adjusted.getStart();
        return (ZonedDateTime[])((TraversableOnce)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)length)).map((Function1 & java.io.Serializable & Serializable)i -> startTime.plus(BoxesRunTime.unboxToLong((Object)i), chronoUnit), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ZonedDateTime.class));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof DateTimeInterval)) return false;
        DateTimeInterval dateTimeInterval = (DateTimeInterval)object;
        if (this == dateTimeInterval) return true;
        Instant instant = this.start();
        Instant instant2 = dateTimeInterval.start();
        if (instant == null) {
            if (instant2 != null) {
                return false;
            }
        } else if (!((Object)instant).equals(instant2)) return false;
        Instant instant3 = this.end();
        Instant instant4 = dateTimeInterval.end();
        if (instant3 == null) {
            if (instant4 == null) return true;
            return false;
        } else {
            if (!((Object)instant3).equals(instant4)) return false;
            return true;
        }
    }

    public int hashCode() {
        return Objects.hash(this.start(), this.end());
    }

    public String toString() {
        return new StringBuilder(1).append(this.getStart().toString()).append("/").append(this.getEnd().toString()).toString();
    }

    public DateTimeInterval(Instant startInclusive, Instant endExclusive) {
        this.start = startInclusive;
        this.end = endExclusive;
    }

    public DateTimeInterval(ZonedDateTime startInclusive, ZonedDateTime endExclusive) {
        this(startInclusive.toInstant(), endExclusive.toInstant());
    }
}

