/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.util.datetime;

import com.linkedin.feathr.common.DateParam;
import com.linkedin.feathr.common.DateTimeResolution$;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.config.ObservationDataTimeSetting;
import com.linkedin.feathr.offline.util.datetime.DateTimeInterval;
import com.linkedin.feathr.offline.util.datetime.DateTimeInterval$;
import com.linkedin.feathr.offline.util.datetime.DateTimePeriod;
import com.linkedin.feathr.offline.util.datetime.DateTimePeriod$;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.TimeZone;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering$;

public final class OfflineDateTimeUtils$ {
    public static OfflineDateTimeUtils$ MODULE$;
    private final String DEFAULT_TIMEZONE;
    private final ZoneId DEFAULT_ZONE_ID;
    private final String DEFAULT_TIME_FORMAT;
    private final String DEFAULT_HOURLY_TIME_FORMAT;

    static {
        new OfflineDateTimeUtils$();
    }

    public DateTimeInterval createTimeIntervalFromDateTimeRange(ObservationDataTimeSetting observationDataTimeSettings) {
        return this.createTimeIntervalFromDateParam((Option<DateParam>)new Some((Object)observationDataTimeSettings.dateParam()), observationDataTimeSettings.timeFormat(), this.createTimeIntervalFromDateParam$default$3());
    }

    public String DEFAULT_TIMEZONE() {
        return this.DEFAULT_TIMEZONE;
    }

    public ZoneId DEFAULT_ZONE_ID() {
        return this.DEFAULT_ZONE_ID;
    }

    public String DEFAULT_TIME_FORMAT() {
        return this.DEFAULT_TIME_FORMAT;
    }

    public String DEFAULT_HOURLY_TIME_FORMAT() {
        return this.DEFAULT_HOURLY_TIME_FORMAT;
    }

    public String dateRange(DateTimeInterval interval, Enumeration.Value dateTimeResolution) {
        DateTimeInterval adjusted = interval.adjustWithDateTimeResolution(dateTimeResolution);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH").withZone(this.DEFAULT_ZONE_ID());
        String localStartTime = formatter.format(adjusted.getStart());
        String localEndTime = formatter.format(adjusted.getEnd());
        return new StringBuilder(42).append("datepartition >= '").append(localStartTime).append("' and datepartition < '").append(localEndTime).append("'").toString();
    }

    public DateTimeInterval getFactDataTimeRange(DateTimeInterval obsTimeRange, Duration window, Duration[] timeDelays) {
        Duration minTimeDelay = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timeDelays)).isEmpty() ? Duration.ZERO : (Duration)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timeDelays)).min(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        Duration maxTimeDelay = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timeDelays)).isEmpty() ? Duration.ZERO : (Duration)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timeDelays)).max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        ZonedDateTime newStartTime = obsTimeRange.getStart().minus(window).minus(maxTimeDelay);
        ZonedDateTime newEndTime = obsTimeRange.getEnd().minus(minTimeDelay);
        return new DateTimeInterval(newStartTime, newEndTime);
    }

    public ZonedDateTime createTimeFromString(String dateString, String formatString, String tz) {
        SimpleDateFormat format = new SimpleDateFormat(formatString);
        format.setTimeZone(TimeZone.getTimeZone(tz));
        Date date = format.parse(new StringOps(Predef$.MODULE$.augmentString(dateString)).stripMargin('/').replaceAll("//", "/"));
        return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.of(tz));
    }

    public String createTimeFromString$default$2() {
        return this.DEFAULT_TIME_FORMAT();
    }

    public String createTimeFromString$default$3() {
        return this.DEFAULT_TIMEZONE();
    }

    public DateTimeInterval createTimeIntervalFromDateParam(Option<DateParam> dateParamOpt, Option<String> timeFormatOpt, Option<String> targetDate) {
        DateTimeInterval dateTimeInterval;
        if (dateParamOpt.isEmpty()) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "Trying to create time Interval from DateParam. Date is not defined. Please provide date.");
        }
        DateParam dateParam = (DateParam)dateParamOpt.get();
        String timeFormat = (String)timeFormatOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_TIME_FORMAT());
        boolean absoluteDateSet = dateParam.startDate().nonEmpty() && dateParam.endDate().nonEmpty();
        boolean relativeDateSet = dateParam.numDays().nonEmpty();
        if (absoluteDateSet && !relativeDateSet) {
            ZonedDateTime startDate = this.createTimeFromString((String)dateParam.startDate().get(), timeFormat, this.createTimeFromString$default$3());
            ZonedDateTime endDate = this.createTimeFromString((String)dateParam.endDate().get(), timeFormat, this.createTimeFromString$default$3());
            dateTimeInterval = DateTimeInterval$.MODULE$.createFromInclusive(startDate, endDate, this.getDateTimeResolutionFromPattern(timeFormat));
        } else if (relativeDateSet && !absoluteDateSet) {
            DateTimePeriod offset = DateTimePeriod$.MODULE$.parse((String)dateParam.dateOffset().getOrElse((Function0 & Serializable & scala.Serializable)() -> "0h"));
            DateTimePeriod window = DateTimePeriod$.MODULE$.parse((String)dateParam.numDays().get());
            if (offset.length() < 0L) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(127).append("Trying to create a valid time interval. ").append("dateOffset(").append(dateParam).append(".dateOffset) should be non-negative. Please provide non-negative dateOffset.").toString());
            }
            if (window.length() <= 0L) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(110).append("Trying to create a valid time interval.").append("numDays(").append(dateParam).append(".numDays) should be positive.").append("Please provide a positive numDays.").toString());
            }
            Enumeration.Value resolution = window.unit();
            ZonedDateTime baseDate = targetDate.isDefined() ? this.createTimeFromString((String)targetDate.get(), timeFormat, this.createTimeFromString$default$3()) : ZonedDateTime.now(this.DEFAULT_ZONE_ID()).truncatedTo(this.dateTimeResolutionToChronoUnit(resolution));
            ZonedDateTime endDate = baseDate.minus(offset.length(), this.dateTimeResolutionToChronoUnit(offset.unit()));
            ZonedDateTime startDate = endDate.minus(window.length() - 1L, this.dateTimeResolutionToChronoUnit(window.unit()));
            dateTimeInterval = DateTimeInterval$.MODULE$.createFromInclusive(startDate, endDate, resolution);
        } else {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(224).append("Trying to create a valid time interval.").append("The provided format is incorrect: dateParam - ").append(dateParam).append(", targetDate - ").append(targetDate).append("Please either set both startDate and endDate, or both numDays and dateOffset. Other parameter combinations are not accepted.").toString());
        }
        return dateTimeInterval;
    }

    public Option<String> createTimeIntervalFromDateParam$default$3() {
        return None$.MODULE$;
    }

    public DateTimeInterval createIntervalFromFeatureGenDateParam(DateParam dateParam) {
        Tuple2 tuple2;
        ChronoUnit chronoUnit = dateParam.getResolution();
        if (ChronoUnit.DAYS.equals(chronoUnit)) {
            tuple2 = new Tuple2((Object)this.DEFAULT_TIME_FORMAT(), (Object)DateTimeResolution$.MODULE$.DAILY());
        } else if (ChronoUnit.HOURS.equals(chronoUnit)) {
            tuple2 = new Tuple2((Object)this.DEFAULT_HOURLY_TIME_FORMAT(), (Object)DateTimeResolution$.MODULE$.HOURLY());
        } else {
            throw new MatchError((Object)chronoUnit);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String timeFormat = (String)tuple22._1();
        Enumeration.Value resolution = (Enumeration.Value)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)timeFormat, (Object)resolution);
        Tuple2 tuple24 = tuple23;
        String timeFormat2 = (String)tuple24._1();
        Enumeration.Value resolution2 = (Enumeration.Value)tuple24._2();
        ZonedDateTime startDate = this.createTimeFromString((String)dateParam.startDate().get(), timeFormat2, this.createTimeFromString$default$3());
        ZonedDateTime endDate = this.createTimeFromString((String)dateParam.endDate().get(), timeFormat2, this.createTimeFromString$default$3());
        ZonedDateTime zonedDateTime = startDate;
        ZonedDateTime zonedDateTime2 = endDate;
        return !(zonedDateTime != null ? !((Object)zonedDateTime).equals(zonedDateTime2) : zonedDateTime2 != null) ? DateTimeInterval$.MODULE$.createFromInclusive(startDate, endDate, resolution2) : new DateTimeInterval(startDate, endDate);
    }

    public long truncateEpochSecond(long epochSecond, boolean isDaily) {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSecond), this.DEFAULT_ZONE_ID()).truncatedTo(isDaily ? ChronoUnit.DAYS : ChronoUnit.HOURS).toEpochSecond();
    }

    public Enumeration.Value getDateTimeResolutionFromPattern(String pattern) {
        return pattern.matches(".*[HhKk].*") ? DateTimeResolution$.MODULE$.HOURLY() : DateTimeResolution$.MODULE$.DAILY();
    }

    public ChronoUnit dateTimeResolutionToChronoUnit(Enumeration.Value dateTimeResolution) {
        ChronoUnit chronoUnit;
        Enumeration.Value value = dateTimeResolution;
        Enumeration.Value value2 = DateTimeResolution$.MODULE$.DAILY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            chronoUnit = ChronoUnit.DAYS;
        } else {
            Enumeration.Value value4 = DateTimeResolution$.MODULE$.HOURLY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                chronoUnit = ChronoUnit.HOURS;
            } else {
                throw new MatchError((Object)value);
            }
        }
        return chronoUnit;
    }

    private OfflineDateTimeUtils$() {
        MODULE$ = this;
        this.DEFAULT_TIMEZONE = "America/Los_Angeles";
        this.DEFAULT_ZONE_ID = ZoneId.of(this.DEFAULT_TIMEZONE());
        this.DEFAULT_TIME_FORMAT = "yyyyMMdd";
        this.DEFAULT_HOURLY_TIME_FORMAT = "yyyyMMddHH";
    }
}

