/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.swj;

import com.linkedin.feathr.swj.FactData;
import com.linkedin.feathr.swj.LabelData;
import com.linkedin.feathr.swj.SlidingWindowFeature;
import com.linkedin.feathr.swj.join.FeatureColumnMetaData;
import com.linkedin.feathr.swj.join.SlidingWindowJoinIterator;
import com.linkedin.feathr.swj.join.SlidingWindowJoinIterator$;
import com.linkedin.feathr.swj.transformer.FeatureTransformer$;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class SlidingWindowJoin$ {
    public static SlidingWindowJoin$ MODULE$;
    private SparkSession spark;
    private final Logger log;
    private final String LABEL_VIEW_NAME;
    private volatile boolean bitmap$0;

    static {
        new SlidingWindowJoin$();
    }

    public Logger log() {
        return this.log;
    }

    private SparkSession spark$lzycompute() {
        SlidingWindowJoin$ slidingWindowJoin$ = this;
        synchronized (slidingWindowJoin$) {
            if (!this.bitmap$0) {
                this.spark = SparkSession$.MODULE$.builder().getOrCreate();
                this.bitmap$0 = true;
            }
        }
        return this.spark;
    }

    public SparkSession spark() {
        return !this.bitmap$0 ? this.spark$lzycompute() : this.spark;
    }

    private String LABEL_VIEW_NAME() {
        return this.LABEL_VIEW_NAME;
    }

    public Dataset<Row> join(LabelData labelDataset, List<FactData> factDatasets, int numPartitions) {
        factDatasets.foreach((Function1 & Serializable & scala.Serializable)factDataset -> {
            SlidingWindowJoin$.$anonfun$join$1(factDataset);
            return BoxedUnit.UNIT;
        });
        Dataset<Row> labelDF = this.addLabelDataCols(labelDataset.dataSource(), labelDataset);
        ObjectRef result = ObjectRef.create((Object)labelDF.repartition(numPartitions, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{labelDF.col(FeatureTransformer$.MODULE$.JOIN_KEY_COL_NAME())})).sortWithinPartitions(FeatureTransformer$.MODULE$.JOIN_KEY_COL_NAME(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{FeatureTransformer$.MODULE$.TIMESTAMP_COL_NAME()})).rdd());
        ObjectRef resultSchema = ObjectRef.create((Object)labelDF.schema());
        int labelJoinKeyIndex = ((StructType)resultSchema.elem).fieldIndex(FeatureTransformer$.MODULE$.JOIN_KEY_COL_NAME());
        int labelTimestampIndex = ((StructType)resultSchema.elem).fieldIndex(FeatureTransformer$.MODULE$.TIMESTAMP_COL_NAME());
        factDatasets.foreach((Function1 & Serializable & scala.Serializable)factDataset -> {
            SlidingWindowJoin$.$anonfun$join$3(numPartitions, result, resultSchema, labelJoinKeyIndex, labelTimestampIndex, factDataset);
            return BoxedUnit.UNIT;
        });
        return this.spark().createDataFrame((RDD)result.elem, (StructType)resultSchema.elem).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{FeatureTransformer$.MODULE$.JOIN_KEY_COL_NAME(), FeatureTransformer$.MODULE$.TIMESTAMP_COL_NAME()}));
    }

    public int join$default$3() {
        return this.spark().sparkContext().getConf().getInt(SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key(), 200);
    }

    private Dataset<Row> addLabelDataCols(Dataset<Row> labelDF, LabelData labelDataset) {
        labelDF.createOrReplaceTempView(this.LABEL_VIEW_NAME());
        return this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n         |SELECT\n         |").append((Object)(labelDataset.joinKey().size() > 1 ? new StringBuilder(8).append("struct(").append(labelDataset.joinKey().mkString(",")).append(")").toString() : String.valueOf(labelDataset.joinKey().head()))).append(" AS ").append(FeatureTransformer$.MODULE$.JOIN_KEY_COL_NAME()).append(",\n         |").append(labelDataset.timestampCol()).append(" AS ").append(FeatureTransformer$.MODULE$.TIMESTAMP_COL_NAME()).append(", * FROM ").append(this.LABEL_VIEW_NAME()).append("\n       ").toString())).stripMargin());
    }

    public static final /* synthetic */ void $anonfun$join$2(SlidingWindowFeature swaFeature) {
        MODULE$.log().info(new StringBuilder(20).append("Evaluating feature ").append(swaFeature.name()).append("\n").toString());
    }

    public static final /* synthetic */ void $anonfun$join$1(FactData factDataset) {
        factDataset.aggFeatures().foreach((Function1 & Serializable & scala.Serializable)swaFeature -> {
            SlidingWindowJoin$.$anonfun$join$2(swaFeature);
            return BoxedUnit.UNIT;
        });
        MODULE$.log().info(new StringBuilder(20).append("Feature's keys are ").append(factDataset.joinKey()).append("\n").toString());
    }

    public static final /* synthetic */ void $anonfun$join$3(int numPartitions$1, ObjectRef result$1, ObjectRef resultSchema$1, int labelJoinKeyIndex$1, int labelTimestampIndex$1, FactData factDataset) {
        Dataset<Row> factDF = FeatureTransformer$.MODULE$.transformFactData(factDataset);
        RDD factRDD = factDF.repartition(numPartitions$1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{factDF.col(FeatureTransformer$.MODULE$.JOIN_KEY_COL_NAME())})).sortWithinPartitions(FeatureTransformer$.MODULE$.JOIN_KEY_COL_NAME(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{FeatureTransformer$.MODULE$.TIMESTAMP_COL_NAME()})).rdd();
        StructType factSchema = factDF.schema();
        if (!factDataset.dataSource().isEmpty()) {
            result$1.elem = ((RDD)result$1.elem).zipPartitions(factRDD, true, (Function2 & Serializable & scala.Serializable)(left, right) -> new SlidingWindowJoinIterator((Iterator<Row>)left, (Iterator<Row>)right, (StructType)resultSchema$1.elem, labelJoinKeyIndex$1, labelTimestampIndex$1, factSchema, factDataset.aggFeatures()), ClassTag$.MODULE$.apply(Row.class), ClassTag$.MODULE$.apply(Row.class));
        } else {
            Seq NULL_SEQ = (Seq)factDataset.aggFeatures().map((Function1 & Serializable & scala.Serializable)x$1 -> null, List$.MODULE$.canBuildFrom());
            RDD qual$1 = (RDD)result$1.elem;
            Function1 & Serializable & scala.Serializable x$12 = (Function1 & Serializable & scala.Serializable)iter -> iter.map((Function1 & Serializable & scala.Serializable)row -> Row$.MODULE$.merge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{row, Row$.MODULE$.fromSeq(NULL_SEQ)})));
            boolean x$2 = qual$1.mapPartitions$default$2();
            result$1.elem = qual$1.mapPartitions((Function1)x$12, x$2, ClassTag$.MODULE$.apply(Row.class));
        }
        List<FeatureColumnMetaData> featureColMetadata = SlidingWindowJoinIterator$.MODULE$.generateFeatureColumns(factDataset.aggFeatures(), factSchema);
        StructType featureSchema = StructType$.MODULE$.apply((Seq)featureColMetadata.map((Function1 & Serializable & scala.Serializable)col -> {
            StructField structField;
            if (col.groupSpec().isEmpty()) {
                structField = new StructField(col.featureName(), col.aggDataType(), true, StructField$.MODULE$.apply$default$4());
            } else {
                StructField structField2 = new StructField(FeatureTransformer$.MODULE$.GROUP_COL_NAME(), (DataType)col.groupColDataType().get(), true, StructField$.MODULE$.apply$default$4());
                StructField structField3 = new StructField("group_agg_metric", col.aggDataType(), true, StructField$.MODULE$.apply$default$4());
                StructType elementStructType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3).$colon$colon((Object)structField2));
                ArrayType arrayType = ArrayType$.MODULE$.apply((DataType)elementStructType);
                structField = new StructField(col.featureName(), (DataType)arrayType, true, StructField$.MODULE$.apply$default$4());
            }
            return structField;
        }, List$.MODULE$.canBuildFrom()));
        resultSchema$1.elem = StructType$.MODULE$.apply((Seq)((StructType)resultSchema$1.elem).$plus$plus((GenTraversableOnce)featureSchema, Seq$.MODULE$.canBuildFrom()));
    }

    private SlidingWindowJoin$() {
        MODULE$ = this;
        this.log = LogManager.getLogger(this.getClass());
        this.LABEL_VIEW_NAME = "label_data";
    }
}

