/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.swj.aggregate;

import com.linkedin.feathr.swj.aggregate.AggregationSpec;
import com.linkedin.feathr.swj.aggregate.AggregationType$;
import com.linkedin.feathr.swj.aggregate.AvgAggregate$;
import com.linkedin.feathr.swj.join.FeatureColumnMetaData;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\n\u0015\u0001}A\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tm\u0001\u0011\t\u0011)A\u0005W!)q\u0007\u0001C\u0001q!)A\b\u0001C!{!)Q\t\u0001C!\r\")q\t\u0001C!\u0011\")\u0001\u000b\u0001C!#\")Q\u000b\u0001C!#\")a\u000b\u0001C!/\")A\u000e\u0001C![\")\u0011\u0010\u0001C!u\"1q\u0010\u0001C!\u0003\u0003Aq!!\u0003\u0001\t\u0013\tYaB\u0005\u0002*Q\t\t\u0011#\u0001\u0002,\u0019A1\u0003FA\u0001\u0012\u0003\ti\u0003\u0003\u00048\u001f\u0011\u0005\u0011Q\u0007\u0005\n\u0003oy\u0011\u0013!C\u0001\u0003sA\u0011\"a\u0014\u0010\u0003\u0003%I!!\u0015\u0003\u0019\u00053x-Q4he\u0016<\u0017\r^3\u000b\u0005U1\u0012!C1hOJ,w-\u0019;f\u0015\t9\u0002$A\u0002to*T!!\u0007\u000e\u0002\r\u0019,\u0017\r\u001e5s\u0015\tYB$\u0001\u0005mS:\\W\rZ5o\u0015\u0005i\u0012aA2p[\u000e\u00011c\u0001\u0001!MA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\u0004\"a\n\u0015\u000e\u0003QI!!\u000b\u000b\u0003\u001f\u0005;wM]3hCRLwN\\*qK\u000e\f\u0001B^1mk\u0016\u001cu\u000e\u001c\t\u0003YMr!!L\u0019\u0011\u00059\u0012S\"A\u0018\u000b\u0005Ar\u0012A\u0002\u001fs_>$h(\u0003\u00023E\u00051\u0001K]3eK\u001aL!\u0001N\u001b\u0003\rM#(/\u001b8h\u0015\t\u0011$%\u0001\u0005d_VtGoQ8m\u0003\u0019a\u0014N\\5u}Q\u0019\u0011HO\u001e\u0011\u0005\u001d\u0002\u0001\"\u0002\u0016\u0004\u0001\u0004Y\u0003b\u0002\u001c\u0004!\u0003\u0005\raK\u0001\fC\u001e<'/Z4bi&|g.F\u0001?!\ty$I\u0004\u0002(\u0001&\u0011\u0011\tF\u0001\u0010\u0003\u001e<'/Z4bi&|g\u000eV=qK&\u00111\t\u0012\u0002\u0010\u0003\u001e<'/Z4bi&|g\u000eV=qK*\u0011\u0011\tF\u0001\n[\u0016$(/[2D_2,\u0012aK\u0001\u000b[\u0016$(/[2OC6,W#A%\u0011\u0005){U\"A&\u000b\u00051k\u0015\u0001\u00027b]\u001eT\u0011AT\u0001\u0005U\u00064\u0018-\u0003\u00025\u0017\u0006\u0001\u0012n]%oGJ,W.\u001a8uC2\fumZ\u000b\u0002%B\u0011\u0011eU\u0005\u0003)\n\u0012qAQ8pY\u0016\fg.\u0001\u000ejg\u000e\u000bGnY;mCR,\u0017iZ4sK\u001e\fG/\u001a(fK\u0012,G-\u0001\ndC2\u001cW\u000f\\1uK\u0006;wM]3hCR,Gc\u0001-\\9B\u0011\u0011%W\u0005\u00035\n\u00121!\u00118z\u0011\u0015)\u0012\u00021\u0001Y\u0011\u0015i\u0016\u00021\u0001_\u0003!!\u0017\r^1UsB,\u0007CA0k\u001b\u0005\u0001'BA1c\u0003\u0015!\u0018\u0010]3t\u0015\t\u0019G-A\u0002tc2T!!\u001a4\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dD\u0017AB1qC\u000eDWMC\u0001j\u0003\ry'oZ\u0005\u0003W\u0002\u0014\u0001\u0002R1uCRK\b/Z\u0001\u0012kB$\u0017\r^3BO\u001e$\u0015\r^1UsB,GC\u00018r!\t\ts.\u0003\u0002qE\t!QK\\5u\u0011\u0015\u0011(\u00021\u0001t\u0003U1W-\u0019;ve\u0016\u001cu\u000e\\;n]6+G/\u0019#bi\u0006\u0004\"\u0001^<\u000e\u0003UT!A\u001e\f\u0002\t)|\u0017N\\\u0005\u0003qV\u0014QCR3biV\u0014XmQ8mk6tW*\u001a;b\t\u0006$\u0018-A\u0002bO\u001e$B\u0001W>}}\")Qc\u0003a\u00011\")Qp\u0003a\u00011\u00061!/Z2pe\u0012DQ!X\u0006A\u0002y\u000bQ\u0001Z3bO\u001e$r\u0001WA\u0002\u0003\u000b\t9\u0001C\u0003\u0016\u0019\u0001\u0007\u0001\fC\u0003~\u0019\u0001\u0007\u0001\fC\u0003^\u0019\u0001\u0007a,\u0001\u0004hK:\u0014vn\u001e\u000b\r\u0003\u001b\t)\"!\u0007\u0002\u001e\u0005\u0005\u0012Q\u0005\t\u0005\u0003\u001f\t\t\"D\u0001c\u0013\r\t\u0019B\u0019\u0002\u0004%><\bBBA\f\u001b\u0001\u0007a,A\u0005wC2,X\rV=qK\"1\u00111D\u0007A\u0002y\u000b\u0011bY8v]R$\u0016\u0010]3\t\u000f\u0005}Q\u00021\u0001\u0002\u000e\u0005a\u0011mZ4sK\u001e\fG/\u001a*po\"9\u00111E\u0007A\u0002\u00055\u0011!\u0003:fG>\u0014HMU8x\u0011\u0019\t9#\u0004a\u0001%\u0006)\u0011n]!hO\u0006a\u0011I^4BO\u001e\u0014XmZ1uKB\u0011qeD\n\u0005\u001f\u0001\ny\u0003E\u0002\"\u0003cI1!a\r#\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\tY#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003wQ3aKA\u001fW\t\ty\u0004\u0005\u0003\u0002B\u0005-SBAA\"\u0015\u0011\t)%a\u0012\u0002\u0013Ut7\r[3dW\u0016$'bAA%E\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00131\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u0015\u0011\u0007)\u000b)&C\u0002\u0002X-\u0013aa\u00142kK\u000e$\b")
public class AvgAggregate
implements AggregationSpec {
    private final String valueCol;
    private final String countCol;

    public static String $lessinit$greater$default$2() {
        return AvgAggregate$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public Enumeration.Value aggregation() {
        return AggregationType$.MODULE$.AVG();
    }

    @Override
    public String metricCol() {
        return new StringBuilder(10).append("struct(").append(this.valueCol).append(", ").append(this.countCol).append(")").toString();
    }

    @Override
    public String metricName() {
        return "avg_col";
    }

    @Override
    public boolean isIncrementalAgg() {
        return true;
    }

    @Override
    public boolean isCalculateAggregateNeeded() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object calculateAggregate(Object aggregate, DataType dataType) {
        Object object;
        if (aggregate == null) {
            object = aggregate;
            return object;
        } else {
            Double d;
            double d2;
            StructType structType;
            StructField[] fields;
            DataType dataType2 = dataType;
            if (!(dataType2 instanceof StructType) || (fields = (structType = (StructType)dataType2).fields()).length != 2) throw new RuntimeException(new StringBuilder(96).append("Invalid data type for AVG aggregate result. ").append("Only StructType with 2 fields is supported, but got ").append(dataType.typeName()).toString());
            DataType valueType = fields[0].dataType();
            DataType countType = fields[1].dataType();
            Row aggregateRow = (Row)aggregate;
            DataType dataType3 = countType;
            if (IntegerType$.MODULE$.equals(dataType3)) {
                d2 = aggregateRow.getInt(1);
            } else {
                if (!LongType$.MODULE$.equals(dataType3)) throw new RuntimeException(new StringBuilder(102).append("Invalid data type for count column for AVG ").append("aggregate result. Only Int and Long are supported, but got ").append(countType.typeName()).toString());
                d2 = aggregateRow.getLong(1);
            }
            double count = d2;
            DataType dataType4 = valueType;
            if (IntegerType$.MODULE$.equals(dataType4)) {
                d = BoxesRunTime.boxToDouble((double)((double)aggregateRow.getInt(0) / count));
            } else if (LongType$.MODULE$.equals(dataType4)) {
                d = BoxesRunTime.boxToDouble((double)((double)aggregateRow.getLong(0) / count));
            } else if (DoubleType$.MODULE$.equals(dataType4)) {
                d = BoxesRunTime.boxToDouble((double)(aggregateRow.getDouble(0) / count));
            } else {
                if (!FloatType$.MODULE$.equals(dataType4)) throw new RuntimeException(new StringBuilder(110).append("Invalid data type for value column for AVG ").append("aggregate. Only Int, Long, Double and Float are supported, but got ").append(valueType.typeName()).toString());
                d = BoxesRunTime.boxToDouble((double)((double)aggregateRow.getFloat(0) / count));
            }
            Double d3 = d;
            object = d3;
        }
        return object;
    }

    @Override
    public void updateAggDataType(FeatureColumnMetaData featureColumnMetaData) {
        featureColumnMetaData.aggDataType_$eq((DataType)DoubleType$.MODULE$);
    }

    @Override
    public Object agg(Object aggregate, Object record, DataType dataType) {
        Object object;
        if (aggregate == null) {
            object = record;
        } else if (record == null) {
            object = aggregate;
        } else {
            StructType structType;
            StructField[] fields;
            DataType dataType2 = dataType;
            if (!(dataType2 instanceof StructType) || (fields = (structType = (StructType)dataType2).fields()).length != 2) {
                throw new RuntimeException(new StringBuilder(91).append("Invalid data type for AVG metric col ").append(this.metricCol()).append(". ").append("Only StructType with 2 fields is supported, but got ").append(dataType.typeName()).toString());
            }
            Row row = this.genRow(fields[0].dataType(), fields[1].dataType(), (Row)aggregate, (Row)record, true);
            object = row;
        }
        return object;
    }

    @Override
    public Object deagg(Object aggregate, Object record, DataType dataType) {
        Object object;
        if (record == null) {
            object = aggregate;
        } else {
            StructType structType;
            StructField[] fields;
            if (aggregate == null) {
                throw new RuntimeException(new StringBuilder(111).append("Aggregate result is null but the record to be removed from aggregate ").append("is not. Such scenario should never happen.").toString());
            }
            DataType dataType2 = dataType;
            if (!(dataType2 instanceof StructType) || (fields = (structType = (StructType)dataType2).fields()).length != 2) {
                throw new RuntimeException(new StringBuilder(91).append("Invalid data type for AVG metric col ").append(this.metricCol()).append(". ").append("Only StructType with 2 fields is supported, but got ").append(dataType.typeName()).toString());
            }
            Row row = this.genRow(fields[0].dataType(), fields[1].dataType(), (Row)aggregate, (Row)record, false);
            object = row;
        }
        return object;
    }

    private Row genRow(DataType valueType, DataType countType, Row aggregateRow, Row recordRow, boolean isAgg) {
        Number number;
        Number number2;
        DataType dataType = countType;
        if (IntegerType$.MODULE$.equals(dataType)) {
            int aggCount = aggregateRow.getInt(1);
            int recordCount = recordRow.getInt(1);
            number2 = isAgg ? BoxesRunTime.boxToInteger((int)(aggCount + recordCount)) : BoxesRunTime.boxToInteger((int)(aggCount - recordCount));
        } else if (LongType$.MODULE$.equals(dataType)) {
            long aggCount = aggregateRow.getLong(1);
            long recordCount = recordRow.getLong(1);
            number2 = isAgg ? BoxesRunTime.boxToLong((long)(aggCount + recordCount)) : BoxesRunTime.boxToLong((long)(aggCount - recordCount));
        } else {
            throw new RuntimeException(new StringBuilder(96).append("Invalid data type for count column ").append(this.countCol).append(" for ").append("AVG aggregate. Only Int and Long are supported, but got ").append(countType.typeName()).toString());
        }
        Integer count = number2;
        DataType dataType2 = valueType;
        if (IntegerType$.MODULE$.equals(dataType2)) {
            int aggValue = aggregateRow.getInt(0);
            int recordValue = recordRow.getInt(0);
            number = isAgg ? BoxesRunTime.boxToInteger((int)(aggValue + recordValue)) : BoxesRunTime.boxToInteger((int)(aggValue - recordValue));
        } else if (LongType$.MODULE$.equals(dataType2)) {
            long aggValue = aggregateRow.getLong(0);
            long recordValue = recordRow.getLong(0);
            number = isAgg ? BoxesRunTime.boxToLong((long)(aggValue + recordValue)) : BoxesRunTime.boxToLong((long)(aggValue - recordValue));
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            double aggValue = aggregateRow.getDouble(0);
            double recordValue = recordRow.getDouble(0);
            number = isAgg ? BoxesRunTime.boxToDouble((double)(aggValue + recordValue)) : BoxesRunTime.boxToDouble((double)(aggValue - recordValue));
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            float aggValue = aggregateRow.getFloat(0);
            float recordValue = recordRow.getFloat(0);
            number = isAgg ? BoxesRunTime.boxToFloat((float)(aggValue + recordValue)) : BoxesRunTime.boxToFloat((float)(aggValue - recordValue));
        } else {
            throw new RuntimeException(new StringBuilder(111).append("Invalid data type for value column ").append(this.valueCol).append(" ").append("for AVG aggregate. Only Int, Long, Double and Float are supported, but got ").append(valueType.typeName()).toString());
        }
        Integer value = number;
        return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value, count}));
    }

    public AvgAggregate(String valueCol, String countCol) {
        this.valueCol = valueCol;
        this.countCol = countCol;
        AggregationSpec.$init$(this);
    }
}

