/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common;

import com.google.common.base.Objects;
import com.linkedin.feathr.common.FeatureErrorCode;
import java.util.StringJoiner;

public class FeatureError {
    private final FeatureErrorCode _errorCode;
    private final String _errorMsg;

    public FeatureError(FeatureErrorCode errorCode) {
        this(errorCode, "");
    }

    public FeatureError(FeatureErrorCode errorCode, String errorMsg) {
        this._errorCode = errorCode;
        this._errorMsg = errorMsg;
    }

    public FeatureError(FeatureErrorCode errorCode, Throwable t) {
        this(errorCode, t.getMessage());
    }

    public FeatureErrorCode getErrorCode() {
        return this._errorCode;
    }

    public String getErrorMsg() {
        return this._errorMsg;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureError that = (FeatureError)o;
        return this.getErrorCode() == that.getErrorCode() && Objects.equal((Object)this.getErrorMsg(), (Object)that.getErrorMsg());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getErrorCode(), this.getErrorMsg()});
    }

    public String toString() {
        return new StringJoiner(", ", FeatureError.class.getSimpleName() + "[", "]").add("_errorCode=" + (Object)((Object)this._errorCode)).add("_errorMsg='" + this._errorMsg + "'").toString();
    }
}

