/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.FeatureTypes;
import com.linkedin.feathr.common.tensor.DimensionType;
import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.PrimitiveDimensionType;
import com.linkedin.feathr.common.tensor.TensorCategory;
import com.linkedin.feathr.common.tensor.TensorType;
import com.linkedin.feathr.common.types.PrimitiveType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class FeatureTypeConfigDeserializer
extends JsonDeserializer<FeatureTypeConfig> {
    private static final String TYPE_FIELD = "type";
    private static final String SHAPE_FIELD = "shape";
    private static final String DIMENSION_TYPE_FIELD = "dimensionType";
    private static final String VAL_TYPE_FIELD = "valType";
    private static final String DOC_FIELD = "doc";
    private static final Set<FeatureTypes> ALL_FEATURE_TYPES = new HashSet<FeatureTypes>(Arrays.asList(FeatureTypes.values()));
    private static final Set<String> ALL_FEATURE_TYPES_STRING = ALL_FEATURE_TYPES.stream().map(Enum::toString).collect(Collectors.toSet());
    private static final Set<Primitive> DENSE_TENSOR_ALLOWED_PRIMITIVE = new HashSet<Primitive>(Arrays.asList(Primitive.INT));
    private static final Set<Primitive> SPARSE_TENSOR_ALLOWED_PRIMITIVE = new HashSet<Primitive>(Arrays.asList(Primitive.INT, Primitive.LONG, Primitive.STRING));
    private static final String DENSE_TENSOR_TYPE_STRING = "DENSE_TENSOR";
    private static final String SPARSE_TENSOR_TYPE_STRING = "SPARSE_TENSOR";
    private static final String RAGGED_TENSOR_TYPE_STRING = "RAGGED_TENSOR";
    private static final Set<String> SUPPORTED_TENSOR_TYPES = new HashSet<String>(Arrays.asList("DENSE_TENSOR", "SPARSE_TENSOR", "RAGGED_TENSOR"));

    public FeatureTypeConfig deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        FeatureTypes featureType;
        TreeNode node = jp.getCodec().readTree(jp);
        if (node instanceof TextNode) {
            FeatureTypes featureTypes = FeatureTypes.valueOf(((TextNode)node).asText());
            return new FeatureTypeConfig(featureTypes);
        }
        ObjectNode objectNode = (ObjectNode)node;
        JsonNode typeNode = objectNode.get(TYPE_FIELD);
        if (typeNode == null) {
            throw new RuntimeException("Type should be specified but it's not. The config is: " + node);
        }
        String typeString = typeNode.asText();
        TensorType tensorType = null;
        TensorCategory tensorCategory = null;
        if (typeString.equals(FeatureTypes.TENSOR.toString())) {
            switch (objectNode.get("tensorCategory").asText()) {
                case "DENSE": {
                    tensorCategory = TensorCategory.DENSE;
                    break;
                }
                case "SPARSE": {
                    tensorCategory = TensorCategory.SPARSE;
                    break;
                }
                case "RAGGED": {
                    tensorCategory = TensorCategory.RAGGED;
                    break;
                }
                default: {
                    throw new RuntimeException("The specified feature type is not supported: " + typeString + ". Supported types are: " + ALL_FEATURE_TYPES + " and " + SUPPORTED_TENSOR_TYPES);
                }
            }
            featureType = FeatureTypes.TENSOR;
        } else {
            featureType = FeatureTypes.valueOf(typeString);
        }
        JsonNode docNode = objectNode.get(DOC_FIELD);
        String doc = docNode != null ? docNode.asText() : null;
        ArrayNode shapeNode = (ArrayNode)objectNode.get(SHAPE_FIELD);
        ArrayList<Object> shapes = new ArrayList<Object>();
        if (shapeNode != null) {
            for (JsonNode jsonNode : shapeNode) {
                Integer shape = Integer.parseInt(jsonNode.asText());
                if (shape != -1 && shape < 1) {
                    throw new RuntimeException("Shape should either be -1 or positive numbers.");
                }
                shapes.add(shape);
            }
        }
        if (featureType != FeatureTypes.TENSOR && !shapes.isEmpty()) {
            throw new RuntimeException("Only TENSOR type can have shape defined.");
        }
        if (featureType == FeatureTypes.TENSOR) {
            ArrayNode dimensionTypeNode = (ArrayNode)objectNode.get(DIMENSION_TYPE_FIELD);
            ArrayList<Primitive> dimensionTypes = new ArrayList<Primitive>();
            if (dimensionTypeNode != null) {
                for (Object jsonNode : dimensionTypeNode) {
                    Primitive primitive = Primitive.valueOf(jsonNode.asText());
                    if (tensorCategory == TensorCategory.DENSE && !DENSE_TENSOR_ALLOWED_PRIMITIVE.contains(primitive)) {
                        throw new RuntimeException("DENSE_TENSOR can only have INT dimension but got: " + primitive);
                    }
                    if (tensorCategory == TensorCategory.SPARSE && !SPARSE_TENSOR_ALLOWED_PRIMITIVE.contains(primitive)) {
                        throw new RuntimeException("SPARSE_TENSOR can only have " + SPARSE_TENSOR_ALLOWED_PRIMITIVE + " dimensions but got: " + primitive);
                    }
                    dimensionTypes.add(primitive);
                }
            }
            ArrayList<DimensionType> primitiveDimensionTypes = new ArrayList<DimensionType>();
            if (shapes.isEmpty()) {
                for (Primitive dimensionType : dimensionTypes) {
                    PrimitiveDimensionType primitiveDimensionType = new PrimitiveDimensionType(dimensionType);
                    primitiveDimensionTypes.add(primitiveDimensionType);
                }
            } else {
                if (dimensionTypes.size() != shapes.size()) {
                    throw new RuntimeException("Sizes of dimensionType and shape should match but got: " + dimensionTypes + " and " + shapes);
                }
                for (int i = 0; i < dimensionTypes.size(); ++i) {
                    Primitive dimensionType;
                    dimensionType = (Primitive)dimensionTypes.get(i);
                    Integer shape = (Integer)shapes.get(i);
                    PrimitiveDimensionType primitiveDimensionType = new PrimitiveDimensionType(dimensionType, shape);
                    primitiveDimensionTypes.add(primitiveDimensionType);
                }
            }
            JsonNode valType = objectNode.get(VAL_TYPE_FIELD);
            PrimitiveType valueType = new PrimitiveType(Primitive.valueOf(valType.textValue()));
            tensorType = new TensorType(tensorCategory, valueType, primitiveDimensionTypes, null);
            return new FeatureTypeConfig(featureType, tensorType, doc);
        }
        return new FeatureTypeConfig(featureType);
    }
}

