/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import com.linkedin.feathr.common.CompatibilityUtils;
import com.linkedin.feathr.common.FeatureTypes;
import com.linkedin.feathr.common.GenericTypedTensor;
import com.linkedin.feathr.common.TypedTensor;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorType;
import com.linkedin.feathr.common.tensor.TensorTypes;
import com.linkedin.feathr.common.tensor.Tensors;
import com.linkedin.feathr.common.tensorbuilder.UniversalTensorBuilderFactory;
import com.linkedin.feathr.common.types.FeatureType;
import com.linkedin.feathr.common.types.TensorFeatureType;
import com.linkedin.feathr.common.util.CoercionUtils;
import com.linkedin.feathr.common.value.BooleanFeatureValue;
import com.linkedin.feathr.common.value.CategoricalFeatureValue;
import com.linkedin.feathr.common.value.CategoricalSetFeatureValue;
import com.linkedin.feathr.common.value.DenseVectorFeatureValue;
import com.linkedin.feathr.common.value.NTVFeatureFormatMapper;
import com.linkedin.feathr.common.value.NumericFeatureValue;
import com.linkedin.feathr.common.value.QuinceFeatureFormatMapper;
import com.linkedin.feathr.common.value.TensorFeatureValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FeatureValue
implements Serializable,
KryoSerializable {
    public static final float DEFAULT_VALUE = 1.0f;
    public static final String EMPTY_TERM = "";
    private com.linkedin.feathr.common.value.FeatureValue _featureValueInternal;

    @VisibleForTesting
    public FeatureValue(com.linkedin.feathr.common.value.FeatureValue featureValueInternal) {
        this._featureValueInternal = Objects.requireNonNull(featureValueInternal);
    }

    @Deprecated
    public FeatureValue(Object value) {
        this(value, FeatureTypes.UNSPECIFIED);
    }

    @Deprecated
    public FeatureValue() {
        this._featureValueInternal = new CompatibilityUtils.MutableTermVectorFeatureValue(new HashMap<String, Float>());
    }

    @Deprecated
    public FeatureValue(Object value, FeatureTypes type) {
        switch (type) {
            case BOOLEAN: {
                boolean booleanValue = (Boolean)value;
                this._featureValueInternal = BooleanFeatureValue.fromBoolean(booleanValue);
                break;
            }
            case NUMERIC: {
                float floatValue = ((Number)value).floatValue();
                this._featureValueInternal = NumericFeatureValue.fromFloat(floatValue);
                break;
            }
            case CATEGORICAL: {
                String stringValue = CoercionUtils.safeToString(value);
                this._featureValueInternal = CategoricalFeatureValue.fromString(stringValue);
                break;
            }
            case CATEGORICAL_SET: {
                Set<String> stringSet = ((Collection)value).stream().map(CoercionUtils::safeToString).collect(Collectors.toSet());
                this._featureValueInternal = CategoricalSetFeatureValue.fromStrings(stringSet);
                break;
            }
            case DENSE_VECTOR: {
                List numberList = ((Collection)value).stream().map(CoercionUtils::safeToFloat).collect(Collectors.toList());
                this._featureValueInternal = DenseVectorFeatureValue.fromNumberList(numberList);
                break;
            }
            case TERM_VECTOR: 
            case UNSPECIFIED: {
                Map<String, Float> tv = CoercionUtils.coerceToVector(value, type);
                this._featureValueInternal = new CompatibilityUtils.MutableTermVectorFeatureValue(tv);
                break;
            }
            case TENSOR: {
                throw new IllegalArgumentException("This legacy constructor does not support Tensor");
            }
            default: {
                throw new IllegalArgumentException("Unhandled type " + (Object)((Object)type));
            }
        }
    }

    public FeatureValue(TypedTensor tensor) {
        Objects.requireNonNull(tensor, "TypedTensor object can't be null");
        this._featureValueInternal = TensorFeatureValue.fromTypedTensor(tensor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FeatureValue(Object value, TensorType type) {
        TensorFeatureType tensorFeatureType = TensorFeatureType.withTensorType(type);
        Objects.requireNonNull(value, "value object can't be null");
        Objects.requireNonNull(type, "TensorType object can't be null");
        if (type.getDimensionTypes() == null || type.getDimensionTypes().size() == 0) {
            TensorData tensorData = Tensors.asScalarTensor(type, value);
            this._featureValueInternal = TensorFeatureValue.fromTensorData(tensorFeatureType, tensorData);
            return;
        } else {
            if (type.getDimensionTypes().size() != 1) throw new IllegalArgumentException("Only creating of 0-d and 1-d tensor is supported but got: " + type);
            if (value instanceof Map) {
                TensorData tensorData = Tensors.asSparseTensor(type, (Map)value);
                this._featureValueInternal = TensorFeatureValue.fromTensorData(tensorFeatureType, tensorData);
                return;
            } else if (value instanceof List) {
                TensorData tensorData;
                Collection list = (Collection)value;
                if (list.isEmpty()) {
                    tensorData = UniversalTensorBuilderFactory.INSTANCE.getTensorBuilder(tensorFeatureType.getTensorType()).build();
                } else {
                    Object head = list.iterator().next();
                    if (head instanceof Map) {
                        Map<Object, Object> mergedMap = list.stream().flatMap(x -> ((Map)x).entrySet().stream()).distinct().collect(Collectors.toMap(e -> e.getKey(), e -> e.getValue()));
                        tensorData = Tensors.asSparseTensor(type, mergedMap);
                    } else {
                        tensorData = Tensors.asDenseTensor(type, (List)value);
                    }
                }
                this._featureValueInternal = TensorFeatureValue.fromTensorData(tensorFeatureType, tensorData);
                return;
            } else if (value instanceof float[]) {
                TensorData tensorData = Tensors.asDenseTensor(type, (float[])value);
                this._featureValueInternal = TensorFeatureValue.fromTensorData(tensorFeatureType, tensorData);
                return;
            } else if (value instanceof int[]) {
                TensorData tensorData = Tensors.asDenseTensor(type, (int[])value);
                this._featureValueInternal = TensorFeatureValue.fromTensorData(tensorFeatureType, tensorData);
                return;
            } else if (value instanceof long[]) {
                TensorData tensorData = Tensors.asDenseTensor(type, (long[])value);
                this._featureValueInternal = TensorFeatureValue.fromTensorData(tensorFeatureType, tensorData);
                return;
            } else {
                if (!(value instanceof double[])) throw new IllegalArgumentException("The value type " + value.getClass() + " is not supported.");
                TensorData tensorData = Tensors.asDenseTensor(type, (double[])value);
                this._featureValueInternal = TensorFeatureValue.fromTensorData(tensorFeatureType, tensorData);
            }
        }
    }

    @Deprecated
    public FeatureValue(Map<String, Float> value) {
        Objects.requireNonNull(value);
        this._featureValueInternal = new CompatibilityUtils.MutableTermVectorFeatureValue(value);
    }

    @Deprecated
    public void put(String key, Float value) {
        if (!(this._featureValueInternal instanceof CompatibilityUtils.MutableTermVectorFeatureValue)) {
            throw new RuntimeException("Cannot modify FeatureValue");
        }
        ((CompatibilityUtils.MutableTermVectorFeatureValue)this._featureValueInternal).getMutableView().put(key, value);
    }

    public boolean isEmpty() {
        if (this.getFeatureType().getBasicType().equals((Object)FeatureType.BasicType.TENSOR)) {
            return this.getAsTensorData().isEmpty();
        }
        return this.getAsTermVector().isEmpty();
    }

    @Deprecated
    public int size() {
        return this.getAsTermVector().size();
    }

    @Deprecated
    public Map<String, Float> getValue() {
        return this.getAsTermVector();
    }

    @Deprecated
    public int getNumTerms() {
        return this.size();
    }

    public FeatureType getFeatureType() {
        return this._featureValueInternal.getFeatureType();
    }

    public TypedTensor getAsTypedTensor() {
        return CompatibilityUtils.TypedTensorFormatMapper.INSTANCE.fromFeatureValue(this._featureValueInternal);
    }

    public TensorData getAsTensorData() {
        return (TensorData)QuinceFeatureFormatMapper.INSTANCE.fromFeatureValue(this._featureValueInternal);
    }

    public Map<String, Float> getAsTermVector() {
        if (this._featureValueInternal instanceof CompatibilityUtils.MutableTermVectorFeatureValue) {
            return ((CompatibilityUtils.MutableTermVectorFeatureValue)this._featureValueInternal).getMutableView();
        }
        return (Map)NTVFeatureFormatMapper.INSTANCE.fromFeatureValue(this._featureValueInternal);
    }

    public Float getAsNumeric() {
        return Float.valueOf(CompatibilityUtils.getNumeric(this._featureValueInternal));
    }

    @Deprecated
    public String getAsString() {
        return this.getAsCategorical();
    }

    public String getAsCategorical() {
        return CompatibilityUtils.getCategoricalString(this._featureValueInternal);
    }

    public Boolean getAsBoolean() {
        return CompatibilityUtils.getBoolean(this._featureValueInternal);
    }

    public static FeatureValue createNumeric(Number num) {
        return new FeatureValue(NumericFeatureValue.fromFloat(num.floatValue()));
    }

    @Deprecated
    public static FeatureValue createCategorical(Number term) {
        return FeatureValue.createCategorical(CoercionUtils.safeToString(term));
    }

    public static FeatureValue createCategorical(CharSequence term) {
        return new FeatureValue(CategoricalFeatureValue.fromString(term.toString()));
    }

    public static FeatureValue createCategorical(Character term) {
        return FeatureValue.createCategorical(String.valueOf(term));
    }

    public static <T extends Number> FeatureValue createDenseVector(List<T> vec) {
        return new FeatureValue(DenseVectorFeatureValue.fromNumberList(vec));
    }

    public static <T extends Number> FeatureValue createDenseVector(T[] vec) {
        return FeatureValue.createDenseVector(Arrays.asList(vec));
    }

    private static FeatureValue createTermVectorFromRawMap(Map<?, ?> inputMap) {
        Map<String, Float> stringFloatMap = inputMap.entrySet().stream().collect(Collectors.toMap(e -> CoercionUtils.safeToString(e.getKey()), e -> Float.valueOf(CoercionUtils.safeToFloat(e.getValue()))));
        return new FeatureValue(stringFloatMap);
    }

    public static <K extends CharSequence, V extends Number> FeatureValue createStringTermVector(Map<K, V> inputMap) {
        return FeatureValue.createTermVectorFromRawMap(inputMap);
    }

    public static <K extends Number, V extends Number> FeatureValue createNumericTermVector(Map<K, V> inputMap) {
        return FeatureValue.createTermVectorFromRawMap(inputMap);
    }

    private static <K, V> Map<K, V> mergeMaps(Collection<Map<K, V>> maps) {
        return maps.stream().flatMap(x -> x.entrySet().stream()).collect(Collectors.toMap(x -> x.getKey(), x -> x.getValue()));
    }

    public static <K extends CharSequence, V extends Number> FeatureValue createStringTermVector(Collection<Map<K, V>> termValues) {
        return FeatureValue.createTermVectorFromRawMap(FeatureValue.mergeMaps(termValues));
    }

    public static <K extends Number, V extends Number> FeatureValue createNumericTermVector(Collection<Map<K, V>> termValues) {
        return FeatureValue.createTermVectorFromRawMap(FeatureValue.mergeMaps(termValues));
    }

    private static Collection<String> safeToStringCollection(Collection<?> collection) {
        return collection.stream().map(CoercionUtils::safeToString).collect(Collectors.toList());
    }

    public static <T extends Number> FeatureValue createNumericCategoricalSet(Collection<T> terms) {
        return FeatureValue.createStringCategoricalSet(FeatureValue.safeToStringCollection(terms));
    }

    public static <T extends CharSequence> FeatureValue createStringCategoricalSet(Collection<T> terms) {
        return new FeatureValue(CategoricalSetFeatureValue.fromStrings(FeatureValue.safeToStringCollection(terms)));
    }

    public static FeatureValue createCharacterCategoricalSet(Collection<Character> characters) {
        return FeatureValue.createStringCategoricalSet(FeatureValue.safeToStringCollection(characters));
    }

    public static FeatureValue createBoolean(Boolean b) {
        return new FeatureValue(BooleanFeatureValue.fromBoolean(b));
    }

    public static FeatureValue createTensor(Object value, TensorType type) {
        return new FeatureValue(value, type);
    }

    public static FeatureValue createTensor(TensorData tensorData) {
        return new FeatureValue(new GenericTypedTensor(tensorData, TensorTypes.fromTensorData(tensorData)));
    }

    public String toString() {
        return Objects.toString(this._featureValueInternal);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureValue that = (FeatureValue)o;
        if (this._featureValueInternal.equals(that._featureValueInternal)) {
            return true;
        }
        return this.getAsTermVector().equals(that.getAsTermVector());
    }

    public int hashCode() {
        if (this._featureValueInternal instanceof TensorFeatureValue) {
            return this._featureValueInternal.hashCode();
        }
        return this.getAsTermVector().hashCode();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(new HashMap<String, Float>(this.getAsTermVector()));
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        Map map = (Map)ois.readObject();
        this._featureValueInternal = new CompatibilityUtils.MutableTermVectorFeatureValue(map);
    }

    public void write(Kryo kryo, Output output) {
        kryo.writeObject(output, new HashMap<String, Float>(this.getAsTermVector()));
    }

    public void read(Kryo kryo, Input input) {
        Map map = (Map)kryo.readObject(input, HashMap.class);
        this._featureValueInternal = new CompatibilityUtils.MutableTermVectorFeatureValue(map);
    }
}

