/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common;

import com.linkedin.feathr.common.ColumnUtils;
import com.linkedin.feathr.common.tensor.ReadableTuple;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorIterator;
import java.util.Arrays;

public class Hasher {
    public static final Hasher INSTANCE = new Hasher();

    public int apply(TensorData tensorData, boolean dimOnly) {
        if (tensorData == null) {
            return 0;
        }
        Representable[] types = tensorData.getTypes();
        int numCols = dimOnly ? ColumnUtils.getDimArity(types) : types.length;
        int hash = this.getTypeHash(types, numCols);
        TensorIterator iterator = tensorData.iterator();
        while (iterator.isValid()) {
            hash = 31 * hash + Hasher.getHash(iterator, numCols);
            iterator.next();
        }
        return hash;
    }

    private int getTypeHash(Representable[] types, int numCols) {
        int hash = 0;
        for (int i = 0; i < numCols; ++i) {
            hash = hash * 31 + types[i].getRepresentation().hashCode();
        }
        return hash;
    }

    public static int getHash(ReadableTuple readableTuple, int numCols) {
        int hash = 0;
        Representable[] types = readableTuple.getTypes();
        block9: for (int i = 0; i < numCols; ++i) {
            switch (types[i].getRepresentation()) {
                case INT: {
                    hash = hash * 31 + Integer.hashCode(readableTuple.getInt(i));
                    continue block9;
                }
                case LONG: {
                    hash = hash * 31 + Long.hashCode(readableTuple.getLong(i));
                    continue block9;
                }
                case DOUBLE: {
                    hash = hash * 31 + Double.hashCode(readableTuple.getDouble(i));
                    continue block9;
                }
                case FLOAT: {
                    hash = hash * 31 + Float.hashCode(readableTuple.getFloat(i));
                    continue block9;
                }
                case STRING: {
                    hash = hash * 31 + readableTuple.getString(i).hashCode();
                    continue block9;
                }
                case BOOLEAN: {
                    hash = hash * 31 + Boolean.hashCode(readableTuple.getBoolean(i));
                    continue block9;
                }
                case BYTES: {
                    hash = hash * 31 + Arrays.hashCode(readableTuple.getBytes(i));
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Cannot generate hash for column type: " + types[i].getRepresentation());
                }
            }
        }
        return hash;
    }
}

