/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common;

import com.linkedin.feathr.common.ErasedEntityTaggedFeature;
import com.linkedin.feathr.common.TaggedFeatureName;
import java.util.List;
import java.util.stream.Collectors;

public class TaggedFeatureUtils {
    private TaggedFeatureUtils() {
    }

    public static void checkArgument(Boolean value) {
        if (!value.booleanValue()) {
            throw new IllegalArgumentException("Unexpected false");
        }
    }

    public static ErasedEntityTaggedFeature eraseStringTags(TaggedFeatureName input, List<String> keyNames) {
        TaggedFeatureUtils.checkArgument(!keyNames.isEmpty());
        TaggedFeatureUtils.checkArgument((long)keyNames.size() == keyNames.stream().distinct().count());
        List<Integer> keyBindingIndexes = input.getKeyTag().stream().map(keyNames::indexOf).collect(Collectors.toList());
        if (keyBindingIndexes.contains(-1)) {
            throw new IllegalArgumentException("input " + input + " contained some key not present in " + keyNames);
        }
        return new ErasedEntityTaggedFeature(keyBindingIndexes, input.getFeatureName());
    }

    @Deprecated
    public static TaggedFeatureName applyStringTags(ErasedEntityTaggedFeature input, List<String> keyNames) {
        return TaggedFeatureUtils.getTaggedFeatureNameFromStringTags(input, keyNames);
    }

    public static TaggedFeatureName getTaggedFeatureNameFromStringTags(ErasedEntityTaggedFeature input, List<String> keyNames) {
        List<String> stringKeys = input.getBinding().stream().map(keyNames::get).collect(Collectors.toList());
        return new TaggedFeatureName(stringKeys, input.getFeatureName());
    }
}

