/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.featurizeddataset;

import com.linkedin.feathr.common.featurizeddataset.SchemaMetadataUtils;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorIterator;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.StructType;
import scala.collection.Seq;

class FDSSparseTensorWrapper
implements TensorData {
    private final Representable[] _columnTypes;
    private final int _rank;
    private final GenericRowWithSchema _featureValue;
    private final int _cardinality;
    private final int[] _fieldIndices;

    FDSSparseTensorWrapper(Representable[] columnTypes, GenericRowWithSchema featureValue) {
        this._columnTypes = columnTypes;
        this._rank = columnTypes.length - 1;
        this._featureValue = featureValue;
        this._fieldIndices = new int[this._rank + 1];
        StructType schema = featureValue.schema();
        for (int i = 0; i < this._rank; ++i) {
            this._fieldIndices[i] = schema.fieldIndex(SchemaMetadataUtils.indexFieldName(i));
        }
        this._fieldIndices[this._rank] = schema.fieldIndex(SchemaMetadataUtils.valueFieldName());
        this._cardinality = ((Seq)this._featureValue.get(this._fieldIndices[this._rank])).size();
    }

    @Override
    public Representable[] getTypes() {
        return this._columnTypes;
    }

    @Override
    public int estimatedCardinality() {
        return this.cardinality();
    }

    @Override
    public int cardinality() {
        return this._cardinality;
    }

    @Override
    public TensorIterator iterator() {
        return new FDSTensorIterator();
    }

    private class FDSTensorIterator
    implements TensorIterator {
        private int _index;
        private final Seq<?>[] _cachedArrays;

        FDSTensorIterator() {
            this._index = 0;
            this._cachedArrays = new Seq[FDSSparseTensorWrapper.this._rank + 1];
            this.start();
        }

        FDSTensorIterator(FDSTensorIterator original) {
            this._index = original._index;
            this._cachedArrays = original._cachedArrays;
        }

        @Override
        public TensorData getTensorData() {
            return FDSSparseTensorWrapper.this;
        }

        @Override
        public void start() {
            this._index = 0;
            for (int i = 0; i <= FDSSparseTensorWrapper.this._rank; ++i) {
                this._cachedArrays[i] = (Seq)FDSSparseTensorWrapper.this._featureValue.get(FDSSparseTensorWrapper.this._fieldIndices[i]);
            }
        }

        @Override
        public boolean isValid() {
            return this._index < FDSSparseTensorWrapper.this._cardinality;
        }

        @Override
        public void next() {
            ++this._index;
        }

        @Override
        public TensorIterator getCopy() {
            return new FDSTensorIterator(this);
        }

        @Override
        public Object getValue(int column) {
            return this._cachedArrays[column].apply(this._index);
        }

        @Override
        public int getInt(int column) {
            return (Integer)this.getValue(column);
        }

        @Override
        public long getLong(int column) {
            return (Long)this.getValue(column);
        }

        @Override
        public float getFloat(int column) {
            return ((Float)this.getValue(column)).floatValue();
        }

        @Override
        public String getString(int column) {
            return (String)this.getValue(column);
        }

        @Override
        public double getDouble(int column) {
            return (Double)this.getValue(column);
        }

        @Override
        public boolean getBoolean(int column) {
            return (Boolean)this.getValue(column);
        }

        @Override
        public byte[] getBytes(int column) {
            return (byte[])this.getValue(column);
        }
    }
}

