/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.util;

import com.linkedin.feathr.common.FeatureValue;
import com.linkedin.feathr.common.util.CoercionUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.mvel2.ParserConfiguration;

public class MvelContextUDFs {
    private static String EMPTY_FILTER_EXPRESSION = "";
    private static String EQUAL_FILTER_OPERATION = "==";
    private static String UNEQUAL_FILTER_OPERATION = "!=";

    private MvelContextUDFs() {
    }

    public static void registerUDFs(Class<?> clazz, ParserConfiguration parserConfig) {
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(ExportToMvel.class)) continue;
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new Error("MVEL context set up incorrectly. Imported method " + method + " must be static but is not.");
            }
            parserConfig.addImport(method.getName(), method);
        }
    }

    @ExportToMvel
    public static String get_data_type(Object input) {
        if (input == null) {
            return "null";
        }
        return input.getClass().getName();
    }

    @ExportToMvel
    public static Double cast_double(Object input) {
        if (input == null) {
            throw new RuntimeException("Input is null so it can't be casted to Double.");
        }
        if (input instanceof String) {
            return Double.parseDouble((String)input);
        }
        if (input instanceof Number) {
            return ((Number)input).doubleValue();
        }
        return (Double)input;
    }

    @ExportToMvel
    public static Float cast_float(Object input) {
        if (input == null) {
            throw new RuntimeException("Input is null so it can't be casted to Float.");
        }
        if (input instanceof String) {
            return Float.valueOf(Float.parseFloat((String)input));
        }
        if (input instanceof Number) {
            return Float.valueOf(((Number)input).floatValue());
        }
        return (Float)input;
    }

    @ExportToMvel
    public static Integer cast_int(Object input) {
        if (input == null) {
            throw new RuntimeException("Input is null so it can't be casted to Integer.");
        }
        if (input instanceof String) {
            return Integer.parseInt((String)input);
        }
        if (input instanceof Number) {
            return ((Number)input).intValue();
        }
        return (Integer)input;
    }

    @ExportToMvel
    public static boolean and(boolean left, boolean right) {
        return left && right;
    }

    @ExportToMvel
    public static boolean or(boolean left, boolean right) {
        return left || right;
    }

    @ExportToMvel
    public static boolean not(boolean input) {
        return !input;
    }

    @ExportToMvel
    public static boolean isnull(Object input) {
        return input == null;
    }

    @ExportToMvel
    public static boolean isnotnull(Object input) {
        return input != null;
    }

    @ExportToMvel
    public static String concat(String left, String right) {
        return left + right;
    }

    @ExportToMvel
    public static String if_else(boolean input, String first, String second) {
        return input ? first : second;
    }

    @ExportToMvel
    public static Double if_else(boolean input, Double first, Double second) {
        return input ? first : second;
    }

    @ExportToMvel
    public static Float if_else(boolean input, Float first, Float second) {
        return input ? first : second;
    }

    @ExportToMvel
    public static Integer if_else(boolean input, Integer first, Integer second) {
        return input ? first : second;
    }

    @ExportToMvel
    public static boolean if_else(boolean input, boolean first, boolean second) {
        return input ? first : second;
    }

    @ExportToMvel
    public static boolean isNonZero(Object vector) {
        return vector != null && CoercionUtils.coerceToVector(vector).values().stream().anyMatch(x -> x.floatValue() != 0.0f);
    }

    @ExportToMvel
    public static boolean isPresent(Object featureValue) {
        return featureValue != null;
    }

    @ExportToMvel
    public static Boolean toBoolean(Object item) {
        if (item instanceof Boolean) {
            return (Boolean)item;
        }
        if (item instanceof FeatureValue) {
            return ((FeatureValue)item).getAsBoolean();
        }
        return new FeatureValue(item).getAsBoolean();
    }

    @ExportToMvel
    public static Object toNumeric(Object item) {
        Map<String, Float> vector = CoercionUtils.coerceToVector(item);
        Set<String> keySet = vector.keySet();
        if (keySet.size() == 1) {
            if (vector.containsKey("")) {
                return vector.get("");
            }
            try {
                return Float.valueOf(Float.parseFloat(keySet.iterator().next()));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Feature cannot be converted to Float. Invalid feature: " + vector);
            }
        }
        throw new RuntimeException("Feature must have 1 TermValue pair. Invalid feature: " + vector);
    }

    @ExportToMvel
    public static Object toCategorical(Object item) {
        Map<String, Float> vector = CoercionUtils.coerceToVector(item);
        Set<String> keySet = vector.keySet();
        HashMap<String, Float> categoricalVector = new HashMap<String, Float>();
        if (keySet.size() == 1 && vector.containsKey("")) {
            categoricalVector.put(vector.get("").toString(), Float.valueOf(1.0f));
            return categoricalVector;
        }
        return vector;
    }

    @ExportToMvel
    public static Collection<String> getTerms(Object item) {
        if (item == null) {
            return Collections.emptyList();
        }
        return CoercionUtils.coerceToVector(item).keySet();
    }

    @ExportToMvel
    public static List<String> getTopKTerms(Object item, int k) {
        if (item == null || k == 0) {
            return new ArrayList<String>();
        }
        boolean ascending = true;
        if (k < 0) {
            k = -k;
            ascending = false;
        }
        return CoercionUtils.coerceToVector(item).entrySet().stream().sorted(ascending ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).limit(k).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @ExportToMvel
    public static String getTopTerm(Object item) {
        if (item == null) {
            return null;
        }
        return MvelContextUDFs.getTopKTerms(item, 1).get(0);
    }

    @ExportToMvel
    public static Collection<Object> distinct(Collection<Object> collection) {
        return collection.stream().distinct().collect(Collectors.toList());
    }

    @ExportToMvel
    public static Collection<Object> flatten(Collection<? extends Collection<Object>> collection) {
        return collection.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @ExportToMvel
    public static Float cosineSimilarity(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return null;
        }
        Map<String, Float> mapA = CoercionUtils.coerceToVector(obj1);
        Map<String, Float> mapB = CoercionUtils.coerceToVector(obj2);
        double dotProduct = 0.0;
        double normA = 0.0;
        double normB = 0.0;
        for (Map.Entry<String, Float> entry : mapA.entrySet()) {
            String k = entry.getKey();
            float valA = entry.getValue().floatValue();
            Float valB = mapB.get(k);
            if (valB != null) {
                dotProduct += (double)(valA * valB.floatValue());
            }
            normA += (double)(valA * valA);
        }
        for (Float valB : mapB.values()) {
            normB += (double)(valB.floatValue() * valB.floatValue());
        }
        if (normA <= 0.0 || normB <= 0.0) {
            return Float.valueOf(0.0f);
        }
        normA = Math.sqrt(normA);
        normB = Math.sqrt(normB);
        return Float.valueOf((float)(dotProduct / (normA * normB)));
    }

    @ExportToMvel
    public static Double dotProduct(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return null;
        }
        Map<String, Float> mapA = CoercionUtils.coerceToVector(obj1);
        Map<String, Float> mapB = CoercionUtils.coerceToVector(obj2);
        double dotProduct = 0.0;
        for (Map.Entry<String, Float> entry : mapA.entrySet()) {
            String k = entry.getKey();
            float valA = entry.getValue().floatValue();
            Float valB = mapB.get(k);
            if (valB == null) continue;
            dotProduct += (double)valA * (double)valB.floatValue();
        }
        return dotProduct;
    }

    @ExportToMvel
    public static String toLowerCase(String input) {
        return input.toLowerCase();
    }

    @ExportToMvel
    public static String toUpperCase(String input) {
        return input.toUpperCase();
    }

    @ExportToMvel
    public static long time_duration(Object startTime, Object endTime, String outputGranularity) {
        if (!outputGranularity.equals("minutes")) {
            throw new IllegalArgumentException(outputGranularity + " is not support in time_duration");
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime startDate = LocalDateTime.parse(startTime.toString(), formatter);
        LocalDateTime endDate = LocalDateTime.parse(endTime.toString(), formatter);
        return Duration.between(startDate, endDate).toMinutes();
    }

    @ExportToMvel
    public static int dayofweek(Object input) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDate = LocalDateTime.parse(input.toString(), formatter);
        return localDate.getDayOfWeek().getValue();
    }

    @ExportToMvel
    public static int dayofmonth(Object input) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDate = LocalDateTime.parse(input.toString(), formatter);
        return localDate.getDayOfMonth();
    }

    @ExportToMvel
    public static int hourofday(Object input) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDate = LocalDateTime.parse(input.toString(), formatter);
        return localDate.getHour();
    }

    @ExportToMvel
    public static Map<String, Float> extract_term_value_from_array(ArrayList<GenericRowWithSchema> array, String termFieldName, String valueFieldName) {
        return MvelContextUDFs.extract_term_value_from_array(array, termFieldName, valueFieldName, EMPTY_FILTER_EXPRESSION);
    }

    @ExportToMvel
    public static Map<String, Float> extract_term_value_from_array(ArrayList<GenericRowWithSchema> array, String termFieldName, String valueFieldName, String filterExpr) {
        HashMap<String, Float> result = new HashMap<String, Float>();
        String filterName = "";
        String filterValue = "";
        Boolean hasFilter = !filterExpr.equals(EMPTY_FILTER_EXPRESSION);
        Boolean equalFilter = filterExpr.contains(EQUAL_FILTER_OPERATION);
        Boolean filterBasedOnConstant = true;
        if (hasFilter.booleanValue()) {
            String delimiter = equalFilter != false ? EQUAL_FILTER_OPERATION : UNEQUAL_FILTER_OPERATION;
            String[] parts = filterExpr.split(delimiter);
            if (parts.length != 2) {
                throw new IllegalArgumentException("Filter expression: " + filterExpr + " in select_term_value_from_array is invalid. It must conform to [fieldName] == [value] or [fieldName] != [value]");
            }
            filterName = parts[0].trim();
            filterValue = parts[1].trim();
            filterBasedOnConstant = filterValue.startsWith("'") || filterValue.startsWith("\"");
            if (filterBasedOnConstant.booleanValue()) {
                filterValue = filterValue.substring(1, filterValue.length() - 1);
            }
        }
        for (GenericRowWithSchema item : array) {
            Object resolvedFilterValue = filterValue;
            if (!filterBasedOnConstant.booleanValue()) {
                resolvedFilterValue = item.getAs(filterValue);
            }
            Boolean equalFilterMet = hasFilter != false && equalFilter != false && item.getAs(filterName).equals(resolvedFilterValue);
            Boolean unEqualFilterMet = hasFilter != false && equalFilter == false && !item.getAs(filterName).equals(resolvedFilterValue);
            if (hasFilter.booleanValue() && !equalFilterMet.booleanValue() && !unEqualFilterMet.booleanValue()) continue;
            result.put((String)item.getAs(termFieldName), (Float)item.getAs(valueFieldName));
        }
        return result;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ExportToMvel {
    }
}

