/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.value;

import com.linkedin.feathr.common.types.BooleanFeatureType;
import com.linkedin.feathr.common.types.FeatureType;
import com.linkedin.feathr.common.value.FeatureValue;
import java.util.Objects;

public class BooleanFeatureValue
implements FeatureValue {
    public static final BooleanFeatureValue FALSE = new BooleanFeatureValue(false);
    public static final BooleanFeatureValue TRUE = new BooleanFeatureValue(true);
    private static final FeatureType TYPE = BooleanFeatureType.INSTANCE;
    private final boolean _booleanValue;

    private BooleanFeatureValue(boolean booleanValue) {
        this._booleanValue = booleanValue;
    }

    public static BooleanFeatureValue fromBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    public boolean getBooleanValue() {
        return this._booleanValue;
    }

    @Override
    public FeatureType getFeatureType() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanFeatureValue that = (BooleanFeatureValue)o;
        return this._booleanValue == that._booleanValue;
    }

    public int hashCode() {
        return Objects.hash(this._booleanValue);
    }

    public String toString() {
        return "BooleanFeatureValue{_booleanValue=" + this._booleanValue + '}';
    }
}

