/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.value;

import com.linkedin.feathr.common.GenericTypedTensor;
import com.linkedin.feathr.common.TensorUtils;
import com.linkedin.feathr.common.TypedTensor;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.types.FeatureType;
import com.linkedin.feathr.common.types.TensorFeatureType;
import com.linkedin.feathr.common.value.FeatureValue;
import java.util.Objects;

public class TensorFeatureValue
implements FeatureValue {
    private final TensorFeatureType _featureType;
    private final TypedTensor _typedTensor;

    private TensorFeatureValue(TensorFeatureType featureType, TensorData tensorData) {
        this._featureType = Objects.requireNonNull(featureType);
        this._typedTensor = new GenericTypedTensor(Objects.requireNonNull(tensorData), this._featureType.getTensorType());
    }

    private TensorFeatureValue(TypedTensor typedTensor) {
        Objects.requireNonNull(typedTensor);
        this._featureType = TensorFeatureType.withTensorType(typedTensor.getType());
        this._typedTensor = typedTensor;
    }

    public static TensorFeatureValue fromTensorData(TensorFeatureType featureType, TensorData tensorData) {
        return new TensorFeatureValue(featureType, tensorData);
    }

    public static TensorFeatureValue fromTypedTensor(TypedTensor typedTensor) {
        return new TensorFeatureValue(typedTensor);
    }

    @Override
    public FeatureType getFeatureType() {
        return this._featureType;
    }

    public TensorData getAsTensor() {
        return this._typedTensor.getData();
    }

    public TypedTensor getAsTypedTensor() {
        return this._typedTensor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TensorFeatureValue that = (TensorFeatureValue)o;
        return this._featureType.equals(that._featureType) && this._typedTensor.equals(that._typedTensor);
    }

    public int hashCode() {
        return Objects.hash(this._featureType, this._typedTensor);
    }

    public String toString() {
        String typedTensorDebugString = TensorUtils.getDebugString(this._typedTensor.getType(), this._typedTensor.getData(), 10240);
        return "TensorFeatureValue{_featureType=" + this._featureType + ", _typedTensor=" + typedTensorDebugString + '}';
    }
}

