/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline;

import com.linkedin.feathr.common.FeatureTypes;
import com.linkedin.feathr.common.FeatureValue;
import com.linkedin.feathr.offline.PostTransformationUtil$;
import com.linkedin.feathr.offline.exception.FeatureTransformationException;
import com.linkedin.feathr.offline.mvel.FeatureVariableResolverFactory;
import com.linkedin.feathr.offline.mvel.MvelContext;
import com.linkedin.feathr.offline.mvel.plugins.FeathrExpressionExecutionContext;
import com.linkedin.feathr.offline.transformation.MvelDefinition;
import com.linkedin.feathr.offline.util.CoercionUtilsScala$;
import com.linkedin.feathr.offline.util.FeaturizedDatasetUtils$;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.integration.VariableResolverFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class PostTransformationUtil$ {
    public static PostTransformationUtil$ MODULE$;
    private final Map<String, Object> NTV_FORMAT_BOOLEAN_TRUE;
    private final Map<String, Object> NTV_FORMAT_BOOLEAN_FALSE;

    static {
        new PostTransformationUtil$();
    }

    public Map<String, Object> NTV_FORMAT_BOOLEAN_TRUE() {
        return this.NTV_FORMAT_BOOLEAN_TRUE;
    }

    public Map<String, Object> NTV_FORMAT_BOOLEAN_FALSE() {
        return this.NTV_FORMAT_BOOLEAN_FALSE;
    }

    public boolean booleanTransformer(String featureName, MvelDefinition mvelExpression, Serializable compiledExpression, boolean input, Option<FeathrExpressionExecutionContext> mvelContext) {
        FeatureValue toFeatureValue = FeatureValue.createBoolean(Predef$.MODULE$.boolean2Boolean(input));
        Try<FeatureValue> transformedFeatureValue = this.transformFeatureValues(featureName, toFeatureValue, compiledExpression, FeatureTypes.TERM_VECTOR, mvelContext);
        Try<FeatureValue> try_ = transformedFeatureValue;
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new FeatureTransformationException(new StringBuilder(90).append("booleanTransformer failed for feature: ").append(featureName).append(" MVEL expression: ").append(mvelExpression).append(" and input data ").append(input).append(" with exception: ").toString(), ex);
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        FeatureValue fVal = (FeatureValue)success.value();
        boolean bl = fVal.getAsTermVector().containsKey("true");
        return bl;
    }

    public Map<String, Object> fds1dTensorTransformer(String featureName, MvelDefinition mvelExpression, Serializable compiledExpression, GenericRowWithSchema input, Option<FeathrExpressionExecutionContext> mvelContext) {
        Map<String, Object> map;
        if (input != null) {
            Seq inputMapKey = (Seq)input.getAs(FeaturizedDatasetUtils$.MODULE$.FDS_1D_TENSOR_DIM());
            Seq inputMapVal = (Seq)input.getAs(FeaturizedDatasetUtils$.MODULE$.FDS_1D_TENSOR_VALUE());
            Map inputMap = ((TraversableOnce)inputMapKey.zip((GenIterable)inputMapVal, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            map = this.mapTransformer(featureName, mvelExpression, compiledExpression, (Map<String, Object>)inputMap, mvelContext);
        } else {
            map = (Map<String, Object>)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        return map;
    }

    public Dataset<Row> transformFeatures(Seq<Tuple2<String, String>> featureNameColumnTuples, Dataset<Row> contextDF, Map<String, MvelDefinition> transformationDef, Function2<DataType, String, Column> defaultTransformation, Option<FeathrExpressionExecutionContext> mvelContext) {
        Seq featureColumnNames = (Seq)featureNameColumnTuples.map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._2(), Seq$.MODULE$.canBuildFrom());
        Seq featureValueColumn = (Seq)featureNameColumnTuples.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String featureName = (String)tuple2._1();
            String columnName = (String)tuple2._2();
            int fieldIndex = contextDF.schema().fieldIndex(columnName);
            StructField fieldType = (StructField)contextDF.schema().toList().apply(fieldIndex);
            Column column = (Column)transformationDef.get((Object)featureName).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Column column;
                MvelDefinition mvelDefinition = x0$2;
                ParserContext parserContext = MvelContext.newParserContext();
                Serializable compiledExpression = MVEL.compileExpression((String)mvelDefinition.mvelDef(), (ParserContext)parserContext);
                FeatureTypes featureType = mvelDefinition.featureType();
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
                public final class Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                    }

                    public Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator1$1() {
                    }
                }
                public final class Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                    }

                    public Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator2$1() {
                    }
                }
                UserDefinedFunction convertToString = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.stringTransformer(featureName, mvelDefinition, compiledExpression, (String)x$2, mvelContext), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator2$1()));
                UserDefinedFunction convertToBoolean = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PostTransformationUtil$.MODULE$.booleanTransformer(featureName, mvelDefinition, compiledExpression, BoxesRunTime.unboxToBoolean((Object)x$3), (Option<FeathrExpressionExecutionContext>)mvelContext)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Boolean(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Boolean());
                UserDefinedFunction convertToFloat = functions$.MODULE$.udf((Function1)(JFunction1.mcFF.sp & Serializable & scala.Serializable)x$4 -> MODULE$.floatTransformer(featureName, mvelDefinition, compiledExpression, x$4, mvelContext), ((TypeTags)package$.MODULE$.universe()).TypeTag().Float(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Float());
                JavaUniverse $u3 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
                JavaUniverse $u4 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
                public final class Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "Map"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator3$1() {
                    }
                }
                public final class Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "Map"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator4$1() {
                    }
                }
                UserDefinedFunction convertToMap = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.mapTransformer(featureName, mvelDefinition, compiledExpression, (Map<String, Object>)x$5, mvelContext), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator3$1()), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator4$1()));
                JavaUniverse $u5 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
                JavaUniverse $u6 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
                public final class Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator5$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "Map"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator5$1() {
                    }
                }
                public final class Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator6$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema").asType().toTypeConstructor();
                    }

                    public Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator6$1() {
                    }
                }
                UserDefinedFunction convertFDS1dTensorToMap = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.fds1dTensorTransformer(featureName, mvelDefinition, compiledExpression, (GenericRowWithSchema)x$6, mvelContext), ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator5$1()), ((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Com_linkedin_feathr_offline_PostTransformationUtil$$typecreator6$1()));
                DataType dataType = fieldType.dataType();
                if (dataType instanceof StringType) {
                    column = convertToString.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{contextDF.apply(columnName)}));
                } else if (dataType instanceof NumericType) {
                    column = convertToFloat.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{contextDF.apply(columnName)}));
                } else if (dataType instanceof MapType) {
                    column = convertToMap.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{contextDF.apply(columnName)}));
                } else if (dataType instanceof StructType) {
                    column = convertFDS1dTensorToMap.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{contextDF.apply(columnName)}));
                } else if (dataType instanceof BooleanType) {
                    column = convertToBoolean.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{contextDF.apply(columnName)}));
                } else {
                    throw new RuntimeException(new StringBuilder(54).append("Type ").append(dataType).append(" is not supported in feature post transformation.").toString());
                }
                Column column2 = column;
                return column2;
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Column)defaultTransformation.apply((Object)fieldType.dataType(), (Object)columnName));
            return column;
        }, Seq$.MODULE$.canBuildFrom());
        Seq featureValueToJoinKeyColumnName = (Seq)featureValueColumn.zip((GenIterable)featureColumnNames, Seq$.MODULE$.canBuildFrom());
        return (Dataset)featureValueToJoinKeyColumnName.foldLeft(contextDF, (Function2 & Serializable & scala.Serializable)(s, x) -> s.withColumn((String)x._2(), (Column)x._1()));
    }

    private Try<FeatureValue> transformFeatureValues(String featureName, FeatureValue featureValue, Serializable compiledExpression, FeatureTypes featureType, Option<FeathrExpressionExecutionContext> mvelContext) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Map args = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), (Object)new Some((Object)featureValue))}));
            FeatureVariableResolverFactory variableResolverFactory = new FeatureVariableResolverFactory((Map<String, Option<FeatureValue>>)args);
            Object transformedValue = MvelContext.executeExpressionWithPluginSupportWithFactory(compiledExpression, featureValue, (VariableResolverFactory)variableResolverFactory, (FeathrExpressionExecutionContext)mvelContext.orNull(Predef$.MODULE$.$conforms()));
            return CoercionUtilsScala$.MODULE$.coerceToFeatureValue(transformedValue, featureType);
        });
    }

    private float floatTransformer(String featureName, MvelDefinition mvelExpression, Serializable compiledExpression, float input, Option<FeathrExpressionExecutionContext> mvelContext) {
        FeatureValue toFeatureValue = FeatureValue.createNumeric(Predef$.MODULE$.float2Float(input));
        Try<FeatureValue> transformedFeatureValue = this.transformFeatureValues(featureName, toFeatureValue, compiledExpression, FeatureTypes.NUMERIC, mvelContext);
        Try<FeatureValue> try_ = transformedFeatureValue;
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new FeatureTransformationException(new StringBuilder(88).append("floatTransformer failed for feature: ").append(featureName).append(" MVEL expression: ").append(mvelExpression).append(" and input data ").append(input).append(" with exception: ").toString(), ex);
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        FeatureValue fVal = (FeatureValue)success.value();
        float f = Predef$.MODULE$.Float2float(fVal.getAsNumeric());
        return f;
    }

    private String stringTransformer(String featureName, MvelDefinition mvelExpression, Serializable compiledExpression, String input, Option<FeathrExpressionExecutionContext> mvelContext) {
        FeatureValue toFeatureValue = FeatureValue.createCategorical(input);
        Try<FeatureValue> transformedFeatureValue = this.transformFeatureValues(featureName, toFeatureValue, compiledExpression, FeatureTypes.CATEGORICAL, mvelContext);
        Try<FeatureValue> try_ = transformedFeatureValue;
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new FeatureTransformationException(new StringBuilder(88).append("floatTransformer failed for feature: ").append(featureName).append(" MVEL expression: ").append(mvelExpression).append(" and input data ").append(input).append(" with exception: ").toString(), ex);
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        FeatureValue fVal = (FeatureValue)success.value();
        String string = fVal.getAsString();
        return string;
    }

    private Map<String, Object> mapTransformer(String featureName, MvelDefinition mvelExpression, Serializable compiledExpression, Map<String, Object> input, Option<FeathrExpressionExecutionContext> mvelContext) {
        if (input == null) {
            return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        FeatureValue toFeatureValue = new FeatureValue(JavaConverters$.MODULE$.mapAsJavaMapConverter(input).asJava());
        Try<FeatureValue> transformedFeatureValue = this.transformFeatureValues(featureName, toFeatureValue, compiledExpression, FeatureTypes.TERM_VECTOR, mvelContext);
        Try<FeatureValue> try_ = transformedFeatureValue;
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new FeatureTransformationException(new StringBuilder(88).append("floatTransformer failed for feature: ").append(featureName).append(" MVEL expression: ").append(mvelExpression).append(" and input data ").append(input).append(" with exception: ").toString(), ex);
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        FeatureValue fVal = (FeatureValue)success.value();
        Map map = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(fVal.getAsTermVector()).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2((Object)((String)kv._1()), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)kv._2()))), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return map;
    }

    private PostTransformationUtil$() {
        MODULE$ = this;
        this.NTV_FORMAT_BOOLEAN_TRUE = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)BoxesRunTime.boxToFloat((float)1.0f))}));
        this.NTV_FORMAT_BOOLEAN_FALSE = Predef$.MODULE$.Map().empty();
    }
}

