/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.anchored.anchorExtractor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.config.ComplexAggregationFeature;
import com.linkedin.feathr.offline.config.ComplexAggregationFeature$;
import com.linkedin.feathr.offline.config.TimeWindowFeatureDefinition;
import com.linkedin.feathr.offline.generation.aggregations.AvgPoolingUDAF;
import com.linkedin.feathr.offline.generation.aggregations.CollectTermValueMap;
import com.linkedin.feathr.offline.generation.aggregations.CollectTermValueMap$;
import com.linkedin.feathr.offline.generation.aggregations.MaxPoolingUDAF;
import com.linkedin.feathr.offline.generation.aggregations.MinPoolingUDAF;
import com.linkedin.feathr.offline.swa.SlidingWindowFeatureUtils$;
import com.linkedin.feathr.sparkcommon.SimpleAnchorExtractorSpark;
import com.linkedin.feathr.swj.LateralViewParams;
import com.linkedin.feathr.swj.SlidingWindowFeature;
import com.linkedin.feathr.swj.aggregate.AggregationType$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.Window$;
import org.apache.spark.sql.expressions.WindowSpec;
import org.apache.spark.sql.functions$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005Me!\u0002\u000b\u0016\u0001e\t\u0003\u0002\u0003\u0015\u0001\u0005\u000b\u0007I\u0011\u0001\u0016\t\u0011\u0005\u0003!\u0011!Q\u0001\n-BQA\u0011\u0001\u0005\u0002\rC\u0011\u0002\u0016\u0001A\u0002\u0003\u0007I\u0011A+\t\u0013Y\u0003\u0001\u0019!a\u0001\n\u00039\u0006\"\u00030\u0001\u0001\u0004\u0005\t\u0015)\u00039\u0011%y\u0006\u00011AA\u0002\u0013\u0005\u0001\rC\u0005k\u0001\u0001\u0007\t\u0019!C\u0001W\"IQ\u000e\u0001a\u0001\u0002\u0003\u0006K!\u0019\u0005\b]\u0002\u0011\r\u0011\"\u0001p\u0011\u00199\b\u0001)A\u0005a\")\u0001\u0010\u0001C\u0001s\"Aa\u0010\u0001EC\u0002\u0013%q\u0010\u0003\u0006\u0002\"\u0001A)\u0019!C\u0005\u0003GAq!!\u000f\u0001\t\u0003\nY\u0004\u0003\u0004\u0002v\u0001!\t\u0005\u0019\u0005\b\u0003o\u0002A\u0011IA=\u0011\u001d\ty\b\u0001C!\u0003\u0003Cq!a\"\u0001\t\u0013\tIIA\u0013US6,w+\u001b8e_^\u001cuN\u001c4jOV\u0014\u0018M\u00197f\u0003:\u001c\u0007n\u001c:FqR\u0014\u0018m\u0019;pe*\u0011acF\u0001\u0010C:\u001c\u0007n\u001c:FqR\u0014\u0018m\u0019;pe*\u0011\u0001$G\u0001\tC:\u001c\u0007n\u001c:fI*\u0011!dG\u0001\b_\u001a4G.\u001b8f\u0015\taR$\u0001\u0004gK\u0006$\bN\u001d\u0006\u0003=}\t\u0001\u0002\\5oW\u0016$\u0017N\u001c\u0006\u0002A\u0005\u00191m\\7\u0014\u0005\u0001\u0011\u0003CA\u0012'\u001b\u0005!#BA\u0013\u001c\u0003-\u0019\b/\u0019:lG>lWn\u001c8\n\u0005\u001d\"#AG*j[BdW-\u00118dQ>\u0014X\t\u001f;sC\u000e$xN]*qCJ\\\u0017\u0001\u00034fCR,(/Z:\u0004\u0001U\t1\u0006\u0005\u0003-kaZdBA\u00174!\tq\u0013'D\u00010\u0015\t\u0001\u0014&\u0001\u0004=e>|GO\u0010\u0006\u0002e\u0005)1oY1mC&\u0011A'M\u0001\u0007!J,G-\u001a4\n\u0005Y:$aA'ba*\u0011A'\r\t\u0003YeJ!AO\u001c\u0003\rM#(/\u001b8h!\tat(D\u0001>\u0015\tq\u0014$\u0001\u0004d_:4\u0017nZ\u0005\u0003\u0001v\u00121\u0004V5nK^Kg\u000eZ8x\r\u0016\fG/\u001e:f\t\u00164\u0017N\\5uS>t\u0017!\u00034fCR,(/Z:!\u0003\u0019a\u0014N\\5u}Q\u0011AI\u0012\t\u0003\u000b\u0002i\u0011!\u0006\u0005\u0006Q\r\u0001\ra\u000b\u0015\u0005\r\"\u00136\u000b\u0005\u0002J!6\t!J\u0003\u0002L\u0019\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u00055s\u0015a\u00026bG.\u001cxN\u001c\u0006\u0003\u001f~\t\u0011BZ1ti\u0016\u0014\b0\u001c7\n\u0005ES%\u0001\u0004&t_:\u0004&o\u001c9feRL\u0018!\u0002<bYV,\u0017%\u0001\u0015\u0002#}#\u0018.\\3ti\u0006l\u0007oQ8m\u000bb\u0004(/F\u00019\u0003UyF/[7fgR\fW\u000e]\"pY\u0016C\bO]0%KF$\"\u0001\u0017/\u0011\u0005eSV\"A\u0019\n\u0005m\u000b$\u0001B+oSRDq!X\u0003\u0002\u0002\u0003\u0007\u0001(A\u0002yIE\n!c\u0018;j[\u0016\u001cH/Y7q\u0007>dW\t\u001f9sA\u0005Iql[3z\u00032L\u0017m]\u000b\u0002CB\u0019!m\u001a\u001d\u000f\u0005\r,gB\u0001\u0018e\u0013\u0005\u0011\u0014B\u000142\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001[5\u0003\u0007M+\u0017O\u0003\u0002gc\u0005iql[3z\u00032L\u0017m]0%KF$\"\u0001\u00177\t\u000fuC\u0011\u0011!a\u0001C\u0006Qql[3z\u00032L\u0017m\u001d\u0011\u0002+QKU*R*U\u00036\u0003vlQ(M+6suLT!N\u000bV\t\u0001\u000f\u0005\u0002rm6\t!O\u0003\u0002ti\u0006!A.\u00198h\u0015\u0005)\u0018\u0001\u00026bm\u0006L!A\u000f:\u0002-QKU*R*U\u00036\u0003vlQ(M+6suLT!N\u000b\u0002\n!\"\u001b8jiB\u000b'/Y7t)\rA&\u0010 \u0005\u0006w2\u0001\r\u0001O\u0001\ri&lWm\u001d;b[B\u001cu\u000e\u001c\u0005\u0006{2\u0001\r!Y\u0001\tW\u0016L\u0018\t\\5bg\u0006\u0019An\\4\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003+i!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0006Y><GG\u001b\u0006\u0005\u0003\u0017\ti!A\u0004m_\u001e<\u0017N\\4\u000b\t\u0005=\u0011\u0011C\u0001\u0007CB\f7\r[3\u000b\u0005\u0005M\u0011aA8sO&!\u0011qCA\u0003\u0005\u0019aunZ4fe\"\u001aQ\"a\u0007\u0011\u0007e\u000bi\"C\u0002\u0002 E\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0017\u0005<wMR3biV\u0014Xm]\u000b\u0003\u0003K\u0001r!a\n\u00022a\n\u0019$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003%IW.\\;uC\ndWMC\u0002\u00020E\n!bY8mY\u0016\u001cG/[8o\u0013\r1\u0014\u0011\u0006\t\u0004y\u0005U\u0012bAA\u001c{\tI2i\\7qY\u0016D\u0018iZ4sK\u001e\fG/[8o\r\u0016\fG/\u001e:f\u0003I\twm\u001a:fO\u0006$X-Q:D_2,XN\\:\u0015\t\u0005u\u0012Q\u000b\t\u0005E\u001e\fy\u0004\u0005\u0004Z\u0003\u0003B\u0014QI\u0005\u0004\u0003\u0007\n$A\u0002+va2,'\u0007\u0005\u0003\u0002H\u0005ESBAA%\u0015\u0011\tY%!\u0014\u0002\u0007M\fHN\u0003\u0003\u0002P\u00055\u0011!B:qCJ\\\u0017\u0002BA*\u0003\u0013\u0012aaQ8mk6t\u0007bBA,\u001f\u0001\u0007\u0011\u0011L\u0001\u0011OJ|W\u000f]3e\t\u0006$\u0018M\u0012:b[\u0016\u0004B!a\u0017\u0002p9!\u0011QLA7\u001d\u0011\ty&a\u001b\u000f\t\u0005\u0005\u0014\u0011\u000e\b\u0005\u0003G\n9GD\u0002/\u0003KJ!!a\u0005\n\t\u0005=\u0011\u0011C\u0005\u0005\u0003\u001f\ni!\u0003\u0003\u0002L\u00055\u0013b\u00014\u0002J%!\u0011\u0011OA:\u0005%!\u0015\r^1Ge\u0006lWMC\u0002g\u0003\u0013\nqcZ3u!J|g/\u001b3fI\u001a+\u0017\r^;sK:\u000bW.Z:\u0002\u001dA|7\u000f\u001e)s_\u000e,7o]5oOR!\u0011QHA>\u0011\u001d\ti(\u0005a\u0001\u00033\n1#Y4he\u0016<\u0017\r^3e\t\u0006$\u0018M\u0012:b[\u0016\f!\u0003\u001e:b]N4wN]7Bg\u000e{G.^7ogR!\u0011QHAB\u0011\u001d\t)I\u0005a\u0001\u00033\nq!\u001b8qkR$e)\u0001\u000bhKR4U-\u0019;ve\u0016\u001cu\u000e\\;n]:\u000bW.\u001a\u000b\u0006q\u0005-\u0015q\u0012\u0005\u0007\u0003\u001b\u001b\u0002\u0019\u0001\u001d\u0002\u0017\u0019,\u0017\r^;sK:\u000bW.\u001a\u0005\u0007\u0003#\u001b\u0002\u0019\u0001\u001d\u0002\u0017\u0005<wMR;oG:\u000bW.\u001a")
public class TimeWindowConfigurableAnchorExtractor
extends SimpleAnchorExtractorSpark {
    private transient Logger log;
    private Map<String, ComplexAggregationFeature> aggFeatures;
    private final Map<String, TimeWindowFeatureDefinition> features;
    private String _timestampColExpr;
    private Seq<String> _keyAlias;
    private final String TIMESTAMP_COLUMN_NAME;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Map<String, TimeWindowFeatureDefinition> features() {
        return this.features;
    }

    public String _timestampColExpr() {
        return this._timestampColExpr;
    }

    public void _timestampColExpr_$eq(String x$1) {
        this._timestampColExpr = x$1;
    }

    public Seq<String> _keyAlias() {
        return this._keyAlias;
    }

    public void _keyAlias_$eq(Seq<String> x$1) {
        this._keyAlias = x$1;
    }

    public String TIMESTAMP_COLUMN_NAME() {
        return this.TIMESTAMP_COLUMN_NAME;
    }

    public void initParams(String timestampCol, Seq<String> keyAlias) {
        this._timestampColExpr_$eq(timestampCol);
        this._keyAlias_$eq(keyAlias);
    }

    private Logger log$lzycompute() {
        TimeWindowConfigurableAnchorExtractor timeWindowConfigurableAnchorExtractor = this;
        synchronized (timeWindowConfigurableAnchorExtractor) {
            if (!this.bitmap$trans$0) {
                this.log = LogManager.getLogger(this.getClass());
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    private Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    private Map<String, ComplexAggregationFeature> aggFeatures$lzycompute() {
        TimeWindowConfigurableAnchorExtractor timeWindowConfigurableAnchorExtractor = this;
        synchronized (timeWindowConfigurableAnchorExtractor) {
            if (!this.bitmap$0) {
                this.aggFeatures = (Map)this.features().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String featureName = (String)tuple2._1();
                    TimeWindowFeatureDefinition featureDef = (TimeWindowFeatureDefinition)tuple2._2();
                    SlidingWindowFeature swjFeature = SlidingWindowFeatureUtils$.MODULE$.convertFeathrDefToSwjDef(featureName, featureDef, Duration.ZERO, (Option<LateralViewParams>)None$.MODULE$);
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), (Object)new ComplexAggregationFeature(featureDef, swjFeature, ComplexAggregationFeature$.MODULE$.apply$default$3()));
                    return tuple22;
                }, Map$.MODULE$.canBuildFrom());
                this.bitmap$0 = true;
            }
        }
        return this.aggFeatures;
    }

    private Map<String, ComplexAggregationFeature> aggFeatures() {
        return !this.bitmap$0 ? this.aggFeatures$lzycompute() : this.aggFeatures;
    }

    @Override
    public Seq<Tuple2<String, Column>> aggregateAsColumns(Dataset<Row> groupedDataFrame) {
        Iterable columnPairs = (Iterable)this.aggFeatures().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeWindowConfigurableAnchorExtractor $outer;

            public final <A1 extends Tuple2<String, ComplexAggregationFeature>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    Column column;
                    String featureName = (String)A1._1();
                    ComplexAggregationFeature featureDef = (ComplexAggregationFeature)A1._2();
                    if (featureDef.swaFeature().lateralView().isDefined()) {
                        throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "Lateral view is not supported in TimeWindowConfigurableAnchorExtractor yet");
                    }
                    String aggFuncName = featureDef.timeWindowFeatureDefinition().aggregationType().toString();
                    Enumeration.Value aggType = AggregationType$.MODULE$.withName(aggFuncName);
                    String colName = this.$outer.com$linkedin$feathr$offline$anchored$anchorExtractor$TimeWindowConfigurableAnchorExtractor$$getFeatureColumnName(featureName, aggFuncName);
                    if (featureDef.timeWindowFeatureDefinition().groupBy().isDefined()) {
                        String groupByKey = (String)featureDef.timeWindowFeatureDefinition().groupBy().get();
                        CollectTermValueMap collectMapUDF = new CollectTermValueMap();
                        Enumeration.Value value = aggType;
                        Enumeration.Value value2 = AggregationType$.MODULE$.LATEST();
                        if (!(value != null ? !value.equals(value2) : value2 != null)) {
                            Config params = ConfigFactory.parseString((String)new StringBuilder(8).append("{").append(CollectTermValueMap$.MODULE$.ALLOW_DUPLICATES()).append(": true}").toString());
                            collectMapUDF.init(params);
                        }
                        column = collectMapUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.expr(groupByKey), functions$.MODULE$.expr(colName)}));
                    } else {
                        Column column2;
                        Enumeration.Value value = aggType;
                        Enumeration.Value value3 = AggregationType$.MODULE$.MAX();
                        Enumeration.Value value4 = value;
                        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                            column2 = functions$.MODULE$.max(functions$.MODULE$.expr(colName));
                        } else {
                            Enumeration.Value value5 = AggregationType$.MODULE$.MIN();
                            Enumeration.Value value6 = value;
                            if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                                column2 = functions$.MODULE$.min(functions$.MODULE$.expr(colName));
                            } else {
                                Enumeration.Value value7 = AggregationType$.MODULE$.SUM();
                                Enumeration.Value value8 = value;
                                if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                                    column2 = functions$.MODULE$.sum(functions$.MODULE$.expr(colName));
                                } else {
                                    Enumeration.Value value9 = AggregationType$.MODULE$.AVG();
                                    Enumeration.Value value10 = value;
                                    if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                                        column2 = functions$.MODULE$.avg(functions$.MODULE$.expr(colName));
                                    } else {
                                        Enumeration.Value value11 = AggregationType$.MODULE$.COUNT();
                                        Enumeration.Value value12 = value;
                                        if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                                            column2 = functions$.MODULE$.count(functions$.MODULE$.expr(colName));
                                        } else {
                                            Enumeration.Value value13 = AggregationType$.MODULE$.MAX_POOLING();
                                            Enumeration.Value value14 = value;
                                            if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                                                column2 = functions$.MODULE$.first(functions$.MODULE$.expr(colName));
                                            } else {
                                                Enumeration.Value value15 = AggregationType$.MODULE$.MIN_POOLING();
                                                Enumeration.Value value16 = value;
                                                if (!(value15 != null ? !value15.equals(value16) : value16 != null)) {
                                                    column2 = functions$.MODULE$.first(functions$.MODULE$.expr(colName));
                                                } else {
                                                    Enumeration.Value value17 = AggregationType$.MODULE$.AVG_POOLING();
                                                    Enumeration.Value value18 = value;
                                                    if (!(value17 != null ? !value17.equals(value18) : value18 != null)) {
                                                        column2 = functions$.MODULE$.first(functions$.MODULE$.expr(colName));
                                                    } else {
                                                        Enumeration.Value value19 = AggregationType$.MODULE$.LATEST();
                                                        Enumeration.Value value20 = value;
                                                        if (!(value19 != null ? !value19.equals(value20) : value20 != null)) {
                                                            column2 = functions$.MODULE$.last(functions$.MODULE$.expr(colName), true);
                                                        } else {
                                                            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(97).append("AggregationType ").append(value).append(" is not supported in aggregateAsColumns of TimeWindowConfigurableAnchorExtractor.").toString());
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        Column aggCol = column2;
                        column = aggCol.alias(featureName);
                    }
                    Column baseAggCol = column;
                    Some baseAggCols = new Some((Object)new .colon.colon((Object)new Tuple2((Object)featureName, (Object)baseAggCol), (List)Nil$.MODULE$));
                    object = baseAggCols.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, ComplexAggregationFeature> x1) {
                Tuple2<String, ComplexAggregationFeature> tuple2 = x1;
                boolean bl = tuple2 != null;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1()}, serializedLambda);
            }
        }, Iterable$.MODULE$.canBuildFrom());
        return ((TraversableOnce)columnPairs.flatten((Function1)Predef$.MODULE$.$conforms())).toSeq();
    }

    @Override
    public Seq<String> getProvidedFeatureNames() {
        return this.features().keys().toIndexedSeq();
    }

    @Override
    public Seq<Tuple2<String, Column>> postProcessing(Dataset<Row> aggregatedDataFrame) {
        return (Seq)Nil$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<Tuple2<String, Column>> transformAsColumns(Dataset<Row> inputDF) {
        void var2_2;
        Seq featureDefColumns = ((MapLike)this.aggFeatures().flatMap((Function1 & Serializable & scala.Serializable)featureNameAndDef -> {
            Some some;
            ComplexAggregationFeature featureDef = (ComplexAggregationFeature)featureNameAndDef._2();
            SlidingWindowFeature swaFeatureDef = featureDef.swaFeature();
            if (swaFeatureDef.lateralView().isDefined()) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "Lateral view is not supported in TimeWindowConfigurableAnchorExtractor yet");
            }
            boolean hasFilter = swaFeatureDef.filterCondition().isDefined();
            String filter = (String)swaFeatureDef.filterCondition().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            Column metricColExpr = hasFilter ? functions$.MODULE$.expr(new StringBuilder(31).append(" CASE WHEN ").append(filter).append(" THEN ").append(featureDef.timeWindowFeatureDefinition().def()).append(" ELSE null END").toString()) : functions$.MODULE$.expr(featureDef.timeWindowFeatureDefinition().def());
            String featureName = featureDef.swaFeature().name();
            String aggFuncName = featureDef.timeWindowFeatureDefinition().aggregationType().toString();
            Enumeration.Value aggType = AggregationType$.MODULE$.withName(aggFuncName);
            String colName = this.com$linkedin$feathr$offline$anchored$anchorExtractor$TimeWindowConfigurableAnchorExtractor$$getFeatureColumnName(featureName, aggFuncName);
            if (featureDef.timeWindowFeatureDefinition().groupBy().isDefined()) {
                Column column;
                Enumeration.Value value = aggType;
                Enumeration.Value value2 = AggregationType$.MODULE$.MAX();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    column = functions$.MODULE$.max(metricColExpr);
                } else {
                    Enumeration.Value value4 = AggregationType$.MODULE$.MIN();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        column = functions$.MODULE$.min(metricColExpr);
                    } else {
                        Enumeration.Value value6 = AggregationType$.MODULE$.SUM();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            column = functions$.MODULE$.sum(metricColExpr);
                        } else {
                            Enumeration.Value value8 = AggregationType$.MODULE$.AVG();
                            Enumeration.Value value9 = value;
                            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                                column = functions$.MODULE$.avg(metricColExpr);
                            } else {
                                Enumeration.Value value10 = AggregationType$.MODULE$.COUNT();
                                Enumeration.Value value11 = value;
                                if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                                    column = functions$.MODULE$.count(metricColExpr);
                                } else {
                                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(94).append(value).append(" with groupBy is not supported in transformAsColumns of TimeWindowConfigurableAnchorExtractor.").toString());
                                }
                            }
                        }
                    }
                }
                Column aggCol = column;
                Seq groupByKey = (Seq)((TraversableLike)new .colon.colon((Object)((String)featureDef.timeWindowFeatureDefinition().groupBy().get()), (List)Nil$.MODULE$)).$plus$plus(this._keyAlias(), Seq$.MODULE$.canBuildFrom());
                WindowSpec baseWindow = Window$.MODULE$.partitionBy((Seq)groupByKey.map((Function1 & Serializable & scala.Serializable)expr -> functions$.MODULE$.expr(expr), Seq$.MODULE$.canBuildFrom()));
                Enumeration.Value value12 = AggregationType$.MODULE$.LATEST();
                Enumeration.Value value13 = aggType;
                WindowSpec window = !(value12 != null ? !value12.equals(value13) : value13 != null) ? baseWindow.orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.expr(this._timestampColExpr())})) : baseWindow;
                some = new Some((Object)new .colon.colon((Object)new Tuple2((Object)colName, (Object)aggCol.over(window)), (List)Nil$.MODULE$));
            } else if (((SeqLike)new .colon.colon((Object)AggregationType$.MODULE$.MAX_POOLING(), (List)new .colon.colon((Object)AggregationType$.MODULE$.MIN_POOLING(), (List)new .colon.colon((Object)AggregationType$.MODULE$.AVG_POOLING(), (List)Nil$.MODULE$)))).contains((Object)aggType)) {
                Column column;
                WindowSpec window = Window$.MODULE$.partitionBy((String)this._keyAlias().head(), (Seq)this._keyAlias().tail());
                String params = new StringBuilder(19).append("{ embeddingSize: ").append(featureDef.timeWindowFeatureDefinition().embeddingSize().get()).append(" }").toString();
                Config paramsConfig = ConfigFactory.parseString((String)params);
                Enumeration.Value value = aggType;
                Enumeration.Value value14 = AggregationType$.MODULE$.MAX_POOLING();
                Enumeration.Value value15 = value;
                if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                    MaxPoolingUDAF maxPoolingUDAF = new MaxPoolingUDAF();
                    maxPoolingUDAF.init(paramsConfig);
                    column = maxPoolingUDAF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{metricColExpr}));
                } else {
                    Enumeration.Value value16 = AggregationType$.MODULE$.MIN_POOLING();
                    Enumeration.Value value17 = value;
                    if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                        MinPoolingUDAF minPoolingUDAF = new MinPoolingUDAF();
                        minPoolingUDAF.init(paramsConfig);
                        column = minPoolingUDAF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{metricColExpr}));
                    } else {
                        Enumeration.Value value18 = AggregationType$.MODULE$.AVG_POOLING();
                        Enumeration.Value value19 = value;
                        if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                            AvgPoolingUDAF avgPoolingUDAF = new AvgPoolingUDAF();
                            avgPoolingUDAF.init(paramsConfig);
                            column = avgPoolingUDAF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{metricColExpr}));
                        } else {
                            throw new MatchError((Object)value);
                        }
                    }
                }
                Column poolCol = column;
                some = new Some((Object)new .colon.colon((Object)new Tuple2((Object)colName, (Object)poolCol.over(window)), (List)Nil$.MODULE$));
            } else {
                Enumeration.Value value = AggregationType$.MODULE$.LATEST();
                Enumeration.Value value20 = aggType;
                if (!(value != null ? !value.equals(value20) : value20 != null)) {
                    WindowSpec window = Window$.MODULE$.partitionBy((String)this._keyAlias().head(), (Seq)this._keyAlias().tail()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.expr(this._timestampColExpr())}));
                    Column latestCol = functions$.MODULE$.last(metricColExpr, true);
                    some = new Some((Object)new .colon.colon((Object)new Tuple2((Object)colName, (Object)latestCol.over(window)), (List)Nil$.MODULE$));
                } else {
                    some = new Some((Object)new .colon.colon((Object)new Tuple2((Object)colName, (Object)metricColExpr), (List)Nil$.MODULE$));
                }
            }
            Some intermediateDefCols = some;
            return (Seq)intermediateDefCols.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        }, Map$.MODULE$.canBuildFrom())).toSeq();
        return var2_2;
    }

    public String com$linkedin$feathr$offline$anchored$anchorExtractor$TimeWindowConfigurableAnchorExtractor$$getFeatureColumnName(String featureName, String aggFuncName) {
        return new StringBuilder(5).append(featureName).append("_").append(aggFuncName).append("_col").toString();
    }

    public TimeWindowConfigurableAnchorExtractor(@JsonProperty(value="features") Map<String, TimeWindowFeatureDefinition> features) {
        this.features = features;
        this.TIMESTAMP_COLUMN_NAME = "_feathr_swa_timestamp_col";
    }
}

